/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.communication;

import Alachisoft.NCache.Common.Communication.IChannelFormatter;
import Alachisoft.NCache.Common.Extensibility.Client.RPC.IResponseConsolidator;
import Alachisoft.NCache.Common.Extensibility.Client.RPC.Partition;
import Alachisoft.NCache.Common.Extensibility.Client.RPC.RPCCallInfo;
import com.alachisoft.ncache.client.internal.communication.ModuleOperation;
import com.alachisoft.ncache.client.internal.communication.RPCTransport;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Map;

abstract class DistributedRPCCallBase {
    public IResponseConsolidator consolidator;
    public String objectUID;
    private IChannelFormatter _formatter;
    private ArrayList<Map.Entry<Partition, Object>> _partitonWiseArguments = new ArrayList();
    private RPCTransport _transport;
    private ModuleOperation _operation;
    private String module = "Lucene";
    private String version = "5.0";

    public DistributedRPCCallBase(RPCTransport transport, IChannelFormatter formatter) {
        if (transport == null) {
            throw new NullPointerException("transport");
        }
        if (formatter == null) {
            throw new NullPointerException("formatter");
        }
        this._transport = transport;
        this._formatter = formatter;
    }

    public IResponseConsolidator getConsolidator() {
        return this.consolidator;
    }

    public void setConsolidator(IResponseConsolidator consolidator) {
        this.consolidator = consolidator;
    }

    public final String GetModule() {
        return this.module;
    }

    public final void SetModule(String value) {
        this.module = value;
    }

    public final String GetVersion() {
        return this.version;
    }

    public final void SetVersion(String value) {
        this.version = value;
    }

    public String getObjectUID() {
        return this.objectUID;
    }

    public void setObjectUID(String objectUID) {
        this.objectUID = objectUID;
    }

    public final void AddArguments(Partition partiton, Object arguments) {
        this._partitonWiseArguments.add(new AbstractMap.SimpleEntry<Partition, Object>(partiton, arguments));
    }

    public void PrepareCall() {
        this._operation = new ModuleOperation();
        this._operation.setModule(this.GetModule());
        this._operation.setVersion(this.GetVersion());
        if (this.consolidator != null) {
            this.consolidator.Initialize();
        }
        for (Map.Entry<Partition, Object> arguments : this._partitonWiseArguments) {
            RPCCallInfo rpcInfo = this.CreateRPCCallInfo();
            rpcInfo.setArguments(arguments.getValue());
            byte[] buffer = null;
            try {
                buffer = this._formatter.Serialize((Object)rpcInfo);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this._operation.AddPayload(arguments.getKey(), buffer);
        }
    }

    public abstract RPCCallInfo CreateRPCCallInfo();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <TResult> TResult Execute() throws Exception {
        if (this._operation == null) {
            throw new Exception(String.format("Module operation is Null. Call %1$s before calling %2$s", "PrepareCall", "Execute"));
        }
        try {
            this._transport.ExecuteModuleOperation(this._operation);
            if (this._operation.GetFailures() != null && this._operation.GetFailures().size() > 0) {
                throw this._operation.GetFailures().get(0).getValue();
            }
            for (Map.Entry<Partition, byte[]> resultPair : this._operation.GetResults()) {
                Object result = this._formatter.Deserialize(resultPair.getValue());
                if (result instanceof RuntimeException) {
                    throw result instanceof RuntimeException ? (RuntimeException)result : null;
                }
                if (this.consolidator == null) continue;
                this.consolidator.CollectResponse((Object)resultPair.getKey(), result);
            }
            if (this.consolidator != null) {
                Object object = this.consolidator.GetFinalResponse();
                return (TResult)object;
            }
        }
        finally {
            if (this.consolidator != null) {
                this.consolidator.Reset();
            }
        }
        return null;
    }
}

