/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.communication;

import Alachisoft.NCache.Common.DataStructures.Queue;
import com.alachisoft.ncache.client.internal.communication.Connection;
import com.alachisoft.ncache.runtime.exceptions.ConnectionException;
import java.net.Socket;
import java.util.ArrayList;
import tangible.RefObject;

class NagglingManager
extends Thread {
    private Queue _msgQueue;
    private long _nagglingSize;
    private Connection _parent;
    private Socket _workingSocket;
    private Object _syncLock;
    private int _sendBufferSize = 0x100000;
    private byte[] _sendBuffer;
    private long _waitTimeout = 0L;

    public NagglingManager(Connection parent, Socket workingSocket, Queue msgQueue, long nagglingSize, Object syncLock) {
        this._parent = parent;
        this._workingSocket = workingSocket;
        this._nagglingSize = nagglingSize;
        this._msgQueue = msgQueue;
        this._sendBuffer = new byte[this._sendBufferSize];
        this._syncLock = syncLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            ArrayList msgList = new ArrayList();
            int totalMsgSize = 0;
            int offset = 0;
            ArrayList<byte[]> msgsTobeSent = new ArrayList<byte[]>();
            while (!this._msgQueue.getClosed()) {
                try {
                    byte[] tmpBuffer;
                    msgsTobeSent.clear();
                    Object object = this._syncLock;
                    synchronized (object) {
                        byte[] msg;
                        tmpBuffer = this._sendBuffer;
                        totalMsgSize = 0;
                        offset = 0;
                        do {
                            if ((msg = (byte[])this._msgQueue.remove()) != null) {
                                msgsTobeSent.add(msg);
                                if ((totalMsgSize += msg.length) > this._sendBuffer.length) {
                                    tmpBuffer = new byte[totalMsgSize];
                                }
                                System.arraycopy(msg, 0, tmpBuffer, offset, msg.length);
                                offset += msg.length;
                            }
                            msg = null;
                            boolean success = false;
                            RefObject tempOut_success = new RefObject((Object)success);
                            Object tempVar = this._msgQueue.peek(this._waitTimeout, tempOut_success);
                            byte[] byArray = msg = tempVar instanceof byte[] ? (byte[])tempVar : null;
                        } while (msg != null && (long)(msg.length + totalMsgSize) <= this._nagglingSize);
                    }
                    this._parent.AssureSendNaggledData(this._workingSocket, tmpBuffer, totalMsgSize, true);
                }
                catch (InterruptedException e) {
                    break;
                }
                catch (ConnectionException connectionException) {
                }
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }
}

