/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.communication;

import Alachisoft.NCache.Common.Communication.IChannelFormatter;
import Alachisoft.NCache.Common.Extensibility.Client.RPC.IRPCCallBuilder;
import Alachisoft.NCache.Common.Extensibility.Client.RPC.IRPCConstructorCall;
import Alachisoft.NCache.Common.Extensibility.Client.RPC.IRPCMethodCall;
import Alachisoft.NCache.Common.Extensibility.Client.RPC.IRPCPropertyCall;
import Alachisoft.NCache.Common.Extensibility.Client.RPC.IRPCTransport;
import Alachisoft.NCache.Common.Extensibility.Client.RPC.PartitioningStrategy;
import com.alachisoft.ncache.client.Cache;
import com.alachisoft.ncache.client.internal.caching.CacheImpl;
import com.alachisoft.ncache.client.internal.caching.ClientCache;
import com.alachisoft.ncache.client.internal.caching.DisconnectedClientCache;
import com.alachisoft.ncache.client.internal.caching.InprocCache;
import com.alachisoft.ncache.client.internal.communication.DistributedCallBuilder;
import com.alachisoft.ncache.client.internal.communication.DistributedConstructorCall;
import com.alachisoft.ncache.client.internal.communication.DistributedMethodCall;
import com.alachisoft.ncache.client.internal.communication.DistributedPropertyCall;
import com.alachisoft.ncache.client.internal.communication.ModuleOperation;
import com.alachisoft.ncache.runtime.exceptions.CommandException;
import com.alachisoft.ncache.runtime.exceptions.LicensingException;
import com.alachisoft.ncache.runtime.exceptions.OperationFailedException;

public class RPCTransport
implements IRPCTransport {
    public String module;
    public String version;
    private CacheImpl _cacheInstance;
    private IRPCCallBuilder _builder;

    public RPCTransport(Cache cache, IChannelFormatter formatter) {
        if (cache == null) {
            throw new NullPointerException("cache");
        }
        if (formatter == null) {
            throw new NullPointerException("formatter");
        }
        if (this._cacheInstance.getCacheImpl() instanceof InprocCache) {
            throw new UnsupportedOperationException("Local InProc topology is not supported. ");
        }
        this._cacheInstance = this._cacheInstance instanceof DisconnectedClientCache ? ((DisconnectedClientCache)this._cacheInstance).getCacheInstanceInternal() : (this._cacheInstance instanceof ClientCache ? ((ClientCache)this._cacheInstance).getCacheInstanceInternal() : (CacheImpl)cache);
        this._builder = new DistributedCallBuilder(this, formatter);
    }

    public final PartitioningStrategy GetPartitioningStrategy() {
        if (this._cacheInstance.getCacheImpl() != null) {
            return this._cacheInstance.getCacheImpl().getPartitioningStrategy();
        }
        return null;
    }

    public final void ExecuteConstructor(IRPCConstructorCall constructor) throws Exception {
        DistributedConstructorCall constructorCall = constructor instanceof DistributedConstructorCall ? (DistributedConstructorCall)constructor : null;
        constructorCall.SetModule(this.module);
        constructorCall.SetVersion(this.version);
        constructorCall.PrepareCall();
        constructorCall.Execute();
    }

    public final <TResult> TResult ExecuteMethod(IRPCMethodCall method) throws Exception {
        DistributedMethodCall methodCall = method instanceof DistributedMethodCall ? (DistributedMethodCall)method : null;
        methodCall.SetModule(this.module);
        methodCall.SetVersion(this.version);
        methodCall.PrepareCall();
        return methodCall.Execute();
    }

    public final <TValue> TValue ExecuteProperty(IRPCPropertyCall property) throws Exception {
        DistributedPropertyCall propertyCall = property instanceof DistributedPropertyCall ? (DistributedPropertyCall)property : null;
        propertyCall.SetModule(this.module);
        propertyCall.SetVersion(this.version);
        propertyCall.PrepareCall();
        return (TValue)propertyCall.Execute();
    }

    public final IRPCCallBuilder GetBuilder() {
        return this._builder;
    }

    public final void ExecuteModuleOperation(ModuleOperation operation) throws OperationFailedException, LicensingException, CommandException {
        if (this._cacheInstance.getCacheImpl() != null) {
            this._cacheInstance.getCacheImpl().ExecuteModuleOperation(operation);
        }
    }
}

