/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.communication;

import com.alachisoft.ncache.client.internal.command.Command;
import com.alachisoft.ncache.client.internal.command.CommandResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class ResponseList {
    private static final int FIRST_CHUNK = 1;
    private Object _mutex = new Object();
    private Command privateCommand;
    private long privateRequestId = -1L;
    private HashMap<Integer, CommandResponse> _responses = new HashMap();

    public ResponseList(Command command) {
        this.privateCommand = command;
    }

    public final Command getCommand() {
        return this.privateCommand;
    }

    public final long getRequestId() {
        return this.privateRequestId;
    }

    public final void setRequestId(long value) {
        this.privateRequestId = value;
    }

    public final List<CommandResponse> getResponses() {
        ArrayList<CommandResponse> responses = new ArrayList<CommandResponse>(this._responses.size());
        for (int i = 1; i <= this._responses.size(); ++i) {
            responses.add(this._responses.get(i));
        }
        return responses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean IsComplete(boolean includeFailedRespnosesOnly) {
        Object object = this._mutex;
        synchronized (object) {
            boolean result = this._responses.containsKey(1);
            if (result) {
                CommandResponse firstChunk = this._responses.get(1);
                result = includeFailedRespnosesOnly ? this._responses.size() == firstChunk.getNumberOfChunks() && firstChunk.getIsSendFailure() : this._responses.size() == firstChunk.getNumberOfChunks();
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void AddResponse(CommandResponse response) {
        Object object = this._mutex;
        synchronized (object) {
            CommandResponse commandResponse = null;
            commandResponse = this._responses.get(response.getSequenceId());
            if (commandResponse == null) {
                this._responses.put(response.getSequenceId(), response);
            } else if (commandResponse.isBrokerReset() && response.getIsSendFailure()) {
                this._responses.put(response.getSequenceId(), response);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void Clear() {
        Object object = this._mutex;
        synchronized (object) {
            this._responses.clear();
        }
    }

    public final void MergeWith(ResponseList rspList) {
        for (Map.Entry<Integer, CommandResponse> response : rspList._responses.entrySet()) {
            this._responses.put(response.getKey(), response.getValue());
        }
    }
}

