/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.communication;

import Alachisoft.NCache.Common.Threading.Monitor;
import com.alachisoft.ncache.client.internal.communication.Broker;
import com.alachisoft.ncache.client.internal.communication.Connection;
import java.util.LinkedList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

class SocketManagerHandler
implements AutoCloseable {
    private final ExecutorService executorService = Executors.newFixedThreadPool(25);
    private final LinkedList<Connection> writeQueue = new LinkedList();
    private boolean _enablePipelining = false;
    private Thread _dedicatedWriter = null;
    private Broker _encloser;
    private Thread _thresholdRefresher = null;

    public boolean isEnablePipelining() {
        return this._enablePipelining;
    }

    public void setEnablePipelining(boolean enablePipelining) {
        this._enablePipelining = enablePipelining;
    }

    public SocketManagerHandler(Broker encloser) {
        this._encloser = encloser;
    }

    public final void StartSocketManager(boolean useHighPrioritySocketThreads) {
        this._dedicatedWriter = new Thread(() -> this.WriteAllQueues());
        this._dedicatedWriter.setPriority(useHighPrioritySocketThreads ? 10 : 5);
        this._dedicatedWriter.setName(this.getClass().getName() + ":Write");
        this._dedicatedWriter.setDaemon(true);
        this._dedicatedWriter.start();
    }

    public final void StartPipelining() {
        this._thresholdRefresher = new Thread(() -> this.UpdateBulkThreshold());
        this._thresholdRefresher.setName("ThresholdRefresher");
        this._thresholdRefresher.setDaemon(true);
        this._thresholdRefresher.start();
    }

    private void UpdateBulkThreshold() {
        block8: {
            try {
                while (!this._encloser.getIsDisposing()) {
                    try {
                        if (this._encloser.getPool() != null) {
                            this._encloser.getPool().UpdateBulkThreshold();
                        }
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                    catch (Exception e) {
                        if (this._encloser.getLogger().getIsErrorLogsEnabled()) {
                            this._encloser.getLogger().getNCacheLog().Error("Broker.UpdateBulkThreshold", "Problem occured while updating bulk threshold. " + e.toString());
                        }
                        break;
                    }
                }
            }
            catch (Exception ex) {
                if (!this._encloser.getLogger().getIsErrorLogsEnabled()) break block8;
                this._encloser.getLogger().getNCacheLog().Error("Broker.UpdateBulkThreshold", "Problem occured while updating bulk threshold. " + ex.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void WriteAllQueues() {
        block18: while (true) {
            try {
                while (true) {
                    Connection connection;
                    LinkedList<Connection> linkedList = this.writeQueue;
                    synchronized (linkedList) {
                        if (this.writeQueue.isEmpty()) {
                            if (this._encloser.getIsDisposing()) {
                                break block18;
                            }
                            Monitor.wait(this.writeQueue);
                            if (this._encloser.getIsDisposing()) {
                                break block18;
                            }
                            if (this.writeQueue.isEmpty()) {
                                continue;
                            }
                        }
                        connection = this.writeQueue.poll();
                    }
                    if (this.isEnablePipelining()) {
                        connection.WaitUntillPipelineFilled();
                    }
                    switch (connection.WriteQueue(200)) {
                        case MoreWork: 
                        case QueueEmptyAfterWrite: {
                            linkedList = this.writeQueue;
                            synchronized (linkedList) {
                                this.writeQueue.offer(connection);
                                break;
                            }
                        }
                        case CompetingWriter: {
                            break;
                        }
                        case NoConnection: {
                            connection.getInWriteQueue().set(0);
                            break;
                        }
                        case NothingToDo: {
                            if (connection.ConfirmRemoveFromWriteQueue()) break;
                            linkedList = this.writeQueue;
                            synchronized (linkedList) {
                                this.writeQueue.offer(connection);
                                break;
                            }
                        }
                    }
                }
            }
            catch (InterruptedException e) {
            }
            catch (Exception e) {
                if (this._encloser.getLogger() == null || !this._encloser.getLogger().getIsErrorLogsEnabled()) continue;
                this._encloser.getLogger().getNCacheLog().Error("Broker.DedicatedWriter", e.toString());
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void RequestWrite(Connection connection, boolean forced) {
        int resultvalue = connection.getInWriteQueue().compareAndExchange(0, 1);
        if (resultvalue == 0 || forced) {
            LinkedList<Connection> linkedList = this.writeQueue;
            synchronized (linkedList) {
                this.writeQueue.offer(connection);
                if (this.writeQueue.size() == 1) {
                    Monitor.pulse(this.writeQueue);
                } else if (this.writeQueue.size() >= 2) {
                    this.executorService.execute(() -> this.writeOneQueue());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeOneQueue() {
        boolean keepGoing;
        Connection connection;
        LinkedList<Connection> linkedList = this.writeQueue;
        synchronized (linkedList) {
            connection = this.writeQueue.isEmpty() ? null : this.writeQueue.poll();
        }
        if (connection == null) {
            return;
        }
        do {
            if (this.isEnablePipelining()) {
                connection.WaitUntillPipelineFilled();
            }
            switch (connection.WriteQueue(-1)) {
                case MoreWork: 
                case QueueEmptyAfterWrite: {
                    keepGoing = true;
                    break;
                }
                case NothingToDo: {
                    keepGoing = !connection.ConfirmRemoveFromWriteQueue();
                    break;
                }
                case CompetingWriter: {
                    keepGoing = false;
                    break;
                }
                case NoConnection: {
                    connection.getInWriteQueue().set(0);
                    keepGoing = false;
                    break;
                }
                default: {
                    keepGoing = false;
                }
            }
        } while (keepGoing);
    }

    public final void StopWriter() {
        if (this._dedicatedWriter != null && this._dedicatedWriter.isAlive()) {
            this._dedicatedWriter.interrupt();
        }
    }

    @Override
    public void close() throws Exception {
        this.StopWriter();
        if (this._thresholdRefresher != null && this._thresholdRefresher.isAlive()) {
            this._thresholdRefresher.interrupt();
        }
        if (this.executorService != null) {
            this.awaitTerminationAfterShutdown(this.executorService);
        }
    }

    public void awaitTerminationAfterShutdown(ExecutorService threadPool) {
        try {
            threadPool.shutdown();
            if (!threadPool.awaitTermination(15L, TimeUnit.SECONDS)) {
                threadPool.shutdownNow();
            }
        }
        catch (InterruptedException ex) {
            try {
                threadPool.shutdownNow();
                Thread.currentThread().interrupt();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

