/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.communication;

import com.alachisoft.ncache.client.internal.communication.Broker;
import com.alachisoft.ncache.serialization.core.io.surrogates.NCacheArgumentException;
import com.alachisoft.ncache.serialization.standard.CompactBinaryFormatter;
import com.alachisoft.ncache.serialization.standard.FormatterServices;
import com.alachisoft.ncache.serialization.util.SerializationUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Hashtable;

class UpdateCompactTypes
implements Runnable {
    private Broker parent;
    private byte[] responsevalue;
    private String _cacheId;

    UpdateCompactTypes() {
    }

    @Override
    public void run() {
        this.UpdateCompactTypesAsync(this.responsevalue);
    }

    public void setData(byte[] value) {
        this.responsevalue = value;
    }

    public void setParent(Broker broker) {
        this.parent = broker;
        this._cacheId = broker.getCache().getName();
    }

    private void UpdateCompactTypesAsync(Object state) {
        block8: {
            byte[] serializedMap = (byte[])(state instanceof byte[] ? state : null);
            try {
                if (serializedMap != null) {
                    Object tempVar = CompactBinaryFormatter.fromByteBuffer((byte[])serializedMap, (String)this._cacheId);
                    Hashtable updatedCompactTypesConfigFromByteBuffer = (Hashtable)(tempVar instanceof Hashtable ? tempVar : null);
                    Hashtable updatedCompactTypesConfig = null;
                    if (updatedCompactTypesConfigFromByteBuffer != null) {
                        updatedCompactTypesConfig = new Hashtable(updatedCompactTypesConfigFromByteBuffer);
                    }
                    HashMap updatedCompactTypes = null;
                    if (updatedCompactTypesConfig != null) {
                        updatedCompactTypes = SerializationUtil.getCompactTypes(updatedCompactTypesConfig, (boolean)false, (String)this._cacheId);
                    }
                    if (updatedCompactTypes != null) {
                        updatedCompactTypes.forEach((type, stringShortHashMap) -> {
                            block3: {
                                HashMap handleNonCompactFields = stringShortHashMap;
                                short typeHandle = (Short)handleNonCompactFields.get("handle");
                                HashMap nonCompactFields = null;
                                if (handleNonCompactFields.containsKey("non-compact-fields")) {
                                    nonCompactFields = (HashMap)handleNonCompactFields.get("non-compact-fields");
                                }
                                FormatterServices impl = FormatterServices.getDefault();
                                FormatterServices.setAttributeOrder((HashMap)SerializationUtil.getAttributeOrder((String)this._cacheId));
                                try {
                                    impl.registerKnownType(type, typeHandle, SerializationUtil.getSubTypeHandle((String)this._cacheId, (String)Short.valueOf(typeHandle).toString(), (Class)type), this._cacheId, SerializationUtil.getPortability((short)typeHandle, (String)this._cacheId), nonCompactFields);
                                }
                                catch (NCacheArgumentException e) {
                                    if (!this.parent.getLogger().getIsErrorLogsEnabled()) break block3;
                                    this.parent.getLogger().getNCacheLog().Error("Broker.UpdateCompactTypesAsync", "An error occurred while installing updated compact types. Error :" + e.toString());
                                }
                            }
                        });
                    }
                }
            }
            catch (IOException tempVar) {
            }
            catch (ClassNotFoundException tempVar) {
            }
            catch (Exception e) {
                if (!this.parent.getLogger().getIsErrorLogsEnabled()) break block8;
                this.parent.getLogger().getNCacheLog().Error("Broker.UpdateCompactTypesAsync", "An error occurred while installing updated compact types. Error :" + e.toString());
            }
        }
    }
}

