/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.datastructure;

import Alachisoft.NCache.Caching.Util.CollectionUtil;
import Alachisoft.NCache.Common.DataTypes.CollectionCreateOrGetOperation;
import Alachisoft.NCache.Common.ErrorHandling.ErrorMessages;
import com.alachisoft.ncache.client.CacheItem;
import com.alachisoft.ncache.client.datastructures.Counter;
import com.alachisoft.ncache.client.datastructures.DataStructureAttributes;
import com.alachisoft.ncache.client.datastructures.DataStructureManager;
import com.alachisoft.ncache.client.datastructures.DistributedHashSet;
import com.alachisoft.ncache.client.datastructures.DistributedList;
import com.alachisoft.ncache.client.datastructures.DistributedMap;
import com.alachisoft.ncache.client.datastructures.DistributedQueue;
import com.alachisoft.ncache.client.internal.caching.CacheImpl;
import com.alachisoft.ncache.client.internal.datastructure.CounterImpl;
import com.alachisoft.ncache.client.internal.datastructure.DistributedHashSetImpl;
import com.alachisoft.ncache.client.internal.datastructure.DistributedListImpl;
import com.alachisoft.ncache.client.internal.datastructure.DistributedMapImpl;
import com.alachisoft.ncache.client.internal.datastructure.DistributedQueueImpl;
import com.alachisoft.ncache.client.internal.util.ConversionUtil;
import com.alachisoft.ncache.runtime.caching.DistributedDataStructure;
import com.alachisoft.ncache.runtime.caching.ReadMode;
import com.alachisoft.ncache.runtime.caching.ReadThruOptions;
import com.alachisoft.ncache.runtime.caching.WriteMode;
import com.alachisoft.ncache.runtime.caching.WriteThruOptions;
import com.alachisoft.ncache.runtime.exceptions.CacheException;
import com.alachisoft.ncache.runtime.exceptions.runtime.OperationFailedRuntimeException;

public class DataStructureManagerImpl
implements DataStructureManager {
    private CacheImpl _cache;

    public DataStructureManagerImpl(CacheImpl cache) {
        this._cache = cache;
    }

    public final CacheImpl getCache() {
        return this._cache;
    }

    @Override
    public void setCache(CacheImpl value) {
        this._cache = value;
    }

    @Override
    public Counter createCounter(String key) throws CacheException {
        return this.createCounter(key, null, 0L, null);
    }

    @Override
    public Counter createCounter(String key, long initialValue) throws CacheException, IllegalArgumentException {
        return this.createCounter(key, null, initialValue, null);
    }

    @Override
    public Counter createCounter(String key, DataStructureAttributes attributes, long initialValue, WriteThruOptions options) throws CacheException {
        this.createCounterInternal(key, attributes, initialValue, options);
        return new CounterImpl(key, this.getCache(), options, null);
    }

    @Override
    public <V> DistributedMap<String, V> createMap(String key, Class<?> cls) throws CacheException {
        return this.createMap(key, null, null, cls);
    }

    @Override
    public <V> DistributedMap<String, V> createMap(String key, DataStructureAttributes attributes, WriteThruOptions options, Class<?> cls) throws CacheException {
        if (cls == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: cls");
        }
        this.createInternal(key, attributes, options, DistributedDataStructure.Map, cls);
        return new DistributedMapImpl(key, this._cache, options, cls);
    }

    @Override
    public <T> DistributedHashSet<T> createHashSet(String key, Class<?> cls) throws CacheException {
        return this.createHashSet(key, null, null, cls);
    }

    @Override
    public <T> DistributedHashSet<T> createHashSet(String key, DataStructureAttributes attributes, WriteThruOptions options, Class<?> cls) throws CacheException {
        if (cls == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: cls");
        }
        CollectionUtil.validateTypeForHashSetOnCreation(cls);
        this.createInternal(key, attributes, options, DistributedDataStructure.Set, cls);
        return new DistributedHashSetImpl(key, this.getCache(), options, cls);
    }

    @Override
    public <T> DistributedList<T> createList(String key, Class<?> cls) throws CacheException {
        return this.createList(key, null, null, cls);
    }

    @Override
    public <T> DistributedList<T> createList(String key, DataStructureAttributes attributes, WriteThruOptions options, Class<?> cls) throws CacheException {
        if (cls == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: cls");
        }
        this.createInternal(key, attributes, options, DistributedDataStructure.List, cls);
        return new DistributedListImpl(key, this.getCache(), options, cls);
    }

    @Override
    public <T> DistributedQueue<T> createQueue(String key, Class<?> cls) throws CacheException {
        return this.createQueue(key, null, null, cls);
    }

    @Override
    public <T> DistributedQueue<T> createQueue(String key, DataStructureAttributes attributes, WriteThruOptions options, Class<?> cls) throws CacheException {
        if (cls == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: cls");
        }
        this.createInternal(key, attributes, options, DistributedDataStructure.Queue, cls);
        return new DistributedQueueImpl(key, this.getCache(), options, (Class)cls);
    }

    @Override
    public Counter getCounter(String key) throws CacheException {
        return this.getCounter(key, null);
    }

    @Override
    public Counter getCounter(String key, ReadThruOptions options) throws CacheException {
        if (this.getInternal(key, options, DistributedDataStructure.Counter)) {
            return new CounterImpl(key, this.getCache(), null, null);
        }
        return null;
    }

    @Override
    public <V> DistributedMap<String, V> getMap(String key, Class<?> cls) throws CacheException {
        return this.getMap(key, null, cls);
    }

    @Override
    public <V> DistributedMap<String, V> getMap(String key, ReadThruOptions options, Class<?> cls) throws CacheException {
        if (this.getInternal(key, options, DistributedDataStructure.Map)) {
            return new DistributedMapImpl(key, this.getCache(), null, cls);
        }
        return null;
    }

    @Override
    public <T> DistributedHashSet<T> getHashSet(String key, Class<?> cls) throws CacheException {
        return this.getHashSet(key, null, cls);
    }

    @Override
    public <T> DistributedHashSet<T> getHashSet(String key, ReadThruOptions options, Class<?> cls) throws CacheException {
        if (this.getInternal(key, options, DistributedDataStructure.Set)) {
            return new DistributedHashSetImpl(key, this.getCache(), null, cls);
        }
        return null;
    }

    @Override
    public <T> DistributedList<T> getList(String key, Class<?> cls) throws CacheException {
        return this.getList(key, null, cls);
    }

    @Override
    public <T> DistributedList<T> getList(String key, ReadThruOptions options, Class<?> cls) throws CacheException {
        if (this.getInternal(key, options, DistributedDataStructure.List)) {
            return new DistributedListImpl(key, this.getCache(), null, cls);
        }
        return null;
    }

    @Override
    public <T> DistributedQueue<T> getQueue(String key, Class<?> cls) throws CacheException {
        return this.getQueue(key, null, cls);
    }

    @Override
    public <T> DistributedQueue<T> getQueue(String key, ReadThruOptions options, Class<?> cls) throws CacheException {
        if (this.getInternal(key, options, DistributedDataStructure.Queue)) {
            return new DistributedQueueImpl(key, this.getCache(), null, (Class)cls);
        }
        return null;
    }

    @Override
    public void remove(String key) throws CacheException {
        this.remove(key, null);
    }

    @Override
    public void remove(String key, WriteThruOptions writeThruOptions) throws CacheException {
        this.getCache().delete(key, null, null, writeThruOptions);
    }

    private void createCounterInternal(String key, DataStructureAttributes attributes, long initialValue, WriteThruOptions options) throws CacheException {
        if (key == null || key.isEmpty()) {
            throw new IllegalArgumentException("Value cannot be null or empty." + System.lineSeparator() + "Parameter name: key");
        }
        if (attributes != null && attributes.getExpiration() != null && ConversionUtil.getExpirationAbsoluteInternal(attributes.getExpiration()) != CacheImpl.NoAbsoluteExpiration && ConversionUtil.getExpirationSlidingInternal(attributes.getExpiration()) != CacheImpl.NoSlidingExpiration) {
            throw new IllegalArgumentException("You can not set both sliding and absolute expirations on a single item");
        }
        if (options == null) {
            options = new WriteThruOptions(WriteMode.None);
        }
        CollectionCreateOrGetOperation tempVar = new CollectionCreateOrGetOperation(key, DistributedDataStructure.Counter);
        tempVar.setWriteThruOptions(options);
        tempVar.setInitialValue(initialValue);
        this.getCache().createDataType(tempVar, attributes);
    }

    private void createInternal(String key, DataStructureAttributes attributes, WriteThruOptions options, DistributedDataStructure type, Class cls) throws CacheException {
        if (key == null || key.isEmpty()) {
            throw new IllegalArgumentException("Value cannot be empty or null." + System.lineSeparator() + "Parameter name: key");
        }
        if (attributes != null && attributes.getExpiration() != null && ConversionUtil.getExpirationAbsoluteInternal(attributes.getExpiration()) != CacheImpl.NoAbsoluteExpiration && ConversionUtil.getExpirationSlidingInternal(attributes.getExpiration()) != CacheImpl.NoSlidingExpiration) {
            throw new IllegalArgumentException("You can not set both sliding and absolute expirations on a single item");
        }
        this.validateTypeOfDistributedDataType(cls);
        if (options == null) {
            options = new WriteThruOptions(WriteMode.None);
        }
        CollectionCreateOrGetOperation tempVar = new CollectionCreateOrGetOperation(key, type);
        tempVar.setWriteThruOptions(options);
        this.getCache().createDataType(tempVar, attributes);
    }

    private boolean getInternal(String key, ReadThruOptions options, DistributedDataStructure type) throws CacheException {
        if (key == null || key.isEmpty()) {
            throw new IllegalArgumentException("Value cannot be null or empty." + System.lineSeparator() + "Parameter name: key");
        }
        if (options == null) {
            options = new ReadThruOptions(ReadMode.None);
        }
        CollectionCreateOrGetOperation op = new CollectionCreateOrGetOperation(key, type);
        op.setReadThruOptions(options);
        return this.getCache().getDataType(op);
    }

    private void validateTypeOfDistributedDataType(Class cls) {
        this.validateTypeNotCacheItem(cls);
    }

    private void validateTypeNotCacheItem(Class type) {
        if (type.equals(CacheItem.class)) {
            throw new OperationFailedRuntimeException(ErrorMessages.getErrorMessage((int)45004, (String[])new String[0]));
        }
    }
}

