/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.datastructure;

import Alachisoft.NCache.Common.DataTypes.Dictionary.DictionaryAddOperation;
import Alachisoft.NCache.Common.DataTypes.Dictionary.DictionaryContainsOperation;
import Alachisoft.NCache.Common.DataTypes.KeyValuePairedEnumerationFilter;
import com.alachisoft.ncache.client.datastructures.DistributedMap;
import com.alachisoft.ncache.client.internal.caching.CacheImpl;
import com.alachisoft.ncache.client.internal.datastructure.DistributedDataStructureImpl;
import com.alachisoft.ncache.client.internal.datastructure.DistributedPairedCollectionIterator;
import com.alachisoft.ncache.runtime.caching.DistributedDataStructure;
import com.alachisoft.ncache.runtime.caching.WriteThruOptions;
import com.alachisoft.ncache.runtime.exceptions.AggregateException;
import com.alachisoft.ncache.runtime.exceptions.CacheException;
import com.alachisoft.ncache.runtime.exceptions.ConnectionException;
import com.alachisoft.ncache.runtime.exceptions.GeneralFailureException;
import com.alachisoft.ncache.runtime.exceptions.OperationFailedException;
import com.alachisoft.ncache.runtime.exceptions.runtime.CacheRuntimeException;
import com.alachisoft.ncache.runtime.exceptions.runtime.GeneralFailureRuntimeException;
import com.alachisoft.ncache.runtime.exceptions.runtime.OperationFailedRuntimeException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

class DistributedMapImpl<V>
extends DistributedDataStructureImpl
implements DistributedMap<String, V> {
    public DistributedMapImpl(String key, CacheImpl cache, WriteThruOptions options, Class<?> cls) {
        super(key, cache, options, cls);
    }

    @Override
    protected DistributedDataStructure getDataType() {
        return DistributedDataStructure.Map;
    }

    @Override
    public void insert(Map<String, V> entries) {
        this.addOrInsertOperation(entries, DictionaryAddOperation.OpType.Insert);
    }

    @Override
    public int remove(Collection<String> keys) {
        try {
            return this.removeOperation(keys);
        }
        catch (AggregateException | OperationFailedException e) {
            throw new OperationFailedRuntimeException(e);
        }
        catch (GeneralFailureException e) {
            throw new GeneralFailureRuntimeException((Throwable)e);
        }
    }

    @Override
    public Collection<V> get(Collection<String> keys) {
        try {
            return this.getOperation(keys);
        }
        catch (CacheException e) {
            throw new CacheRuntimeException((Throwable)e);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() < 1;
    }

    @Override
    public boolean containsKey(Object key) {
        try {
            return this.containsOperation(key, DictionaryContainsOperation.OpType.ContainsKey);
        }
        catch (AggregateException | OperationFailedException e) {
            throw new OperationFailedRuntimeException(e);
        }
        catch (GeneralFailureException e) {
            throw new GeneralFailureRuntimeException((Throwable)e);
        }
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException("containsValue");
    }

    @Override
    public V get(Object key) {
        try {
            return this.getItem(key);
        }
        catch (CacheException e) {
            throw new CacheRuntimeException((Throwable)e);
        }
    }

    @Override
    public V put(String key, V value) {
        this.setItem(key, value);
        return null;
    }

    @Override
    public V remove(Object key) {
        if (key.getClass() != String.class) {
            throw new ClassCastException("key not String");
        }
        if (key == null || ((String)key).isEmpty()) {
            throw new IllegalArgumentException("Value cannot be null" + System.lineSeparator() + "Parameter name: key");
        }
        V previousValue = this.get(key);
        ArrayList<String> arr = new ArrayList<String>();
        arr.add((String)key);
        try {
            this.removeOperation(arr);
        }
        catch (AggregateException | OperationFailedException e) {
            throw new OperationFailedRuntimeException(e);
        }
        catch (GeneralFailureException e) {
            throw new GeneralFailureRuntimeException((Throwable)e);
        }
        return previousValue;
    }

    @Override
    public void putAll(Map<? extends String, ? extends V> m) {
        this.addOrInsertOperation(m, DictionaryAddOperation.OpType.Insert);
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> keys = new HashSet<String>();
        DistributedPairedCollectionIterator enumerator = new DistributedPairedCollectionIterator(this.getCache(), this.getKey(), DistributedDataStructure.Map, KeyValuePairedEnumerationFilter.KeysOnly, this._valueType);
        while (enumerator.hasNext()) {
            keys.add((String)((Map.Entry)enumerator.next()).getKey());
        }
        return keys;
    }

    @Override
    public Collection<V> values() {
        ArrayList values = new ArrayList();
        DistributedPairedCollectionIterator enumerator = new DistributedPairedCollectionIterator(this.getCache(), this.getKey(), DistributedDataStructure.Map, KeyValuePairedEnumerationFilter.ValuesOnly, this._valueType);
        while (enumerator.hasNext()) {
            values.add(((Map.Entry)enumerator.next()).getValue());
        }
        return values;
    }

    @Override
    public Set<Map.Entry<String, V>> entrySet() {
        HashSet<Map.Entry<String, V>> entries = new HashSet<Map.Entry<String, V>>();
        DistributedPairedCollectionIterator enumerator = new DistributedPairedCollectionIterator(this.getCache(), this.getKey(), DistributedDataStructure.Map, KeyValuePairedEnumerationFilter.BothKeysAndValues, this._valueType);
        while (enumerator.hasNext()) {
            entries.add((Map.Entry)enumerator.next());
        }
        return entries;
    }

    private V getItem(Object key) throws CacheException {
        if (key.getClass() != String.class) {
            throw new ClassCastException("key not String");
        }
        if (((String)key).isEmpty()) {
            throw new IllegalArgumentException("Value cannot be null" + System.lineSeparator() + "Parameter name: key");
        }
        ArrayList<String> arr = new ArrayList<String>();
        arr.add((String)key);
        List value = this.getCache().dictionaryGet(this.getKey(), this._lockHandle.getLockId(), this._lockTimeout, arr, this._valueType);
        if (value.size() == 0) {
            return null;
        }
        return value.get(0);
    }

    private void setItem(String key, V value) {
        if (key == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: key");
        }
        if (key.isEmpty()) {
            throw new IllegalArgumentException("Value cannot be empty." + System.lineSeparator() + "Parameter name: key");
        }
        if (value == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: value");
        }
        HashMap<String, V> dictionary = new HashMap<String, V>();
        dictionary.put(key, value);
        this.addOrInsertOperation(dictionary, DictionaryAddOperation.OpType.Insert);
    }

    private void addOrInsertOperation(Map<? extends String, ? extends V> collection, DictionaryAddOperation.OpType operationType) {
        if (collection == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: collection");
        }
        for (Map.Entry<String, V> item : collection.entrySet()) {
            if (item.getKey() == null) {
                throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: key");
            }
            if (item.getKey().isEmpty()) {
                throw new IllegalArgumentException("Value cannot be empty." + System.lineSeparator() + "Parameter name: key");
            }
            if (item.getValue() == null) {
                throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: value");
            }
            this.validateTypeNotCacheItem(item.getValue().getClass());
        }
        this.getCache().dictionaryAdd(this.getKey(), collection, this._lockHandle.getLockId(), this._lockTimeout, this.getWriteThruOptions(), operationType);
    }

    private Collection<V> getOperation(Collection<String> keys) throws CacheException {
        if (keys == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: keys");
        }
        for (String key : keys) {
            if (key != null && !key.isEmpty()) continue;
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: key");
        }
        return this.getCache().dictionaryGet(this.getKey(), this._lockHandle.getLockId(), this._lockTimeout, keys, this._valueType);
    }

    private int removeOperation(Collection<String> keys) throws OperationFailedException, GeneralFailureException, AggregateException {
        if (keys == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: keys");
        }
        for (String key : keys) {
            if (!key.isEmpty() && key != null) continue;
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: key");
        }
        return this.getCache().dictionaryRemove(this.getKey(), keys, this._lockHandle.getLockId(), this._lockTimeout, this.getWriteThruOptions());
    }

    private boolean containsOperation(Object key, DictionaryContainsOperation.OpType operationType) throws OperationFailedException, GeneralFailureException, ConnectionException, AggregateException {
        return this.containsOperation(key, null, operationType);
    }

    private boolean containsOperation(Object key, V value, DictionaryContainsOperation.OpType operationType) throws OperationFailedException, GeneralFailureException, ConnectionException, AggregateException {
        if (key == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: key");
        }
        if (key.getClass() != String.class) {
            throw new ClassCastException("Key is not String");
        }
        if (((String)key).isEmpty()) {
            throw new IllegalArgumentException("Value cannot be empty." + System.lineSeparator() + "Parameter name: key");
        }
        if (value != null) {
            this.validateTypeNotCacheItem(value.getClass());
        }
        return this.getCache().dictionaryContains(this.getKey(), this._lockHandle.getLockId(), this._lockTimeout, (String)key, value, operationType);
    }

    @Override
    public final void copyTo(Map.Entry<String, V>[] array, int arrayIndex) {
        try {
            this.CopyToInternal(this.entrySet(), array, arrayIndex, this.CountInternal(DistributedDataStructure.Map));
        }
        catch (AggregateException | GeneralFailureException | OperationFailedException e) {
            throw new OperationFailedRuntimeException();
        }
    }

    public Iterator<Map.Entry<String, V>> iterator() {
        return new DistributedPairedCollectionIterator(this.getCache(), this.getKey(), DistributedDataStructure.Map, KeyValuePairedEnumerationFilter.BothKeysAndValues, this._valueType);
    }
}

