/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.messaging;

import Alachisoft.NCache.Common.BitSet;
import Alachisoft.NCache.Common.Enum.TopicOperationType;
import Alachisoft.NCache.Common.ErrorHandling.ErrorMessages;
import Alachisoft.NCache.Common.IDisposable;
import Alachisoft.NCache.Common.MessageUtil;
import Alachisoft.NCache.Common.Threading.Monitor;
import Alachisoft.NCache.Management.Statistics.StatisticsCounter;
import com.alachisoft.ncache.client.MessageItem;
import com.alachisoft.ncache.client.internal.caching.CacheImplBase;
import com.alachisoft.ncache.client.internal.caching.ContinuousQueryManager;
import com.alachisoft.ncache.client.internal.caching.EventManager;
import com.alachisoft.ncache.client.internal.caching.EventTypeInternal;
import com.alachisoft.ncache.client.internal.caching.PollNotificationListener;
import com.alachisoft.ncache.client.internal.caching.TopicImpl;
import com.alachisoft.ncache.client.internal.caching.TopicReRegister;
import com.alachisoft.ncache.client.internal.caching.TopicSubscriptionImpl;
import com.alachisoft.ncache.client.internal.messaging.ReceivedMessages;
import com.alachisoft.ncache.client.internal.messaging.TopicIdentity;
import com.alachisoft.ncache.runtime.caching.Topic;
import com.alachisoft.ncache.runtime.caching.messaging.TopicPriority;
import com.alachisoft.ncache.runtime.caching.messaging.TopicSearchOptions;
import com.alachisoft.ncache.runtime.exceptions.CacheException;
import com.alachisoft.ncache.runtime.exceptions.OperationFailedException;
import com.alachisoft.ncache.runtime.util.TimeSpan;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import tangible.DotNetToJavaStringHelper;
import tangible.RefObject;

public class MessageManager
implements IDisposable,
TopicReRegister,
PollNotificationListener {
    private static final int pollingInterval = 10;
    private final ConcurrentHashMap<TopicIdentity, TopicImpl> topicsMap;
    private final EventManager eventManager;
    private final Object lockObj = new Object();
    private CacheImplBase cacheImpl;
    private Thread pollingThread;
    private boolean poll;
    private Date _lastPoll = new Date();
    private StatisticsCounter perfStatsCollector;
    private boolean isNotificationRegister = false;
    private long version;

    public MessageManager(EventManager eventManager, StatisticsCounter perfStatsCollector) {
        this.topicsMap = new ConcurrentHashMap();
        this.eventManager = eventManager;
        this.perfStatsCollector = perfStatsCollector;
    }

    public final void initialize() {
        this.eventManager.registerPollingEvent(this, EventTypeInternal.PubSub);
    }

    public final TopicReRegister getReregisterTopicListener() {
        return this;
    }

    public boolean getIsValidName(String topicName, TopicOperationType type) {
        if (type != TopicOperationType.GetPatternBased) {
            return true;
        }
        try {
            String regexPattern = MessageUtil.wildcardToRegex((String)topicName);
            Pattern.compile(regexPattern);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Topic getOrCreateTopic(TopicIdentity topicPair, TopicOperationType type, boolean internalOperation) throws CacheException {
        String topicName = topicPair.getTopicName();
        if (DotNetToJavaStringHelper.isNullOrEmpty((String)topicName)) {
            throw new IllegalArgumentException("Value cannot be null or empty." + System.lineSeparator() + "Parameter name: topicName");
        }
        if (!this.getIsValidName(topicName, type)) {
            throw new OperationFailedException(20009, ErrorMessages.getErrorMessage((int)20009, (String[])new String[0]));
        }
        if (!internalOperation && this.isDefaultTopicName(topicName)) {
            throw new OperationFailedException(20002, ErrorMessages.getErrorMessage((int)20002, (String[])new String[0]));
        }
        if (this.cacheImpl == null) {
            throw new OperationFailedException(10006, ErrorMessages.getErrorMessage((int)10006, (String[])new String[0]));
        }
        TopicImpl topic = null;
        TopicPriority topicPriority = topicPair.getTopicPriority();
        RefObject tempRef_topicPriority = new RefObject((Object)topicPriority);
        if (this.cacheImpl.getOrCreate(topicName, (RefObject<TopicPriority>)tempRef_topicPriority, type)) {
            MessageManager messageManager = this;
            synchronized (messageManager) {
                if (type == TopicOperationType.Get) {
                    topicPair.setTopicPriority((TopicPriority)tempRef_topicPriority.argvalue);
                }
                if ((topic = this.topicsMap.get(topicPair)) != null) {
                    if (topic.getIsClosed()) {
                        this.topicsMap.remove(topicPair, topic);
                        TopicSearchOptions searchOptions = topic.getSearchOptions();
                        topic = new TopicImpl(topicName, topicPair.getTopicPriority(), this.cacheImpl, this.perfStatsCollector, this);
                        topic.setSearchOptions(searchOptions);
                    }
                    this.topicsMap.putIfAbsent(topicPair, topic);
                    topic.IncrementRefCount();
                    return topic;
                }
                topic = new TopicImpl(topicName, topicPair.getTopicPriority(), this.cacheImpl, this.perfStatsCollector, this);
                if (type == TopicOperationType.GetPatternBased) {
                    topic.setSearchOptions(TopicSearchOptions.ByPattern);
                }
                topic.IncrementRefCount();
                this.topicsMap.putIfAbsent(topicPair, topic);
            }
        }
        return topic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stopPollingIfRequired(TopicImpl topic) {
        boolean keepPollingOn = false;
        if (topic == null || topic.getActiveSubscriptions() <= 0) {
            MessageManager messageManager = this;
            synchronized (messageManager) {
                for (TopicImpl registerTopic : this.topicsMap.values()) {
                    if (registerTopic.getActiveSubscriptions() <= 0 && !registerTopic.getHasFailureDeliveryNotification()) continue;
                    keepPollingOn = true;
                    break;
                }
                if (!keepPollingOn) {
                    this.stopPolling();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopPolling() {
        try {
            MessageManager messageManager = this;
            synchronized (messageManager) {
                this.poll = false;
                this.isNotificationRegister = false;
                if (this.pollingThread != null) {
                    this.pollingThread.interrupt();
                }
                this.pollingThread = null;
                if (ContinuousQueryManager.getTracingEnabled()) {
                    System.out.println("Thread : " + this.pollingThread.getName() + " stopped at " + new Date().toString());
                }
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public final void onSubscriptionCreated(TopicImpl topic, TopicSubscriptionImpl topicSubscription) {
        this.startPolling();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void startPolling() {
        MessageManager messageManager = this;
        synchronized (messageManager) {
            if (!this.isNotificationRegister) {
                this.startPollForMessage();
                this.isNotificationRegister = true;
            }
        }
    }

    private void startPollForMessage() {
        this.poll = true;
        this.pollingThread = new Thread(new Runnable(){

            @Override
            public void run() {
                MessageManager.this.pollForMessage();
            }
        });
        this.pollingThread.setDaemon(true);
        this.pollingThread.setName(this.cacheImpl.getName() + ":TopicPollingThread");
        this.pollingThread.start();
        if (ContinuousQueryManager.getTracingEnabled()) {
            System.out.println("Thread : " + this.pollingThread.getName() + " started at " + new Date().toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pollForMessage() {
        long currentVersion = -1L;
        while (this.poll) {
            try {
                Object object = this.lockObj;
                synchronized (object) {
                    if (currentVersion == this.version) {
                        Monitor.wait((Object)this.lockObj, (long)10000L);
                    }
                }
                TimeSpan diff = TimeSpan.subtract((Date)new Date(), (Date)this._lastPoll);
                currentVersion = this.version;
                this.poll();
            }
            catch (InterruptedException e) {
                break;
            }
            catch (Exception exception) {
            }
        }
    }

    private void poll() throws CacheException {
        BitSet flagMap = new BitSet();
        ReceivedMessages assignedResponse = this.cacheImpl.getMessageData(flagMap);
        if (assignedResponse != null) {
            this.sendMessageAcknowledgements(assignedResponse);
            this.deliverValidMessagesToClient(assignedResponse);
            this.topicValidation(assignedResponse);
        }
        this._lastPoll = new Date();
    }

    public final void dispose() {
        this.stopPolling();
        for (TopicImpl messageTopic : this.topicsMap.values()) {
            messageTopic.disposeInternal(false);
        }
        this.topicsMap.clear();
        this.cacheImpl = null;
        if (ContinuousQueryManager.getTracingEnabled()) {
            System.out.println("MessageManager disposed at " + new Date().toString());
            Thread.dumpStack();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void onPollNotified() {
        Object object = this.lockObj;
        synchronized (object) {
            ++this.version;
            Monitor.pulse((Object)this.lockObj);
        }
    }

    public final void setCacheImpl(CacheImplBase value) {
        this.cacheImpl = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void topicDisposeItself(TopicImpl topic) {
        MessageManager messageManager = this;
        synchronized (messageManager) {
            TopicIdentity topicPair = new TopicIdentity(topic.getName(), topic.getSearchOptions());
            TopicImpl existingTopic = this.topicsMap.get(topicPair);
            if (existingTopic != null && topic == existingTopic) {
                this.topicsMap.remove(topicPair);
            }
        }
    }

    public final void deleteTopic(String topicName) throws CacheException {
        if (this.cacheImpl == null) {
            throw new OperationFailedException(10006, ErrorMessages.resolveError((int)10006, (String[])new String[0]));
        }
        if (this.isDefaultTopicName(topicName)) {
            return;
        }
        TopicIdentity topicPair = new TopicIdentity(topicName, TopicSearchOptions.ByName);
        TopicImpl topic = this.topicsMap.get(topicPair);
        if (this.topicsMap.remove(topicPair, topic) && topic.getSearchOptions() == TopicSearchOptions.ByName) {
            topic.disposeInternal(true);
            topic.fireDeleteNotification();
            this.stopPollingIfRequired(topic);
        }
        this.cacheImpl.removeTopic(topicName, true);
    }

    private void sendMesasgeAcknowledgment(HashMap<String, List<String>> acknowledgmentIdList) throws Exception {
        this.cacheImpl.acknowledgeMessageReceipt(acknowledgmentIdList);
    }

    @Override
    public void onTopicReregisterListener() throws Exception {
        for (TopicImpl topic : this.topicsMap.values()) {
            if (topic.getSearchOptions() == TopicSearchOptions.ByName) {
                TopicPriority topicPriority = topic.getPriority();
                RefObject tempRef_topicPriority = new RefObject((Object)topicPriority);
                this.cacheImpl.getOrCreate(topic.getName(), (RefObject<TopicPriority>)tempRef_topicPriority, TopicOperationType.Create);
            }
            topic.reRegisterSubscribers(topic.getSearchOptions());
        }
    }

    public final boolean isDefaultTopicName(String topicName) {
        boolean isDefaultTopicName = false;
        if (!DotNetToJavaStringHelper.isNullOrEmpty((String)topicName)) {
            isDefaultTopicName = topicName.equals("$ContinuousQueryEvents$");
            isDefaultTopicName = isDefaultTopicName || topicName.equals("$GeneralEvents$");
            isDefaultTopicName = isDefaultTopicName || topicName.equals("$ItemLevelEvents$");
            isDefaultTopicName = isDefaultTopicName || topicName.equals("$CollectionEvents$");
        }
        return isDefaultTopicName;
    }

    private void sendMessageAcknowledgements(ReceivedMessages assignedResponse) throws CacheException {
        HashMap<String, List<String>> ackIdList = new HashMap<String, List<String>>();
        for (Map.Entry<String, List<MessageItem>> pair : assignedResponse.getAssignedMessages().entrySet()) {
            ArrayList<String> messageIds = new ArrayList<String>();
            for (MessageItem messageItem : pair.getValue()) {
                messageIds.add(messageItem.getMessageId());
            }
            if (messageIds.size() <= 0) continue;
            ackIdList.put(pair.getKey(), messageIds);
        }
        if (ackIdList.size() > 0) {
            try {
                this.sendMesasgeAcknowledgment(ackIdList);
            }
            catch (Exception e) {
                throw new CacheException(e.getMessage(), e.getCause());
            }
        }
    }

    private void deliverValidMessagesToClient(ReceivedMessages assignedResponse) {
        int count = 0;
        for (Map.Entry<String, List<MessageItem>> pair : assignedResponse.getAssignedMessages().entrySet()) {
            TopicImpl selectedTopic = null;
            for (TopicImpl topic : this.topicsMap.values()) {
                selectedTopic = this.getValidTopic(topic, pair.getKey());
                if (selectedTopic == null || pair.getValue() == null || pair.getValue().size() <= 0) continue;
                count += pair.getValue().size();
                selectedTopic.updateSyncData(pair.getValue(), pair.getKey());
            }
        }
        if (this.perfStatsCollector != null) {
            this.perfStatsCollector.incrementMessageDeliverPerSec((long)count);
        }
    }

    private void topicValidation(ReceivedMessages assignedResponse) throws CacheException {
        ArrayList<String> removeList = new ArrayList<String>();
        for (TopicImpl topic : this.topicsMap.values()) {
            TopicIdentity topicPair = new TopicIdentity(topic.getName(), topic.getSearchOptions());
            if (assignedResponse.getAssignedMessages().containsKey(topic.getName()) || assignedResponse.getRegisteredPatterns().contains(topic.getName()) || !topic.getHasFailureDeliveryNotification() && topic.getActiveSubscriptions() <= 0) continue;
            if (topic.getSearchOptions() == TopicSearchOptions.ByName) {
                if (this.getOrCreateTopic(topicPair, TopicOperationType.Get, true) == null) continue;
                topic.reRegisterSubscribers(topic.getSearchOptions());
                continue;
            }
            if (topic.getSearchOptions() == TopicSearchOptions.ByPattern) {
                if (this.getOrCreateTopic(topicPair, TopicOperationType.GetPatternBased, true) == null) continue;
                topic.reRegisterSubscribers(topic.getSearchOptions());
                continue;
            }
            removeList.add(topic.getName());
            topic.fireDeleteNotification();
        }
    }

    private TopicImpl getValidTopic(TopicImpl topic, String serverSideTopicName) {
        switch (topic.getSearchOptions()) {
            case ByPattern: {
                String regexPattern = MessageUtil.wildcardToRegex((String)topic.getName());
                regexPattern.equalsIgnoreCase(serverSideTopicName);
                return topic;
            }
            case ByName: {
                if (!topic.getName().equals(serverSideTopicName)) break;
                return topic;
            }
        }
        return null;
    }
}

