/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.util;

import com.alachisoft.ncache.client.internal.util.DirectoryUtil;
import com.alachisoft.ncache.runtime.exceptions.ConfigurationException;
import java.io.File;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import tangible.RefObject;

public class ConfigReader {
    String fileName;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String ClientCacheID(String fileName, String cacheId, RefObject<Boolean> isPessimistic) throws Exception {
        File file = null;
        try {
            String path = ConfigReader.GetClientConfigurationPath();
            file = new File(path);
            if (!file.exists()) {
                return "";
            }
            Document configuration = null;
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = null;
            try {
                builder = builderFactory.newDocumentBuilder();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                // empty catch block
            }
            configuration = builder.parse(file);
            NodeList cacheList = configuration.getElementsByTagName("cache");
            int i = 0;
            while (i < cacheList.getLength()) {
                Node cache = cacheList.item(i);
                if (cache.hasAttributes() && cache.getAttributes().getNamedItem("id").getNodeValue().equalsIgnoreCase(cacheId)) {
                    if (cache.getAttributes().getNamedItem("client-cache-syncmode") != null) {
                        isPessimistic.argvalue = cache.getAttributes().getNamedItem("client-cache-syncmode").getNodeValue().equalsIgnoreCase("pessimistic");
                    }
                    if (cache.getAttributes().getNamedItem("client-cache-id").getNodeValue().toLowerCase().length() != 0) {
                        return cache.getAttributes().getNamedItem("client-cache-id").getNodeValue();
                    }
                }
                ++i;
            }
            return "";
        }
        catch (Exception e) {
            throw new ConfigurationException("An error occured while reading client.ncconf. " + e.getMessage());
        }
    }

    public static HashMap ReadSecurityParams(String fileName, String cacheId) throws ConfigurationException {
        HashMap securityParams = null;
        try {
            Element cacheElement;
            int nodeItem;
            String filePath = ConfigReader.GetClientConfigurationPath();
            if (filePath == null) {
                return null;
            }
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document document = db.parse(new File(filePath));
            Element docEle = document.getDocumentElement();
            NodeList cacheList = docEle.getElementsByTagName("cache");
            NodeList cacheConfig = null;
            if (cacheList != null && cacheList.getLength() > 0) {
                for (nodeItem = 0; nodeItem < cacheList.getLength(); ++nodeItem) {
                    Node cacheNode = cacheList.item(nodeItem);
                    if (cacheNode.getNodeType() != 1 || !cacheId.equals((cacheElement = (Element)cacheNode).getAttribute("id"))) continue;
                    cacheConfig = cacheNode.getChildNodes();
                    break;
                }
            }
            if (cacheConfig == null) {
                return null;
            }
            if (cacheConfig != null && cacheConfig.getLength() > 0) {
                for (nodeItem = 0; nodeItem < cacheConfig.getLength(); ++nodeItem) {
                    Node currentConfig = cacheConfig.item(nodeItem);
                    if (currentConfig.getNodeType() != 1 || !(cacheElement = (Element)currentConfig).getTagName().equals("security")) continue;
                    NodeList securityData = currentConfig.getChildNodes();
                    if (securityData != null) {
                        securityParams = new HashMap();
                        HashMap<String, String> tmp = null;
                        for (int j = 0; j < securityData.getLength(); ++j) {
                            Node securitUser = securityData.item(j);
                            if (securitUser.getNodeType() != 1) continue;
                            Element primaryElement = (Element)securitUser;
                            String tempVar = primaryElement.getTagName();
                            if (tempVar.equals("primary")) {
                                tmp = new HashMap<String, String>();
                                securityParams.put("pri-user", tmp);
                                tmp.put("user-id", primaryElement.getAttribute("user-id"));
                                tmp.put("password", primaryElement.getAttribute("password"));
                                continue;
                            }
                            if (tempVar.equals("secondary")) {
                                tmp = new HashMap();
                                securityParams.put("sec-user", tmp);
                                tmp.put("user-id", primaryElement.getAttribute("user-id"));
                                tmp.put("password", primaryElement.getAttribute("password"));
                                continue;
                            }
                            throw new ConfigurationException("Invalid XmlNode '" + primaryElement.getTagName() + "' found in security section");
                        }
                        return securityParams;
                    }
                    return null;
                }
            }
        }
        catch (ConfigurationException ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new ConfigurationException("An error occured while reading client.ncconf. " + e.getMessage());
        }
        return securityParams;
    }

    private static String GetClientConfigurationPath() {
        return DirectoryUtil.getBaseFilePath("client.ncconf");
    }
}

