/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.util;

import Alachisoft.NCache.Common.BitSet;
import Alachisoft.NCache.Common.Enum.SerializationFormat;
import Alachisoft.NCache.Common.Enum.UserObjectType;
import Alachisoft.NCache.Common.JSON.ExtendedJsonValueBase;
import Alachisoft.NCache.Common.JSON.JsonHelper;
import com.alachisoft.ncache.runtime.JSON.JsonValueBase;
import com.alachisoft.ncache.runtime.exceptions.GeneralFailureException;
import com.alachisoft.ncache.runtime.exceptions.OperationFailedException;
import com.alachisoft.ncache.serialization.JSON.JsonBinaryFormatter;
import com.alachisoft.ncache.serialization.standard.CompactBinaryFormatter;
import java.io.IOException;
import tangible.RefObject;

public class SerializationUtil {
    public static Object safeSerializeOutProc(Object serializableObject, String serializationContext, BitSet flag, boolean serializationEnabled, SerializationFormat serializationFormat, RefObject<Long> size, UserObjectType userObjectType, boolean isCustomAtributeBaseSerialized) throws GeneralFailureException, OperationFailedException {
        if (serializableObject == null || !serializationEnabled) {
            return serializableObject;
        }
        switch (userObjectType) {
            case CacheItem: {
                Class<?> type = serializableObject.getClass();
                if (byte[].class.equals(type) && flag != null) {
                    flag.SetBit((byte)-128);
                    return serializableObject;
                }
                try {
                    if (JsonValueBase.class.isAssignableFrom(serializableObject.getClass())) {
                        serializableObject = JsonBinaryFormatter.toByteArray((Object)serializableObject);
                        flag.SetBit((byte)32);
                        return serializableObject;
                    }
                    switch (serializationFormat) {
                        case Binary: {
                            serializableObject = CompactBinaryFormatter.toByteBuffer((Object)serializableObject, (String)serializationContext);
                            break;
                        }
                        case Json: {
                            serializableObject = JsonBinaryFormatter.toByteArray((Object)serializableObject);
                            flag.SetBit((byte)32);
                        }
                    }
                    break;
                }
                catch (OperationFailedException | IOException e) {
                    throw new GeneralFailureException(e);
                }
            }
            case DistributedDataType: {
                ExtendedJsonValueBase jsonSerializedValue = JsonHelper.getBinaryJsonValue((Object)serializableObject, (boolean)isCustomAtributeBaseSerialized);
                serializableObject = jsonSerializedValue;
            }
        }
        return serializableObject;
    }

    public static <T> T safeDeserializeOutProc(Object serializedObject, String serializationContext, BitSet flag, boolean isSerializationEnabled, UserObjectType userObjectType, Class<?> cls) throws IOException, ClassNotFoundException, OperationFailedException {
        if (cls == null) {
            cls = Object.class;
        }
        Object deserialized = serializedObject;
        boolean userAskedForJson = JsonValueBase.class.isAssignableFrom(cls);
        switch (userObjectType) {
            case CacheItem: {
                if (!(serializedObject instanceof byte[]) || !isSerializationEnabled) break;
                if (flag != null && flag.IsBitSet((byte)-128)) {
                    if (!userAskedForJson) {
                        return (T)serializedObject;
                    }
                    throw new UnsupportedOperationException("Cannot interpret binary serialized data as JSON serialized data.");
                }
                if (flag != null && flag.IsBitSet((byte)32)) {
                    if (userAskedForJson) {
                        deserialized = JsonBinaryFormatter.fromByteBuffer((byte[])((byte[])serializedObject), cls);
                        break;
                    }
                    deserialized = JsonBinaryFormatter.deserializeObject((String)JsonBinaryFormatter.decodeString((byte[])((byte[])serializedObject)), cls);
                    break;
                }
                deserialized = CompactBinaryFormatter.fromByteBuffer((byte[])((byte[])serializedObject), (String)serializationContext);
                if (cls.isAssignableFrom(deserialized.getClass())) break;
                throw new ClassCastException("class " + deserialized.getClass().getName() + " cannot be cast to " + cls);
            }
            case DistributedDataType: {
                JsonValueBase jsonValue = (JsonValueBase)serializedObject;
                if (jsonValue == null) break;
                deserialized = JsonBinaryFormatter.deserializeObject((String)jsonValue.toJson(), cls);
            }
        }
        return (T)deserialized;
    }

    public static Object safeSerializeInProc(Object serializableObject, String serializationContext, BitSet flag, boolean serializationEnabled, SerializationFormat serializationFormat, RefObject<Long> size, UserObjectType userObjectType, boolean isCustomAtributeBaseSerialized) throws GeneralFailureException, OperationFailedException, IOException {
        if (serializationEnabled) {
            return SerializationUtil.safeSerializeOutProc(serializableObject, serializationContext, flag, serializationEnabled, serializationFormat, size, userObjectType, isCustomAtributeBaseSerialized);
        }
        Object serializableObjectUnser = serializableObject;
        if ((Long)size.argvalue <= 0L) {
            switch (userObjectType) {
                case CacheItem: {
                    Class<?> type = serializableObject.getClass();
                    if (byte[].class.equals(type) && flag != null) {
                        flag.SetBit((byte)-128);
                        size.setValue((Object)((byte[])serializableObject).length);
                        return serializableObject;
                    }
                    if (JsonValueBase.class.isAssignableFrom(serializableObject.getClass())) {
                        serializableObject = JsonBinaryFormatter.toByteArray((Object)serializableObject);
                        flag.SetBit((byte)32);
                        return serializableObject;
                    }
                    switch (serializationFormat) {
                        case Binary: {
                            serializableObject = CompactBinaryFormatter.toByteBuffer((Object)serializableObject, (String)serializationContext);
                            break;
                        }
                        case Json: {
                            serializableObject = JsonBinaryFormatter.toByteArray((Object)serializableObject);
                            flag.SetBit((byte)32);
                        }
                    }
                    size.argvalue = (long)(serializableObject instanceof byte[] ? ((byte[])serializableObject).length : 0);
                    break;
                }
                case DistributedDataType: {
                    ExtendedJsonValueBase jsonSerializedValue = JsonHelper.getUserObjectJsonValue((Object)serializableObject, (boolean)isCustomAtributeBaseSerialized);
                    serializableObject = jsonSerializedValue;
                    size.argvalue = (long)jsonSerializedValue.getSize();
                    return jsonSerializedValue;
                }
            }
        }
        return serializableObjectUnser;
    }

    public static <T> T safeDeserializeInProc(Object serializedObject, String serializationContext, BitSet flag, boolean isSerializationEnabled, UserObjectType userObjectType, Class<?> cls) throws IOException, ClassNotFoundException, OperationFailedException {
        if (cls == null) {
            cls = Object.class;
        }
        if (isSerializationEnabled) {
            return SerializationUtil.safeDeserializeOutProc(serializedObject, serializationContext, flag, isSerializationEnabled, userObjectType, cls);
        }
        if (serializedObject == null) {
            return (T)serializedObject;
        }
        boolean userAskedForJson = JsonValueBase.class.isAssignableFrom(cls);
        switch (userObjectType) {
            case CacheItem: {
                boolean valueFromCacheIsJson = serializedObject instanceof JsonValueBase;
                if (!valueFromCacheIsJson && userAskedForJson) {
                    throw new UnsupportedOperationException("Caches with object data format do not support JSON formatted data from user data.");
                }
                if (!cls.isAssignableFrom(serializedObject.getClass())) {
                    throw new ClassCastException("class " + serializedObject.getClass().getName() + " cannot be cast to " + cls);
                }
                if (valueFromCacheIsJson && !userAskedForJson) {
                    return (T)JsonBinaryFormatter.deserializeObject((String)JsonBinaryFormatter.serializeObject((Object)serializedObject), cls);
                }
                return (T)serializedObject;
            }
            case DistributedDataType: {
                ExtendedJsonValueBase extendedJsonValueBase = (ExtendedJsonValueBase)(serializedObject instanceof ExtendedJsonValueBase ? serializedObject : null);
                if (extendedJsonValueBase != null) {
                    boolean dataStructureHasJsonData = extendedJsonValueBase.getValue() instanceof JsonValueBase;
                    if (!dataStructureHasJsonData && userAskedForJson) {
                        throw new UnsupportedOperationException("Caches with object data format do not support JSON formatted data from user data.");
                    }
                    if (dataStructureHasJsonData && !userAskedForJson) {
                        return (T)JsonBinaryFormatter.deserializeObject((String)JsonBinaryFormatter.serializeObject((Object)extendedJsonValueBase.getValue(), (boolean)false), cls);
                    }
                    return (T)extendedJsonValueBase.getValue();
                }
                return (T)serializedObject;
            }
        }
        return (T)serializedObject;
    }

    static Object safeSerialize(Object serializableObject, SerializationFormat serializer, String serializationContext, BitSet flag) throws IOException, OperationFailedException {
        if (serializableObject != null) {
            if (serializableObject instanceof byte[]) {
                flag.SetBit((byte)-128);
                return serializableObject;
            }
            if (JsonValueBase.class.isAssignableFrom(serializableObject.getClass())) {
                serializableObject = JsonBinaryFormatter.toByteArray((Object)serializableObject);
                flag.SetBit((byte)32);
                return serializableObject;
            }
            switch (serializer) {
                case Binary: {
                    serializableObject = CompactBinaryFormatter.toByteBuffer((Object)serializableObject, (String)serializationContext);
                    break;
                }
                case Json: {
                    flag.SetBit((byte)32);
                    serializableObject = JsonBinaryFormatter.toByteArray((Object)serializableObject);
                }
            }
        }
        return serializableObject;
    }
}

