/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.jsr107;

import com.alachisoft.ncache.client.CacheClearedListener;
import com.alachisoft.ncache.client.CacheDataModificationListener;
import com.alachisoft.ncache.client.CacheEventArg;
import com.alachisoft.ncache.client.internal.caching.CacheItemRemovedReason;
import com.alachisoft.ncache.jsr107.NCacheCache;
import com.alachisoft.ncache.jsr107.NCacheEntryEventAdapter;
import java.util.ArrayList;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.event.CacheEntryCreatedListener;
import javax.cache.event.CacheEntryEventFilter;
import javax.cache.event.CacheEntryExpiredListener;
import javax.cache.event.CacheEntryListener;
import javax.cache.event.CacheEntryRemovedListener;
import javax.cache.event.CacheEntryUpdatedListener;
import javax.cache.event.EventType;

public class CacheEventListener<K, V>
implements CacheDataModificationListener,
CacheClearedListener {
    private final CacheEntryListener<K, V> cacheListener;
    private final CacheEntryEventFilter<? super K, ? super V> cacheEntryEventFilter;
    private final NCacheCache<K, V> jCache;
    private boolean removedListener;
    private boolean createdListener;
    private boolean updatedListener;
    private boolean expiredListener;

    public CacheEventListener(CacheEntryListener<K, V> cacheListener, NCacheCache<K, V> jCache, CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
        this.cacheListener = cacheListener;
        this.jCache = jCache;
        this.removedListener = this.implementsMethods(CacheEntryRemovedListener.class);
        this.createdListener = this.implementsMethods(CacheEntryCreatedListener.class);
        this.updatedListener = this.implementsMethods(CacheEntryUpdatedListener.class);
        this.expiredListener = this.implementsMethods(CacheEntryExpiredListener.class);
        this.cacheEntryEventFilter = cacheEntryListenerConfiguration.getCacheEntryEventFilterFactory() != null ? (CacheEntryEventFilter)cacheEntryListenerConfiguration.getCacheEntryEventFilterFactory().create() : null;
    }

    public boolean isRemovedListenerConfigure() {
        return this.removedListener;
    }

    public boolean isAddedListenerConfigure() {
        return this.createdListener;
    }

    public boolean isUpdatedListenerConfigure() {
        return this.updatedListener;
    }

    public boolean isExpiredListenerConfigure() {
        return this.expiredListener;
    }

    @Override
    public void onCacheDataModified(String key, CacheEventArg cea) {
        EventType eventType = EventType.CREATED;
        if (cea.getEventType() == com.alachisoft.ncache.runtime.events.EventType.ItemAdded) {
            eventType = EventType.CREATED;
        } else if (cea.getEventType() == com.alachisoft.ncache.runtime.events.EventType.ItemRemoved) {
            eventType = cea.getCacheItemRemovedReason() == CacheItemRemovedReason.Expired ? EventType.EXPIRED : EventType.REMOVED;
        } else if (cea.getEventType() == com.alachisoft.ncache.runtime.events.EventType.ItemUpdated) {
            eventType = EventType.UPDATED;
        }
        NCacheEntryEventAdapter<K, V> e = new NCacheEntryEventAdapter<K, V>(this.jCache, eventType, cea, key);
        if (this.cacheEntryEventFilter != null && !this.cacheEntryEventFilter.evaluate(e)) {
            return;
        }
        ArrayList<NCacheEntryEventAdapter<K, V>> arrayList = new ArrayList<NCacheEntryEventAdapter<K, V>>();
        arrayList.add(e);
        if (cea.getEventType() == com.alachisoft.ncache.runtime.events.EventType.ItemAdded) {
            if (this.createdListener) {
                ((CacheEntryCreatedListener)this.cacheListener).onCreated(arrayList);
            }
        } else if (cea.getEventType() == com.alachisoft.ncache.runtime.events.EventType.ItemUpdated) {
            if (this.updatedListener) {
                ((CacheEntryUpdatedListener)this.cacheListener).onUpdated(arrayList);
            }
        } else if (cea.getEventType() == com.alachisoft.ncache.runtime.events.EventType.ItemRemoved) {
            if (cea.getCacheItemRemovedReason() == CacheItemRemovedReason.Expired) {
                if (this.expiredListener) {
                    ((CacheEntryExpiredListener)this.cacheListener).onExpired(arrayList);
                }
            } else if (this.removedListener) {
                ((CacheEntryRemovedListener)this.cacheListener).onRemoved(arrayList);
            }
        }
    }

    @Override
    public void onCacheCleared(String cacheName) {
    }

    @Override
    public void onCacheCleared() {
    }

    private boolean implementsMethods(Class cls) {
        return cls.isAssignableFrom(this.cacheListener.getClass());
    }
}

