/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.jsr107;

import com.alachisoft.ncache.client.Cache;
import com.alachisoft.ncache.client.CacheManager;
import com.alachisoft.ncache.jsr107.NCacheCache;
import com.alachisoft.ncache.jsr107.NCacheConfiguration;
import com.alachisoft.ncache.jsr107.NCacheMXBean;
import com.alachisoft.ncache.jsr107.NCacheManagementMXBean;
import com.alachisoft.ncache.jsr107.NCacheStatisticsMXBean;
import com.alachisoft.ncache.jsr107.spi.NCacheCachingProvider;
import com.alachisoft.ncache.runtime.exceptions.ConfigurationException;
import java.io.File;
import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.cache.CacheException;
import javax.cache.configuration.CompleteConfiguration;
import javax.cache.configuration.Configuration;
import javax.cache.spi.CachingProvider;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NCacheManager
implements javax.cache.CacheManager {
    protected static final int DEFAULT_SIZE = 1000;
    protected static MBeanServer mBeanServer = MBeanServerFactory.createMBeanServer();
    protected final NCacheCachingProvider jCacheCachingProvider;
    protected final URI uri;
    protected final Properties props;
    protected final ConcurrentHashMap<String, NCacheCache> allCaches = new ConcurrentHashMap();
    protected final ClassLoader classloader;
    protected final ExecutorService executorService = Executors.newSingleThreadExecutor();
    protected final ConcurrentMap<javax.cache.Cache, NCacheMXBean> cfgMXBeans = new ConcurrentHashMap<javax.cache.Cache, NCacheMXBean>();
    protected final ConcurrentMap<javax.cache.Cache, NCacheStatisticsMXBean> statMXBeans = new ConcurrentHashMap<javax.cache.Cache, NCacheStatisticsMXBean>();
    protected volatile boolean closed = false;

    public NCacheManager() {
        this.jCacheCachingProvider = new NCacheCachingProvider();
        this.props = new Properties();
        this.uri = null;
        this.classloader = null;
    }

    public NCacheManager(NCacheCachingProvider jCacheCachingProvider, ClassLoader classloader, URI uri, Properties props) {
        this.jCacheCachingProvider = jCacheCachingProvider;
        this.uri = uri;
        this.props = props;
        this.classloader = classloader;
    }

    public static HashSet<String> GetCacheNames(String path) throws ConfigurationException {
        HashSet<String> cacheNames;
        File file;
        block8: {
            file = null;
            cacheNames = new HashSet<String>();
            file = new File(path);
            if (file.exists()) break block8;
            HashSet<String> hashSet = cacheNames;
            return hashSet;
        }
        try {
            Document configuration = null;
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = null;
            try {
                builder = builderFactory.newDocumentBuilder();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                // empty catch block
            }
            configuration = builder.parse(file);
            NodeList cacheList = configuration.getElementsByTagName("cache");
            for (int i = 0; i < cacheList.getLength(); ++i) {
                String cacheName;
                Node cache = cacheList.item(i);
                if (!cache.hasAttributes() || (cacheName = cache.getAttributes().getNamedItem("id").getNodeValue()) == null && cacheName.equals("")) continue;
                cacheNames.add(cacheName.toLowerCase());
            }
        }
        catch (Exception e) {
            throw new ConfigurationException("An error occured while reading config file. " + e.getMessage());
        }
        return cacheNames;
    }

    public CachingProvider getCachingProvider() {
        return this.jCacheCachingProvider;
    }

    public URI getURI() {
        return this.uri;
    }

    public ClassLoader getClassLoader() {
        return this.classloader;
    }

    public Properties getProperties() {
        return this.props;
    }

    public <K, V, C extends Configuration<K, V>> javax.cache.Cache<K, V> createCache(String cacheName, C configuration) throws IllegalArgumentException {
        this.checkManagerStatus();
        if (configuration == null) {
            throw new NullPointerException();
        }
        NCacheCache jCache = this.allCaches.get(cacheName);
        if (jCache != null) {
            throw new CacheException("Cache with same name already exist");
        }
        try {
            Cache tayzGrid = CacheManager.getCache(cacheName);
            NCacheConfiguration cfg = new NCacheConfiguration(configuration);
            jCache = new NCacheCache(this, cfg, tayzGrid);
            NCacheCache previous = this.allCaches.putIfAbsent(cacheName, jCache);
            if (previous != null) {
                previous.setClose();
            }
            if (cfg.isStatisticsEnabled()) {
                this.enableStatistics(cacheName, true);
            }
            if (cfg.isManagementEnabled()) {
                this.enableManagement(cacheName, true);
            }
            return jCache;
        }
        catch (Exception ex) {
            throw new CacheException((Throwable)ex);
        }
    }

    public <K, V> javax.cache.Cache<K, V> getCache(String cacheName, Class<K> type, Class<V> valueType) {
        NCacheCache jCache = this.allCaches.get(cacheName);
        if (jCache != null) {
            return jCache;
        }
        try {
            Cache tayzGrid = CacheManager.getCache(cacheName);
            jCache = new NCacheCache(this, new NCacheConfiguration(cacheName, null, type, valueType), tayzGrid);
        }
        catch (Exception tayzGrid) {
            // empty catch block
        }
        NCacheCache previous = this.allCaches.putIfAbsent(cacheName, jCache);
        return jCache;
    }

    public <K, V> javax.cache.Cache<K, V> getCache(String cacheName) {
        NCacheCache jCache = this.allCaches.get(cacheName);
        if (jCache == null) {
            try {
                Cache tayzGrid = CacheManager.getCache(cacheName);
                jCache = new NCacheCache(this, new NCacheConfiguration(cacheName, null, String.class, Object.class), tayzGrid);
                this.allCaches.putIfAbsent(cacheName, jCache);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this.allCaches.get(cacheName);
        }
        if (jCache.getConfiguration(CompleteConfiguration.class).getKeyType() != Object.class || jCache.getConfiguration(CompleteConfiguration.class).getValueType() != Object.class) {
            throw new IllegalArgumentException();
        }
        return jCache;
    }

    public Iterable<String> getCacheNames() {
        return Collections.unmodifiableSet(new HashSet(this.allCaches.keySet()));
    }

    public void destroyCache(String cacheName) {
        this.checkManagerStatus();
        javax.cache.Cache jCache = this.allCaches.get(cacheName);
        this.allCaches.remove(cacheName);
        if (jCache != null) {
            jCache.close();
        }
    }

    public void enableManagement(String cacheName, boolean enabled) {
        this.checkManagerStatus();
        if (cacheName == null) {
            throw new NullPointerException();
        }
        NCacheCache jCache = this.allCaches.get(cacheName);
        if (jCache == null) {
            throw new NullPointerException();
        }
        this.enableManagement(enabled, jCache);
    }

    private void enableManagement(boolean enabled, NCacheCache jCache) {
        try {
            if (enabled) {
                this.registerObject(this.getOrCreateCfgObject(jCache));
            } else {
                this.unregisterObject((NCacheMXBean)this.cfgMXBeans.remove(jCache));
            }
            jCache.getConfiguration(NCacheConfiguration.class).setManagementEnabled(enabled);
        }
        catch (NotCompliantMBeanException e) {
            throw new CacheException((Throwable)e);
        }
        catch (InstanceAlreadyExistsException e) {
        }
        catch (MBeanRegistrationException e) {
            throw new CacheException((Throwable)e);
        }
        catch (InstanceNotFoundException e) {
        }
        catch (MalformedObjectNameException e) {
            throw new CacheException((Throwable)e);
        }
    }

    public void enableStatistics(String cacheName, boolean enabled) {
        this.checkManagerStatus();
        if (cacheName == null) {
            throw new NullPointerException();
        }
        NCacheCache jCache = this.allCaches.get(cacheName);
        if (jCache == null) {
            throw new NullPointerException();
        }
        this.enableStatistics(enabled, jCache);
    }

    private void enableStatistics(boolean enabled, NCacheCache jCache) {
        try {
            if (enabled) {
                this.registerObject(this.getOrCreateStatObject(jCache));
            } else {
                this.unregisterObject((NCacheMXBean)this.statMXBeans.remove(jCache));
            }
            jCache.getConfiguration(NCacheConfiguration.class).setStatisticsEnabled(enabled);
        }
        catch (NotCompliantMBeanException e) {
            throw new CacheException((Throwable)e);
        }
        catch (InstanceAlreadyExistsException e) {
        }
        catch (MBeanRegistrationException e) {
            throw new CacheException((Throwable)e);
        }
        catch (InstanceNotFoundException e) {
        }
        catch (MalformedObjectNameException e) {
            throw new CacheException("Illegal ObjectName for Management Bean. CacheManager=[" + this.getURI().toString() + "], Cache=[" + jCache.getName() + "]", (Throwable)e);
        }
    }

    public NCacheStatisticsMXBean getMBeanServer(String cache) {
        return (NCacheStatisticsMXBean)this.statMXBeans.get(this.allCaches.get(cache));
    }

    private void registerObject(NCacheMXBean cacheMXBean) throws NotCompliantMBeanException, InstanceAlreadyExistsException, MBeanRegistrationException, MalformedObjectNameException {
        ObjectName objectName = new ObjectName(cacheMXBean.getObjectName());
        if (mBeanServer.queryNames(objectName, null).isEmpty()) {
            mBeanServer.registerMBean(cacheMXBean, objectName);
        }
    }

    private void unregisterObject(NCacheMXBean cacheMXBean) throws MBeanRegistrationException, InstanceNotFoundException, MalformedObjectNameException {
        if (cacheMXBean == null) {
            return;
        }
        String name = cacheMXBean.getObjectName();
        ObjectName objectName = new ObjectName(name);
        for (ObjectName n : mBeanServer.queryNames(objectName, null)) {
            mBeanServer.unregisterMBean(n);
        }
    }

    private NCacheManagementMXBean getOrCreateCfgObject(NCacheCache jCache) {
        NCacheManagementMXBean previous;
        NCacheManagementMXBean cacheMXBean = (NCacheManagementMXBean)this.cfgMXBeans.get(jCache);
        if (cacheMXBean == null && (previous = (NCacheManagementMXBean)this.cfgMXBeans.putIfAbsent(jCache, cacheMXBean = new NCacheManagementMXBean(jCache))) != null) {
            cacheMXBean = previous;
        }
        return cacheMXBean;
    }

    private NCacheStatisticsMXBean getOrCreateStatObject(NCacheCache jCache) {
        NCacheStatisticsMXBean previous;
        NCacheStatisticsMXBean cacheMXBean = (NCacheStatisticsMXBean)this.statMXBeans.get(jCache);
        if (cacheMXBean == null && (previous = this.statMXBeans.putIfAbsent(jCache, cacheMXBean = new NCacheStatisticsMXBean(jCache))) != null) {
            cacheMXBean = previous;
        }
        return cacheMXBean;
    }

    public void close() {
        try {
            if (!this.closed) {
                this.jCacheCachingProvider.shutdown(this);
            }
        }
        catch (SecurityException e) {
            throw new CacheException((Throwable)e);
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void removeCache(String name) {
        this.allCaches.remove(name);
    }

    public <T> T unwrap(Class<T> type) {
        if (type.isAssignableFrom(this.getClass())) {
            return type.cast(this);
        }
        if (type.isAssignableFrom(javax.cache.CacheManager.class)) {
            return type.cast(javax.cache.CacheManager.class);
        }
        throw new IllegalArgumentException();
    }

    protected void checkManagerStatus() {
        if (this.closed) {
            throw new IllegalStateException();
        }
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public void shutdown() {
        for (javax.cache.Cache cache : this.allCaches.values()) {
            try {
                this.allCaches.remove(cache.getName());
                cache.close();
            }
            catch (Exception exception) {}
        }
        this.allCaches.clear();
        this.closed = true;
    }

    void shutdown(NCacheCache jCache) {
        javax.cache.Cache r = this.allCaches.remove(jCache.getName());
        if (r == jCache) {
            this.enableStatistics(false, jCache);
            this.enableManagement(false, jCache);
            jCache.shutdown();
        }
    }
}

