/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.jsr107;

import com.alachisoft.ncache.jsr107.NCacheCache;
import com.alachisoft.ncache.jsr107.NCacheMXBean;
import javax.cache.management.CacheStatisticsMXBean;

public class NCacheStatisticsMXBean
extends NCacheMXBean
implements CacheStatisticsMXBean {
    public NCacheStatisticsMXBean(NCacheCache jCache) {
        super(jCache, "Statistics");
    }

    public void clear() {
        this.jCache.clear();
    }

    public long getCacheHits() {
        return Math.round(this.getTayzGrid().getHitsPerSec());
    }

    public float getCacheHitPercentage() {
        double val = Math.round(this.getTayzGrid().getHitsRatioSec());
        if (Double.isNaN(val)) {
            return this.getTayzGrid().getHitsPerSec() == 0.0 ? 0.0f : 100.0f;
        }
        return (float)val * 100.0f;
    }

    public long getCacheMisses() {
        return Math.round(this.getTayzGrid().getCount());
    }

    public float getCacheMissPercentage() {
        double v = this.getTayzGrid().getHitsRatioSec();
        if (Double.isNaN(v)) {
            return 0.0f;
        }
        return (float)(1.0 - v) * 100.0f;
    }

    public long getCacheGets() {
        return (long)this.getTayzGrid().getGetsPerSec();
    }

    public long getCachePuts() {
        return (long)this.getTayzGrid().getInsertsPerSec();
    }

    public long getCacheRemovals() {
        return (long)this.getTayzGrid().getDelsPerSec();
    }

    public long getCacheEvictions() {
        return (long)this.getTayzGrid().getEvictionPerSec();
    }

    public float getAverageGetTime() {
        return (long)this.getTayzGrid().getGetsPerSec();
    }

    public float getAveragePutTime() {
        return (long)this.getTayzGrid().getInsertsPerSec();
    }

    public float getAverageRemoveTime() {
        return (long)this.getTayzGrid().getDelsPerSec();
    }
}

