/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Caching.AutoExpiration;

import Alachisoft.NCache.Caching.AutoExpiration.ExpirationHint;
import Alachisoft.NCache.Caching.Util.DbConnectionPool;
import Alachisoft.NCache.Caching.Util.OleDbConnectionPool;
import Alachisoft.NCache.Common.Logger.ILogger;
import Alachisoft.NCache.Common.ResourcePool;
import com.microsoft.sqlserver.jdbc.SQLServerDriver;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CacheDbSyncManager {
    public static final String SYNC_TABLE = "tgcache_db_sync";
    private HashMap _connStringTable;
    private OleDbConnectionPool _oledbConPool;
    private DbConnectionPool _sqlConPool;
    private HashMap _tblDepCount;
    private String _cacheID = null;
    private ILogger _ncacheLog;
    private HashMap _dbKeysMappingTbl;

    public CacheDbSyncManager(ILogger NCacheLog) {
        this._ncacheLog = NCacheLog;
        this._oledbConPool = new OleDbConnectionPool(NCacheLog);
        this._sqlConPool = new DbConnectionPool(NCacheLog);
        this._connStringTable = new HashMap();
        this._connStringTable.put("oledb", new HashMap());
        this._connStringTable.put("sql", new HashMap());
        this._dbKeysMappingTbl = new HashMap();
    }

    private ILogger getNCacheLog() {
        return this._ncacheLog;
    }

    public final HashMap getTblDepCount() {
        return this._tblDepCount;
    }

    public final HashMap getConnectoinStringTable() {
        return this._connStringTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void AddDBMapping(String dbKey, String cacheKey, ExpirationHint hint) {
        HashMap hashMap = this._dbKeysMappingTbl;
        synchronized (hashMap) {
            this._dbKeysMappingTbl.put(dbKey, new DependencyInformation(cacheKey, hint));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void RemoveDBMapping(String dbKey) {
        HashMap hashMap = this._dbKeysMappingTbl;
        synchronized (hashMap) {
            this._dbKeysMappingTbl.remove(dbKey);
        }
    }

    public final String GetCacheID(String instanceName) {
        if (this._cacheID == null) {
            this._cacheID = instanceName.indexOf("_BK_NODE_") != -1 ? instanceName.substring(0, instanceName.indexOf("_BK_NODE_")) : instanceName;
        }
        return this._cacheID;
    }

    public final boolean ConnectionStringExists(String connString) {
        return ((HashMap)this.getConnectoinStringTable().get("sql")).containsKey(connString.toLowerCase()) || ((HashMap)this.getConnectoinStringTable().get("oledb")).containsKey(connString.toLowerCase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void AddConnectionString(String connString, boolean isSql) {
        if (this._connStringTable != null) {
            HashMap hashMap = this._connStringTable;
            synchronized (hashMap) {
                if (isSql) {
                    if (!((HashMap)this._connStringTable.get("sql")).containsKey(connString.toLowerCase())) {
                        ((HashMap)this._connStringTable.get("sql")).put(connString.toLowerCase(), connString);
                    }
                } else if (!((HashMap)this._connStringTable.get("oledb")).containsKey(connString.toLowerCase())) {
                    ((HashMap)this._connStringTable.get("oledb")).put(connString.toLowerCase(), connString);
                }
            }
        }
    }

    public final Connection AddToOleDbConnectionPool(String connectionString) throws SQLException {
        Connection conn = null;
        return this._oledbConPool.PoolConnection(connectionString, conn);
    }

    public final void RemoveFromOleDbConnectionPool(String connectionString) {
        this._oledbConPool.RemoveConnection(connectionString.toLowerCase());
    }

    public final Connection AddToSqlConnectionPool(String connectionString) throws SQLException {
        Connection connection = null;
        SQLServerDriver sql = null;
        sql = new SQLServerDriver();
        try {
            connection = sql.connect(connectionString, null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return this._sqlConPool.PoolConnection(connectionString, connection);
    }

    public final void RemoveFromSqlConnectionPool(String connectionString) {
        this._sqlConPool.RemoveConnection(connectionString.toLowerCase());
    }

    public final void AcquireSyncData() throws SQLException {
        if (this._cacheID == null) {
            return;
        }
        String connString = "";
        try {
            for (Map.Entry pair : ((HashMap)this._connStringTable.get("oledb")).entrySet()) {
                connString = pair.getValue().toString();
                this.AddToOleDbConnectionPool(connString);
            }
            this._oledbConPool.AcquireSyncData(SYNC_TABLE, this._cacheID);
        }
        catch (SQLException e) {
            this.getNCacheLog().Error("CacheDbSyncManager", e.toString());
            if (e.getMessage().contains("Unsuported connection string:")) {
                ((HashMap)this._connStringTable.get("oledb")).remove(connString.toLowerCase());
                this.RemoveFromOleDbConnectionPool(connString);
            }
            throw e;
        }
        catch (Exception e) {
            this.getNCacheLog().Error("CacheDbSyncManager", e.toString());
        }
        try {
            connString = "";
            for (Map.Entry pair : ((HashMap)this._connStringTable.get("sql")).entrySet()) {
                connString = pair.getValue().toString();
                this.AddToSqlConnectionPool(connString);
            }
            this._sqlConPool.AcquireSyncData(SYNC_TABLE, this._cacheID);
        }
        catch (SQLException e) {
            this.getNCacheLog().Error("CacheDbSyncManager", e.toString());
            if (e.getMessage().contains("Unsuported connection string:")) {
                ((HashMap)this._connStringTable.get("sql")).remove(connString.toLowerCase());
                this.RemoveFromSqlConnectionPool(connString);
            }
            throw e;
        }
    }

    public final void RemoveSyncData() {
        if (this._cacheID == null) {
            return;
        }
        try {
            this._oledbConPool.RemoveSyncData(SYNC_TABLE, this._cacheID);
        }
        catch (Exception e) {
            this.getNCacheLog().Error("CacheDbSyncManager", e.toString());
        }
        try {
            this._sqlConPool.RemoveSyncData(SYNC_TABLE, this._cacheID);
        }
        catch (Exception e) {
            this.getNCacheLog().Error("CacheDbSyncManager", e.toString());
        }
    }

    public final void ClearResourcePools() {
        this._sqlConPool.removeAllResources();
    }

    public final void Clear() {
        this.RemoveAllResources();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void RemoveAllResources() {
        Iterator em;
        Connection connection;
        Object[] tableInfo = new Object[]{SYNC_TABLE, this._cacheID};
        ResourcePool resourcePool = this._oledbConPool;
        synchronized (resourcePool) {
            connection = null;
            em = this._oledbConPool.getKeys().iterator();
            boolean oldAutoCommit = false;
            while (em.hasNext()) {
                Object reader = null;
                Statement command = null;
                try {
                    OleDbConnectionPool.SqlDbResourceInfo connInfo = (OleDbConnectionPool.SqlDbResourceInfo)this._oledbConPool.GetResource((String)em.next());
                    connection = connInfo.getConnection();
                    oldAutoCommit = connection.getAutoCommit();
                    connection.setAutoCommit(false);
                    command = connection.createStatement();
                    int rowsAffected = command.executeUpdate(String.format("DELETE FROM %1$s WHERE CACHE_ID = '%2$s'", tableInfo));
                    connection.commit();
                    connection.setAutoCommit(oldAutoCommit);
                }
                catch (Exception ex) {
                    this.getNCacheLog().Error(ex.toString());
                }
                finally {
                    if (command == null) continue;
                    try {
                        command.close();
                    }
                    catch (SQLException ex) {
                        Logger.getLogger(CacheDbSyncManager.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    command = null;
                }
            }
            this._oledbConPool.removeAllResources();
            this._tblDepCount = null;
        }
        resourcePool = this._sqlConPool;
        synchronized (resourcePool) {
            connection = null;
            em = this._sqlConPool.getKeys().iterator();
            while (em.hasNext()) {
                ResultSet reader = null;
                Statement command = null;
                try {
                    DbConnectionPool.DbResourceInfo connInfo = (DbConnectionPool.DbResourceInfo)this._sqlConPool.GetResource((String)em.next());
                    connection = connInfo.getConnection();
                    command = connection.createStatement();
                    String sql = String.format("DELETE FROM %1$s WHERE CACHE_ID = '%2$s'", tableInfo);
                    command.executeUpdate(sql);
                }
                catch (Exception ex) {
                    this.getNCacheLog().Error(ex.toString());
                }
                finally {
                    if (reader == null) continue;
                    try {
                        reader.close();
                    }
                    catch (SQLException ex) {
                        Logger.getLogger(CacheDbSyncManager.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    reader = null;
                }
            }
            this._sqlConPool.removeAllResources();
        }
    }

    public final void FlushSyncData() {
        try {
            this._sqlConPool.FlushSyncData();
        }
        catch (Exception e) {
            this.getNCacheLog().Error("CacheDbSyncManager", e.toString());
        }
    }

    public final boolean IsSqlItemExpired(String cacheKey, String connectionString) {
        boolean count = false;
        Map dbSyncData = this._sqlConPool.GetResourceSyncInfo(connectionString);
        return dbSyncData != null && dbSyncData.containsKey(cacheKey);
    }

    public final void UpdateDepCount(String cacheKey) {
        if (this._tblDepCount == null) {
            this._tblDepCount = new HashMap();
        }
        if (this._tblDepCount.containsKey(cacheKey)) {
            int depCount = (Integer)this._tblDepCount.get(cacheKey);
            this._tblDepCount.put(cacheKey, ++depCount);
        } else {
            this._tblDepCount.put(cacheKey, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final HashMap GetExpiredKeys() {
        ArrayList sqlKeyList = this._sqlConPool.GetExpiredKeys();
        sqlKeyList.addAll(this._oledbConPool.GetExpiredKeys());
        if (sqlKeyList != null && sqlKeyList.size() > 0) {
            HashMap cacheKeyList = new HashMap();
            ArrayList<String> expire = new ArrayList<String>();
            ArrayList<String> resync = new ArrayList<String>();
            Iterator ie = sqlKeyList.iterator();
            HashMap hashMap = this._dbKeysMappingTbl;
            synchronized (hashMap) {
                while (ie.hasNext()) {
                    DependencyInformation depInfo;
                    String key = ie.next().toString();
                    Object val = this._dbKeysMappingTbl.get(key);
                    if (!this._dbKeysMappingTbl.containsKey(key) || (depInfo = (DependencyInformation)val instanceof DependencyInformation ? (DependencyInformation)val : null) == null) continue;
                    if (depInfo.getHint().getNeedsReSync()) {
                        resync.add(depInfo.getCacheKey());
                        continue;
                    }
                    expire.add(depInfo.getCacheKey());
                }
                cacheKeyList.put("expire-items", expire);
                cacheKeyList.put("resync-items", resync);
                return cacheKeyList;
            }
        }
        return new HashMap();
    }

    public static class DependencyInformation {
        private String _cacheKey;
        private ExpirationHint _hint;

        public DependencyInformation(String key, ExpirationHint hint) {
            this._cacheKey = key;
            this._hint = hint;
        }

        public final String getCacheKey() {
            return this._cacheKey;
        }

        public final ExpirationHint getHint() {
            return this._hint;
        }
    }
}

