/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Caching.AutoExpiration;

import Alachisoft.NCache.Caching.AutoExpiration.ExpirationHint;
import Alachisoft.NCache.Caching.AutoExpiration.ExpirationHintType;
import Alachisoft.NCache.Caching.CacheRuntimeContext;
import Alachisoft.NCache.Common.AppUtil;
import com.alachisoft.ncache.serialization.core.io.ICompactSerializable;
import com.alachisoft.ncache.serialization.core.io.NCacheObjectInput;
import com.alachisoft.ncache.serialization.core.io.NCacheObjectOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;

public abstract class DependencyHint
extends ExpirationHint
implements ICompactSerializable,
Serializable {
    protected int _startAfter;

    protected DependencyHint() {
        this._hintType = ExpirationHintType.DependencyHint;
        try {
            this._startAfter = AppUtil.DiffSeconds((Date)new Date());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    protected DependencyHint(Date startAfter) {
        try {
            this._startAfter = AppUtil.DiffSeconds((Date)startAfter);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Override
    public final int getSortKey() {
        return this._startAfter;
    }

    @Override
    public boolean DetermineExpiration(CacheRuntimeContext context) {
        try {
            if (new Integer(this._startAfter).compareTo(AppUtil.DiffSeconds((Date)new Date())) > 0) {
                return false;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (!this.getHasExpired() && this.getHasChanged()) {
            this.NotifyExpiration(this, null);
        }
        return this.getHasExpired();
    }

    @Override
    public boolean CheckExpired(CacheRuntimeContext context) {
        return this.DetermineExpiration(context);
    }

    public abstract boolean getHasChanged();

    @Override
    public void deserialize(NCacheObjectInput reader) throws ClassNotFoundException, IOException {
        super.deserialize(reader);
        this._startAfter = reader.readInt();
    }

    @Override
    public void serialize(NCacheObjectOutput writer) throws IOException {
        super.serialize(writer);
        writer.writeInt(this._startAfter);
    }
}

