/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Caching.AutoExpiration;

import Alachisoft.NCache.Caching.AutoExpiration.DependencyHint;
import Alachisoft.NCache.Caching.AutoExpiration.ExpirationHintType;
import Alachisoft.NCache.Caching.CacheRuntimeContext;
import com.alachisoft.ncache.runtime.exceptions.OperationFailedException;
import com.alachisoft.ncache.runtime.util.NCDateTime;
import com.alachisoft.ncache.serialization.core.io.ICompactSerializable;
import com.alachisoft.ncache.serialization.core.io.NCacheObjectInput;
import com.alachisoft.ncache.serialization.core.io.NCacheObjectOutput;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;

public class FileDependency
extends DependencyHint
implements ICompactSerializable,
Serializable {
    private boolean[] _fileExists;
    private boolean[] _isDir;
    private String[] _fileName;
    private Date[] _lastWriteTime;
    private long _startAfterTicks;

    public FileDependency() {
        this._hintType = ExpirationHintType.FileDependency;
    }

    public FileDependency(String fileName) {
        this(fileName, new Date());
        this._hintType = ExpirationHintType.FileDependency;
    }

    public FileDependency(String[] fileName) {
        this(fileName, new Date());
        this._hintType = ExpirationHintType.FileDependency;
    }

    public FileDependency(String fileName, Date startAfter) {
        this(new String[]{fileName}, startAfter);
        this._hintType = ExpirationHintType.FileDependency;
    }

    public FileDependency(String[] fileName, Date startAfter) {
        super(startAfter);
        this._hintType = ExpirationHintType.FileDependency;
        this._fileName = fileName;
        NCDateTime ncdt = null;
        try {
            ncdt = new NCDateTime(startAfter);
        }
        catch (IllegalArgumentException argumentException) {
            this._startAfterTicks = Long.MAX_VALUE;
        }
        this._startAfterTicks = ncdt.getTicks();
        try {
            this.Initialize(this._fileName);
        }
        catch (OperationFailedException operationFailedException) {
            // empty catch block
        }
    }

    @Override
    public boolean Reset(CacheRuntimeContext context) throws OperationFailedException {
        if (context.IsClientCache) {
            return true;
        }
        super.Reset(context);
        return this.Initialize(this.getfileNames());
    }

    @Override
    public boolean getHasChanged() {
        return this.fileExpired();
    }

    public final String[] getfileNames() {
        return this._fileName;
    }

    public final long getStartAfterTicks() {
        return this._startAfterTicks;
    }

    public String toString() {
        Object toString = "FILEDEPENDENCY \"";
        for (int i = 0; i < this._fileName.length; ++i) {
            toString = (String)toString + this._fileName[i] + "\"";
        }
        toString = (String)toString + "STARTAFTER\"" + this._startAfterTicks + "\"\r\n";
        return toString;
    }

    private boolean Initialize(String[] fileName) throws OperationFailedException {
        int length = fileName.length;
        this._fileExists = new boolean[length];
        this._isDir = new boolean[length];
        this._lastWriteTime = new Date[length];
        this._fileName = new String[length];
        try {
            for (int i = 0; i < length; ++i) {
                File fileInfo = new File(fileName[i]);
                this._fileName[i] = fileName[i];
                boolean bl = this._isDir[i] = fileInfo.isDirectory();
                if (this._isDir[i]) {
                    File dirInfo = new File(fileName[i]);
                    this._fileExists[i] = dirInfo.exists();
                    this._lastWriteTime[i] = new Date(dirInfo.lastModified());
                    continue;
                }
                this._fileExists[i] = fileInfo.exists();
                this._lastWriteTime[i] = new Date(fileInfo.lastModified());
            }
        }
        catch (Exception e) {
            throw new OperationFailedException((Throwable)e);
        }
        return true;
    }

    private boolean fileExpired() {
        int length = this._fileName.length;
        boolean isDir = false;
        boolean fileExists = false;
        Date lastWriteTime = new Date(0L);
        for (int i = 0; i < length; ++i) {
            File fileInfo = new File(this._fileName[i]);
            boolean bl = isDir = fileInfo.isDirectory();
            if (isDir) {
                File dirInfo = new File(this._fileName[i]);
                fileExists = dirInfo.exists();
                lastWriteTime = new Date(dirInfo.lastModified());
            } else {
                fileExists = fileInfo.exists();
                lastWriteTime = new Date(fileInfo.lastModified());
            }
            if (this._fileExists[i]) {
                if (!fileExists) {
                    return true;
                }
                if (isDir != this._isDir[i]) {
                    return true;
                }
                if (this._lastWriteTime[i].equals(lastWriteTime)) continue;
                return true;
            }
            if (!fileExists) continue;
            return true;
        }
        return false;
    }

    @Override
    public void deserialize(NCacheObjectInput reader) throws ClassNotFoundException, IOException {
        super.deserialize(reader);
        this._fileExists = (boolean[])reader.readObject();
        this._isDir = (boolean[])reader.readObject();
        this._fileName = (String[])reader.readObject();
        this._lastWriteTime = (Date[])reader.readObject();
        this._startAfterTicks = reader.readLong();
    }

    @Override
    public void serialize(NCacheObjectOutput writer) throws IOException {
        super.serialize(writer);
        writer.writeObject((Object)this._fileExists);
        writer.writeObject((Object)this._isDir);
        writer.writeObject((Object)this._fileName);
        writer.writeObject((Object)this._lastWriteTime);
        writer.writeLong(this._startAfterTicks);
    }
}

