/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Caching.AutoExpiration;

import Alachisoft.NCache.Caching.AutoExpiration.ExpirationHint;
import Alachisoft.NCache.Caching.AutoExpiration.ExpirationHintType;
import Alachisoft.NCache.Caching.CacheRuntimeContext;
import Alachisoft.NCache.Common.AppUtil;
import com.alachisoft.ncache.runtime.exceptions.OperationFailedException;
import com.alachisoft.ncache.runtime.util.TimeSpan;
import com.alachisoft.ncache.serialization.core.io.ICompactSerializable;
import com.alachisoft.ncache.serialization.core.io.NCacheObjectInput;
import com.alachisoft.ncache.serialization.core.io.NCacheObjectOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;

public class IdleExpiration
extends ExpirationHint
implements ICompactSerializable,
Serializable {
    private int _idleTimeToLive;
    private int _lastTimeStamp;

    public IdleExpiration() {
        this._hintType = ExpirationHintType.IdleExpiration;
    }

    public IdleExpiration(TimeSpan idleTTL) {
        this.SetBit(4);
        this._idleTimeToLive = (int)idleTTL.getTotalMiliSeconds() / 1000;
        try {
            this._lastTimeStamp = AppUtil.DiffSeconds((Date)new Date());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this._hintType = ExpirationHintType.IdleExpiration;
    }

    public final TimeSpan getSlidingTime() {
        return new TimeSpan(0, 0, this._idleTimeToLive);
    }

    public String toString() {
        return "";
    }

    public final int getLastAccessTime() {
        return this._lastTimeStamp;
    }

    @Override
    public int getSortKey() {
        return this._lastTimeStamp + this._idleTimeToLive;
    }

    @Override
    public boolean DetermineExpiration(CacheRuntimeContext context) {
        if (this.getHasExpired()) {
            return true;
        }
        try {
            if (new Integer(this.getSortKey()).compareTo(AppUtil.DiffSeconds((Date)new Date())) < 0) {
                this.NotifyExpiration(this, null);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return this.getHasExpired();
    }

    @Override
    public boolean Reset(CacheRuntimeContext context) throws OperationFailedException {
        try {
            this._lastTimeStamp = AppUtil.DiffSeconds((Date)new Date());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return super.Reset(context);
    }

    @Override
    public final void deserialize(NCacheObjectInput reader) throws ClassNotFoundException, IOException {
        super.deserialize(reader);
        this._idleTimeToLive = reader.readInt();
        this._lastTimeStamp = reader.readInt();
    }

    @Override
    public final void serialize(NCacheObjectOutput writer) throws IOException {
        super.serialize(writer);
        writer.writeInt(this._idleTimeToLive);
        writer.writeInt(this._lastTimeStamp);
    }
}

