/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Caching.AutoExpiration;

import Alachisoft.NCache.Caching.AutoExpiration.DependencyHint;
import Alachisoft.NCache.Caching.AutoExpiration.ExpirationHintType;
import Alachisoft.NCache.Caching.CacheRuntimeContext;
import Alachisoft.NCache.Common.AppUtil;
import com.alachisoft.ncache.runtime.exceptions.OperationFailedException;
import com.alachisoft.ncache.runtime.util.HelperFxn;
import com.alachisoft.ncache.serialization.core.io.ICompactSerializable;
import com.alachisoft.ncache.serialization.core.io.NCacheObjectInput;
import com.alachisoft.ncache.serialization.core.io.NCacheObjectOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;

public class KeyDependency
extends DependencyHint
implements ICompactSerializable,
Serializable {
    private String[] _cacheKeys;
    private long _startAfterTicks;

    public KeyDependency() {
        this._hintType = ExpirationHintType.KeyDependency;
    }

    public KeyDependency(String key) {
        this(new String[]{key}, new Date());
        this._hintType = ExpirationHintType.KeyDependency;
    }

    public KeyDependency(String key, Date startAfter) {
        this(new String[]{key}, startAfter);
        this._hintType = ExpirationHintType.KeyDependency;
    }

    public KeyDependency(String[] keys) {
        this(keys, new Date());
        this._hintType = ExpirationHintType.KeyDependency;
    }

    public KeyDependency(String[] keys, Date startAfter) {
        super(startAfter);
        this._hintType = ExpirationHintType.KeyDependency;
        this._cacheKeys = keys;
        this._startAfterTicks = HelperFxn.getUTCTicks((Date)startAfter);
    }

    public final String[] getCacheKeys() {
        return this._cacheKeys;
    }

    public final long getStartAfterTicks() {
        return this._startAfterTicks;
    }

    @Override
    public boolean DetermineExpiration(CacheRuntimeContext context) {
        try {
            if (new Integer(this._startAfter).compareTo(AppUtil.DiffSeconds((Date)new Date())) > 0) {
                return false;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return this.getHasExpired();
    }

    @Override
    public boolean CheckExpired(CacheRuntimeContext context) {
        return this.DetermineExpiration(context);
    }

    @Override
    public boolean Reset(CacheRuntimeContext context) throws OperationFailedException {
        if (context.IsClientCache) {
            return true;
        }
        return super.Reset(context);
    }

    @Override
    public boolean getHasChanged() {
        return false;
    }

    public String toString() {
        Object toString = "KEYDEPENDENCY \"";
        for (int i = 0; i < this._cacheKeys.length; ++i) {
            toString = (String)toString + this._cacheKeys[i] + "\"";
        }
        toString = (String)toString + "STARTAFTER\"" + new Long(this._startAfterTicks).toString() + "\"\r\n";
        return toString;
    }

    @Override
    public void deserialize(NCacheObjectInput reader) throws ClassNotFoundException, IOException {
        super.deserialize(reader);
        this._cacheKeys = (String[])reader.readObject();
        this._startAfterTicks = reader.readLong();
    }

    @Override
    public void serialize(NCacheObjectOutput writer) throws IOException {
        super.serialize(writer);
        writer.writeObject((Object)this._cacheKeys);
        writer.writeLong(this._startAfterTicks);
    }
}

