/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Caching;

import Alachisoft.NCache.Caching.Cache;
import Alachisoft.NCache.Common.Event.NEventStart;
import Alachisoft.NCache.Config.ConfigReader;
import Alachisoft.NCache.Config.Dom.CacheServerConfig;
import Alachisoft.NCache.Config.PropsConfigReader;
import Alachisoft.NCache.Config.XmlConfigReader;
import com.alachisoft.ncache.runtime.exceptions.ConfigurationException;
import java.util.HashMap;
import java.util.Map;

public class CacheFactory {
    public static Cache CreateFromXmlConfig(String configFileName, String configSection, NEventStart itemAdded, NEventStart itemRemoved, NEventStart itemUpdated, NEventStart cacheCleared, NEventStart customRemove, NEventStart customUpdate) throws ConfigurationException {
        XmlConfigReader xmlReader = new XmlConfigReader(configFileName, configSection);
        return CacheFactory.CreateFromProperties(((ConfigReader)xmlReader).getProperties(), itemAdded, itemRemoved, itemUpdated, cacheCleared, customRemove, customUpdate);
    }

    public static Cache CreateFromPropertyString(String propertyString, String userId, String password) throws ConfigurationException {
        return CacheFactory.CreateFromPropertyString(propertyString, userId, password, false);
    }

    public static Cache CreateFromPropertyString(String propertyString, String userId, String password, boolean isStartedAsMirror) throws ConfigurationException {
        PropsConfigReader propReader = new PropsConfigReader(propertyString);
        return CacheFactory.CreateFromProperties(((ConfigReader)propReader).getProperties(), null, null, null, null, null, null, null, userId, password, isStartedAsMirror, false);
    }

    public static Cache CreateFromPropertyString(String propertyString, CacheServerConfig config, String userId, String password, boolean isStartedAsMirror, boolean twoPhaseInitialization) throws ConfigurationException {
        return CacheFactory.CreateFromPropertyString(propertyString, config, userId, password, isStartedAsMirror, twoPhaseInitialization, true);
    }

    public static Cache CreateFromPropertyString(String propertyString, CacheServerConfig config, String userId, String password, boolean isStartedAsMirror, boolean twoPhaseInitialization, boolean inProc) throws ConfigurationException {
        PropsConfigReader propReader = new PropsConfigReader(propertyString);
        HashMap map = ((ConfigReader)propReader).getProperties();
        Map cacheConfig = (Map)map.get("cache");
        if (cacheConfig != null) {
            cacheConfig.put("inproc", inProc);
        }
        return CacheFactory.CreateFromProperties(map, config, null, null, null, null, null, null, userId, password, isStartedAsMirror, twoPhaseInitialization);
    }

    public static Cache CreateFromPropertyString(Map propertyString, CacheServerConfig config, String userId, String password, boolean isStartedAsMirror, boolean twoPhaseInitialization) throws ConfigurationException {
        return CacheFactory.CreateFromProperties(propertyString, config, null, null, null, null, null, null, userId, password, isStartedAsMirror, twoPhaseInitialization);
    }

    public static Cache CreateFromPropertyString(String propertyString) throws ConfigurationException {
        PropsConfigReader propReader = new PropsConfigReader(propertyString);
        return CacheFactory.CreateFromProperties(((ConfigReader)propReader).getProperties(), null, null, null, null, null, null);
    }

    public static Cache CreateFromPropertyString(String propertyString, NEventStart itemAdded, NEventStart itemRemoved, NEventStart itemUpdated, NEventStart cacheCleared, NEventStart customRemove, NEventStart customUpdate) throws ConfigurationException {
        PropsConfigReader propReader = new PropsConfigReader(propertyString);
        return CacheFactory.CreateFromProperties(((ConfigReader)propReader).getProperties(), itemAdded, itemRemoved, itemUpdated, cacheCleared, customRemove, customUpdate);
    }

    private static Cache CreateFromProperties(Map properties, NEventStart itemAdded, NEventStart itemRemoved, NEventStart itemUpdated, NEventStart cacheCleared, NEventStart customRemove, NEventStart customUpdate) throws ConfigurationException {
        Cache cache = new Cache();
        if (itemAdded != null) {
            cache.addItemAddedListner(itemAdded, null);
        }
        if (itemRemoved != null) {
            cache.addItemRemovedListner(itemRemoved, null);
        }
        if (itemUpdated != null) {
            cache.addItemUpdatedListner(itemUpdated, null);
        }
        if (cacheCleared != null) {
            cache.addCacheClearedListner(cacheCleared, null);
        }
        if (customRemove != null) {
            cache.addCustomRemoveNotifListner(customRemove, null);
        }
        if (customUpdate != null) {
            cache.addCustomUpdateNotifListner(customUpdate, null);
        }
        cache.Initialize(properties, true, null, null);
        return cache;
    }

    private static Cache CreateFromProperties(Map properties, NEventStart itemAdded, NEventStart itemRemoved, NEventStart itemUpdated, NEventStart cacheCleared, NEventStart customRemove, NEventStart customUpdate, String userId, String password) throws ConfigurationException {
        return CacheFactory.CreateFromProperties(properties, null, itemAdded, itemRemoved, itemUpdated, cacheCleared, customRemove, customUpdate, userId, password, false, false);
    }

    private static Cache CreateFromProperties(Map properties, CacheServerConfig config, NEventStart itemAdded, NEventStart itemRemoved, NEventStart itemUpdated, NEventStart cacheCleared, NEventStart customRemove, NEventStart customUpdate, String userId, String password, boolean isStartingAsMirror, boolean twoPhaseInitialization) throws ConfigurationException {
        Cache cache = new Cache();
        cache.setConfiguration(config);
        if (itemAdded != null) {
            cache.addItemAddedListner(itemAdded, null);
        }
        if (itemRemoved != null) {
            cache.addItemRemovedListner(itemRemoved, null);
        }
        if (itemUpdated != null) {
            cache.addItemUpdatedListner(itemUpdated, null);
        }
        if (cacheCleared != null) {
            cache.addCacheClearedListner(cacheCleared, null);
        }
        if (customRemove != null) {
            cache.addCustomRemoveNotifListner(customRemove, null);
        }
        if (customUpdate != null) {
            cache.addCustomUpdateNotifListner(customUpdate, null);
        }
        cache.Initialize(properties, true, userId, password, isStartingAsMirror, twoPhaseInitialization);
        return cache;
    }

    public final Cache CreateFromXmlConfig(String configFileName, String configSection) throws ConfigurationException {
        XmlConfigReader xmlReader = new XmlConfigReader(configFileName, configSection);
        return CacheFactory.CreateFromProperties(((ConfigReader)xmlReader).getProperties(), null, null, null, null, null, null);
    }
}

