/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Caching.DataGrouping;

import com.alachisoft.ncache.serialization.core.io.ICompactSerializable;
import com.alachisoft.ncache.serialization.core.io.NCacheObjectInput;
import com.alachisoft.ncache.serialization.core.io.NCacheObjectOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;

public class DataAffinity
implements Cloneable,
ICompactSerializable,
Serializable {
    private ArrayList _groups = new ArrayList();
    private ArrayList _allBindedGroups = new ArrayList();
    private ArrayList _unbindedGroups = new ArrayList();
    private boolean _strict;
    private boolean _serialize;

    public DataAffinity() {
    }

    public DataAffinity(ArrayList groups, boolean strict) {
        if (groups != null) {
            this._groups = (ArrayList)groups.clone();
            Collections.sort(this._groups);
        }
        this._strict = strict;
    }

    public DataAffinity(ArrayList groups, ArrayList allBindedGroups, ArrayList unbindGroups, boolean strict) {
        if (groups != null) {
            this._groups = (ArrayList)groups.clone();
            Collections.sort(this._groups);
        }
        if (allBindedGroups != null) {
            this._allBindedGroups = (ArrayList)allBindedGroups.clone();
            Collections.sort(this._allBindedGroups);
        }
        if (unbindGroups != null) {
            this._unbindedGroups = (ArrayList)unbindGroups.clone();
            Collections.sort(this._unbindedGroups);
        }
        this._strict = strict;
    }

    public DataAffinity(Map props) {
        int i;
        ArrayList<String> list;
        String[] groups;
        String groupsStr;
        if (props.containsKey("strict")) {
            this._strict = (Boolean)props.get("strict");
        }
        if (props.containsKey("data-groups") && (groupsStr = (String)props.get("data-groups")).trim().length() > 0) {
            groups = groupsStr.split("[,]", -1);
            list = new ArrayList<String>();
            for (i = 0; i < groups.length; ++i) {
                list.add(groups[i]);
            }
            Collections.sort(list);
            this._groups = list;
        }
        if (props.containsKey("binded-groups-list") && (groupsStr = (String)props.get("binded-groups-list")).trim().length() > 0) {
            groups = groupsStr.split("[,]", -1);
            list = new ArrayList();
            for (i = 0; i < groups.length; ++i) {
                list.add(groups[i]);
            }
            Collections.sort(list);
            this._allBindedGroups = list;
        }
    }

    public final ArrayList getGroups() {
        return this._groups == null ? null : (ArrayList)this._groups.clone();
    }

    public final void setGroups(ArrayList value) {
        this._groups = value;
        if (this._groups != null) {
            Collections.sort(this._groups);
        }
    }

    public final ArrayList getAllBindedGroups() {
        return this._allBindedGroups == null ? null : (ArrayList)this._allBindedGroups.clone();
    }

    public final void setAllBindedGroups(ArrayList value) {
        this._allBindedGroups = value;
        if (this._allBindedGroups != null) {
            Collections.sort(this._allBindedGroups);
        }
    }

    public final ArrayList getAllUndbindedGroups() {
        return this._unbindedGroups == null ? null : (ArrayList)this._unbindedGroups.clone();
    }

    public final void setAllUndbindedGroups(ArrayList value) {
        this._unbindedGroups = value;
        if (this._unbindedGroups != null) {
            Collections.sort(this._unbindedGroups);
        }
    }

    public final boolean getStrict() {
        return this._strict;
    }

    public final boolean IsExists(String group) {
        if (group == null) {
            return false;
        }
        if (this._groups == null) {
            return false;
        }
        return Collections.binarySearch(this._groups, group) >= 0;
    }

    public final boolean IsUnbindedGroups(String group) {
        if (group == null) {
            return false;
        }
        if (this._unbindedGroups == null) {
            return false;
        }
        return Collections.binarySearch(this._unbindedGroups, group) >= 0;
    }

    public final Object clone() {
        return new DataAffinity(this._groups, this._allBindedGroups, this._unbindedGroups, this._strict);
    }

    public final void serialize(NCacheObjectOutput writer) throws IOException {
        writer.writeBoolean(this._strict);
        writer.writeObject((Object)this._groups);
        writer.writeObject((Object)this._allBindedGroups);
        writer.writeObject((Object)this._unbindedGroups);
    }

    public final void deserialize(NCacheObjectInput reader) throws ClassNotFoundException, IOException {
        this._strict = reader.readBoolean();
        this._groups = (ArrayList)reader.readObject();
        this._allBindedGroups = (ArrayList)reader.readObject();
        this._unbindedGroups = (ArrayList)reader.readObject();
    }

    public static DataAffinity readDataAffinity(NCacheObjectInput reader) throws IOException, ClassNotFoundException {
        byte isNull = reader.readByte();
        if (isNull == 1) {
            return null;
        }
        DataAffinity newAffinity = new DataAffinity();
        newAffinity.deserialize(reader);
        return newAffinity;
    }

    public static void writeDataAffinity(NCacheObjectOutput writer, DataAffinity dataAffinity) throws IOException {
        int isNull = 1;
        if (dataAffinity == null) {
            writer.write(isNull);
        } else {
            isNull = 0;
            writer.write(isNull);
            dataAffinity.serialize(writer);
        }
    }
}

