/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Caching.DataGrouping;

import Alachisoft.NCache.Caching.DataGrouping.DataAffinity;
import Alachisoft.NCache.Common.Net.Address;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

public class DataGroupsMapping
implements Cloneable {
    private HashMap _groupMap = new HashMap();

    public DataGroupsMapping() {
    }

    public DataGroupsMapping(String groupList) {
        this.Initialize(groupList);
    }

    public final void Initialize(String groupList) {
        String[] gList;
        if (groupList != null && (gList = groupList.split("[,]", -1)) != null) {
            for (int i = 0; i < gList.length; ++i) {
                if (!this._groupMap.containsKey(gList[i])) continue;
                this._groupMap.put(gList[i], null);
            }
        }
    }

    public final boolean HasDatGroup(String group) {
        return this._groupMap.containsKey(group);
    }

    public final Collection getGroupList() {
        return this._groupMap.keySet();
    }

    public final void AddDataGroup(String group, Address node) {
        if (group == null) {
            return;
        }
        ArrayList nodeList = null;
        if (node != null) {
            nodeList = this._groupMap.containsKey(group) ? (ArrayList)this._groupMap.get(group) : new ArrayList();
            nodeList.add(node);
        }
        this._groupMap.put(group, nodeList);
    }

    public final void AddDataGroup(DataAffinity affinity, Address node) {
        if (affinity == null || node == null) {
            return;
        }
        if (affinity.getGroups() != null) {
            for (String group : affinity.getGroups()) {
                this.AddDataGroup(group, node);
            }
        }
    }

    public final Object clone() {
        return null;
    }
}

