/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Caching.DatasourceProviders;

import Alachisoft.NCache.Caching.CacheLoader.JarFileLoader;
import Alachisoft.NCache.Caching.CacheRuntimeContext;
import Alachisoft.NCache.Caching.DatasourceProviders.ClassPaths;
import Alachisoft.NCache.Common.AppUtil;
import Alachisoft.NCache.Common.DirectoryUtil;
import Alachisoft.NCache.Common.IDisposable;
import Alachisoft.NCache.Common.Logger.ILogger;
import Alachisoft.NCache.Common.Util.AuthenticateFeature;
import Alachisoft.NCache.Common.Util.LanguageContext;
import Alachisoft.NCache.Config.NewDom.Assembly;
import com.alachisoft.ncache.runtime.datasourceprovider.ProviderCacheItem;
import com.alachisoft.ncache.runtime.datasourceprovider.ReadThruProvider;
import com.alachisoft.ncache.runtime.exceptions.ConfigurationException;
import com.alachisoft.ncache.runtime.exceptions.OperationFailedException;
import com.alachisoft.ncache.serialization.util.SerializationUtil;
import com.alachisoft.ncache.serialization.util.TypeInfoMap;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import tangible.RefObject;

public class ReadThruProviderMgr
implements IDisposable {
    private Assembly _asm;
    private CacheRuntimeContext _context;
    private ReadThruProvider _dsReader;
    private String _cacheName;
    private LanguageContext _languageContext = LanguageContext.values()[0];

    public ReadThruProviderMgr() {
    }

    public ReadThruProviderMgr(String cacheName, Map properties, CacheRuntimeContext context) throws ConfigurationException {
        this._cacheName = cacheName;
        this._context = context;
        this.Initialize(properties);
    }

    public final LanguageContext getProviderType() {
        return this._languageContext;
    }

    private ILogger getNCacheLog() {
        return this._context.getNCacheLog();
    }

    public final String getCacheId() {
        return this._cacheName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (this._dsReader != null) {
            ReadThruProvider readThruProvider = this._dsReader;
            synchronized (readThruProvider) {
                try {
                    this._dsReader.close();
                }
                catch (Exception e) {
                    this.getNCacheLog().Error("ReadThruProviderMgr", "User code threw " + e.toString());
                }
            }
            this._dsReader = null;
        }
    }

    private void Initialize(Map properties) throws ConfigurationException {
        block19: {
            Object asm = null;
            if (properties == null) {
                throw new IllegalArgumentException("properties");
            }
            try {
                HashMap startupparams;
                if (!properties.containsKey("assembly-name")) {
                    throw new ConfigurationException("Missing assembly name for read-thru option");
                }
                if (!properties.containsKey("class-name")) {
                    throw new ConfigurationException("Missing class name for read-thru option");
                }
                String assembly = String.valueOf(properties.get("assembly-name"));
                this._context.getNCacheLog().CriticalInfo(assembly);
                String classname = String.valueOf(properties.get("class-name"));
                this._context.getNCacheLog().CriticalInfo(classname);
                String extension = ".dll";
                if (properties.containsKey("full-name")) {
                    extension = String.valueOf(properties.get("full-name")).split("\\.")[String.valueOf(properties.get("full-name")).split("\\.").length - 1];
                }
                if ((startupparams = (HashMap)(properties.get("parameters") instanceof Map ? properties.get("parameters") : null)) == null) {
                    startupparams = new HashMap();
                }
                Iterator paramsIterator = startupparams.values().iterator();
                while (paramsIterator.hasNext()) {
                    this._context.getNCacheLog().CriticalInfo(paramsIterator.next().toString());
                }
                if (extension.endsWith(".dll") || extension.endsWith(".exe")) {
                    AuthenticateFeature.Authenticate((LanguageContext)LanguageContext.DOTNET);
                    this._languageContext = LanguageContext.DOTNET;
                    try {
                        String path = AppUtil.DeployedAssemblyDir + this._cacheName.toLowerCase() + this.GetReadThruAssemblyPath(assembly) + extension;
                        if (asm != null) {
                            // empty if block
                        }
                        if (this._dsReader == null) {
                            throw new Exception("Unable to instantiate " + classname);
                        }
                        this._dsReader.init(startupparams, this._cacheName);
                        break block19;
                    }
                    catch (ClassCastException e) {
                        this._context.getNCacheLog().CriticalInfo(e.getMessage().toString());
                        this._context.getNCacheLog().CriticalInfo(e.getCause().toString());
                        throw new ConfigurationException("The class specified in read-thru does not implement IDatasourceReader");
                    }
                    catch (Exception e) {
                        this._context.getNCacheLog().CriticalInfo(e.getMessage().toString());
                        this._context.getNCacheLog().CriticalInfo(e.getCause().toString());
                        throw new ConfigurationException(e.getMessage(), (Throwable)e);
                    }
                }
                if (!extension.endsWith("jar") && !extension.endsWith("class")) break block19;
                AuthenticateFeature.Authenticate((LanguageContext)LanguageContext.JAVA);
                this._languageContext = LanguageContext.JAVA;
                this._context.getNCacheLog().CriticalInfo(this._languageContext.name());
                this._context.getNCacheLog().CriticalInfo(classname);
                File deployedFolder = DirectoryUtil.createDeployAssemblyFolder((String)this._cacheName);
                if (!deployedFolder.exists()) {
                    throw new ConfigurationException("Could not load " + assembly + ". Deploy the required provider's Jar file(s)");
                }
                try {
                    JarFileLoader cl = ClassPaths.addPath(deployedFolder, this._context.getNCacheLog());
                    this._dsReader = (ReadThruProvider)cl.loadClass(classname).newInstance();
                    this._dsReader.init(startupparams, this._cacheName);
                }
                catch (ClassNotFoundException e) {
                    throw new ConfigurationException("ClassNotFoundException " + classname);
                }
                catch (Exception exception) {
                    throw new ConfigurationException(exception.getMessage());
                }
                SerializationUtil.registerTypeInfoMap((String)this._cacheName, (TypeInfoMap)this._context.getCacheRoot().GetTypeInfoMap());
            }
            catch (ConfigurationException e) {
                this._context.getNCacheLog().CriticalInfo(e.getMessage().toString());
                throw e;
            }
            catch (Exception e) {
                this._context.getNCacheLog().CriticalInfo(e.getMessage().toString());
                this._context.getNCacheLog().CriticalInfo(e.getCause().toString());
                throw new ConfigurationException("Configuration Error: " + e.toString(), (Throwable)e);
            }
        }
    }

    private String GetReadThruAssemblyPath(String asm) {
        Object path = "/";
        String[] folderNames = asm.split("[,=]", -1);
        path = (String)path + folderNames[0];
        return path;
    }

    private String GetReadThruAssembly(String asm) {
        String path = "";
        String[] folderNames = asm.split("[,=]", -1);
        path = folderNames[0];
        return path;
    }

    public final void ReadThru(String key, RefObject<ProviderCacheItem> item) throws OperationFailedException {
        item.argvalue = new ProviderCacheItem((Object)"");
        try {
            this._dsReader.loadFromSource(key);
            this._context.PerfStatsColl.incrementReadThruPerSec();
        }
        catch (Exception e) {
            throw new OperationFailedException("IReadThruProvider.LoadFromSource failed. Error: " + e.toString(), (Throwable)e);
        }
    }

    public final HashMap<String, ProviderCacheItem> ReadThru(String[] keys) throws OperationFailedException {
        Map cacheItems = null;
        try {
            List<String> keysCollection = Arrays.asList(keys);
            cacheItems = this._dsReader.loadFromSource(keysCollection);
            this._context.PerfStatsColl.incrementReadThruPerSecBy(keys.length);
        }
        catch (Exception e) {
            throw new OperationFailedException("IReadThruProvider.LoadFromSource failed. Error: " + e.getMessage(), (Throwable)e);
        }
        return (HashMap)cacheItems;
    }
}

