/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Caching.DatasourceProviders;

import Alachisoft.NCache.Caching.CacheRuntimeContext;
import Alachisoft.NCache.Caching.CallbackEntry;
import Alachisoft.NCache.Caching.DatasourceProviders.DSWriteBehindOperation;
import Alachisoft.NCache.Caching.DatasourceProviders.DatasourceMgr;
import Alachisoft.NCache.Caching.DatasourceProviders.WriteThruProviderMgr;
import Alachisoft.NCache.Caching.OperationContext;
import Alachisoft.NCache.Caching.OperationContextFieldName;
import Alachisoft.NCache.Caching.OperationContextOperationType;
import Alachisoft.NCache.Caching.Topologies.CacheBase;
import Alachisoft.NCache.Common.Logger.ILogger;
import Alachisoft.NCache.Common.Threading.Latch;
import Alachisoft.NCache.Common.Threading.Monitor;
import com.alachisoft.ncache.runtime.datasourceprovider.OperationResult;
import com.alachisoft.ncache.runtime.datasourceprovider.WriteOperation;
import com.alachisoft.ncache.runtime.exceptions.OperationFailedException;
import com.alachisoft.ncache.runtime.util.TimeSpan;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import tangible.RefObject;

public class WriteBehindAsyncProcessor
implements Runnable {
    private static boolean _isNotify;
    private static boolean _reset;
    private Thread _worker;
    private WriteBehindQueue _queue;
    private int _timeout;
    private Object _statusMutex;
    private Object _processMutex;
    private boolean _isDisposing;
    private Date _startTime;
    private int _operationCount = 0;
    private int test = 0;
    private ILogger _ncacheLog;
    private String _mode;
    private int _throttleRate = 0;
    private int _batchInterval = 0;
    private int _operationDelay = 0;
    private int _requeueLimit = 0;
    private int _requeueEvcRatio = 0;
    private boolean _isSliding = false;
    private DatasourceMgr _dsManager;
    private CacheBase _cacheImpl;
    private CacheRuntimeContext _context;
    private boolean _isShutDown = false;
    private HashMap<String, WriteThruProviderMgr> _writerProivder = new HashMap();

    public WriteBehindAsyncProcessor(DatasourceMgr dsManager, int rate, String mode, long batchInterval, long operationDelay, int requeueLimit, int evictionRatio, long taskWaiteTimeout, HashMap<String, WriteThruProviderMgr> writerProvider, CacheBase cacheImpl, CacheRuntimeContext context) {
        this._dsManager = dsManager;
        this._context = context;
        this._worker = null;
        this._timeout = (int)taskWaiteTimeout;
        this._statusMutex = new Object();
        this._processMutex = new Object();
        this._isDisposing = false;
        this._writerProivder = writerProvider;
        this._mode = mode;
        this.SetConfigDefaults(mode, rate, batchInterval, operationDelay, requeueLimit, evictionRatio);
        this._cacheImpl = cacheImpl;
        this._queue = new WriteBehindQueue(this._context);
        this._queue.SetConfigDefaults(this._requeueLimit, this._requeueEvcRatio);
    }

    private ILogger getNCacheLog() {
        return this._context.getNCacheLog();
    }

    public final void WindUpTask() throws Exception {
        this._context.getNCacheLog().CriticalInfo("WriteBehindAsyncProcessor", "WindUp Task Started.");
        this._isShutDown = true;
        this._batchInterval = 0;
        this._operationDelay = 0;
        this.ExecuteWaitQueue();
        if (this._queue != null) {
            this._queue.WindUpTask();
        }
        this._context.getNCacheLog().CriticalInfo("WriteBehindAsyncProcessor", "WindUp Task Ended.");
    }

    public final void WaitForShutDown(long interval) {
        this._context.getNCacheLog().CriticalInfo("WriteBehindAsyncProcessor", "Waiting for  Write Behind queue shutdown task completion.");
        Date startShutDown = new Date();
        if (this._queue != null) {
            this._queue.WaitForShutDown(interval);
        }
        this._context.getNCacheLog().CriticalInfo("WriteBehindAsyncProcessor", "Shutdown task completed.");
    }

    public final void SetConfigDefaults(String mode, int rate, long batchInterval, long operationDelay, int requeueLimit, int requeueEvcRatio) {
        String tempVar;
        this._throttleRate = rate < 0 ? 500 : rate;
        this._requeueLimit = requeueLimit < 0 ? 5000 : requeueLimit;
        if (this._requeueLimit > 0) {
            this._requeueEvcRatio = requeueEvcRatio < 0 ? 5 : requeueEvcRatio;
        }
        if ((tempVar = mode).equals("batch")) {
            this._batchInterval = batchInterval < 0L ? 5000 : (int)(batchInterval * 1000L);
            this._operationDelay = operationDelay < 0L ? 0 : (int)operationDelay;
            for (Map.Entry<String, WriteThruProviderMgr> kv : this._writerProivder.entrySet()) {
                kv.getValue().HotApplyConfig(this._operationDelay);
            }
            this._mode = mode;
        } else if (tempVar.equals("non-batch")) {
            this._mode = "non-batch";
        }
        if (this._queue != null) {
            this._queue.SetConfigDefaults(this._requeueLimit, this._requeueEvcRatio);
        }
    }

    public final boolean getIsRunning() {
        return this._worker != null && this._worker.isAlive();
    }

    public final CacheBase getCacheImpl() {
        return this._cacheImpl;
    }

    public final void setCacheImpl(CacheBase value) {
        this._cacheImpl = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void Start() {
        WriteBehindAsyncProcessor writeBehindAsyncProcessor = this;
        synchronized (writeBehindAsyncProcessor) {
            if (this._worker == null) {
                this._worker = new Thread(this);
                this._worker.setDaemon(true);
                this._worker.setName("WriteBehindAsyncProcessor");
                this._worker.start();
            }
        }
    }

    @Override
    public void run() {
        this.Run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void Stop() {
        WriteBehindAsyncProcessor writeBehindAsyncProcessor = this;
        synchronized (writeBehindAsyncProcessor) {
            Monitor.pulse((Object)this);
            Object object = this._processMutex;
            synchronized (object) {
                this._isDisposing = true;
                if (this._worker != null && this._worker.isAlive()) {
                    this._worker.stop();
                    this._worker = null;
                }
            }
        }
    }

    protected final void Run() {
        int remainingInetrval = this._batchInterval;
        while (this._worker != null && !this._isDisposing) {
            try {
                if (this._mode.toLowerCase().equals("batch")) {
                    if (!this._isShutDown && remainingInetrval > 0) {
                        Thread.sleep(remainingInetrval);
                    }
                    Date start = new Date();
                    this.ProcessQueue(WriteBehindMode.Batch);
                    TimeSpan interval = new TimeSpan();
                    try {
                        interval = TimeSpan.subtract((Date)new Date(), (Date)start);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    int processTime = (int)interval.getTotalMiliSeconds();
                    if (this._isSliding && this._batchInterval - processTime > 0) {
                        remainingInetrval = this._batchInterval - processTime;
                        continue;
                    }
                    remainingInetrval = this._batchInterval;
                    continue;
                }
                this.ProcessQueue(WriteBehindMode.NonBatch);
            }
            catch (InterruptedException e) {
                break;
            }
            catch (Exception exception) {
            }
        }
    }

    public final void StartExecutionOfTasksForSource(String source, boolean execute) {
        final Object[] args = new Object[]{source, execute};
        Thread workerThread = new Thread(new Runnable(){

            @Override
            public void run() {
                WriteBehindAsyncProcessor.this.ExecuteAllTaskForSource(args);
            }
        });
        workerThread.setDaemon(true);
        workerThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ProcessQueue(WriteBehindMode mode) throws Exception {
        DSWriteBehindOperation operation = null;
        OperationContext operationContext = new OperationContext(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation);
        switch (mode) {
            case NonBatch: {
                operation = this._queue.Dequeue(false, new Date());
                this._context.PerfStatsColl.setWBCurrentBatchOpsCounter(1L);
                Object object = this._processMutex;
                synchronized (object) {
                    if (!this._isDisposing) {
                        this.ExecuteWriteOperation(operation, operationContext);
                    }
                    if (!this._isShutDown) {
                        this.ThrottleOperations(this._throttleRate, false);
                    }
                    break;
                }
            }
            case Batch: {
                ArrayList<DSWriteBehindOperation> selectedOperations = new ArrayList<DSWriteBehindOperation>();
                Date selectionTime = new Date();
                while (this._worker != null && !this._isDisposing) {
                    try {
                        operation = this._queue.Dequeue(true, selectionTime);
                        if (operation != null) {
                            selectedOperations.add(operation);
                        }
                        if (operation != null && this._queue.getCount() != 0) continue;
                        break;
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                    catch (Exception e) {
                    }
                }
                this._context.PerfStatsColl.setWBCurrentBatchOpsCounter(selectedOperations.size());
                int rate = this._throttleRate;
                if (selectedOperations.size() <= 0) break;
                this._startTime = new Date();
                for (Map.Entry<String, WriteThruProviderMgr> pair : this._writerProivder.entrySet()) {
                    String provider = pair.getKey();
                    DSWriteBehindOperation[] operations = this.SortProviders(selectedOperations, provider);
                    if (operations == null || operations.length <= 0) continue;
                    int index = 0;
                    boolean getNext = true;
                    while (getNext) {
                        RefObject tempRef_getNext = new RefObject((Object)getNext);
                        DSWriteBehindOperation[] opsBatch = this.CreateBatch(operations, rate, index, (RefObject<Boolean>)tempRef_getNext);
                        getNext = (Boolean)tempRef_getNext.argvalue;
                        if (opsBatch != null && opsBatch.length > 0) {
                            this.ExecuteWriteOperation(opsBatch, provider, operationContext);
                            if (!this._isShutDown) {
                                this.ThrottleOperations(opsBatch.length, true);
                            }
                        }
                        if (!getNext) continue;
                        index += rate;
                    }
                }
                break;
            }
            default: {
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ExecuteWriteOperation(DSWriteBehindOperation operation, OperationContext context) {
        OperationResult result = null;
        HashMap<Object, Object> opResult = new HashMap<Object, Object>(1);
        boolean notify = false;
        if (operation != null) {
            try {
                result = this._dsManager.WriteThru(operation, context);
                if (result != null) {
                    if (result.getOperationStatus() == OperationResult.Status.FailureRetry) {
                        this._cacheImpl.getContext().getNCacheLog().Info("Retrying Write Operation: " + operation.getOperationCode() + " for key:" + operation.getKey());
                        operation.setOperationState(OperationState.Requeue);
                        operation.setOperationDelay(this._operationDelay);
                        operation.incrementRetryCount();
                        this.Enqueue(operation);
                        return;
                    }
                    this._cacheImpl.DoWrite("Executing WriteBehindTask", "taskId=" + operation.getTaskId() + "operation result status=" + result.getOperationStatus(), new OperationContext(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation));
                    opResult.put(operation.getKey(), result.getOperationStatus());
                } else {
                    notify = true;
                    opResult.put(operation.getKey(), OperationResult.Status.Success);
                }
            }
            catch (Exception excep) {
                notify = true;
                if (this._cacheImpl.getContext().getNCacheLog().getIsErrorEnabled()) {
                    this._cacheImpl.getContext().getNCacheLog().Error("Executing WriteBehindTask", excep.getMessage());
                }
                opResult.put(operation.getKey(), excep);
            }
            finally {
                if (notify || result != null && result.getOperationStatus() != OperationResult.Status.FailureRetry) {
                    this.NotifyWriteBehindCompletion(operation, opResult);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void ExecuteWriteOperation(DSWriteBehindOperation[] operations, String provider, OperationContext context) throws OperationFailedException {
        block43: {
            HashMap<Object, DSWriteBehindOperation> opResult = new HashMap<Object, DSWriteBehindOperation>();
            HashMap returnSet = new HashMap();
            CallbackEntry cbEntry = null;
            Throwable exc = null;
            ArrayList<Object> retryOps = new ArrayList<Object>();
            ArrayList<String> taskList = new ArrayList<String>();
            String[] taskIds = null;
            if (operations != null && operations.length > 0 && this._dsManager != null) {
                block42: {
                    OperationResult[] returnOps = this._dsManager.WriteThru(operations, provider, returnSet, context);
                    if (returnOps == null || returnOps.length <= 0) break block42;
                    for (int i = 0; i < operations.length; ++i) {
                        OperationResult.Status status;
                        if (!returnSet.containsKey(operations[i].getKey()) || returnSet.get(operations[i].getKey()) instanceof Exception || (status = (OperationResult.Status)returnSet.get(operations[i].getKey())) != OperationResult.Status.FailureRetry) continue;
                        retryOps.add(operations[i].getKey());
                        this._cacheImpl.getContext().getNCacheLog().Info("Retrying Write Behind " + operations[i].getOperationCode() + " operation for key:" + operations[i].getKey());
                        operations[i].setOperationState(OperationState.Requeue);
                        operations[i].setOperationDelay(this._operationDelay);
                        operations[i].incrementRetryCount();
                        this.Enqueue(operations[i]);
                    }
                }
                for (int i = 0; i < operations.length; ++i) {
                    if (operations[i] != null && operations[i].getEntry() != null && operations[i].getEntry().getValue() instanceof CallbackEntry) {
                        cbEntry = (CallbackEntry)(operations[i].getEntry().getValue() instanceof CallbackEntry ? operations[i].getEntry().getValue() : null);
                    }
                    if (cbEntry != null) {
                        if (exc != null) {
                            operations[i].setException((Exception)exc);
                            opResult.put(operations[i].getKey(), operations[i]);
                            continue;
                        }
                        if (returnSet.containsKey(operations[i].getKey())) {
                            if (returnSet.get(operations[i].getKey()) instanceof Exception) {
                                operations[i].setException(returnSet.get(operations[i].getKey()) instanceof Exception ? returnSet.get(operations[i].getKey()) : null);
                                opResult.put(operations[i].getKey(), operations[i]);
                            } else {
                                OperationResult.Status status = (OperationResult.Status)returnSet.get(operations[i].getKey());
                                if (status != OperationResult.Status.FailureRetry) {
                                    operations[i].setDSOpState(status);
                                    opResult.put(operations[i].getKey(), operations[i]);
                                }
                            }
                        } else {
                            operations[i].setDSOpState(OperationResult.Status.Success);
                            opResult.put(operations[i].getKey(), operations[i]);
                        }
                    }
                    if (retryOps.contains(operations[i].getKey())) continue;
                    taskList.add(operations[i].getTaskId());
                }
                try {
                    if (taskList.size() > 0) {
                        taskIds = new String[taskList.size()];
                        System.arraycopy(taskList.toArray(), 0, taskIds, 0, taskList.size());
                    }
                    this._cacheImpl.NotifyWriteBehindTaskStatus(opResult, taskIds, provider, context);
                }
                catch (Exception i) {}
                break block43;
                catch (Exception excep) {
                    this._cacheImpl.getContext().getNCacheLog().Error("Excecuting Write Behind batch operations ", exc.getMessage());
                    exc = excep;
                    for (int i = 0; i < operations.length; ++i) {
                        if (operations[i] != null && operations[i].getEntry() != null && operations[i].getEntry().getValue() instanceof CallbackEntry) {
                            cbEntry = (CallbackEntry)(operations[i].getEntry().getValue() instanceof CallbackEntry ? operations[i].getEntry().getValue() : null);
                        }
                        if (cbEntry != null) {
                            if (exc != null) {
                                operations[i].setException((Exception)exc);
                                opResult.put(operations[i].getKey(), operations[i]);
                                continue;
                            }
                            if (returnSet.containsKey(operations[i].getKey())) {
                                if (returnSet.get(operations[i].getKey()) instanceof Exception) {
                                    operations[i].setException(returnSet.get(operations[i].getKey()) instanceof Exception ? returnSet.get(operations[i].getKey()) : null);
                                    opResult.put(operations[i].getKey(), operations[i]);
                                } else {
                                    OperationResult.Status status = (OperationResult.Status)returnSet.get(operations[i].getKey());
                                    if (status != OperationResult.Status.FailureRetry) {
                                        operations[i].setDSOpState(status);
                                        opResult.put(operations[i].getKey(), operations[i]);
                                    }
                                }
                            } else {
                                operations[i].setDSOpState(OperationResult.Status.Success);
                                opResult.put(operations[i].getKey(), operations[i]);
                            }
                        }
                        if (retryOps.contains(operations[i].getKey())) continue;
                        taskList.add(operations[i].getTaskId());
                    }
                    try {
                        if (taskList.size() > 0) {
                            taskIds = new String[taskList.size()];
                            System.arraycopy(taskList.toArray(), 0, taskIds, 0, taskList.size());
                        }
                        this._cacheImpl.NotifyWriteBehindTaskStatus(opResult, taskIds, provider, context);
                    }
                    catch (Exception exception) {}
                    catch (Throwable throwable) {
                        for (int i = 0; i < operations.length; ++i) {
                            if (operations[i] != null && operations[i].getEntry() != null && operations[i].getEntry().getValue() instanceof CallbackEntry) {
                                cbEntry = (CallbackEntry)(operations[i].getEntry().getValue() instanceof CallbackEntry ? operations[i].getEntry().getValue() : null);
                            }
                            if (cbEntry != null) {
                                if (exc != null) {
                                    operations[i].setException((Exception)exc);
                                    opResult.put(operations[i].getKey(), operations[i]);
                                    continue;
                                }
                                if (returnSet.containsKey(operations[i].getKey())) {
                                    if (returnSet.get(operations[i].getKey()) instanceof Exception) {
                                        operations[i].setException(returnSet.get(operations[i].getKey()) instanceof Exception ? returnSet.get(operations[i].getKey()) : null);
                                        opResult.put(operations[i].getKey(), operations[i]);
                                    } else {
                                        OperationResult.Status status = (OperationResult.Status)returnSet.get(operations[i].getKey());
                                        if (status != OperationResult.Status.FailureRetry) {
                                            operations[i].setDSOpState(status);
                                            opResult.put(operations[i].getKey(), operations[i]);
                                        }
                                    }
                                } else {
                                    operations[i].setDSOpState(OperationResult.Status.Success);
                                    opResult.put(operations[i].getKey(), operations[i]);
                                }
                            }
                            if (retryOps.contains(operations[i].getKey())) continue;
                            taskList.add(operations[i].getTaskId());
                        }
                        try {
                            if (taskList.size() > 0) {
                                taskIds = new String[taskList.size()];
                                System.arraycopy(taskList.toArray(), 0, taskIds, 0, taskList.size());
                            }
                            this._cacheImpl.NotifyWriteBehindTaskStatus(opResult, taskIds, provider, context);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
            }
        }
    }

    private HashMap<String, WriteOperation> CompileResult(OperationResult[] returnOps) {
        HashMap<String, WriteOperation> result = new HashMap<String, WriteOperation>();
        if (returnOps == null) {
            return result;
        }
        for (int i = 0; i < returnOps.length; ++i) {
            if (returnOps[i] == null) continue;
            result.put(returnOps[i].getOperation().getKey(), (WriteOperation)returnOps[i].getOperation());
        }
        return result;
    }

    private void NotifyWriteBehindCompletion(DSWriteBehindOperation operation, HashMap result) {
        CallbackEntry cbEntry = null;
        if (operation.getEntry() != null && operation.getEntry().getValue() instanceof CallbackEntry) {
            cbEntry = (CallbackEntry)(operation.getEntry().getValue() instanceof CallbackEntry ? operation.getEntry().getValue() : null);
        }
        try {
            this._cacheImpl.NotifyWriteBehindTaskStatus(operation.getOperationCode(), result, cbEntry, operation.getTaskId(), operation.getProviderName(), new OperationContext(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private DSWriteBehindOperation[] SortProviders(ArrayList operations, String provider) {
        ArrayList<DSWriteBehindOperation> selectedOps = new ArrayList<DSWriteBehindOperation>();
        for (int i = 0; i < operations.size(); ++i) {
            DSWriteBehindOperation operation;
            DSWriteBehindOperation dSWriteBehindOperation = operation = operations.get(i) instanceof DSWriteBehindOperation ? (DSWriteBehindOperation)operations.get(i) : null;
            if (operation.getProviderName() != provider.toLowerCase()) continue;
            selectedOps.add(operation);
        }
        if (selectedOps.size() > 0) {
            DSWriteBehindOperation[] dsOps = new DSWriteBehindOperation[selectedOps.size()];
            System.arraycopy(selectedOps.toArray(), 0, dsOps, 0, selectedOps.size());
            return dsOps;
        }
        return null;
    }

    private DSWriteBehindOperation[] CreateBatch(DSWriteBehindOperation[] operations, int batchCount, int index, RefObject<Boolean> getNext) {
        int operationCount = operations.length;
        DSWriteBehindOperation[] result = null;
        if (operationCount - index <= 0) {
            getNext.argvalue = false;
            return null;
        }
        if (operationCount - index <= batchCount) {
            result = new DSWriteBehindOperation[operationCount - index];
            System.arraycopy(operations, index, result, 0, operationCount - index);
            getNext.argvalue = false;
            return result;
        }
        result = new DSWriteBehindOperation[batchCount];
        System.arraycopy(operations, index, result, 0, batchCount);
        getNext.argvalue = true;
        return result;
    }

    protected final void ExecuteAllTaskForSource(Object args) {
        int i;
        DSWriteBehindOperation operation = null;
        Object[] objs = (Object[])(args instanceof Object[] ? args : null);
        String source = (String)(objs[0] instanceof String ? objs[0] : null);
        boolean execute = (Boolean)objs[1];
        ArrayList<Integer> removableIndexes = new ArrayList<Integer>();
        WaitQueue waitQueue = this._queue.getWaitQueue();
        for (i = 0; i < waitQueue.getCount(); ++i) {
            try {
                operation = waitQueue.getItem(i);
                if (operation == null || !operation.getSource().equals(source)) continue;
                removableIndexes.add(i);
                if (!execute) continue;
                operation.setState(TaskState.Execute);
                this.Enqueue(operation);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        for (i = removableIndexes.size() - 1; i >= 0; --i) {
            this._queue.getWaitQueue().RemoveAt((Integer)removableIndexes.get(i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void Enqueue(DSWriteBehindOperation operation) throws Exception {
        WriteBehindAsyncProcessor writeBehindAsyncProcessor = this;
        synchronized (writeBehindAsyncProcessor) {
            this._queue.Enqueue(operation.getKey(), false, operation);
            if (this._startTime == null) {
                this._startTime = new Date();
            }
            Monitor.pulse((Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void Dequeue(String[] taskId) throws Exception {
        WriteBehindAsyncProcessor writeBehindAsyncProcessor = this;
        synchronized (writeBehindAsyncProcessor) {
            if (taskId == null) {
                return;
            }
            block3: for (int j = 0; j < taskId.length; ++j) {
                if (this._queue.SearchWaitQueue(taskId[j])) {
                    return;
                }
                DSWriteBehindOperation operation = this._queue.Peek();
                if (operation != null && operation.getTaskId().contains(taskId[j])) {
                    this._queue.Dequeue(false, new Date());
                    continue;
                }
                WriteBehindQueue tempQ = (WriteBehindQueue)this._queue.clone();
                for (int i = 0; i < this._queue.getCount(); ++i) {
                    operation = tempQ.Dequeue(false, new Date());
                    if (operation == null || !operation.getTaskId().contains(taskId[j])) continue;
                    this._queue = tempQ;
                    continue block3;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void NodeLeft(String address) {
        WriteBehindAsyncProcessor writeBehindAsyncProcessor = this;
        synchronized (writeBehindAsyncProcessor) {
            try {
                this._queue.UpdateState(address);
            }
            catch (Exception e) {
                this.getNCacheLog().Error("WriteBehindAsyncProcessor.NodeLeft", e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void SetState(String taskId, TaskState state) throws Exception {
        WriteBehindAsyncProcessor writeBehindAsyncProcessor = this;
        synchronized (writeBehindAsyncProcessor) {
            this._queue.UpdateState(taskId, state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void SetState(String taskId, TaskState state, HashMap newTable) throws Exception {
        WriteBehindAsyncProcessor writeBehindAsyncProcessor = this;
        synchronized (writeBehindAsyncProcessor) {
            this._queue.UpdateState(taskId, state, newTable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final WriteBehindQueue CloneQueue() {
        WriteBehindAsyncProcessor writeBehindAsyncProcessor = this;
        synchronized (writeBehindAsyncProcessor) {
            return (WriteBehindQueue)this._queue.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void ExecuteWaitQueue() throws Exception {
        WriteBehindAsyncProcessor writeBehindAsyncProcessor = this;
        synchronized (writeBehindAsyncProcessor) {
            this._queue.ExecuteWaitQueue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void MergeQueue(CacheRuntimeContext context, WriteBehindQueue queue) throws Exception {
        WriteBehindAsyncProcessor writeBehindAsyncProcessor = this;
        synchronized (writeBehindAsyncProcessor) {
            if (queue != null) {
                this._queue.MergeQueue(queue);
            }
        }
    }

    private void ThrottleOperations(int operationExecuted, boolean isBatch) {
        TimeSpan interval = new TimeSpan();
        try {
            interval = TimeSpan.subtract((Date)new Date(), (Date)this._startTime);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        int processTime = (int)interval.getTotalMiliSeconds();
        if (processTime > 1000 || _reset) {
            this._startTime = new Date();
            this._operationCount = 0;
        }
        this._operationCount = !isBatch ? ++this._operationCount : (this._operationCount += operationExecuted);
        if (this._operationCount > operationExecuted - 1) {
            if (processTime < 1000) {
                try {
                    Thread.sleep(1000 - processTime);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this._startTime = new Date();
            }
            _reset = true;
            return;
        }
        _reset = false;
    }

    static {
        _reset = false;
    }

    public static class WriteBehindQueue
    implements Cloneable,
    Serializable {
        private HashMap _queue = new HashMap(1000);
        private HashMap<String, Integer> _keyToIndexMap = new HashMap(1000);
        private HashMap<Integer, String> _indexToKeyMap = new HashMap(1000);
        private HashMap<String, Integer> _taskIDMap = new HashMap(1000);
        private WaitQueue _waitQueue = new WaitQueue();
        private int _tail = -1;
        private int _head = -1;
        private boolean _tailMaxReached = false;
        private Object _sync_mutex = new Object();
        private int _requeueLimit = 0;
        private int _evictionRatio = 0;
        private float _ratio = 0.25f;
        private ArrayList _requeuedOps = new ArrayList();
        private CacheRuntimeContext _context;
        private Latch _shutdownStatusLatch = new Latch(1);

        public WriteBehindQueue(CacheRuntimeContext context) {
            this._context = context;
            this._waitQueue = new WaitQueue();
            this._requeuedOps = new ArrayList();
        }

        public final WaitQueue getWaitQueue() {
            return this._waitQueue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void WindUpTask() {
            this._context.getNCacheLog().CriticalInfo("WriteBehindQueue", "WindUp Task Started.");
            if (this._queue != null) {
                this._context.getNCacheLog().CriticalInfo("WriteBehindQueue", "Write Behind Queue Count: " + this._queue.size());
            }
            this._shutdownStatusLatch.SetStatusBit((byte)2, (byte)1);
            Object object = this._sync_mutex;
            synchronized (object) {
                this._sync_mutex.notifyAll();
            }
            this._context.getNCacheLog().CriticalInfo("WriteBehindQueue", "WindUp Task Ended.");
        }

        public final void WaitForShutDown(long interval) {
            this._context.getNCacheLog().CriticalInfo("WriteBehindQueue", "Waiting for shutdown task completion.");
            if (this._queue.size() > 0) {
                this._shutdownStatusLatch.WaitForAny((byte)4, interval * 1000L);
            }
            if (this._queue != null && this._queue.size() > 0) {
                this._context.getNCacheLog().CriticalInfo("WriteBehindQueue", "Remaining write behind queue operations: " + this._queue.size());
            }
            this._context.getNCacheLog().CriticalInfo("WriteBehindQueue", "Shutdown task completed.");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void Enqueue(Object cacheKey, boolean merge, DSWriteBehindOperation operation) throws Exception {
            boolean isNewItem = true;
            boolean isRequeueDisable = operation.getOperationState() == OperationState.Requeue && this._requeueLimit == 0;
            Object object = this._sync_mutex;
            synchronized (object) {
                if (operation.getState() == TaskState.Waite) {
                    this._waitQueue.Enqueue(operation);
                    return;
                }
                if (this._tail == Integer.MAX_VALUE) {
                    this._tail = -1;
                    this._tailMaxReached = true;
                }
                if (!merge) {
                    if (this._requeueLimit > 0 && operation.getOperationState() == OperationState.Requeue && this._requeuedOps.size() > this._requeueLimit) {
                        this.EvictRequeuedOps();
                    }
                    if (this._keyToIndexMap.containsKey((String)cacheKey)) {
                        if (isRequeueDisable) {
                            return;
                        }
                        int queueIndex = this._keyToIndexMap.get((String)cacheKey);
                        DSWriteBehindOperation oldOperation = this._queue.get(queueIndex) instanceof DSWriteBehindOperation ? this._queue.get(queueIndex) : null;
                        if (!oldOperation.getOperationState().equals((Object)operation.getOperationState())) {
                            if (operation.getOperationState() == OperationState.New) {
                                operation.setEnqueueTime(new Date());
                                this._taskIDMap.remove(oldOperation.getTaskId());
                                this._queue.put(queueIndex, operation);
                                this._taskIDMap.put(operation.getTaskId(), queueIndex);
                            }
                        } else {
                            if (operation.getOperationState() == OperationState.Requeue) {
                                operation.setEnqueueTime(new Date());
                                this._requeuedOps.add(operation);
                            } else {
                                operation.setEnqueueTime(oldOperation.getEnqueueTime());
                            }
                            this._taskIDMap.remove(oldOperation.getTaskId());
                            this._queue.put(queueIndex, operation);
                            this._taskIDMap.put(operation.getTaskId(), queueIndex);
                        }
                        isNewItem = false;
                    }
                }
                if (isNewItem && !isRequeueDisable) {
                    int index = ++this._tail;
                    operation.setEnqueueTime(new Date());
                    this._queue.put(index, operation);
                    this._keyToIndexMap.put((String)cacheKey, index);
                    this._indexToKeyMap.put(index, (String)cacheKey);
                    this._taskIDMap.put(operation.getTaskId(), index);
                    Monitor.pulse((Object)this._sync_mutex);
                    if (operation.getOperationState() == OperationState.Requeue) {
                        this._requeuedOps.add(operation);
                    }
                }
                this._context.PerfStatsColl.setWBQueueCounter(this._queue.size());
                this._context.PerfStatsColl.setWBFailureRetryCounter(this._requeuedOps.size());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final DSWriteBehindOperation Dequeue(boolean batchOperations, Date selectionTime) throws Exception {
            DSWriteBehindOperation operation = null;
            Object object = this._sync_mutex;
            synchronized (object) {
                if (this._queue.size() < 1) {
                    if (this._shutdownStatusLatch.IsAnyBitsSet((byte)2)) {
                        this._shutdownStatusLatch.SetStatusBit((byte)4, (byte)2);
                        return null;
                    }
                    if (batchOperations) {
                        return null;
                    }
                    Monitor.wait((Object)this._sync_mutex);
                    _reset = true;
                }
                int index = 0;
                while (this._head < this._tail || this._tailMaxReached) {
                    if (this._head == Integer.MAX_VALUE) {
                        this._head = -1;
                        this._tailMaxReached = false;
                    }
                    if ((operation = (DSWriteBehindOperation)(this._queue.get(index = ++this._head) instanceof DSWriteBehindOperation ? this._queue.get(index) : null)) != null) {
                        if (batchOperations && !this._shutdownStatusLatch.IsAnyBitsSet((byte)2)) {
                            if (!operation.getOperationDelayExpired()) {
                                --this._head;
                                return null;
                            }
                            if (operation.getEnqueueTime().compareTo(selectionTime) > 0) {
                                return null;
                            }
                        }
                        String cacheKey = this._indexToKeyMap.get(index) instanceof String ? this._indexToKeyMap.get(index) : null;
                        this._taskIDMap.remove(operation.getTaskId());
                        this._keyToIndexMap.remove(cacheKey);
                        this._indexToKeyMap.remove(index);
                        this._queue.remove(index);
                        if (operation.getOperationState() == OperationState.Requeue) {
                            this._requeuedOps.remove(operation);
                        }
                    }
                    if (operation == null) continue;
                }
                this._context.PerfStatsColl.setWBQueueCounter(this._queue.size());
                this._context.PerfStatsColl.setWBFailureRetryCounter(this._requeuedOps.size());
            }
            return operation;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final DSWriteBehindOperation Peek() {
            HashMap hashMap = this._queue;
            synchronized (hashMap) {
                if (this._queue.isEmpty()) {
                    return null;
                }
                return this._queue.get(this._head + 1) instanceof DSWriteBehindOperation ? this._queue.get(this._head + 1) : null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final DSWriteBehindOperation getItem(int index) {
            HashMap hashMap = this._queue;
            synchronized (hashMap) {
                if (index >= this._queue.size() || index < 0) {
                    throw new IndexOutOfBoundsException();
                }
                return this._queue.get(index) instanceof DSWriteBehindOperation ? this._queue.get(index) : null;
            }
        }

        public final void setItem(int index, DSWriteBehindOperation value) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void EvictRequeuedOps() {
            Object object = this._sync_mutex;
            synchronized (object) {
                if (this._requeuedOps.size() > 0) {
                    int i;
                    int opsCountTobeRemoved = (int)Math.ceil((float)this._requeuedOps.size() * this._ratio);
                    ArrayList<Integer> removableIndexes = new ArrayList<Integer>();
                    Arrays.sort(this._requeuedOps.toArray());
                    for (i = opsCountTobeRemoved; i > 0; --i) {
                        DSWriteBehindOperation operation = this._requeuedOps.get(i) instanceof DSWriteBehindOperation ? this._requeuedOps.get(i) : null;
                        Object tempVar = operation.getKey();
                        String cacheKey = (String)(tempVar instanceof String ? tempVar : null);
                        int index = this._keyToIndexMap.get(cacheKey);
                        this._keyToIndexMap.remove(cacheKey);
                        this._indexToKeyMap.remove(index);
                        this._taskIDMap.remove(operation.getTaskId());
                        this._queue.remove(index);
                        removableIndexes.add(i);
                        this._context.PerfStatsColl.incrementWBEvictionRate();
                    }
                    for (i = removableIndexes.size(); i > 0; --i) {
                        this._requeuedOps.remove(i);
                    }
                }
                this._context.PerfStatsColl.setWBQueueCounter(this._queue.size());
                this._context.PerfStatsColl.setWBFailureRetryCounter(this._requeuedOps.size());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void UpdateState(String taskId, TaskState state) throws Exception {
            Object object = this._sync_mutex;
            synchronized (object) {
                boolean found = false;
                int index = -1;
                for (int i = this._waitQueue.getCount() - 1; i >= 0; --i) {
                    DSWriteBehindOperation operation;
                    DSWriteBehindOperation dSWriteBehindOperation = operation = this._waitQueue.getItem(i) instanceof DSWriteBehindOperation ? this._waitQueue.getItem(i) : null;
                    if (!operation.getTaskId().contains(taskId)) continue;
                    if (state == TaskState.Execute) {
                        operation.setState(state);
                        this.Enqueue(operation.getKey(), false, operation);
                    }
                    found = true;
                    index = i;
                    break;
                }
                if (index >= 0) {
                    this._waitQueue.RemoveAt(index);
                }
                if (!found && this._taskIDMap.containsKey(taskId)) {
                    int queueIndex = this._taskIDMap.get(taskId);
                    String cachekey = this._indexToKeyMap.get(queueIndex);
                    DSWriteBehindOperation operation = this._queue.get(queueIndex) instanceof DSWriteBehindOperation ? this._queue.get(queueIndex) : null;
                    this._queue.remove(queueIndex);
                    this._keyToIndexMap.remove(cachekey);
                    this._indexToKeyMap.remove(queueIndex);
                    this._taskIDMap.remove(taskId);
                    if (operation.getOperationState() == OperationState.Requeue) {
                        this._requeuedOps.remove(operation);
                    }
                }
                this._context.PerfStatsColl.setWBQueueCounter(this._queue.size());
                this._context.PerfStatsColl.setWBFailureRetryCounter(this._requeuedOps.size());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void UpdateState(String taskId, TaskState state, HashMap newBulkTable) throws Exception {
            Object object = this._sync_mutex;
            synchronized (object) {
                int i;
                boolean removeOps = false;
                int count = this._waitQueue.getCount();
                ArrayList<Integer> removableIndexes = new ArrayList<Integer>();
                int j = 0;
                for (i = 0; i < count; ++i) {
                    DSWriteBehindOperation queueOp;
                    DSWriteBehindOperation dSWriteBehindOperation = queueOp = this._waitQueue.getItem(i) instanceof DSWriteBehindOperation ? this._waitQueue.getItem(i) : null;
                    if (!newBulkTable.containsKey(queueOp.getKey()) || !queueOp.getTaskId().contains(taskId)) continue;
                    if (state == TaskState.Execute) {
                        queueOp.setState(state);
                        this.Enqueue(queueOp.getKey(), false, queueOp);
                    }
                    removableIndexes.add(i);
                    if (newBulkTable.size() != ++j) continue;
                    removeOps = true;
                    break;
                }
                for (i = removableIndexes.size() - 1; i >= 0; --i) {
                    this._waitQueue.RemoveAt((Integer)removableIndexes.get(i));
                }
                if (state == TaskState.Remove && !removeOps) {
                    for (Map.Entry pair : newBulkTable.entrySet()) {
                        String key = (String)pair.getKey();
                        if (!this._keyToIndexMap.containsKey(key)) continue;
                        int queueIndex = this._keyToIndexMap.get(key);
                        String cachekey = this._indexToKeyMap.get(queueIndex);
                        DSWriteBehindOperation operation = this._queue.get(queueIndex) instanceof DSWriteBehindOperation ? this._queue.get(queueIndex) : null;
                        this._queue.remove(queueIndex);
                        this._keyToIndexMap.remove(cachekey);
                        this._indexToKeyMap.remove(queueIndex);
                        this._taskIDMap.remove(operation.getTaskId());
                        if (operation.getOperationState() != OperationState.Requeue) continue;
                        this._requeuedOps.remove(operation);
                    }
                }
                this._context.PerfStatsColl.setWBQueueCounter(this._queue.size());
                this._context.PerfStatsColl.setWBFailureRetryCounter(this._requeuedOps.size());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void UpdateState(HashMap states) throws Exception {
            Object object = this._sync_mutex;
            synchronized (object) {
                boolean removeOps = false;
                int j = 0;
                for (int i = 0; i < this._waitQueue.getCount(); ++i) {
                    DSWriteBehindOperation queueOp;
                    DSWriteBehindOperation dSWriteBehindOperation = queueOp = this._waitQueue.getItem(i) instanceof DSWriteBehindOperation ? this._waitQueue.getItem(i) : null;
                    if (!states.containsKey(queueOp.getTaskId())) continue;
                    TaskState state = (TaskState)((Object)states.get(queueOp.getTaskId()));
                    if (state == TaskState.Execute) {
                        queueOp.setState(state);
                        this.Enqueue(queueOp.getKey(), false, queueOp);
                    }
                    this._waitQueue.Remove(queueOp.getTaskId());
                    if (states.size() != ++j) continue;
                    removeOps = true;
                    break;
                }
                if (!removeOps) {
                    for (Map.Entry pair : states.entrySet()) {
                        String taskId = (String)pair.getKey();
                        if (!this._taskIDMap.containsKey(taskId)) continue;
                        int queueIndex = this._taskIDMap.get(taskId);
                        String cachekey = this._indexToKeyMap.get(queueIndex);
                        DSWriteBehindOperation operation = this._queue.get(queueIndex) instanceof DSWriteBehindOperation ? this._queue.get(queueIndex) : null;
                        this._queue.remove(queueIndex);
                        this._keyToIndexMap.remove(cachekey);
                        this._indexToKeyMap.remove(queueIndex);
                        if (operation.getOperationState() != OperationState.Requeue) continue;
                        this._requeuedOps.remove(operation);
                    }
                }
                this._context.PerfStatsColl.setWBQueueCounter(this._queue.size());
                this._context.PerfStatsColl.setWBFailureRetryCounter(this._requeuedOps.size());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void UpdateState(String source) throws Exception {
            Object object = this._sync_mutex;
            synchronized (object) {
                int index = -1;
                for (int i = 0; i < this._waitQueue.getCount(); ++i) {
                    DSWriteBehindOperation queueOp;
                    DSWriteBehindOperation dSWriteBehindOperation = queueOp = this._waitQueue.getItem(i) instanceof DSWriteBehindOperation ? this._waitQueue.getItem(i) : null;
                    if (!queueOp.getSource().equals(source)) continue;
                    queueOp.setState(TaskState.Execute);
                    this.Enqueue(queueOp.getKey(), false, queueOp);
                    index = i;
                    break;
                }
                if (index >= 0) {
                    this._waitQueue.RemoveAt(index);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final boolean SearchWaitQueue(String taskId) {
            Object object = this._sync_mutex;
            synchronized (object) {
                boolean found = false;
                int index = -1;
                for (int i = 0; i < this._waitQueue.getCount(); ++i) {
                    DSWriteBehindOperation queueOp;
                    DSWriteBehindOperation dSWriteBehindOperation = queueOp = this._waitQueue.getItem(i) instanceof DSWriteBehindOperation ? this._waitQueue.getItem(i) : null;
                    if (!queueOp.getTaskId().contains(taskId)) continue;
                    found = true;
                    index = i;
                    break;
                }
                if (index >= 0) {
                    this._waitQueue.RemoveAt(index);
                }
                return found;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void clear() {
            Object object = this._sync_mutex;
            synchronized (object) {
                if (this._queue != null) {
                    this._queue.clear();
                }
                if (this._requeuedOps != null) {
                    this._requeuedOps.clear();
                }
                if (this._taskIDMap != null) {
                    this._taskIDMap.clear();
                }
                if (this._taskIDMap != null) {
                    this._taskIDMap.clear();
                }
                if (this._keyToIndexMap != null) {
                    this._keyToIndexMap.clear();
                }
            }
            if (this._context != null) {
                this._context.PerfStatsColl.setWBQueueCounter(this._queue.size());
                this._context.PerfStatsColl.setWBFailureRetryCounter(this._requeuedOps.size());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final Object clone() {
            Object object = this._sync_mutex;
            synchronized (object) {
                WriteBehindQueue queue = new WriteBehindQueue(this._context);
                queue._queue = this._queue;
                queue._keyToIndexMap = this._keyToIndexMap;
                queue._indexToKeyMap = this._indexToKeyMap;
                queue._taskIDMap = this._taskIDMap;
                queue._waitQueue = this._waitQueue;
                queue._tail = this._tail;
                queue._head = this._head;
                queue._tailMaxReached = this._tailMaxReached;
                queue._requeueLimit = this._requeueLimit;
                queue._evictionRatio = this._evictionRatio;
                queue._ratio = this._ratio;
                queue._requeuedOps = this._requeuedOps;
                return queue;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final int getCount() {
            HashMap hashMap = this._queue;
            synchronized (hashMap) {
                return this._queue.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final Iterator GetEnumerator() {
            HashMap hashMap = this._queue;
            synchronized (hashMap) {
                return this._queue.entrySet().iterator();
            }
        }

        public final void MergeQueue(WriteBehindQueue chunkOfQueue) throws Exception {
            Iterator iterator = chunkOfQueue.GetEnumerator();
            while (iterator.hasNext()) {
                Map.Entry pair = (Map.Entry)iterator.next();
                if (!(pair.getValue() instanceof DSWriteBehindOperation)) continue;
                DSWriteBehindOperation operation = (DSWriteBehindOperation)pair.getValue();
                this.Enqueue(operation.getKey(), true, operation);
            }
        }

        public final void SetConfigDefaults(int requeueLimit, int requeueEvcRatio) {
            if (requeueLimit >= this._requeueLimit) {
                this._requeueLimit = requeueLimit;
            }
            if (this._requeueLimit > 0) {
                this._evictionRatio = requeueEvcRatio;
            }
            this._ratio = (float)this._evictionRatio / 100.0f;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void ExecuteWaitQueue() throws Exception {
            Object object = this._sync_mutex;
            synchronized (object) {
                for (int i = 0; i < this._waitQueue.getCount(); ++i) {
                    DSWriteBehindOperation queueOp = this._waitQueue.getItem(i) instanceof DSWriteBehindOperation ? this._waitQueue.getItem(i) : null;
                    queueOp.setState(TaskState.Execute);
                    this.Enqueue(queueOp.getKey(), false, queueOp);
                    this._waitQueue.Remove(queueOp.getTaskId());
                }
            }
        }
    }

    public static class WaitQueue
    implements Cloneable {
        private ArrayList _queue;

        public WaitQueue() {
            this._queue = new ArrayList();
        }

        public WaitQueue(int capacity) {
            this._queue = new ArrayList(capacity);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void Enqueue(DSWriteBehindOperation writeOperations) {
            ArrayList arrayList = this._queue;
            synchronized (arrayList) {
                this._queue.add(writeOperations);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final DSWriteBehindOperation Dequeue() {
            ArrayList arrayList = this._queue;
            synchronized (arrayList) {
                if (this._queue.isEmpty()) {
                    return null;
                }
                DSWriteBehindOperation value = this._queue.get(0) instanceof DSWriteBehindOperation ? this._queue.get(0) : null;
                this._queue.remove(0);
                return value;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final DSWriteBehindOperation Peek() {
            ArrayList arrayList = this._queue;
            synchronized (arrayList) {
                if (this._queue.isEmpty()) {
                    return null;
                }
                return this._queue.get(0) instanceof DSWriteBehindOperation ? this._queue.get(0) : null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final DSWriteBehindOperation getItem(int index) {
            ArrayList arrayList = this._queue;
            synchronized (arrayList) {
                if (index >= this._queue.size() || index < 0) {
                    throw new IndexOutOfBoundsException();
                }
                return this._queue.get(index) instanceof DSWriteBehindOperation ? this._queue.get(index) : null;
            }
        }

        public final void setItem(int index, DSWriteBehindOperation value) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void RemoveAt(int index) {
            ArrayList arrayList = this._queue;
            synchronized (arrayList) {
                if (index >= this._queue.size() || index < 0) {
                    throw new IndexOutOfBoundsException();
                }
                this._queue.remove(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void Remove(String taskId) {
            ArrayList arrayList = this._queue;
            synchronized (arrayList) {
                for (int i = this._queue.size() - 1; i >= 0; --i) {
                    DSWriteBehindOperation qTask = this._queue.get(i) instanceof DSWriteBehindOperation ? this._queue.get(i) : null;
                    if (!qTask.getTaskId().contains(taskId)) continue;
                    this._queue.remove(i);
                    break;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void Clear() {
            ArrayList arrayList = this._queue;
            synchronized (arrayList) {
                this._queue.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final int getCount() {
            ArrayList arrayList = this._queue;
            synchronized (arrayList) {
                return this._queue.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final Iterator GetEnumerator() {
            ArrayList arrayList = this._queue;
            synchronized (arrayList) {
                return this._queue.iterator();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final Object clone() {
            ArrayList arrayList = this._queue;
            synchronized (arrayList) {
                return this._queue.clone();
            }
        }
    }

    public static enum WriteBehindMode {
        Batch,
        NonBatch;


        public static WriteBehindMode forValue(int value) {
            return WriteBehindMode.values()[value];
        }

        public int getValue() {
            return this.ordinal();
        }
    }

    public static enum OperationState {
        New,
        Requeue;


        public static OperationState forValue(int value) {
            return OperationState.values()[value];
        }

        public int getValue() {
            return this.ordinal();
        }
    }

    public static enum TaskState {
        Waite,
        Execute,
        Remove;


        public static TaskState forValue(int value) {
            return TaskState.values()[value];
        }

        public int getValue() {
            return this.ordinal();
        }
    }
}

