/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Caching.Enumeration;

import Alachisoft.NCache.Caching.Topologies.CacheBase;
import Alachisoft.NCache.Common.ServicePropValues;
import com.alachisoft.ncache.runtime.exceptions.CacheException;
import com.alachisoft.ncache.runtime.exceptions.GeneralFailureException;
import com.alachisoft.ncache.runtime.exceptions.OperationFailedException;
import com.alachisoft.ncache.runtime.util.TimeSpan;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.UUID;
import tangible.DotNetToJavaStringHelper;

public class CacheSnapshotPool {
    private static final CacheSnapshotPool instance = new CacheSnapshotPool();
    private int _minSnaphotSizeForPooling = 100000;
    private int _maxSnapshotsInPool = 10;
    private int _newSnapshotCreationThreshold = 120;
    private HashMap _cachePoolMap;

    private CacheSnapshotPool() {
        if (ServicePropValues.CacheServer_EnableSnapshotPoolingCacheSize != null) {
            this._minSnaphotSizeForPooling = Integer.decode(ServicePropValues.CacheServer_MinimumSnaphotSizeForPooling);
        }
        if (ServicePropValues.CacheServer_MaxNumOfSnapshotsInPool != null) {
            this._maxSnapshotsInPool = Integer.decode(ServicePropValues.CacheServer_SnapshotPoolSize);
        }
        if (ServicePropValues.CacheServer_NewSnapshotCreationTimeInSec != null) {
            this._newSnapshotCreationThreshold = Integer.decode(ServicePropValues.CacheServer_SnapshotCreationThreshold);
        }
        this._cachePoolMap = new HashMap();
    }

    public static CacheSnapshotPool getInstance() {
        return instance;
    }

    public final Object[] GetSnaphot(String pointerID, CacheBase cache) throws GeneralFailureException, OperationFailedException, CacheException {
        CachePool pool = null;
        if (this._cachePoolMap.containsKey(cache.getContext().getCacheRoot().getName())) {
            pool = this._cachePoolMap.get(cache.getContext().getCacheRoot().getName()) instanceof CachePool ? this._cachePoolMap.get(cache.getContext().getCacheRoot().getName()) : null;
            return pool.GetSnaphotInPool(pointerID, cache);
        }
        pool = new CachePool(this._minSnaphotSizeForPooling, this._maxSnapshotsInPool, this._newSnapshotCreationThreshold);
        this._cachePoolMap.put(cache.getContext().getCacheRoot().getName(), pool);
        return pool.GetSnaphotInPool(pointerID, cache);
    }

    public final void DiposeSnapshot(String pointerID, CacheBase cache) {
        CachePool pool = null;
        if (this._cachePoolMap.containsKey(cache.getContext().getCacheRoot().getName())) {
            pool = this._cachePoolMap.get(cache.getContext().getCacheRoot().getName()) instanceof CachePool ? this._cachePoolMap.get(cache.getContext().getCacheRoot().getName()) : null;
            pool.DiposeSnapshotInPool(pointerID);
        }
    }

    public final void DisposePool(String cacheId) {
        this._cachePoolMap.remove(cacheId);
    }

    private static class CachePool {
        private int _minimumSnaphotSizeForPooling = 100000;
        private int _maxNumOfSnapshotsInPool = 10;
        private int _newSnapshotCreationTimeInSec = 120;
        private Date _lastSnaphotCreationTime = new Date(0L);
        private HashMap<String, Object[]> _pool = new HashMap();
        private HashMap<String, String> _enumeratorSnaphotMap = new HashMap();
        private HashMap<String, Integer> _snapshotRefCountMap = new HashMap();
        private String _currentUsableSnapshot;

        public CachePool(int minSnaphotSizeForPooling, int maxSnapshotsInPool, int newSnapshotCreationThreshold) {
            this._minimumSnaphotSizeForPooling = minSnaphotSizeForPooling;
            this._maxNumOfSnapshotsInPool = maxSnapshotsInPool;
            this._newSnapshotCreationTimeInSec = newSnapshotCreationThreshold;
        }

        private String GetNewUniqueID() {
            return UUID.randomUUID().toString();
        }

        public final Object[] GetSnaphotInPool(String pointerID, CacheBase cache) throws GeneralFailureException, OperationFailedException, CacheException {
            String uniqueID = "";
            double totalSec = 0.0;
            if (cache.getCount() < (long)this._minimumSnaphotSizeForPooling) {
                return cache.getKeys();
            }
            if (this._pool.isEmpty()) {
                uniqueID = this.GetNewUniqueID();
                this._pool.put(uniqueID, cache.getKeys());
                this._lastSnaphotCreationTime = new Date();
                this._currentUsableSnapshot = uniqueID;
            } else if (this._pool.size() < this._maxNumOfSnapshotsInPool) {
                TimeSpan elapsedTime = null;
                try {
                    elapsedTime = TimeSpan.subtract((Date)Calendar.getInstance().getTime(), (Date)this._lastSnaphotCreationTime);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                totalSec = elapsedTime.getTotalMiliSeconds() / 1000L;
                if (totalSec >= (double)this._newSnapshotCreationTimeInSec) {
                    uniqueID = this.GetNewUniqueID();
                    this._pool.put(uniqueID, cache.getKeys());
                    this._lastSnaphotCreationTime = new Date();
                    this._currentUsableSnapshot = uniqueID;
                }
            }
            if (!this._enumeratorSnaphotMap.containsKey(pointerID)) {
                this._enumeratorSnaphotMap.put(pointerID, uniqueID);
                if (!this._snapshotRefCountMap.containsKey(uniqueID)) {
                    this._snapshotRefCountMap.put(uniqueID, 1);
                } else {
                    int refCount = this._snapshotRefCountMap.get(uniqueID);
                    this._snapshotRefCountMap.put(uniqueID, ++refCount);
                }
            }
            return this._pool.get(this._currentUsableSnapshot);
        }

        public final void DiposeSnapshotInPool(String pointerID) {
            String snapshotID;
            if (this._enumeratorSnaphotMap.containsKey(pointerID) && !DotNetToJavaStringHelper.isNullOrEmpty((String)(snapshotID = this._enumeratorSnaphotMap.get(pointerID))) && this._snapshotRefCountMap.containsKey(snapshotID)) {
                int refCount = this._snapshotRefCountMap.get(snapshotID);
                if (--refCount == 0) {
                    this._pool.remove(snapshotID);
                } else {
                    this._snapshotRefCountMap.put(snapshotID, refCount);
                }
            }
        }
    }
}

