/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Caching.EvictionPolicies;

import Alachisoft.NCache.Caching.Cache;
import Alachisoft.NCache.Caching.CacheRuntimeContext;
import Alachisoft.NCache.Caching.EvictionPolicies.EvictionHint;
import Alachisoft.NCache.Caching.EvictionPolicies.EvictionIndex;
import Alachisoft.NCache.Caching.EvictionPolicies.IEvictionPolicy;
import Alachisoft.NCache.Caching.EvictionPolicies.TimestampHint;
import Alachisoft.NCache.Caching.ItemRemoveReason;
import Alachisoft.NCache.Caching.OperationContext;
import Alachisoft.NCache.Caching.OperationContextFieldName;
import Alachisoft.NCache.Caching.OperationContextOperationType;
import Alachisoft.NCache.Caching.Topologies.CacheBase;
import Alachisoft.NCache.Common.Logger.ILogger;
import Alachisoft.NCache.Common.ServicePropValues;
import com.alachisoft.ncache.runtime.exceptions.CacheException;
import com.alachisoft.ncache.runtime.util.TimeSpan;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TimeZone;

public class LRUEvictionPolicy
implements IEvictionPolicy {
    private EvictionIndex _index;
    private float _ratio = 0.25f;
    private Date _initTime = new Date(0L);
    private int _minHint;
    private int _maxHint;
    private long _sleepInterval = 0L;
    private int _removeThreshhold = 10;
    private long totalEvicted;

    public LRUEvictionPolicy() {
        this.Initialize();
    }

    public LRUEvictionPolicy(Map properties, float ratio) {
        this._ratio = ratio / 100.0f;
        this._sleepInterval = Integer.parseInt(ServicePropValues.CacheServer_EvictionBulkRemoveDelay);
        this._removeThreshhold = Integer.parseInt(ServicePropValues.CacheServer_EvictionBulkRemoveSize);
        this.Initialize();
    }

    private void Initialize() {
        this._index = new EvictionIndex();
        TimeZone utc = TimeZone.getTimeZone("UTC");
        this._initTime = Calendar.getInstance(utc).getTime();
        this._maxHint = 0;
        this._minHint = 0;
    }

    @Override
    public final EvictionHint CompatibleHint(EvictionHint eh) {
        if (eh != null && eh instanceof TimestampHint) {
            return eh;
        }
        return new TimestampHint();
    }

    @Override
    public void Execute(CacheBase cache, CacheRuntimeContext context, long evictSize) {
        OperationContext lruEvictionOperationContext;
        int notifThreshold = 30720;
        ILogger NCacheLog = cache.getContext().getNCacheLog();
        if (NCacheLog.getIsInfoEnabled()) {
            try {
                NCacheLog.Info("LRU LocalCache.Evict()", "Cache Size: {0}" + new Long(cache.getCount()).toString());
            }
            catch (CacheException cacheException) {
                context.getNCacheLog().Info("LRU LocalCache.Evict()", "Logging cache count throws Exception: " + cacheException.getMessage());
            }
        }
        this._sleepInterval = Integer.parseInt(ServicePropValues.CacheServer_EvictionBulkRemoveDelay);
        this._removeThreshhold = Integer.parseInt(ServicePropValues.CacheServer_EvictionBulkRemoveSize);
        Date startTime = new Date();
        ArrayList selectedKeys = this.GetSelectedKeys(cache, (long)Math.ceil((float)evictSize * this._ratio));
        Date endTime = new Date();
        if (NCacheLog.getIsInfoEnabled()) {
            try {
                NCacheLog.Info("LocalCache.Evict()", String.format("Time Span for {0} Items: " + TimeSpan.subtract((Date)endTime, (Date)startTime), selectedKeys.size()));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        startTime = new Date();
        Cache rootCache = context.getCacheRoot();
        ArrayList keysTobeRemoved = new ArrayList();
        ArrayList dependentItems = new ArrayList();
        ArrayList removedItems = null;
        this.totalEvicted += (long)selectedKeys.size();
        Iterator e = selectedKeys.iterator();
        int removedThreshhold = this._removeThreshhold / 300;
        int remIteration = 0;
        while (e.hasNext()) {
            Object key = e.next();
            keysTobeRemoved.add(key);
            if (keysTobeRemoved.size() % 300 != 0) continue;
            try {
                lruEvictionOperationContext = new OperationContext();
                lruEvictionOperationContext.Add(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation);
                lruEvictionOperationContext.Add(OperationContextFieldName.RaiseCQNotification, true);
                Object tempVar = cache.RemoveSync(keysTobeRemoved.toArray(new Object[0]), ItemRemoveReason.Underused, false, lruEvictionOperationContext);
                removedItems = (ArrayList)(tempVar instanceof ArrayList ? tempVar : null);
                context.PerfStatsColl.incrementEvictPerSecStatsBy(keysTobeRemoved.size());
            }
            catch (Exception ex) {
                NCacheLog.Error("LruEvictionPolicy.Execute", "an error occured while removing items. Error " + ex.toString());
            }
            keysTobeRemoved.clear();
            if (removedItems != null && removedItems.size() > 0) {
                dependentItems.addAll(removedItems);
            }
            if (++remIteration < removedThreshhold) continue;
            try {
                Thread.sleep(this._sleepInterval * 1000L);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            remIteration = 0;
        }
        if (keysTobeRemoved.size() > 0) {
            try {
                OperationContext lruEvictionOperationContext2 = new OperationContext();
                lruEvictionOperationContext2.Add(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation);
                lruEvictionOperationContext2.Add(OperationContextFieldName.RaiseCQNotification, true);
                Object tempVar2 = cache.RemoveSync(keysTobeRemoved.toArray(new Object[0]), ItemRemoveReason.Underused, false, lruEvictionOperationContext2);
                removedItems = (ArrayList)(tempVar2 instanceof ArrayList ? tempVar2 : null);
                context.PerfStatsColl.incrementEvictPerSecStatsBy(keysTobeRemoved.size());
                if (removedItems != null && removedItems.size() > 0) {
                    dependentItems.addAll(removedItems);
                }
            }
            catch (Exception ex) {
                NCacheLog.Error("LruEvictionPolicy.Execute", "an error occured while removing items. Error " + ex.toString());
            }
        }
        if (dependentItems.size() > 0) {
            ArrayList removableList = new ArrayList();
            if (rootCache != null) {
                for (Object depenentItme : dependentItems) {
                    if (depenentItme == null) continue;
                    removableList.add(depenentItme);
                    if (removableList.size() % 100 != 0) continue;
                    try {
                        OperationContext lruEvictionOperationContext3 = new OperationContext();
                        lruEvictionOperationContext3.Add(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation);
                        lruEvictionOperationContext3.Add(OperationContextFieldName.RaiseCQNotification, true);
                        rootCache.CascadedRemove(removableList.toArray(new Object[0]), ItemRemoveReason.Underused, true, lruEvictionOperationContext3);
                        context.PerfStatsColl.incrementEvictPerSecStatsBy(removableList.size());
                    }
                    catch (Exception exc) {
                        NCacheLog.Error("LruEvictionPolicy.Execute", "an error occured while removing dependent items. Error " + exc.toString());
                    }
                    removableList.clear();
                }
                if (removableList.size() > 0) {
                    try {
                        lruEvictionOperationContext = new OperationContext();
                        lruEvictionOperationContext.Add(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation);
                        lruEvictionOperationContext.Add(OperationContextFieldName.RaiseCQNotification, true);
                        rootCache.CascadedRemove(removableList.toArray(new Object[0]), ItemRemoveReason.Underused, true, lruEvictionOperationContext);
                        context.PerfStatsColl.incrementEvictPerSecStatsBy(removableList.size());
                    }
                    catch (Exception exc) {
                        NCacheLog.Error("LruEvictionPolicy.Execute", "an error occured while removing dependent items. Error " + exc.toString());
                    }
                    removableList.clear();
                }
            }
        }
    }

    @Override
    public float getEvictRatio() {
        return this._ratio;
    }

    @Override
    public void setEvictRatio(float value) {
        this._ratio = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void Notify(Object key, EvictionHint oldhint, EvictionHint newHint) {
        Object object = this._index.getSyncRoot();
        synchronized (object) {
            EvictionHint hint;
            EvictionHint evictionHint = hint = oldhint == null ? newHint : oldhint;
            if (this._index != null && key != null && hint != null) {
                TimeSpan diffTime = null;
                try {
                    diffTime = TimeSpan.subtract((Date)((TimestampHint)hint).getTimeStamp(), (Date)this._initTime);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                long indexKey = this.GetIndexKey(diffTime);
                if (this._index.Contains(indexKey, key)) {
                    this._index.Remove(indexKey, key);
                    hint = newHint == null ? oldhint : newHint;
                    hint.Update();
                    try {
                        diffTime = TimeSpan.subtract((Date)((TimestampHint)hint).getTimeStamp(), (Date)this._initTime);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    indexKey = this.GetIndexKey(diffTime);
                    this._index.Add(indexKey, key);
                } else {
                    this._index.Add(indexKey, key);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void Remove(Object key, EvictionHint hint) {
        if (hint == null) {
            return;
        }
        Object object = this._index.getSyncRoot();
        synchronized (object) {
            TimeSpan diffTime = null;
            try {
                diffTime = TimeSpan.subtract((Date)((TimestampHint)hint).getTimeStamp(), (Date)this._initTime);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            long indexKey = this.GetIndexKey(diffTime);
            this._index.Remove(indexKey, key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void Clear() {
        Object object = this._index.getSyncRoot();
        synchronized (object) {
            this._index.Clear();
        }
    }

    private ArrayList GetSelectedKeys(CacheBase cache, long evictSize) {
        return this._index.GetSelectedKeys(cache, evictSize);
    }

    private long GetIndexKey(TimeSpan diffTime) {
        return (long)diffTime.getTotalSeconds();
    }

    public static class TimestampComparer
    implements Comparator {
        private HashMap _unsortedList;

        public TimestampComparer(HashMap unsortedList) {
            this._unsortedList = unsortedList;
        }

        public int compare(Object x, Object y) {
            Object first = this._unsortedList.get(x);
            Object second = this._unsortedList.get(y);
            return ((Date)first).compareTo((Date)second);
        }
    }
}

