/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Caching.Queries.Filters;

import Alachisoft.NCache.Caching.Queries.AttributeIndex;
import Alachisoft.NCache.Caching.Queries.ComparisonType;
import Alachisoft.NCache.Caching.Queries.Filters.IFunctor;
import Alachisoft.NCache.Caching.Queries.Filters.IGenerator;
import Alachisoft.NCache.Caching.Queries.Filters.MemberFunction;
import Alachisoft.NCache.Caching.Queries.Filters.Predicate;
import Alachisoft.NCache.Caching.Queries.IIndexStore;
import Alachisoft.NCache.Caching.Queries.QueryContext;
import Alachisoft.NCache.Common.DataStructures.SortedMap;
import Alachisoft.NCache.Parser.AttributeIndexNotDefined;
import com.alachisoft.ncache.runtime.exceptions.CacheException;
import com.alachisoft.ncache.runtime.exceptions.GeneralFailureException;
import com.alachisoft.ncache.runtime.exceptions.OperationFailedException;
import java.util.ArrayList;
import java.util.Iterator;
import tangible.RefObject;

public class FunctorEqualsGeneratorPredicate
extends Predicate
implements Comparable {
    private IFunctor functor;
    private IGenerator generator;

    public FunctorEqualsGeneratorPredicate(IFunctor lhs, IGenerator rhs) {
        this.functor = lhs;
        this.generator = rhs;
    }

    @Override
    public boolean ApplyPredicate(Object o) {
        Object lhs = this.functor.Evaluate(o);
        if (this.getInverse()) {
            return !lhs.equals(this.generator.Evaluate());
        }
        return lhs.equals(this.generator.Evaluate());
    }

    @Override
    public void ExecuteInternal(QueryContext queryContext, RefObject<SortedMap> list) throws GeneralFailureException, OperationFailedException, CacheException {
        AttributeIndex index = queryContext.getIndex();
        IIndexStore store = ((MemberFunction)this.functor).GetStore(index);
        if (store != null) {
            ArrayList keyList = null;
            keyList = this.getInverse() ? store.GetData(this.generator.Evaluate(((MemberFunction)this.functor).getMemberName(), queryContext.getAttributeValues()), ComparisonType.NOT_EQUALS) : store.GetData(this.generator.Evaluate(((MemberFunction)this.functor).getMemberName(), queryContext.getAttributeValues()), ComparisonType.EQUALS);
            if (keyList != null) {
                ((SortedMap)list.argvalue).putValue((Object)keyList.size(), (Object)keyList);
            }
        } else {
            throw new AttributeIndexNotDefined("Index is not defined for attribute '" + ((MemberFunction)this.functor).getMemberName() + "'");
        }
    }

    @Override
    public void Execute(QueryContext queryContext, Predicate nextPredicate) throws GeneralFailureException, OperationFailedException, CacheException {
        AttributeIndex index = queryContext.getIndex();
        IIndexStore store = ((MemberFunction)this.functor).GetStore(index);
        if (store != null) {
            ArrayList keyList = null;
            keyList = this.getInverse() ? store.GetData(this.generator.Evaluate(((MemberFunction)this.functor).getMemberName(), queryContext.getAttributeValues()), ComparisonType.NOT_EQUALS) : store.GetData(this.generator.Evaluate(((MemberFunction)this.functor).getMemberName(), queryContext.getAttributeValues()), ComparisonType.EQUALS);
            if (keyList != null && keyList.size() > 0) {
                Iterator keyListEnum = keyList.iterator();
                if (queryContext.getPopulateTree()) {
                    queryContext.getTree().setRightList(keyList);
                    queryContext.setPopulateTree(false);
                } else {
                    while (keyListEnum.hasNext()) {
                        if (!queryContext.getTree().getLeftList().contains(keyListEnum.next())) continue;
                        queryContext.getTree().Shift(keyListEnum.next());
                    }
                }
            }
        } else {
            throw new AttributeIndexNotDefined("Index is not defined for attribute '" + ((MemberFunction)this.functor).getMemberName() + "'");
        }
    }

    public String toString() {
        return this.functor + (this.getInverse() ? " != " : " == ") + this.generator;
    }

    public final int compareTo(Object obj) {
        if (obj instanceof FunctorEqualsGeneratorPredicate) {
            FunctorEqualsGeneratorPredicate other = (FunctorEqualsGeneratorPredicate)obj;
            if (this.getInverse() == other.getInverse()) {
                return ((Comparable)((Object)this.functor)).compareTo(other.functor) == 0 && ((Comparable)((Object)this.generator)).compareTo(other.generator) == 0 ? 0 : -1;
            }
        }
        return -1;
    }
}

