/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Caching.Queries.Filters;

import Alachisoft.NCache.Caching.Queries.AttributeIndex;
import Alachisoft.NCache.Caching.Queries.ComparisonType;
import Alachisoft.NCache.Caching.Queries.Filters.IFunctor;
import Alachisoft.NCache.Caching.Queries.Filters.IGenerator;
import Alachisoft.NCache.Caching.Queries.Filters.MemberFunction;
import Alachisoft.NCache.Caching.Queries.Filters.Predicate;
import Alachisoft.NCache.Caching.Queries.IIndexStore;
import Alachisoft.NCache.Caching.Queries.QueryContext;
import Alachisoft.NCache.Common.DataStructures.SortedMap;
import Alachisoft.NCache.Parser.AttributeIndexNotDefined;
import com.alachisoft.ncache.runtime.exceptions.CacheException;
import com.alachisoft.ncache.runtime.exceptions.GeneralFailureException;
import com.alachisoft.ncache.runtime.exceptions.OperationFailedException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import tangible.DotNetToJavaStringHelper;
import tangible.RefObject;

public class FunctorLikePatternPredicate
extends Predicate
implements Comparable {
    private IFunctor functor;
    private IGenerator generator;
    private Matcher regex;
    private String pattern;

    public FunctorLikePatternPredicate(IFunctor lhs, IGenerator rhs) {
        this.functor = lhs;
        this.generator = rhs;
    }

    @Override
    public boolean ApplyPredicate(Object o) {
        Object lhs = this.functor.Evaluate(o);
        Pattern responseCodePattern = Pattern.compile("^HTTP/1\\.1 (\\d+) OK$");
        this.regex = responseCodePattern.matcher(lhs.toString());
        if (this.getInverse()) {
            return !this.regex.matches();
        }
        return this.regex.matches();
    }

    @Override
    public void ExecuteInternal(QueryContext queryContext, RefObject<SortedMap> list) throws GeneralFailureException, OperationFailedException, CacheException {
        ArrayList keyList = null;
        this.pattern = (String)this.generator.Evaluate(((MemberFunction)this.functor).getMemberName(), queryContext.getAttributeValues());
        this.pattern = DotNetToJavaStringHelper.trim((String)this.pattern, (Character[])new Character[]{Character.valueOf('\'')});
        AttributeIndex index = queryContext.getIndex();
        IIndexStore store = ((MemberFunction)this.functor).GetStore(index);
        if (store != null) {
            keyList = this.getInverse() ? store.GetData(this.pattern, ComparisonType.NOT_LIKE) : store.GetData(this.pattern, ComparisonType.LIKE);
            if (keyList != null) {
                ((SortedMap)list.argvalue).putValue((Object)keyList.size(), (Object)keyList);
            }
        } else {
            throw new AttributeIndexNotDefined("Index is not defined for attribute '" + ((MemberFunction)this.functor).getMemberName() + "'");
        }
    }

    @Override
    public void Execute(QueryContext queryContext, Predicate nextPredicate) throws GeneralFailureException, OperationFailedException, CacheException {
        ArrayList keyList = null;
        this.pattern = (String)this.generator.Evaluate(((MemberFunction)this.functor).getMemberName(), queryContext.getAttributeValues());
        this.pattern = DotNetToJavaStringHelper.trim((String)this.pattern, (Character[])new Character[]{Character.valueOf('\'')});
        AttributeIndex index = queryContext.getIndex();
        IIndexStore store = ((MemberFunction)this.functor).GetStore(index);
        if (store != null) {
            keyList = this.getInverse() ? store.GetData(this.pattern, ComparisonType.NOT_LIKE) : store.GetData(this.pattern, ComparisonType.LIKE);
            if (keyList != null && keyList.size() > 0) {
                Iterator keyListEnum = keyList.iterator();
                if (queryContext.getPopulateTree()) {
                    queryContext.getTree().setRightList(keyList);
                    queryContext.setPopulateTree(false);
                } else {
                    while (keyListEnum.hasNext()) {
                        if (!queryContext.getTree().getLeftList().contains(keyListEnum.next())) continue;
                        queryContext.getTree().Shift(keyListEnum.next());
                    }
                }
            }
        } else {
            throw new AttributeIndexNotDefined("Index is not defined for attribute '" + ((MemberFunction)this.functor).getMemberName() + "'");
        }
    }

    public String toString() {
        return this.functor + (this.getInverse() ? " not like " : " like ") + this.pattern;
    }

    public final int compareTo(Object obj) {
        return -1;
    }
}

