/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Caching.Queries.Filters;

import Alachisoft.NCache.Caching.Exceptions.StateTransferException;
import Alachisoft.NCache.Caching.Queries.Filters.AggregateFunctionPredicate;
import Alachisoft.NCache.Caching.Queries.Filters.Predicate;
import Alachisoft.NCache.Caching.Queries.GroupByValueList;
import Alachisoft.NCache.Caching.Queries.QueryContext;
import Alachisoft.NCache.Caching.Queries.QueryType;
import Alachisoft.NCache.Common.DataStructures.ColumnDataType;
import Alachisoft.NCache.Common.DataStructures.ColumnType;
import Alachisoft.NCache.Common.DataStructures.KeyValuesContainer;
import Alachisoft.NCache.Common.DataStructures.MultiRootTree;
import Alachisoft.NCache.Common.DataStructures.RecordSet;
import java.util.ArrayList;
import java.util.Iterator;

public class GroupByPredicate
extends Predicate
implements Comparable {
    private ArrayList<String> _attributeNames = new ArrayList();
    private Predicate _childPredicate;
    private GroupByValueList _groupByValueList;

    public Predicate getChildPredicate() {
        return this._childPredicate;
    }

    public void setChildPredicate(Predicate value) {
        this._childPredicate = value;
    }

    public GroupByValueList getGroupByValueList() {
        return this._groupByValueList;
    }

    public void setGroupByValueList(GroupByValueList value) {
        this._groupByValueList = value;
    }

    @Override
    public boolean ApplyPredicate(Object o) {
        return false;
    }

    public ArrayList<String> getAttributeNamesList() {
        return this._attributeNames;
    }

    @Override
    public void Execute(QueryContext queryContext, Predicate nextPredicate) throws StateTransferException, Exception {
        this.getChildPredicate().Execute(queryContext, nextPredicate);
        queryContext.getTree().Reduce();
        MultiRootTree groupTree = new MultiRootTree(this._attributeNames.size(), this._attributeNames);
        KeyValuesContainer keyValues = new KeyValuesContainer();
        if (!queryContext.getTree().getLeftList().isEmpty()) {
            for (Iterator<Object> key : queryContext.getTree().getLeftList()) {
                String strKey = (String)((Object)key);
                keyValues.setKey(strKey);
                boolean invalidGroupKey = false;
                for (int i = 0; i < this._attributeNames.size(); ++i) {
                    Object attributeValue = queryContext.getIndex().GetAttributeValue(strKey, this._attributeNames.get(i));
                    if (attributeValue == null) {
                        invalidGroupKey = true;
                        break;
                    }
                    keyValues.getValues().put(this._attributeNames.get(i), attributeValue);
                }
                if (invalidGroupKey) continue;
                groupTree.Add(keyValues);
            }
        }
        RecordSet resultRecordSet = new RecordSet();
        for (String columnName : this._groupByValueList.getObjectAttributesList()) {
            resultRecordSet.AddColumn(columnName, false);
        }
        for (AggregateFunctionPredicate afp : this._groupByValueList.getAggregateFunctionsList()) {
            String columnName = null;
            columnName = afp.getAttributeName() != null ? afp.getFunctionType().toString() + "(" + afp.getAttributeName() + ")" : afp.getFunctionType().toString() + "()";
            if (!resultRecordSet.AddColumn(columnName, false, ColumnType.AggregateResultColumn, afp.getFunctionType())) {
                throw new IllegalArgumentException("Invalid query. Same value cannot be selected twice.");
            }
            afp.setChildPredicate(null);
        }
        for (String attribute : this._attributeNames) {
            resultRecordSet.AddColumn(attribute, true);
        }
        groupTree.ToRecordSet(resultRecordSet);
        for (int rowID = 0; rowID < resultRecordSet.getRowCount(); ++rowID) {
            ArrayList keysList = (ArrayList)resultRecordSet.GetObject(rowID, resultRecordSet.getColumnCount() - 1);
            int j = 0;
            for (AggregateFunctionPredicate afp : this._groupByValueList.getAggregateFunctionsList()) {
                queryContext.getTree().getRightList().addAll(keysList);
                afp.Execute(queryContext, null);
                int columnId = this._groupByValueList.getObjectAttributesList().size() + j++;
                if (resultRecordSet.GetColumnDataType(columnId) == ColumnDataType.Object) {
                    resultRecordSet.SetColumnDataType(columnId, RecordSet.ToColumnDataType(queryContext.getResultSet().getAggregateFunctionResult().getValue()));
                }
                resultRecordSet.Add(queryContext.getResultSet().getAggregateFunctionResult().getValue(), rowID, columnId);
            }
        }
        resultRecordSet.RemoveLastColumn();
        queryContext.getResultSet().setGroupByResult(resultRecordSet);
        queryContext.getResultSet().setType(QueryType.GroupByAggregateFunction);
    }

    public int compareTo(Object o) {
        GroupByPredicate other = (GroupByPredicate)(o instanceof GroupByPredicate ? o : null);
        if (other != null) {
            return ((Comparable)((Object)this.getChildPredicate())).compareTo(o);
        }
        return -1;
    }
}

