/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Caching.Queries;

import Alachisoft.NCache.Caching.CacheEntry;
import Alachisoft.NCache.Caching.MetaInformation;
import Alachisoft.NCache.Caching.Queries.AttributeIndex;
import Alachisoft.NCache.Caching.Queries.IQueryIndex;
import Alachisoft.NCache.Caching.Queries.IndexInformation;
import Alachisoft.NCache.Caching.Queries.IndexStoreInformation;
import Alachisoft.NCache.Caching.Queries.RBStore;
import Alachisoft.NCache.Caching.Queries.TypeIndex;
import Alachisoft.NCache.Caching.Queries.VirtualQueryIndex;
import Alachisoft.NCache.Caching.Topologies.Local.IndexedLocalCache;
import Alachisoft.NCache.Common.Configuration.ConfigurationBuilder;
import Alachisoft.NCache.Common.DataStructures.RedBlackException;
import Alachisoft.NCache.Common.ServicePropValues;
import Alachisoft.NCache.Common.Threading.AsyncProcessor;
import com.alachisoft.ncache.runtime.util.HelperFxn;
import com.alachisoft.ncache.runtime.util.NCDateTime;
import com.alachisoft.ncache.serialization.util.TypeInfoMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class QueryIndexManager {
    private static boolean _disableException = false;
    protected String _cacheName;
    protected TypeInfoMap _typeMap;
    protected HashMap _indexMap = new HashMap();
    protected HashMap _dataSharingTypesMap;
    protected HashMap<String, AttributeIndex> _sharedAttributeIndex;
    String TAG_INDEX_KEY = "$Tag$";
    String NAMED_TAG_PREFIX = "$NamedTagAttribute$";
    private AsyncProcessor _asyncProcessor;
    private boolean _indexForAll;
    private IndexedLocalCache _cache;
    private Map _props;

    public QueryIndexManager(Map props, IndexedLocalCache cache, String cacheName, HashMap dataSharingKnownTypes) {
        this._cache = cache;
        this._props = props;
        this._cacheName = cacheName;
        this._dataSharingTypesMap = dataSharingKnownTypes;
        if (this._dataSharingTypesMap != null && this._dataSharingTypesMap.size() > 0) {
            this._sharedAttributeIndex = new HashMap();
        }
    }

    public static final boolean getDisableException() {
        if (ServicePropValues.Cache_DisableIndexNotDefinedException != null) {
            _disableException = Boolean.parseBoolean(ServicePropValues.Cache_DisableIndexNotDefinedException);
        }
        return _disableException;
    }

    public final TypeInfoMap getTypeInfoMap() {
        return this._typeMap;
    }

    public final AsyncProcessor getAsyncProcessor() {
        return this._asyncProcessor;
    }

    public final boolean getIndexForAll() {
        return this._indexForAll;
    }

    public final HashMap getIndexMap() {
        return this._indexMap;
    }

    public final void createSharedTypeAttributeIndex(HashMap knownSharedClasses, HashMap indexedClasses) {
        HashMap<Object, RBStore> commonRBStore = new HashMap<Object, RBStore>();
        HashMap<String, AttributeIndex> sharedAttributeIndexMap = new HashMap<String, AttributeIndex>();
        Iterator iteouterSharedTypes = knownSharedClasses.entrySet().iterator();
        commonRBStore.put("$Tag$", new RBStore(this._cacheName));
        while (iteouterSharedTypes.hasNext()) {
            HashMap outerTypeAttributes;
            Map.Entry outerEntry = iteouterSharedTypes.next();
            HashMap outerEntryValue = (HashMap)outerEntry.getValue();
            String name = (String)outerEntryValue.get("name");
            String[] temp = name.split(":");
            String outerTypeName = temp[0];
            sharedAttributeIndexMap.put(outerTypeName, new AttributeIndex(this._cacheName, outerTypeName));
            if (indexedClasses.size() <= 0 || !this.isQueryindexed(outerTypeName, indexedClasses) || (outerTypeAttributes = (HashMap)outerEntryValue.get("attribute")) == null) continue;
            for (Map.Entry tempEntry : outerTypeAttributes.entrySet()) {
                HashMap outerAttributeMeta = (HashMap)tempEntry.getValue();
                String outerOrderNo = (String)outerAttributeMeta.get("order");
                String outerAttributeName = (String)outerAttributeMeta.get("name");
                if (!this.isQueryindexedAttribute(outerTypeName, outerAttributeName, indexedClasses)) continue;
                block2: for (Map.Entry innerEntry : knownSharedClasses.entrySet()) {
                    HashMap innerEntryValue = (HashMap)innerEntry.getValue();
                    String name1 = (String)innerEntryValue.get("name");
                    String[] temp1 = name1.split(":");
                    String innerTypeName = temp1[0];
                    if (outerTypeName.equals(innerTypeName) || !this.isQueryindexed(innerTypeName, indexedClasses)) continue;
                    HashMap innerTypeAttributes = (HashMap)((HashMap)innerEntry.getValue()).get("attribute");
                    for (Map.Entry tempEntry1 : innerTypeAttributes.entrySet()) {
                        RBStore commonRB;
                        HashMap innerAttributeMeta = (HashMap)tempEntry1.getValue();
                        String innerorderNo = (String)innerAttributeMeta.get("order");
                        String innerAttributeName = (String)innerAttributeMeta.get("name");
                        if (!innerorderNo.equals(outerOrderNo) || !this.isQueryindexedAttribute(innerTypeName, innerAttributeName, indexedClasses)) continue;
                        if (commonRBStore.containsKey(outerTypeName + ":" + outerAttributeName)) {
                            commonRB = (RBStore)commonRBStore.get(outerTypeName + ":" + outerAttributeName);
                            commonRBStore.put(innerTypeName + ":" + innerAttributeName, commonRB);
                            continue block2;
                        }
                        commonRB = new RBStore(this._cacheName);
                        commonRBStore.put(innerTypeName + ":" + innerAttributeName, commonRB);
                        commonRBStore.put(outerTypeName + ":" + outerAttributeName, commonRB);
                        continue block2;
                    }
                }
            }
        }
        if (sharedAttributeIndexMap.size() > 0) {
            Iterator iteSharedIndexMap = sharedAttributeIndexMap.entrySet().iterator();
            while (iteSharedIndexMap.hasNext()) {
                ArrayList<AttributeIndex> sharedTypes = new ArrayList<AttributeIndex>();
                Map.Entry outerEntry = iteSharedIndexMap.next();
                String outerTypeName = (String)outerEntry.getKey();
                AttributeIndex outerSharedIndex = (AttributeIndex)outerEntry.getValue();
                for (Map.Entry innerEntry : sharedAttributeIndexMap.entrySet()) {
                    String innerTypeName = (String)innerEntry.getKey();
                    if (innerTypeName.equals(outerTypeName)) continue;
                    AttributeIndex innerSharedIndex = (AttributeIndex)innerEntry.getValue();
                    sharedTypes.add(innerSharedIndex);
                }
                outerSharedIndex.setCommonRBStores(commonRBStore);
                outerSharedIndex.setSharedTypes(sharedTypes);
                this._sharedAttributeIndex.put(outerTypeName, outerSharedIndex);
            }
        }
    }

    public final boolean isQueryindexed(String typeName, HashMap indexedClasses) {
        for (Map.Entry current_1 : indexedClasses.entrySet()) {
            HashMap innerProps = current_1.getValue() instanceof HashMap ? current_1.getValue() : null;
            String queryIndexedTypename = "";
            if (innerProps == null || !typeName.equals(queryIndexedTypename = (String)innerProps.get("id"))) continue;
            return true;
        }
        return false;
    }

    public final boolean isQueryindexedAttribute(String typeName, String attributeName, HashMap indexedClasses) {
        for (Map.Entry current_1 : indexedClasses.entrySet()) {
            HashMap innerProps = current_1.getValue() instanceof HashMap ? current_1.getValue() : null;
            String queryIndexedTypeName = "";
            if (innerProps == null || !typeName.equals(queryIndexedTypeName = (String)innerProps.get("id"))) continue;
            ArrayList attribList = new ArrayList();
            for (Map.Entry current_2 : innerProps.entrySet()) {
                HashMap attribs = current_2.getValue() instanceof HashMap ? current_2.getValue() : null;
                if (attribs == null) continue;
                for (Map.Entry current_3 : attribs.entrySet()) {
                    String tempAttrib;
                    HashMap attrib = current_3.getValue() instanceof HashMap ? current_3.getValue() : null;
                    if (attrib == null || !attributeName.equals(tempAttrib = (String)attrib.get("id"))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public final boolean checkForSameClassNames(HashMap knownSharedClasses) {
        Collection coll = knownSharedClasses.values();
        HashMap[] values = new HashMap[coll.size()];
        values = coll.toArray(values);
        for (int outer = 0; outer < values.length - 1; ++outer) {
            HashMap outerValue = values[outer];
            String name = (String)outerValue.get("name");
            String[] temp = name.split("[:]", -1);
            String outerTypeName = temp[0];
            for (int inner = outer + 1; inner < values.length; ++inner) {
                HashMap innerValue = values[inner];
                String name1 = (String)innerValue.get("name");
                String[] temp1 = name1.split("[:]", -1);
                String innerTypeName = temp1[0];
                if (!outerTypeName.equals(innerTypeName)) continue;
                return false;
            }
        }
        return true;
    }

    public final void manipulateDataSharing(HashMap indexClasses) {
        if (this._dataSharingTypesMap != null && this._dataSharingTypesMap.size() > 0 && indexClasses != null) {
            for (Map.Entry current_1 : this._dataSharingTypesMap.entrySet()) {
                HashMap knownSharedClasses;
                HashMap typeHashMap = current_1.getValue() instanceof HashMap ? current_1.getValue() : null;
                if (typeHashMap == null || !typeHashMap.containsKey("known-classes") || !this.checkForSameClassNames(knownSharedClasses = (HashMap)typeHashMap.get("known-classes"))) continue;
                this.createSharedTypeAttributeIndex(knownSharedClasses, indexClasses);
            }
        }
    }

    public boolean Initialize() {
        boolean indexedDefined = false;
        if (this._props != null) {
            if (this._props.containsKey("index-for-all")) {
                indexedDefined = this._indexForAll = ((Boolean)this._props.get("index-for-all")).booleanValue();
            }
            if (this._props.containsKey("index-classes")) {
                HashMap indexClasses = this._props.get("index-classes") instanceof HashMap ? this._props.get("index-classes") : null;
                this._typeMap = new TypeInfoMap(indexClasses);
                this.manipulateDataSharing(indexClasses);
                for (Map.Entry current_1 : indexClasses.entrySet()) {
                    HashMap innerProps = current_1.getValue() instanceof HashMap ? current_1.getValue() : null;
                    String typename = "";
                    if (innerProps == null) continue;
                    typename = (String)innerProps.get("id");
                    ArrayList<String> attribList = new ArrayList<String>();
                    for (Map.Entry current_2 : innerProps.entrySet()) {
                        HashMap attribs = current_2.getValue() instanceof HashMap ? current_2.getValue() : null;
                        if (attribs == null) continue;
                        for (Map.Entry current_3 : attribs.entrySet()) {
                            HashMap attrib = current_3.getValue() instanceof HashMap ? current_3.getValue() : null;
                            if (attrib == null) continue;
                            attribList.add(attrib.get("id") instanceof String ? attrib.get("id") : null);
                        }
                    }
                    if (attribList.size() > 0) {
                        if (this._sharedAttributeIndex != null && this._sharedAttributeIndex.containsKey(typename)) {
                            AttributeIndex attribIndex = this._sharedAttributeIndex.get(typename);
                            attribIndex.Initialize(attribList);
                            this._indexMap.put(typename, attribIndex);
                        } else {
                            this._indexMap.put(typename, new AttributeIndex(attribList, this._cacheName, typename));
                        }
                    } else {
                        this._indexMap.put(typename, new TypeIndex(typename, this._indexForAll));
                    }
                    indexedDefined = true;
                }
            }
        } else {
            this._indexMap.put("default", new VirtualQueryIndex(this._cache));
            this.manipulateDataSharing(new HashMap());
        }
        if (indexedDefined) {
            this._asyncProcessor = new AsyncProcessor(this._cache.getContext().getNCacheLog());
            this._asyncProcessor.Start();
        }
        return indexedDefined;
    }

    public final void dispose() {
        if (this._asyncProcessor != null) {
            this._asyncProcessor.Stop();
            this._asyncProcessor = null;
        }
        if (this._indexMap != null) {
            this._indexMap.clear();
            this._indexMap = null;
        }
        this._cache = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void AddToIndex(Object key, Object value) throws ClassNotFoundException, RedBlackException {
        CacheEntry entry = (CacheEntry)value;
        Object tempVar = entry.getQueryInfo().get("query-info");
        HashMap queryInfo = (HashMap)(tempVar instanceof HashMap ? tempVar : null);
        if (queryInfo == null) {
            return;
        }
        HashMap hashMap = this._indexMap;
        synchronized (hashMap) {
            Iterator queryInfoEnumerator = queryInfo.entrySet().iterator();
            if (this._typeMap != null) {
                while (queryInfoEnumerator.hasNext()) {
                    Map.Entry current = queryInfoEnumerator.next();
                    int handleId = (Integer)current.getKey();
                    String type = this._typeMap.getTypeName(handleId);
                    if (!this._indexMap.containsKey(type)) continue;
                    HashMap<String, Object> indexAttribs = new HashMap<String, Object>();
                    HashMap<String, Object> metaInfoAttribs = new HashMap<String, Object>();
                    ArrayList values = (ArrayList)current.getValue();
                    ArrayList attribList = this._typeMap.getAttribList(handleId);
                    for (int i = 0; i < attribList.size(); ++i) {
                        String attribute = attribList.get(i).toString();
                        String val = this._typeMap.getAttributes(handleId).get(attribList.get(i)) instanceof String ? this._typeMap.getAttributes(handleId).get(attribList.get(i)) : null;
                        Class t1 = this.ConvertCLRtoJavaMapping(val);
                        Object obj = null;
                        if (values.get(i) != null) {
                            try {
                                if (t1 == Date.class && !((String)values.get(i)).equals("NCNULL")) {
                                    NCDateTime ncd = new NCDateTime(Long.parseLong((String)values.get(i)));
                                    obj = ncd.getDate();
                                } else {
                                    obj = new ConfigurationBuilder().ConvertToPrimitive(t1, values.get(i).toString(), "");
                                }
                            }
                            catch (Exception e) {
                                throw new ClassNotFoundException("Cannot convert '" + values.get(i) + "' to " + t1.toString());
                            }
                            indexAttribs.put(attribute, obj);
                        } else {
                            indexAttribs.put(attribute, null);
                        }
                        metaInfoAttribs.put(attribute, obj);
                    }
                    entry.setMetaInformation(new MetaInformation(metaInfoAttribs));
                    entry.getMetaInformation().setCacheKey((String)(key instanceof String ? key : null));
                    entry.getMetaInformation().setType(this._typeMap.getTypeName(handleId));
                    entry.setObjectType(this._typeMap.getTypeName(handleId));
                    IQueryIndex index = (IQueryIndex)this._indexMap.get(type);
                    index.AddToIndex(key, indexAttribs);
                }
            }
        }
    }

    /*
     * Loose catch block
     */
    public final Class ConvertCLRtoJavaMapping(String dataType) throws ClassNotFoundException {
        block22: {
            if (!dataType.startsWith("System")) break block22;
            if (dataType.equals("System.String")) {
                return Class.forName("java.lang.String");
            }
            if (dataType.equals("System.Boolean")) {
                return Class.forName("java.lang.Boolean");
            }
            if (dataType.equals("System.Char")) {
                return Class.forName("java.lang.Character");
            }
            if (dataType.equals("System.Double")) {
                return Class.forName("java.lang.Double");
            }
            if (dataType.equals("System.Single")) {
                return Class.forName("java.lang.Float");
            }
            if (dataType.equals("System.Int16")) {
                return Class.forName("java.lang.Short");
            }
            if (dataType.equals("System.Int32")) {
                return Class.forName("java.lang.Integer");
            }
            if (dataType.equals("System.Int64")) {
                return Class.forName("java.lang.Long");
            }
            if (dataType.equals("System.Byte")) {
                return Class.forName("java.lang.Byte");
            }
            if (dataType.equals("System.SByte")) {
                return Class.forName("java.lang.Byte");
            }
            if (dataType.equals("System.DateTime")) {
                return Class.forName("java.util.Date");
            }
            if (dataType.equals("System.UInt16")) {
                return Class.forName("java.lang.Integer");
            }
            if (dataType.equals("System.UInt32")) {
                return Class.forName("java.lang.Long");
            }
            if (dataType.equals("System.UInt64")) {
                return Class.forName("java.math.BigInteger");
            }
            if (dataType.equals("System.Decimal")) {
                return Class.forName("java.math.BigDecimal");
            }
            return Class.forName(dataType);
            {
                catch (ClassNotFoundException classNotFoundException) {
                    try {
                        return Class.forName(dataType);
                    }
                    catch (ClassNotFoundException classNotFoundException1) {
                        throw classNotFoundException;
                    }
                }
            }
        }
        return Class.forName(dataType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void AsyncAddToIndex(Object key, CacheEntry value) {
        AsyncProcessor asyncProcessor = this._asyncProcessor;
        synchronized (asyncProcessor) {
            this._asyncProcessor.Enqueue((AsyncProcessor.IAsyncTask)new IndexAddTask(this, key, value));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void RemoveFromIndex(Object key, String value) throws RedBlackException {
        if (value == null) {
            return;
        }
        HashMap hashMap = this._indexMap;
        synchronized (hashMap) {
            String type = value.toString();
            if (this._indexMap.containsKey(type)) {
                IQueryIndex index = (IQueryIndex)this._indexMap.get(type);
                index.RemoveFromIndex(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void RemoveFromIndex(Object key, Object value) throws RedBlackException, ClassNotFoundException {
        if (value == null) {
            return;
        }
        HashMap hashMap = this._indexMap;
        synchronized (hashMap) {
            for (Map.Entry current : ((HashMap)value).entrySet()) {
                int handleId = (Integer)current.getKey();
                String type = this._typeMap.getTypeName(handleId);
                if (!this._indexMap.containsKey(type)) continue;
                HashMap<String, Object> attribs = new HashMap<String, Object>();
                ArrayList values = (ArrayList)current.getValue();
                ArrayList attribList = this._typeMap.getAttribList(handleId);
                for (int i = 0; i < attribList.size(); ++i) {
                    String val = this._typeMap.getAttributes(handleId).get(attribList.get(i)) instanceof String ? this._typeMap.getAttributes(handleId).get(attribList.get(i)) : null;
                    Class t1 = this.ConvertCLRtoJavaMapping(val);
                    Object obj = null;
                    if (values.get(i) == null) continue;
                    try {
                        if (t1 == Date.class && !((String)values.get(i)).equals("NCNULL")) {
                            NCDateTime ncd = new NCDateTime(Long.parseLong(values.get(i).toString()));
                            obj = ncd.getDate();
                        } else {
                            obj = new ConfigurationBuilder().ConvertToPrimitive(t1, values.get(i).toString(), "");
                        }
                    }
                    catch (Exception e) {
                        throw new ClassNotFoundException("Cannot convert '" + values.get(i) + "' to " + t1.toString());
                    }
                    String attribute = attribList.get(i).toString();
                    if (obj != null && obj instanceof String) {
                        attribs.put(attribute, ((String)obj).toLowerCase());
                        continue;
                    }
                    attribs.put(attribute, obj);
                }
                IQueryIndex index = (IQueryIndex)this._indexMap.get(type);
                index.RemoveFromIndex(key, attribs);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void AsyncRemoveFromIndex(Object key, CacheEntry value) {
        AsyncProcessor asyncProcessor = this._asyncProcessor;
        synchronized (asyncProcessor) {
            this._asyncProcessor.Enqueue((AsyncProcessor.IAsyncTask)new IndexRemoveTask(this, key, value));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void Clear() {
        if (this._indexMap != null) {
            HashMap hashMap = this._indexMap;
            synchronized (hashMap) {
                for (Map.Entry current : this._indexMap.entrySet()) {
                    IQueryIndex index = current.getValue() instanceof IQueryIndex ? current.getValue() : null;
                    index.Clear();
                }
            }
        }
    }

    public HashMap GetQueryInfo(Object key, Object value) {
        int handleId;
        HashMap queryInfo = new HashMap();
        HashMap queryIndex = new HashMap();
        CacheEntry entry = (CacheEntry)value;
        if (entry.getObjectType() == null) {
            return queryInfo;
        }
        IQueryIndex index = (IQueryIndex)this._indexMap.get(entry.getObjectType());
        IndexInformation indexInformation = index.GetIndexInformation(key);
        if (this._typeMap != null && (handleId = this._typeMap.getHandleId(entry.getObjectType())) > -1) {
            ArrayList attributes = this._typeMap.getAttribList(handleId);
            ArrayList<String> attributeValues = new ArrayList<String>();
            block0: for (int i = 0; i < attributes.size(); ++i) {
                for (IndexStoreInformation indexStoreInfo : indexInformation.getIndexStoreInformations()) {
                    if (!attributes.get(i).toString().equals(indexStoreInfo.getStoreName())) continue;
                    if (indexStoreInfo.getIndexPosition() == null) {
                        attributeValues.add(null);
                        continue block0;
                    }
                    Comparable val = indexStoreInfo.getIndexPosition().getRBReference().getKey();
                    String objValue = null;
                    if (val instanceof Date) {
                        long ticks = HelperFxn.getUTCTicks((Date)((Date)val));
                        objValue = Long.toString(ticks);
                    } else {
                        objValue = val.toString();
                    }
                    attributeValues.add(objValue);
                    continue block0;
                }
            }
            queryIndex.put(handleId, attributeValues);
            queryInfo.put("query-info", queryIndex);
        }
        HashMap<String, Object> namedTagInfo = new HashMap<String, Object>();
        HashMap<String, Comparable> namedTagsList = new HashMap<String, Comparable>();
        HashMap<String, Object> tagInfo = new HashMap<String, Object>();
        ArrayList<Comparable> tagsList = new ArrayList<Comparable>();
        for (IndexStoreInformation indexStoreinfo : indexInformation.getIndexStoreInformations()) {
            if (AttributeIndex.IsNamedTagKey(indexStoreinfo.getStoreName())) {
                if (indexStoreinfo.getIndexPosition() == null) continue;
                namedTagsList.put(this.ConvertToNamedTag(indexStoreinfo.getStoreName().toString()), indexStoreinfo.getIndexPosition().getRBReference().getKey());
                continue;
            }
            if (!indexStoreinfo.getStoreName().equals(this.TAG_INDEX_KEY) || indexStoreinfo.getIndexPosition() == null) continue;
            tagsList.add(indexStoreinfo.getIndexPosition().getRBReference().getKey());
        }
        namedTagInfo.put("type", entry.getObjectType());
        namedTagInfo.put("named-tags-list", namedTagsList);
        queryInfo.put("named-tag-info", namedTagInfo);
        tagInfo.put("type", entry.getObjectType());
        tagInfo.put("tags-list", tagsList);
        queryInfo.put("tag-info", tagInfo);
        return queryInfo;
    }

    public final String ConvertToNamedTag(String indexKey) {
        String namedTagKey = indexKey.replace(this.NAMED_TAG_PREFIX, "");
        return namedTagKey;
    }

    private static class IndexRemoveTask
    implements AsyncProcessor.IAsyncTask {
        private Object _key;
        private CacheEntry _entry;
        private QueryIndexManager _indexManager;

        public IndexRemoveTask(QueryIndexManager indexManager, Object key, CacheEntry value) {
            this._key = key;
            this._entry = value;
            this._indexManager = indexManager;
        }

        public void Process() {
            try {
                this._indexManager.RemoveFromIndex(this._key, this._entry.getObjectType());
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    private static class IndexAddTask
    implements AsyncProcessor.IAsyncTask {
        private Object _key;
        private CacheEntry _entry;
        private QueryIndexManager _indexManager;

        public IndexAddTask(QueryIndexManager indexManager, Object key, CacheEntry value) {
            this._key = key;
            this._entry = value;
            this._indexManager = indexManager;
        }

        public void Process() {
            try {
                this._indexManager.AddToIndex(this._key, this._entry);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }
}

