/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Caching.Statistics;

import Alachisoft.NCache.Caching.Statistics.CacheStatistics;
import Alachisoft.NCache.Caching.Statistics.NodeInfo;
import Alachisoft.NCache.Common.Net.Address;
import com.alachisoft.ncache.serialization.core.io.ICompactSerializable;
import com.alachisoft.ncache.serialization.core.io.NCacheObjectInput;
import com.alachisoft.ncache.serialization.core.io.NCacheObjectOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ClusterCacheStatistics
extends CacheStatistics
implements Cloneable,
ICompactSerializable {
    private String _groupName;
    private String _channelType;
    private int _memberCount;
    private int _serverCount;
    private int _otherCount;
    private NodeInfo _localNode;
    private List _nodeInfos;
    private ArrayList _clusterDataAffinity = new ArrayList();
    private HashMap _datagroupsAtPartition = new HashMap();
    private HashMap _partitionsHavingDatagroup = new HashMap();
    private HashMap _subgroupNodes = new HashMap();

    public ClusterCacheStatistics() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ClusterCacheStatistics(ClusterCacheStatistics stat) throws CloneNotSupportedException {
        super(stat);
        ClusterCacheStatistics clusterCacheStatistics = stat;
        synchronized (clusterCacheStatistics) {
            Object tempVar;
            this._groupName = stat._groupName;
            this._channelType = stat._channelType;
            this._memberCount = stat._memberCount;
            this._serverCount = stat._serverCount;
            this._otherCount = stat._otherCount;
            Object object = tempVar = stat._localNode == null ? null : stat._localNode.clone();
            NodeInfo nodeInfo = stat._localNode == null ? null : (this._localNode = (NodeInfo)(tempVar instanceof NodeInfo ? tempVar : null));
            if (stat._nodeInfos != null) {
                this._nodeInfos = new ArrayList(stat._nodeInfos.size());
                for (int i = 0; i < stat._nodeInfos.size(); ++i) {
                    Object tempVar2 = ((NodeInfo)stat._nodeInfos.get(i)).clone();
                    this._nodeInfos.add((NodeInfo)(tempVar2 instanceof NodeInfo ? tempVar2 : null));
                }
            }
            if (stat.getClusterDataAffinity() != null) {
                this.setClusterDataAffinity((ArrayList)stat.getClusterDataAffinity().clone());
            }
            if (stat.getPartitionsHavingDatagroup() != null) {
                this.setPartitionsHavingDatagroup((HashMap)stat.getPartitionsHavingDatagroup().clone());
            }
            if (stat.getDatagroupsAtPartition() != null) {
                this.setDatagroupsAtPartition((HashMap)stat.getDatagroupsAtPartition().clone());
            }
            if (stat.getSubgroupNodes() != null) {
                this.setSubgroupNodes((HashMap)stat.getSubgroupNodes().clone());
            }
        }
    }

    @Override
    public long getMaxSize() {
        return this.getLocalNode().getStatistics().getMaxSize();
    }

    @Override
    public void setMaxSize(long value) {
        if (this.getLocalNode() != null) {
            this.getLocalNode().getStatistics().setMaxSize(value);
        }
    }

    public final String getGroupName() {
        return this._groupName;
    }

    public final void setGroupName(String value) {
        this._groupName = value;
    }

    public final String getChannelType() {
        return this._channelType;
    }

    public final void setChannelType(String value) {
        this._channelType = value;
    }

    public final int getClusterSize() {
        return this.getMemberCount() + this.getOtherCount();
    }

    public final int getMemberCount() {
        return this._memberCount;
    }

    public final void setMemberCount(int value) {
        this._memberCount = value;
    }

    public final int getServerCount() {
        return this._serverCount;
    }

    public final void setServerCount(int value) {
        this._serverCount = value;
    }

    public final int getOtherCount() {
        return this._otherCount;
    }

    public final void setOtherCount(int value) {
        this._otherCount = value;
    }

    public final NodeInfo getLocalNode() {
        return this._localNode;
    }

    public final void setLocalNode(NodeInfo value) {
        this._localNode = value;
    }

    public final List getNodes() {
        return this._nodeInfos;
    }

    public final void setNodes(List value) {
        this._nodeInfos = value;
    }

    public final ArrayList getClusterDataAffinity() {
        return this._clusterDataAffinity;
    }

    public final void setClusterDataAffinity(ArrayList value) {
        this._clusterDataAffinity = value;
    }

    public final HashMap getDatagroupsAtPartition() {
        return this._datagroupsAtPartition;
    }

    public final void setDatagroupsAtPartition(HashMap value) {
        this._datagroupsAtPartition = value;
    }

    public final HashMap getPartitionsHavingDatagroup() {
        return this._partitionsHavingDatagroup;
    }

    public final void setPartitionsHavingDatagroup(HashMap value) {
        this._partitionsHavingDatagroup = value;
    }

    public final HashMap getSubgroupNodes() {
        return this._subgroupNodes;
    }

    public final void setSubgroupNodes(HashMap value) {
        this._subgroupNodes = value;
    }

    @Override
    public Object clone() {
        try {
            return new ClusterCacheStatistics(this);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final NodeInfo GetNode(Address address) {
        ClusterCacheStatistics clusterCacheStatistics = this;
        synchronized (clusterCacheStatistics) {
            if (this._nodeInfos != null) {
                for (int i = 0; i < this._nodeInfos.size(); ++i) {
                    if (((NodeInfo)this._nodeInfos.get(i)).getAddress().compareTo((Object)address) != 0) continue;
                    return this._nodeInfos.get(i) instanceof NodeInfo ? this._nodeInfos.get(i) : null;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void SetServerCounts(int servCnt, int memCnt, int otherCnt) {
        ClusterCacheStatistics clusterCacheStatistics = this;
        synchronized (clusterCacheStatistics) {
            this._serverCount = servCnt;
            this._memberCount = memCnt;
            this._otherCount = otherCnt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        ClusterCacheStatistics clusterCacheStatistics = this;
        synchronized (clusterCacheStatistics) {
            StringBuilder ret = new StringBuilder();
            ret.append("Cluster[" + super.toString() + ", Nm:" + this.getGroupName() + ", ");
            ret.append("S:" + new Integer(this.getServerCount()).toString() + ", ");
            ret.append("M:" + new Integer(this.getMemberCount()).toString() + ", ");
            ret.append("O:" + new Integer(this.getOtherCount()).toString() + ", ");
            if (this._localNode != null) {
                ret.append("Local" + this._localNode.toString());
            }
            for (NodeInfo i : this._nodeInfos) {
                ret.append(", " + i.toString());
            }
            ret.append("]");
            return ret.toString();
        }
    }

    @Override
    public void deserialize(NCacheObjectInput reader) throws ClassNotFoundException, IOException {
        super.deserialize(reader);
        this._groupName = (String)reader.readObject();
        this._channelType = (String)reader.readObject();
        this._memberCount = reader.readInt();
        this._serverCount = reader.readInt();
        this._otherCount = reader.readInt();
        this._localNode = NodeInfo.ReadNodeInfo(reader);
        this._nodeInfos = (ArrayList)reader.readObject();
    }

    @Override
    public void serialize(NCacheObjectOutput writer) throws IOException {
        super.serialize(writer);
        writer.writeObject((Object)this._groupName);
        writer.writeObject((Object)this._channelType);
        writer.writeInt(this._memberCount);
        writer.writeInt(this._serverCount);
        writer.writeInt(this._otherCount);
        if (this._localNode != null) {
            writer.writeBoolean(false);
            this._localNode.serialize(writer);
        } else {
            writer.writeBoolean(true);
        }
        writer.writeObject((Object)this._nodeInfos);
    }
}

