/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Caching.Statistics;

import Alachisoft.NCache.Common.Monitoring.Category;
import Alachisoft.NCache.Common.Monitoring.Counter;
import com.alachisoft.ncache.common.caching.statistics.monitoring.CounterCreationData;
import com.alachisoft.ncache.common.caching.statistics.monitoring.PerformanceCounterType;
import com.alachisoft.ncache.common.monitoring.CounterMetadata;
import com.alachisoft.ncache.common.monitoring.CounterMetadataCollection;
import com.alachisoft.ncache.common.monitoring.CounterType;
import com.alachisoft.ncache.common.monitoring.Publisher;
import java.util.ArrayList;

public class StatsMetricsUtil {
    public static CounterMetadataCollection Metadata(CounterCreationData[] counterMeta, Publisher publisher, Category category) {
        try {
            ArrayList<CounterMetadata> registeredCounters = new ArrayList<CounterMetadata>();
            for (CounterCreationData counterData : counterMeta) {
                for (Counter counter : category.getCounters()) {
                    if (!counter.getName().equals(counterData.getCounterName()) || !counter.getPublish() || counterData.getCounterType() == PerformanceCounterType.AverageBase) continue;
                    CounterType type = StatsMetricsUtil.GetCounterType(counterData);
                    CounterMetadata tempVar = new CounterMetadata();
                    tempVar.setName(counterData.getCounterName());
                    tempVar.setType(type);
                    tempVar.setDescription(counterData.getCounterHelp());
                    tempVar.setCategory(publisher);
                    registeredCounters.add(tempVar);
                }
            }
            CounterMetadataCollection tempVar2 = new CounterMetadataCollection();
            tempVar2.setCounters(registeredCounters);
            tempVar2.setCategory(publisher);
            return tempVar2;
        }
        catch (RuntimeException ex) {
            return null;
        }
    }

    private static CounterType GetCounterType(CounterCreationData counter) {
        PerformanceCounterType type = counter.getCounterType();
        switch (type) {
            case AverageCount64: 
            case AverageTimer32: 
            case AverageBase: {
                return CounterType.AverageCounter;
            }
            case NumberOfItems32: 
            case NumberOfItems64: 
            case NumberOfItemsHEX32: 
            case NumberOfItemsHEX64: {
                return CounterType.NumberOfItemCounter;
            }
            case RateOfCountsPerSecond32: 
            case RateOfCountsPerSecond64: {
                return CounterType.RateOfCounter;
            }
            case SampleBase: 
            case SampleCounter: 
            case SampleFraction: {
                return CounterType.SampleCounter;
            }
        }
        return CounterType.Default;
    }
}

