/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Caching.Topologies.Local;

import Alachisoft.NCache.Caching.AutoExpiration.LockExpiration;
import Alachisoft.NCache.Caching.CacheEntry;
import Alachisoft.NCache.Caching.CacheRuntimeContext;
import Alachisoft.NCache.Caching.DataGrouping.GroupIndexManager;
import Alachisoft.NCache.Caching.DataGrouping.GroupInfo;
import Alachisoft.NCache.Caching.Enumeration.EnumerationIndex;
import Alachisoft.NCache.Caching.Exceptions.StateTransferException;
import Alachisoft.NCache.Caching.ItemRemoveReason;
import Alachisoft.NCache.Caching.OperationContext;
import Alachisoft.NCache.Caching.OperationContextFieldName;
import Alachisoft.NCache.Caching.Queries.ActiveQueryAnalyzer;
import Alachisoft.NCache.Caching.Queries.Filters.Predicate;
import Alachisoft.NCache.Caching.Queries.NamedTagIndexManager;
import Alachisoft.NCache.Caching.Queries.QueryContext;
import Alachisoft.NCache.Caching.Queries.QueryIndexManager;
import Alachisoft.NCache.Caching.TagComparisonType;
import Alachisoft.NCache.Caching.Topologies.CacheAddResult;
import Alachisoft.NCache.Caching.Topologies.CacheBase;
import Alachisoft.NCache.Caching.Topologies.CacheInsResult;
import Alachisoft.NCache.Caching.Topologies.ICacheEventsListener;
import Alachisoft.NCache.Caching.Topologies.Local.LocalCache;
import Alachisoft.NCache.Caching.Util.CacheHelper;
import Alachisoft.NCache.Common.DataStructures.EnumerationDataChunk;
import Alachisoft.NCache.Common.DataStructures.EnumerationPointer;
import Alachisoft.NCache.Common.DataStructures.RedBlackException;
import Alachisoft.NCache.Common.Locking.LockAccessType;
import Alachisoft.NCache.Parser.AttributeIndexNotDefined;
import Alachisoft.NCache.Parser.TypeIndexNotDefined;
import com.alachisoft.ncache.runtime.exceptions.CacheException;
import com.alachisoft.ncache.runtime.exceptions.ConfigurationException;
import com.alachisoft.ncache.runtime.exceptions.GeneralFailureException;
import com.alachisoft.ncache.runtime.exceptions.LockingException;
import com.alachisoft.ncache.runtime.exceptions.OperationFailedException;
import com.alachisoft.ncache.serialization.util.TypeInfoMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import tangible.RefObject;

public class IndexedLocalCache
extends LocalCache {
    private GroupIndexManager _grpIndexManager = new GroupIndexManager();
    private QueryIndexManager _queryIndexManager;
    private EnumerationIndex _enumerationIndex;

    public IndexedLocalCache(Map cacheClasses, CacheBase parentCache, Map properties, ICacheEventsListener listener, CacheRuntimeContext context, ActiveQueryAnalyzer activeQueryAnalyzer) throws ConfigurationException {
        super(cacheClasses, parentCache, properties, listener, context, activeQueryAnalyzer);
        Map props = null;
        if (properties.containsKey("indexes")) {
            props = properties.get("indexes") instanceof Map ? properties.get("indexes") : null;
        }
        this._queryIndexManager = new NamedTagIndexManager(props, this, this._context.getCacheRoot().getName(), context._dataSharingKnownTypesforNet);
        if (!this._queryIndexManager.Initialize()) {
            this._queryIndexManager = null;
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this._queryIndexManager != null) {
            this._queryIndexManager.dispose();
            this._queryIndexManager = null;
        }
        if (this._grpIndexManager != null) {
            this._grpIndexManager.dispose();
            this._grpIndexManager = null;
        }
    }

    public final QueryIndexManager getIndexManager() {
        return this._queryIndexManager;
    }

    @Override
    public final TypeInfoMap getTypeInfoMap() {
        if (this._queryIndexManager != null) {
            return this._queryIndexManager.getTypeInfoMap();
        }
        return null;
    }

    @Override
    public void ClearInternal() {
        super.ClearInternal();
        this._grpIndexManager.Clear();
        if (this._queryIndexManager != null) {
            this._queryIndexManager.Clear();
        }
    }

    @Override
    public QueryContext SearchInternal(Predicate pred, Map values) throws CacheException {
        QueryContext queryContext = new QueryContext(this);
        queryContext.setAttributeValues(values);
        queryContext.setCacheContext(this._context.getCacheRoot().getName());
        try {
            pred.Execute(queryContext, null);
            return queryContext;
        }
        catch (AttributeIndexNotDefined e) {
            throw e;
        }
        catch (TypeIndexNotDefined e) {
            throw e;
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    @Override
    public QueryContext DeleteQueryInternal(Predicate pred, Map values) throws Exception {
        QueryContext queryContext = new QueryContext(this);
        queryContext.setAttributeValues(values);
        queryContext.setCacheContext(this._context.getCacheRoot().getName());
        pred.Execute(queryContext, null);
        return queryContext;
    }

    @Override
    public CacheEntry GetInternal(Object key, boolean isUserOperation, OperationContext operationContext) throws StateTransferException {
        CacheEntry entry = super.GetInternal(key, isUserOperation, operationContext);
        if (entry != null && operationContext != null && operationContext.Contains(OperationContextFieldName.GenerateQueryInfo) && entry.getObjectType() != null) {
            CacheEntry clone = (CacheEntry)entry.clone();
            clone.setQueryInfo(this._queryIndexManager.GetQueryInfo(key, entry));
            return clone;
        }
        return entry;
    }

    @Override
    public ArrayList GetGroupKeys(String group, String subGroup, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException {
        return this._grpIndexManager.GetGroupKeys(group, subGroup);
    }

    @Override
    public CacheEntry GetGroup(Object key, String group, String subGroup, RefObject<Long> version, RefObject<Object> lockId, RefObject<Date> lockDate, LockExpiration lockExpiration, LockAccessType accessType, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException, StateTransferException, CacheException {
        if (this._grpIndexManager.KeyExists(key, group, subGroup)) {
            return this.Get(key, version, lockId, lockDate, lockExpiration, accessType, operationContext);
        }
        return null;
    }

    @Override
    public HashMap GetGroup(Object[] keys, String group, String subGroup, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException, StateTransferException {
        HashMap<Object, Serializable> result = new HashMap<Object, Serializable>();
        for (int i = 0; i < keys.length; ++i) {
            try {
                if (!this._grpIndexManager.KeyExists(keys[i], group, subGroup)) continue;
                result.put(keys[i], this.Get(keys[i], operationContext));
                continue;
            }
            catch (StateTransferException se) {
                result.put(keys[i], se);
                continue;
            }
            catch (Exception e) {
                throw new OperationFailedException((Throwable)e);
            }
        }
        return result;
    }

    @Override
    public ArrayList getDataGroupList() {
        return this._grpIndexManager != null ? this._grpIndexManager.getDataGroupList() : null;
    }

    @Override
    public GroupInfo GetGroupInfo(Object key, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException, StateTransferException, CacheException {
        CacheEntry entry = this.Get(key, operationContext);
        GroupInfo info = null;
        if (entry != null) {
            info = entry.getGroupInfo() != null ? new GroupInfo(entry.getGroupInfo().getGroup(), entry.getGroupInfo().getSubGroup()) : new GroupInfo(null, null);
        }
        return info;
    }

    @Override
    public HashMap GetGroupInfoBulk(Object[] keys, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException, StateTransferException, CacheException {
        HashMap infoTahle = new HashMap();
        HashMap entries = this.Get(keys, operationContext);
        if (entries != null) {
            for (Map.Entry pair : entries.entrySet()) {
                GroupInfo info = null;
                CacheEntry currentEntry = (CacheEntry)pair.getValue();
                if (currentEntry != null && (info = currentEntry.getGroupInfo()) == null) {
                    info = new GroupInfo(null, null);
                }
                infoTahle.put(pair.getKey(), info);
            }
        }
        return infoTahle;
    }

    @Override
    public ArrayList GetTagKeys(String[] tags, TagComparisonType comparisonType, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException, StateTransferException {
        switch (comparisonType) {
            case BY_TAG: {
                return ((NamedTagIndexManager)this._queryIndexManager).GetByTag(tags[0]);
            }
            case ANY_MATCHING_TAG: {
                return ((NamedTagIndexManager)this._queryIndexManager).GetAnyMatchingTag(tags);
            }
            case ALL_MATCHING_TAGS: {
                return ((NamedTagIndexManager)this._queryIndexManager).GetAllMatchingTags(tags);
            }
        }
        return null;
    }

    @Override
    public HashMap Remove(String group, String subGroup, boolean notify, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException, CacheException {
        ArrayList list = this._grpIndexManager.GetGroupKeys(group, subGroup);
        Object[] keys = new Object[list.size()];
        int i = 0;
        for (Object key : list) {
            keys[i] = key;
            ++i;
        }
        return this.Remove(keys, ItemRemoveReason.Removed, notify, operationContext);
    }

    @Override
    public CacheAddResult AddInternal(Object key, CacheEntry cacheEntry, boolean isUserOperation) throws StateTransferException, CacheException {
        CacheAddResult result = super.AddInternal(key, cacheEntry, isUserOperation);
        if (result == CacheAddResult.Success || result == CacheAddResult.SuccessNearEviction) {
            this._grpIndexManager.AddToGroup(key, cacheEntry.getGroupInfo());
            if (this._queryIndexManager != null && cacheEntry.getQueryInfo() != null) {
                try {
                    this._queryIndexManager.AddToIndex(key, cacheEntry);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new CacheException((Throwable)classNotFoundException);
                }
                catch (RedBlackException red) {
                    throw new CacheException((Throwable)red);
                }
            }
        }
        return result;
    }

    @Override
    public CacheInsResult InsertInternal(Object key, CacheEntry cacheEntry, boolean isUserOperation, CacheEntry oldEntry, OperationContext operationContext) throws StateTransferException, CacheException {
        try {
            if (oldEntry != null && !CacheHelper.CheckDataGroupsCompatibility(cacheEntry.getGroupInfo(), oldEntry.getGroupInfo())) {
                return CacheInsResult.IncompatibleGroup;
            }
            CacheInsResult result = super.InsertInternal(key, cacheEntry, isUserOperation, oldEntry, operationContext);
            if (result == CacheInsResult.Success || result == CacheInsResult.SuccessNearEvicition) {
                this._grpIndexManager.AddToGroup(key, cacheEntry.getGroupInfo());
                if (this._queryIndexManager != null && cacheEntry.getQueryInfo() != null) {
                    this._queryIndexManager.AddToIndex(key, cacheEntry);
                }
            } else if (result == CacheInsResult.SuccessOverwrite || result == CacheInsResult.SuccessOverwriteNearEviction) {
                if (oldEntry != null) {
                    this._grpIndexManager.RemoveFromGroup(key, oldEntry.getGroupInfo());
                }
                this._grpIndexManager.AddToGroup(key, cacheEntry.getGroupInfo());
                if (this._queryIndexManager != null) {
                    if (oldEntry != null && oldEntry.getObjectType() != null) {
                        this._queryIndexManager.RemoveFromIndex(key, oldEntry.getObjectType());
                    }
                    if (cacheEntry.getQueryInfo() != null) {
                        this._queryIndexManager.AddToIndex(key, cacheEntry);
                    }
                }
            }
            return result;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new CacheException((Throwable)classNotFoundException);
        }
        catch (RedBlackException redBlackException) {
            throw new CacheException((Throwable)redBlackException);
        }
    }

    @Override
    public CacheEntry RemoveInternal(Object key, ItemRemoveReason removalReason, boolean isUserOperation, OperationContext operationContext) throws StateTransferException, CacheException {
        CacheEntry e = super.RemoveInternal(key, removalReason, isUserOperation, operationContext);
        if (e != null) {
            this._grpIndexManager.RemoveFromGroup(key, e.getGroupInfo());
            if (this._queryIndexManager != null && e.getObjectType() != null) {
                try {
                    this._queryIndexManager.RemoveFromIndex(key, e.getObjectType());
                }
                catch (RedBlackException redBlackException) {
                    throw new CacheException((Throwable)redBlackException);
                }
            }
        }
        return e;
    }

    @Override
    public EnumerationDataChunk GetNextChunk(EnumerationPointer pointer, OperationContext operationContext) throws OperationFailedException {
        if (this._enumerationIndex == null) {
            this._enumerationIndex = new EnumerationIndex(this);
        }
        try {
            EnumerationDataChunk nextChunk = this._enumerationIndex.GetNextChunk(pointer);
            return nextChunk;
        }
        catch (Exception exception) {
            throw new OperationFailedException((Throwable)exception);
        }
    }

    @Override
    public boolean HasEnumerationPointer(EnumerationPointer pointer) {
        if (this._enumerationIndex == null) {
            return false;
        }
        return this._enumerationIndex.Contains(pointer);
    }
}

