/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Caching.Topologies.Local;

import Alachisoft.NCache.Caching.CacheEntry;
import Alachisoft.NCache.Caching.CacheRuntimeContext;
import Alachisoft.NCache.Caching.Topologies.Local.LogMode;
import Alachisoft.NCache.Caching.Topologies.Local.OperationLogger;
import Alachisoft.NCache.Caching.Topologies.OperationType;
import Alachisoft.NCache.Common.IDisposable;
import Alachisoft.NCache.Common.Logger.ILogger;
import java.util.ArrayList;
import java.util.HashMap;

public class OpLogManager
implements IDisposable {
    private HashMap _loggers = new HashMap();
    private boolean _logEnteries;
    private boolean _allowOPAfterBuckeTxfrd = true;
    private ILogger _ncacheLog;

    public OpLogManager(boolean logEnteries, CacheRuntimeContext context) {
        this._logEnteries = logEnteries;
        this._ncacheLog = context.getNCacheLog();
    }

    private ILogger getNCacheLog() {
        return this._ncacheLog;
    }

    public final void StartLogging(int bucket, LogMode loggingMode) {
        if (!this._loggers.containsKey(bucket)) {
            this._loggers.put(bucket, new OperationLogger(bucket, loggingMode));
        } else {
            OperationLogger logger = this._loggers.get(bucket) instanceof OperationLogger ? this._loggers.get(bucket) : null;
            logger.setLoggingMode(loggingMode);
            logger.setBucketTransfered(false);
            logger.Clear();
        }
    }

    public final boolean IsLoggingEnbaled(int bucket, LogMode logMode) {
        if (this._loggers.containsKey(bucket)) {
            OperationLogger logger = this._loggers.get(bucket) instanceof OperationLogger ? this._loggers.get(bucket) : null;
            return logger.getLoggingMode() == logMode;
        }
        return false;
    }

    public final void StopLogging(int bucket) {
        if (this._loggers.containsKey(bucket)) {
            OperationLogger logger = this._loggers.get(bucket) instanceof OperationLogger ? this._loggers.get(bucket) : null;
            logger.setBucketTransfered(this._allowOPAfterBuckeTxfrd);
            logger.Clear();
        }
    }

    public final void StopLogging(ArrayList buckets) {
        if (buckets != null) {
            for (Object bucket : buckets) {
                this.StopLogging((Integer)bucket);
            }
        }
    }

    public final void RemoveLogger(int bucket) {
        this._loggers.remove(bucket);
    }

    public final boolean LogOperation(int bucket, Object key, CacheEntry entry, OperationType type) {
        if (this._loggers.containsKey(bucket)) {
            OperationLogger logger = this._loggers.get(bucket) instanceof OperationLogger ? this._loggers.get(bucket) : null;
            if (this._logEnteries) {
                logger.LogOperation(key, entry, type);
            } else {
                logger.LogOperation(key, null, type);
            }
            return true;
        }
        return false;
    }

    public final boolean IsOperationAllowed(int bucket) {
        if (this._loggers.containsKey(bucket)) {
            OperationLogger logger = this._loggers.get(bucket) instanceof OperationLogger ? this._loggers.get(bucket) : null;
            return !logger.getBucketTransfered();
        }
        return true;
    }

    public final HashMap GetLogTable(int bucket) {
        HashMap result = null;
        if (this._loggers.containsKey(bucket)) {
            OperationLogger opLogger = (OperationLogger)this._loggers.get(bucket);
            Object tempVar = opLogger.getLoggedKeys().clone();
            result = (HashMap)(tempVar instanceof HashMap ? tempVar : null);
            opLogger.Clear();
        }
        return result;
    }

    public final HashMap GetLoggedEnteries(int bucket) {
        HashMap result = null;
        if (this._loggers.containsKey(bucket)) {
            OperationLogger opLogger = (OperationLogger)this._loggers.get(bucket);
            Object tempVar = opLogger.getLoggedEnteries().clone();
            result = (HashMap)(tempVar instanceof HashMap ? tempVar : null);
            opLogger.Clear();
        }
        return result;
    }

    public final void dispose() {
        if (this._loggers != null) {
            for (Object logObject : this._loggers.values()) {
                OperationLogger logger = (OperationLogger)logObject;
                logger.Clear();
            }
            this._loggers.clear();
        }
    }
}

