/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Caching.Topologies.Local;

import Alachisoft.NCache.Caching.AutoExpiration.ExpirationHint;
import Alachisoft.NCache.Caching.CacheEntry;
import Alachisoft.NCache.Caching.CacheRuntimeContext;
import Alachisoft.NCache.Caching.CallbackEntry;
import Alachisoft.NCache.Caching.EventContext;
import Alachisoft.NCache.Caching.Exceptions.StateTransferException;
import Alachisoft.NCache.Caching.ItemRemoveReason;
import Alachisoft.NCache.Caching.OpCode;
import Alachisoft.NCache.Caching.OperationContext;
import Alachisoft.NCache.Caching.Queries.ActiveQueryAnalyzer;
import Alachisoft.NCache.Caching.Queries.CQCallbackInfo;
import Alachisoft.NCache.Caching.Queries.QueryChangeType;
import Alachisoft.NCache.Caching.Statistics.CacheStatistics;
import Alachisoft.NCache.Caching.Topologies.CacheAddResult;
import Alachisoft.NCache.Caching.Topologies.CacheBase;
import Alachisoft.NCache.Caching.Topologies.CacheInsResult;
import Alachisoft.NCache.Caching.Topologies.ICacheEventsListener;
import Alachisoft.NCache.Caching.Topologies.Local.LocalCache;
import Alachisoft.NCache.Caching.Topologies.Local.LocalCacheBase;
import Alachisoft.NCache.Common.DataStructures.NewHashmap;
import Alachisoft.NCache.Common.IDisposable;
import Alachisoft.NCache.Common.ResetableIterator;
import Alachisoft.NCache.Config.ConfigHelper;
import com.alachisoft.ncache.runtime.exceptions.CacheException;
import com.alachisoft.ncache.runtime.exceptions.ConfigurationException;
import com.alachisoft.ncache.runtime.exceptions.GeneralFailureException;
import com.alachisoft.ncache.runtime.exceptions.LockingException;
import com.alachisoft.ncache.runtime.exceptions.OperationFailedException;
import java.util.ArrayList;
import java.util.Map;

public class OverflowCache
extends LocalCacheBase {
    protected LocalCacheBase _primary = null;
    protected LocalCacheBase _secondary = null;

    public OverflowCache(Map cacheClasses, CacheBase parentCache, Map properties, ICacheEventsListener listener, CacheRuntimeContext context, ActiveQueryAnalyzer activeQueryAnalyzer) throws ConfigurationException {
        super(properties, parentCache, listener, context, activeQueryAnalyzer);
        this._stats.setClassName("overflow-cache");
        this.Initialize(cacheClasses, properties);
        CacheStatistics pstat = this._primary.getStatistics();
        CacheStatistics sstat = this._secondary.getStatistics();
        if (pstat.getMaxCount() == 0L || sstat.getMaxCount() == 0L) {
            this._stats.setMaxCount(0L);
        } else {
            this._stats.setMaxCount(pstat.getMaxCount() + sstat.getMaxCount());
        }
    }

    @Override
    public void dispose() {
        if (this._primary != null) {
            this._primary.dispose();
            this._primary = null;
        }
        if (this._secondary != null) {
            this._secondary.dispose();
            this._secondary = null;
        }
        super.dispose();
    }

    public final CacheBase getPrimary() {
        return this._primary;
    }

    @Override
    public long getSize() {
        if (this._primary == null || this._secondary == null) {
            throw new UnsupportedOperationException();
        }
        long size = 0L;
        size += this._primary.getSize();
        return size += this._secondary.getSize();
    }

    public final CacheBase getSecondary() {
        return this._secondary;
    }

    @Override
    public long getCount() {
        return 0L;
    }

    @Override
    protected void Initialize(Map cacheClasses, Map properties) throws ConfigurationException {
        if (properties == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: properties");
        }
        try {
            super.Initialize(cacheClasses, properties);
            Map schemeProps = ConfigHelper.GetCacheScheme(cacheClasses, properties, "primary-cache");
            String cacheType = String.valueOf(schemeProps.get("type")).toLowerCase();
            if (cacheType.compareTo("local-cache") == 0) {
                this._primary = this.CreateLocalCache(this, cacheClasses, schemeProps);
                this._primary._allowAsyncEviction = false;
            } else if (cacheType.compareTo("overflow-cache") == 0) {
                this._primary = this.CreateOverflowCache(cacheClasses, schemeProps);
            } else {
                throw new ConfigurationException("invalid or non-local cache class specified in composite cache");
            }
            schemeProps = ConfigHelper.GetCacheScheme(cacheClasses, properties, "secondary-cache");
            cacheType = String.valueOf(schemeProps.get("type")).toLowerCase();
            if (cacheType.compareTo("local-cache") == 0) {
                this._secondary = this.CreateLocalCache(this._parentCache, cacheClasses, schemeProps);
                this._secondary._allowAsyncEviction = true;
            } else if (cacheType.compareTo("overflow-cache") == 0) {
                this._secondary = this.CreateOverflowCache(cacheClasses, schemeProps);
            } else {
                throw new ConfigurationException("invalid or non-local cache class specified in composite cache");
            }
            this._primary.setListener(new PrimaryCacheListener(this));
            this._secondary.setListener(new SecondaryCacheListener(this));
        }
        catch (ConfigurationException e) {
            if (this._context != null) {
                this._context.getNCacheLog().Error("OverflowCache.Initialize()", e.getMessage());
            }
            this.dispose();
            throw e;
        }
        catch (Exception e) {
            if (this._context != null) {
                this._context.getNCacheLog().Error("OverflowCache.Initialize()", e.getMessage());
            }
            this.dispose();
            throw new ConfigurationException("Configuration Error: " + e.toString(), (Throwable)e);
        }
    }

    protected LocalCacheBase CreateLocalCache(CacheBase parentCache, Map cacheClasses, Map schemeProps) throws ConfigurationException {
        return new LocalCache(cacheClasses, parentCache, schemeProps, null, this._context, this._activeQueryAnalyzer);
    }

    protected LocalCacheBase CreateOverflowCache(Map cacheClasses, Map schemeProps) throws ConfigurationException {
        return new OverflowCache(cacheClasses, this, schemeProps, null, this._context, this._activeQueryAnalyzer);
    }

    @Override
    public void ClearInternal() {
        if (this._primary == null || this._secondary == null) {
            throw new UnsupportedOperationException();
        }
        this._secondary.ClearInternal();
        this._primary.ClearInternal();
    }

    @Override
    public boolean ContainsInternal(Object key) throws StateTransferException, CacheException {
        if (this._primary == null || this._secondary == null) {
            throw new UnsupportedOperationException();
        }
        return this._primary.ContainsInternal(key) || this._secondary.ContainsInternal(key);
    }

    @Override
    public CacheEntry GetInternal(Object key, boolean isUserOperation, OperationContext operationContext) {
        return null;
    }

    @Override
    public CacheAddResult AddInternal(Object key, CacheEntry cacheEntry, boolean isUserOperation) throws StateTransferException, CacheException, CacheException {
        if (this._primary == null || this._secondary == null) {
            throw new UnsupportedOperationException();
        }
        if (this._secondary.ContainsInternal(key)) {
            return CacheAddResult.KeyExists;
        }
        return this._primary.AddInternal(key, cacheEntry, false);
    }

    @Override
    public boolean AddInternal(Object key, ExpirationHint eh, OperationContext operationContext) {
        return false;
    }

    @Override
    public CacheInsResult InsertInternal(Object key, CacheEntry cacheEntry, boolean isUserOperation, CacheEntry oldEntry, OperationContext operationContext) {
        return CacheInsResult.Failure;
    }

    @Override
    public Object RemoveSync(Object[] keys, ItemRemoveReason reason, boolean notify, OperationContext operationContext) throws OperationFailedException, LockingException, GeneralFailureException {
        return null;
    }

    @Override
    public CacheEntry RemoveInternal(Object key, ItemRemoveReason removalReason, boolean isUserOperation, OperationContext operationContext) {
        return null;
    }

    @Override
    public ResetableIterator GetEnumerator() throws OperationFailedException, LockingException, GeneralFailureException {
        return null;
    }

    @Override
    public void Evict() {
        if (this._primary == null || this._secondary == null) {
            throw new UnsupportedOperationException();
        }
        this._primary.Evict();
    }

    private static class SecondaryCacheListener
    implements ICacheEventsListener {
        private OverflowCache _parent = null;

        public SecondaryCacheListener(OverflowCache parent) {
            this._parent = parent;
        }

        @Override
        public void OnItemAdded(Object key, OperationContext operationContext, EventContext eventContext) {
        }

        @Override
        public void OnItemUpdated(Object key, OperationContext operationContext, EventContext eventContext) {
        }

        @Override
        public void OnCacheCleared(OperationContext operationContext, EventContext eventContext) {
        }

        @Override
        public void OnItemRemoved(Object key, Object val, ItemRemoveReason reason, OperationContext operationContext, EventContext eventContext) throws OperationFailedException, CacheException, CacheException, LockingException {
            if (reason == ItemRemoveReason.Underused && this._parent.getListener() != null) {
                this._parent.getListener().OnItemRemoved(key, val, reason, operationContext, eventContext);
            }
            ((IDisposable)val).dispose();
        }

        @Override
        public final void OnItemsRemoved(Object[] key, Object[] val, ItemRemoveReason reason, OperationContext operationContext, EventContext[] eventContext) throws OperationFailedException, CacheException, LockingException {
            if (reason != ItemRemoveReason.Underused || this._parent.getListener() == null) {
                return;
            }
            for (int i = 0; i < key.length; ++i) {
                this._parent.getListener().OnItemRemoved(key[i], val[i], reason, operationContext, eventContext[i]);
                ((IDisposable)val[i]).dispose();
            }
        }

        @Override
        public void OnCustomEvent(Object notifId, Object data, OperationContext operationContext, EventContext eventContext) {
        }

        @Override
        public void OnHashmapChanged(NewHashmap newHashmap, boolean updateClientMap) {
        }

        @Override
        public void OnWriteBehindOperationCompletedCallback(OpCode operationCode, Object result, CallbackEntry cbEntry) {
        }

        @Override
        public final void OnCustomUpdateCallback(Object key, Object value, OperationContext operationContext, EventContext eventContext) {
        }

        @Override
        public final void OnCustomRemoveCallback(Object key, Object value, ItemRemoveReason reason, OperationContext operationContext, EventContext eventContext) {
        }

        @Override
        public final void OnActiveQueryChanged(Object key, QueryChangeType changeType, ArrayList<CQCallbackInfo> activeQueries, OperationContext operationContext, EventContext eventContext) {
        }
    }

    private static class PrimaryCacheListener
    implements ICacheEventsListener {
        private OverflowCache _parent = null;

        public PrimaryCacheListener(OverflowCache parent) {
            this._parent = parent;
        }

        @Override
        public void OnItemAdded(Object key, OperationContext operationContext, EventContext eventContext) {
        }

        @Override
        public void OnItemUpdated(Object key, OperationContext operationContext, EventContext eventContext) {
        }

        @Override
        public void OnCacheCleared(OperationContext operationContext, EventContext eventContext) {
        }

        @Override
        public void OnItemRemoved(Object key, Object val, ItemRemoveReason reason, OperationContext operationContext, EventContext eventContext) {
        }

        @Override
        public final void OnItemsRemoved(Object[] key, Object[] val, ItemRemoveReason reason, OperationContext operationContext, EventContext[] eventContext) {
        }

        @Override
        public void OnCustomEvent(Object notifId, Object data, OperationContext operationContext, EventContext eventContext) {
        }

        @Override
        public void OnHashmapChanged(NewHashmap newHashmap, boolean updateClientMap) {
        }

        @Override
        public void OnWriteBehindOperationCompletedCallback(OpCode operationCode, Object result, CallbackEntry cbEntry) {
        }

        @Override
        public final void OnCustomUpdateCallback(Object key, Object value, OperationContext operationContext, EventContext eventContext) {
        }

        @Override
        public final void OnCustomRemoveCallback(Object key, Object value, ItemRemoveReason reason, OperationContext operationContext, EventContext eventContext) {
        }

        @Override
        public final void OnActiveQueryChanged(Object key, QueryChangeType changeType, ArrayList<CQCallbackInfo> activeQueries, OperationContext operationContext, EventContext eventContext) {
        }
    }
}

