/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Caching.Util;

import Alachisoft.NCache.Caching.AsyncOpCode;
import Alachisoft.NCache.Caching.AsyncOpResult;
import Alachisoft.NCache.Caching.Cache;
import Alachisoft.NCache.Caching.CallbackEntry;
import Alachisoft.NCache.Caching.OperationContext;
import Alachisoft.NCache.Caching.OperationContextFieldName;
import Alachisoft.NCache.Common.BitSet;
import Alachisoft.NCache.Common.Logger.ILogger;
import Alachisoft.NCache.Common.Threading.AsyncProcessor;

public class AsyncClear
implements AsyncProcessor.IAsyncTask {
    private Cache _cache = null;
    private CallbackEntry _cbEntry;
    private BitSet _flagMap;
    private OperationContext _operationContext;

    public AsyncClear(Cache cache, CallbackEntry cbEntry, BitSet flagMap, OperationContext operationContext) {
        this._cache = cache;
        this._cbEntry = cbEntry;
        this._flagMap = flagMap;
        this._operationContext = operationContext;
    }

    private ILogger getNCacheLog() {
        return this._cache.getNCacheLog();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void Process() {
        AsyncOpResult asyncOpResult;
        Object var1_1 = null;
        try {
            this._operationContext.Add(OperationContextFieldName.NoGracefulBlock, true);
            this._cache.Clear(this._flagMap, this._cbEntry, this._operationContext);
            asyncOpResult = AsyncOpResult.Success;
            if (this._cbEntry == null || this._cbEntry.getAsyncOperationCompleteCallback() == null) return;
        }
        catch (Exception e) {
            Exception exception;
            try {
                if (this.getNCacheLog() != null) {
                    this.getNCacheLog().Error("AsyncClear.Process()", e.getMessage());
                }
                exception = e;
                if (this._cbEntry == null || this._cbEntry.getAsyncOperationCompleteCallback() == null) return;
            }
            catch (Throwable throwable) {
                if (this._cbEntry == null || this._cbEntry.getAsyncOperationCompleteCallback() == null) throw throwable;
                this._cache.OnAsyncOperationCompleted(AsyncOpCode.Clear, new Object[]{null, this._cbEntry.getAsyncOperationCompleteCallback(), var1_1});
                throw throwable;
            }
            this._cache.OnAsyncOperationCompleted(AsyncOpCode.Clear, new Object[]{null, this._cbEntry.getAsyncOperationCompleteCallback(), exception});
            return;
        }
        this._cache.OnAsyncOperationCompleted(AsyncOpCode.Clear, new Object[]{null, this._cbEntry.getAsyncOperationCompleteCallback(), asyncOpResult});
        return;
    }
}

