/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Caching.Util;

import Alachisoft.NCache.Caching.AutoExpiration.AggregateExpirationHint;
import Alachisoft.NCache.Caching.AutoExpiration.ExpirationHint;
import Alachisoft.NCache.Caching.AutoExpiration.ExpirationHintType;
import Alachisoft.NCache.Caching.AutoExpiration.KeyDependency;
import Alachisoft.NCache.Caching.CacheEntry;
import Alachisoft.NCache.Caching.CallbackEntry;
import Alachisoft.NCache.Caching.CallbackInfo;
import Alachisoft.NCache.Caching.DataGrouping.GroupInfo;
import Alachisoft.NCache.Caching.EventCacheEntry;
import Alachisoft.NCache.Caching.Topologies.CacheBase;
import Alachisoft.NCache.Caching.Topologies.CacheInsResult;
import Alachisoft.NCache.Caching.Topologies.CacheInsResultWithEntry;
import Alachisoft.NCache.Common.ResetableIterator;
import com.alachisoft.ncache.runtime.events.EventDataFilter;
import com.alachisoft.ncache.runtime.exceptions.CacheException;
import com.alachisoft.ncache.runtime.exceptions.GeneralFailureException;
import com.alachisoft.ncache.runtime.exceptions.OperationFailedException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import tangible.RefObject;

public class CacheHelper {
    public static long GetLocalCount(CacheBase cache) throws GeneralFailureException, OperationFailedException, CacheException {
        if (cache != null && cache.getInternalCache() != null) {
            return cache.getInternalCache().getCount();
        }
        return 0L;
    }

    public static long getCacheSize(CacheBase cache) {
        if (cache != null && cache.getInternalCache() != null) {
            return cache.getInternalCache().getSize();
        }
        return 0L;
    }

    public static boolean IsClusteredCache(CacheBase cache) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CacheEntry[] GetCacheEntries(CacheBase cache, long count) {
        int index = 0;
        CacheEntry[] entArr = null;
        CacheEntry ent = null;
        cache.getSync().AcquireReaderLock();
        try {
            if (count == 0L || count > cache.getCount()) {
                count = cache.getCount();
            }
            entArr = new CacheEntry[(int)count];
            ResetableIterator i = cache.GetEnumerator();
            while ((long)index < count && i.hasNext()) {
                Object cacheEntry = ((Map.Entry)i.next()).getValue();
                ent = (CacheEntry)(cacheEntry instanceof CacheEntry ? cacheEntry : null);
                entArr[index++] = ent.RoutableClone(null);
            }
        }
        catch (Exception e) {
            cache.getContext().getNCacheLog().Error("CacheHelper.CreateLocalEntry()", e.getMessage());
            CacheEntry[] cacheEntryArray = null;
            return cacheEntryArray;
        }
        finally {
            cache.getSync().ReleaseReaderLock();
        }
        return entArr;
    }

    public static CacheEntry MergeEntries(CacheEntry c1, CacheEntry c2) {
        if (c1 != null && c1.getValue() instanceof CallbackEntry) {
            CallbackEntry cbEtnry = null;
            Object tempVar = c1.getValue();
            cbEtnry = (CallbackEntry)(tempVar instanceof CallbackEntry ? tempVar : null);
            if (cbEtnry.getItemRemoveCallbackListener() != null) {
                for (CallbackInfo cbInfo : cbEtnry.getItemRemoveCallbackListener()) {
                    c2.AddCallbackInfo(null, cbInfo);
                }
            }
            if (cbEtnry.getItemUpdateCallbackListener() != null) {
                for (CallbackInfo cbInfo : cbEtnry.getItemUpdateCallbackListener()) {
                    c2.AddCallbackInfo(cbInfo, null);
                }
            }
        }
        if (c1 != null && c1.getEvictionHint() != null && c2.getEvictionHint() == null) {
            c2.setEvictionHint(c1.getEvictionHint());
        }
        return c2;
    }

    public static Object[] GetKeyDependencyTable(ExpirationHint hint) {
        ArrayList<String> keyList = null;
        if (hint != null) {
            if (hint._hintType == ExpirationHintType.AggregateExpirationHint) {
                ExpirationHint[] hints = ((AggregateExpirationHint)hint).getHints();
                for (int i = 0; i < hints.length; ++i) {
                    String[] tmp;
                    if (hints[i]._hintType != ExpirationHintType.KeyDependency) continue;
                    if (keyList == null) {
                        keyList = new ArrayList<String>();
                    }
                    if ((tmp = ((KeyDependency)hints[i]).getCacheKeys()) == null || tmp.length <= 0) continue;
                    for (int j = 0; j < tmp.length; ++j) {
                        if (keyList.contains(tmp[j])) continue;
                        keyList.add(tmp[j]);
                    }
                }
                if (keyList != null && keyList.size() > 0) {
                    Object[] cacheKeys = new Object[keyList.size()];
                    System.arraycopy(keyList.toArray(), 0, cacheKeys, 0, keyList.size());
                    return cacheKeys;
                }
            } else if (hint._hintType == ExpirationHintType.KeyDependency) {
                return ((KeyDependency)hint).getCacheKeys();
            }
        }
        return null;
    }

    public static EventCacheEntry CreateCacheEventEntry(List listeners, CacheEntry cacheEntry) {
        EventDataFilter maxFilter = EventDataFilter.None;
        for (Object temp : listeners) {
            CallbackInfo cbInfo = (CallbackInfo)temp;
            if (cbInfo.getDataFilter().getValue() > maxFilter.getValue()) {
                maxFilter = cbInfo.getDataFilter();
            }
            if (maxFilter != EventDataFilter.DataWithMetadata) continue;
            break;
        }
        return CacheHelper.CreateCacheEventEntry(maxFilter, cacheEntry);
    }

    public static EventCacheEntry CreateCacheEventEntry(EventDataFilter filter, CacheEntry cacheEntry) {
        if (filter != EventDataFilter.None && cacheEntry != null) {
            cacheEntry = (CacheEntry)cacheEntry.clone();
            EventCacheEntry entry = new EventCacheEntry(cacheEntry);
            entry.setFlags(cacheEntry.getFlag());
            if (filter == EventDataFilter.DataWithMetadata) {
                if (cacheEntry.getValue() instanceof CallbackEntry) {
                    entry.setValue(((CallbackEntry)cacheEntry.getValue()).getValue());
                } else {
                    entry.setValue(cacheEntry.getValue());
                }
            }
            return entry;
        }
        return null;
    }

    public static boolean CheckLockCompatibility(CacheEntry existingEntry, CacheEntry newEntry) {
        Object lockId = null;
        Date lockDate = new Date(0L);
        RefObject tempRef_lockId = new RefObject(lockId);
        RefObject tempRef_lockDate = new RefObject((Object)lockDate);
        boolean tempVar = existingEntry.IsLocked((RefObject<Object>)tempRef_lockId, (RefObject<Date>)tempRef_lockDate);
        lockId = tempRef_lockId.argvalue;
        lockDate = (Date)tempRef_lockDate.argvalue;
        if (tempVar) {
            return existingEntry.getLockId().equals(newEntry.getLockId());
        }
        return true;
    }

    public static boolean CheckDataGroupsCompatibility(GroupInfo g1, GroupInfo g2) {
        boolean compatible = false;
        if (g1 == null && g2 == null) {
            compatible = true;
        } else if (g1 != null && g2 != null) {
            boolean G1Compatibility;
            boolean bl = g1.getGroup() == null ? g2.getGroup() == null : (G1Compatibility = g1.getGroup().equals(g2.getGroup()));
            boolean SubGCompatibility = g1.getSubGroup() == null ? g2.getSubGroup() == null : g1.getSubGroup().equals(g2.getSubGroup());
            compatible = G1Compatibility && SubGCompatibility;
        } else if (g1 != null) {
            if (g1.getGroup() == null && g1.getSubGroup() == null) {
                compatible = true;
            }
        } else if (g2.getGroup() == null && g2.getSubGroup() == null) {
            compatible = true;
        }
        return compatible;
    }

    public static HashMap GetInsertableItems(HashMap existingItems, HashMap newItems) {
        HashMap insertable = new HashMap();
        if (existingItems != null) {
            for (Map.Entry KeyValue : existingItems.entrySet()) {
                GroupInfo oldInfo;
                Object key = KeyValue.getKey();
                Object value = KeyValue.getValue();
                GroupInfo tempVar = ((CacheEntry)newItems.get(key)).getGroupInfo();
                GroupInfo newInfo = tempVar instanceof GroupInfo ? tempVar : null;
                if (!CacheHelper.CheckDataGroupsCompatibility(newInfo, oldInfo = (GroupInfo)(value instanceof GroupInfo ? value : null))) continue;
                insertable.put(key, newItems.get(key));
            }
        }
        return insertable;
    }

    public static HashMap CompileInsertResult(HashMap insertResults) {
        HashMap failedTable = new HashMap();
        if (insertResults != null) {
            for (Map.Entry KeyValue : insertResults.entrySet()) {
                Object key = KeyValue.getKey();
                if (!(KeyValue.getValue() instanceof CacheInsResultWithEntry)) continue;
                CacheInsResult result = ((CacheInsResultWithEntry)KeyValue.getValue()).getResult();
                switch (result) {
                    case SuccessOverwrite: {
                        failedTable.put(key, KeyValue.getValue());
                        break;
                    }
                    case Failure: {
                        failedTable.put(key, new OperationFailedException("Generic operation failure; not enough information is available."));
                        break;
                    }
                    case NeedsEviction: {
                        failedTable.put(key, new OperationFailedException("The cache is full and not enough items could be evicted."));
                        break;
                    }
                    case IncompatibleGroup: {
                        failedTable.put(key, new OperationFailedException("Data group of the inserted item does not match the existing item's data group"));
                        break;
                    }
                    case DependencyKeyNotExist: {
                        failedTable.put(key, new OperationFailedException("One of the dependency keys does not exist."));
                    }
                }
            }
        }
        return failedTable;
    }
}

