/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Caching.Util;

import Alachisoft.NCache.Common.IDisposable;
import Alachisoft.NCache.Common.Logger.ILogger;
import Alachisoft.NCache.Common.ResourcePool;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleDriver;

public class DbConnectionPool
extends ResourcePool {
    private ILogger _ncacheLog;

    public DbConnectionPool(ILogger NCacheLog) {
        this._ncacheLog = NCacheLog;
    }

    private ILogger getNCacheLog() {
        return this._ncacheLog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Connection PoolConnection(String connString, Connection connection) throws SQLException {
        DbConnectionPool dbConnectionPool = this;
        synchronized (dbConnectionPool) {
            String connKey = connString.toLowerCase();
            DbResourceInfo connInfo = (DbResourceInfo)this.GetResource(connKey);
            if (connInfo == null) {
                DriverManager.registerDriver((Driver)new OracleDriver());
                connection = DriverManager.getConnection(connKey);
                connInfo = new DbResourceInfo(connection, connKey);
                this.AddResource(connKey, connInfo);
            } else {
                this.AddResource(connKey, null);
            }
            return connInfo.getConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void RemoveConnection(String connString) {
        DbConnectionPool dbConnectionPool = this;
        synchronized (dbConnectionPool) {
            this.RemoveResource(connString.toLowerCase());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void RemoveSeveredConnection(String connString) {
        DbConnectionPool dbConnectionPool = this;
        synchronized (dbConnectionPool) {
            try {
                Connection conn = this.GetConnection(connString);
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.RemoveSeveredResource(connString.toLowerCase());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Connection GetConnection(String connString) throws SQLException {
        DbConnectionPool dbConnectionPool = this;
        synchronized (dbConnectionPool) {
            DbResourceInfo connInfo = (DbResourceInfo)this.GetResource(connString.toLowerCase());
            if (connInfo != null) {
                return connInfo.getConnection();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Map GetResourceSyncInfo(String connString) {
        DbConnectionPool dbConnectionPool = this;
        synchronized (dbConnectionPool) {
            DbResourceInfo connInfo = (DbResourceInfo)this.GetResource(connString.toLowerCase());
            if (connInfo != null) {
                return connInfo.getDbSyncInfo();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void AcquireSyncData(String syncTable, String cacheName) throws SQLException {
        DbConnectionPool dbConnectionPool = this;
        synchronized (dbConnectionPool) {
            Iterator em = this.getKeys().iterator();
            while (em.hasNext()) {
                DbResourceInfo connInfo = (DbResourceInfo)this.GetResource((String)em.next());
                HashMap dbSyncInfo = this.LoadTableData(syncTable, cacheName, connInfo.getConnection());
                connInfo.setDbSyncInfo(dbSyncInfo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void RemoveSyncData(String syncTable, String cacheName) throws SQLException {
        DbConnectionPool dbConnectionPool = this;
        synchronized (dbConnectionPool) {
            Iterator em = this.getKeys().iterator();
            while (em.hasNext()) {
                DbResourceInfo connInfo = (DbResourceInfo)this.GetResource((String)em.next());
                this.RemoveTableData(syncTable, cacheName, connInfo.getConnection());
                connInfo.setDbSyncInfo(null);
            }
        }
    }

    private boolean RemoveTableData(String syncTable, String cacheName, Connection connection) {
        Object[] tableInfo = new Object[]{syncTable, cacheName};
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void FlushSyncData() {
        DbConnectionPool dbConnectionPool = this;
        synchronized (dbConnectionPool) {
            Iterator em = this.getKeys().iterator();
            while (em.hasNext()) {
                DbResourceInfo connInfo = (DbResourceInfo)this.GetResource((String)em.next());
                connInfo.setDbSyncInfo(null);
            }
        }
    }

    private HashMap LoadTableData(String syncTable, String cacheName, Connection connection) {
        Object[] tableInfo = new Object[]{syncTable, cacheName};
        HashMap tableData = new HashMap();
        return tableData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ArrayList GetExpiredKeys() {
        ArrayList keys = new ArrayList();
        DbConnectionPool dbConnectionPool = this;
        synchronized (dbConnectionPool) {
            Iterator em = this.getKeys().iterator();
            while (em.hasNext()) {
                DbResourceInfo connInfo = (DbResourceInfo)this.GetResource((String)em.next());
                if (connInfo == null || connInfo.getDbSyncInfo() == null) continue;
                keys.addAll(connInfo.getDbSyncInfo().keySet());
                connInfo.setDbSyncInfo(null);
            }
        }
        return keys;
    }

    public static class DbResourceInfo
    implements IDisposable {
        private Connection _conn;
        private Map _syncData;
        private String _connString;

        public DbResourceInfo(Connection conn, String connString) {
            this._conn = conn;
            this._connString = connString;
        }

        public void dispose() {
            try {
                if (this._conn != null) {
                    this._conn.close();
                    this._conn = null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public final Connection getConnection() throws SQLException {
            if (this._conn != null) {
                return this._conn;
            }
            DriverManager.registerDriver((Driver)new OracleDriver());
            this._conn = DriverManager.getConnection(this._connString);
            return this._conn;
        }

        public final void setConnection(OracleConnection value) {
            this._conn = value;
        }

        public final Map getDbSyncInfo() {
            return this._syncData;
        }

        public final void setDbSyncInfo(Map value) {
            this._syncData = value;
        }
    }
}

