/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Config;

import Alachisoft.NCache.Common.ServicePropValues;
import Alachisoft.NCache.Config.ConfigHelper;
import java.util.HashMap;
import java.util.Map;

public class ChannelConfigBuilder {
    public static String BuildTCPConfiguration(Map properties, long opTimeout) {
        StringBuilder b = new StringBuilder(2048);
        b.append(ChannelConfigBuilder.BuildTCP(properties.get("tcp") instanceof Map ? properties.get("tcp") : null)).append(":");
        b.append(ChannelConfigBuilder.BuildTCPPING(properties.get("tcpping") instanceof Map ? properties.get("tcpping") : null)).append(":");
        b.append(ChannelConfigBuilder.BuildQueue(properties.get("queue") instanceof Map ? properties.get("queue") : null)).append(":");
        b.append(ChannelConfigBuilder.Buildpbcast_GMS(properties.get("pbcast.gms") instanceof Map ? properties.get("pbcast.gms") : null, false)).append(":");
        b.append(ChannelConfigBuilder.BuildTOTAL(properties.get("total") instanceof Map ? properties.get("total") : null, opTimeout)).append(":");
        b.append(ChannelConfigBuilder.BuildVIEW_ENFORCER(properties.get("view-enforcer") instanceof Map ? properties.get("view-enforcer") : null));
        return b.toString();
    }

    public static String BuildTCPConfiguration(Map properties, String userId, String password, long opTimeout, boolean isPor) {
        StringBuilder b = new StringBuilder(2048);
        b.append(ChannelConfigBuilder.BuildTCP(properties.get("tcp") instanceof Map ? properties.get("tcp") : null)).append(":");
        b.append(ChannelConfigBuilder.BuildTCPPING(properties.get("tcpping") instanceof Map ? properties.get("tcpping") : null, userId, password)).append(":");
        b.append(ChannelConfigBuilder.BuildQueue(properties.get("queue") instanceof Map ? properties.get("queue") : null)).append(":");
        b.append(ChannelConfigBuilder.Buildpbcast_GMS(properties.get("pbcast.gms") instanceof Map ? properties.get("pbcast.gms") : null, isPor)).append(":");
        b.append(ChannelConfigBuilder.BuildTOTAL(properties.get("total") instanceof Map ? properties.get("total") : null, opTimeout)).append(":");
        b.append(ChannelConfigBuilder.BuildVIEW_ENFORCER(properties.get("view-enforcer") instanceof Map ? properties.get("view-enforcer") : null));
        return b.toString();
    }

    public static String BuildUDPConfiguration(Map properties) {
        StringBuilder b = new StringBuilder(2048);
        b.append(ChannelConfigBuilder.BuildUDP(properties.get("udp") instanceof Map ? properties.get("udp") : null)).append(":");
        b.append(ChannelConfigBuilder.BuildPING(properties.get("ping") instanceof Map ? properties.get("ping") : null)).append(":");
        b.append(ChannelConfigBuilder.BuildMERGEFAST(properties.get("mergefast") instanceof Map ? properties.get("mergefast") : null)).append(":");
        b.append(ChannelConfigBuilder.BuildFD_SOCK(properties.get("fd-sock") instanceof Map ? properties.get("fd-sock") : null)).append(":");
        b.append(ChannelConfigBuilder.BuildVERIFY_SUSPECT(properties.get("verify-suspect") instanceof Map ? properties.get("verify-suspect") : null)).append(":");
        b.append(ChannelConfigBuilder.BuildFRAG(properties.get("frag") instanceof Map ? properties.get("frag") : null)).append(":");
        b.append(ChannelConfigBuilder.BuildUNICAST(properties.get("unicast") instanceof Map ? properties.get("unicast") : null)).append(":");
        b.append(ChannelConfigBuilder.BuildQueue(properties.get("queue") instanceof Map ? properties.get("queue") : null)).append(":");
        b.append(ChannelConfigBuilder.Buildpbcast_NAKACK(properties.get("pbcast.nakack") instanceof Map ? properties.get("pbcast.nakack") : null)).append(":");
        b.append(ChannelConfigBuilder.Buildpbcast_STABLE(properties.get("pbcast.stable") instanceof Map ? properties.get("pbcast.stable") : null)).append(":");
        b.append(ChannelConfigBuilder.Buildpbcast_GMS(properties.get("pbcast.gms") instanceof Map ? properties.get("pbcast.gms") : null, false)).append(":");
        b.append(ChannelConfigBuilder.BuildTOTAL(properties.get("total") instanceof Map ? properties.get("total") : null, 5000L)).append(":");
        b.append(ChannelConfigBuilder.BuildVIEW_ENFORCER(properties.get("view-enforcer") instanceof Map ? properties.get("view-enforcer") : null));
        return b.toString();
    }

    private static String BuildUDP(Map properties) {
        StringBuilder b = new StringBuilder(256);
        b.append("UDP(").append(ConfigHelper.SafeGetPair(properties, "mcast_addr", "239.0.1.10")).append(ConfigHelper.SafeGetPair(properties, "mcast_port", 10001)).append(ConfigHelper.SafeGetPair(properties, "bind_addr", null)).append(ConfigHelper.SafeGetPair(properties, "bind_port", null)).append(ConfigHelper.SafeGetPair(properties, "port_range", 256)).append(ConfigHelper.SafeGetPair(properties, "ip_mcast", null)).append(ConfigHelper.SafeGetPair(properties, "mcast_send_buf_size", null)).append(ConfigHelper.SafeGetPair(properties, "mcast_recv_buf_size", null)).append(ConfigHelper.SafeGetPair(properties, "ucast_send_buf_size", null)).append(ConfigHelper.SafeGetPair(properties, "ucast_recv_buf_size", null)).append(ConfigHelper.SafeGetPair(properties, "max_bundle_size", null)).append(ConfigHelper.SafeGetPair(properties, "max_bundle_timeout", null)).append(ConfigHelper.SafeGetPair(properties, "enable_bundling", null)).append(ConfigHelper.SafeGetPair(properties, "down_thread", null)).append(ConfigHelper.SafeGetPair(properties, "up_thread", null)).append(ConfigHelper.SafeGetPair(properties, "use_incoming_packet_handler", null)).append(ConfigHelper.SafeGetPair(properties, "use_outgoing_packet_handler", null)).append("ip_ttl=32;").append(")");
        return b.toString();
    }

    private static String BuildPING(Map properties) {
        StringBuilder b = new StringBuilder(256);
        b.append("PING(").append(ConfigHelper.SafeGetPair(properties, "timeout", null)).append(ConfigHelper.SafeGetPair(properties, "num_initial_members", null)).append(ConfigHelper.SafeGetPair(properties, "port_range", null)).append(ConfigHelper.SafeGetPair(properties, "initial_hosts", null)).append(ConfigHelper.SafeGetPair(properties, "down_thread", null)).append(ConfigHelper.SafeGetPair(properties, "up_thread", null)).append(")");
        return b.toString();
    }

    private static String BuildMERGEFAST(Map properties) {
        StringBuilder b = new StringBuilder(16);
        b.append("MERGEFAST(").append(ConfigHelper.SafeGetPair(properties, "down_thread", null)).append(ConfigHelper.SafeGetPair(properties, "up_thread", null)).append(")");
        return b.toString();
    }

    private static String BuildFD_SOCK(Map properties) {
        StringBuilder b = new StringBuilder(64);
        b.append("FD_SOCK(").append(ConfigHelper.SafeGetPair(properties, "get_cache_timeout", null)).append(ConfigHelper.SafeGetPair(properties, "start_port", null)).append(ConfigHelper.SafeGetPair(properties, "num_tries", null)).append(ConfigHelper.SafeGetPair(properties, "suspect_msg_interval", null)).append(ConfigHelper.SafeGetPair(properties, "down_thread", null)).append(ConfigHelper.SafeGetPair(properties, "up_thread", null)).append(")");
        return b.toString();
    }

    private static String BuildVERIFY_SUSPECT(Map properties) {
        StringBuilder b = new StringBuilder(32);
        b.append("VERIFY_SUSPECT(").append(ConfigHelper.SafeGetPair(properties, "timeout", 1500)).append(ConfigHelper.SafeGetPair(properties, "num_msgs", null)).append(ConfigHelper.SafeGetPair(properties, "down_thread", null)).append(ConfigHelper.SafeGetPair(properties, "up_thread", null)).append(")");
        return b.toString();
    }

    private static String BuildQueue(Map properties) {
        StringBuilder b = new StringBuilder(32);
        b.append("QUEUE(").append(ConfigHelper.SafeGetPair(properties, "down_thread", null)).append(ConfigHelper.SafeGetPair(properties, "up_thread", null)).append(")");
        return b.toString();
    }

    private static String Buildpbcast_NAKACK(Map properties) {
        StringBuilder b = new StringBuilder(128);
        b.append("pbcast.NAKACK(").append(ConfigHelper.SafeGetPair(properties, "retransmit_timeout", null)).append(ConfigHelper.SafeGetPair(properties, "gc_lag", 40)).append(ConfigHelper.SafeGetPair(properties, "max_xmit_size", null)).append(ConfigHelper.SafeGetPair(properties, "use_mcast_xmit", null)).append(ConfigHelper.SafeGetPair(properties, "discard_delivered_msgs", null)).append(ConfigHelper.SafeGetPair(properties, "down_thread", null)).append(ConfigHelper.SafeGetPair(properties, "up_thread", null)).append(")");
        return b.toString();
    }

    private static String BuildUNICAST(Map properties) {
        StringBuilder b = new StringBuilder(64);
        b.append("UNICAST(").append(ConfigHelper.SafeGetPair(properties, "timeout", null)).append(ConfigHelper.SafeGetPair(properties, "window_size", null)).append(ConfigHelper.SafeGetPair(properties, "min_threshold", null)).append(ConfigHelper.SafeGetPair(properties, "down_thread", null)).append(ConfigHelper.SafeGetPair(properties, "up_thread", null)).append(")");
        return b.toString();
    }

    private static String Buildpbcast_STABLE(Map properties) {
        StringBuilder b = new StringBuilder(256);
        b.append("pbcast.STABLE(").append(ConfigHelper.SafeGetPair(properties, "digest_timeout", null)).append(ConfigHelper.SafeGetPair(properties, "desired_avg_gossip", null)).append(ConfigHelper.SafeGetPair(properties, "stability_delay", null)).append(ConfigHelper.SafeGetPair(properties, "max_gossip_runs", null)).append(ConfigHelper.SafeGetPair(properties, "max_bytes", null)).append(ConfigHelper.SafeGetPair(properties, "max_suspend_time", null)).append(ConfigHelper.SafeGetPair(properties, "down_thread", null)).append(ConfigHelper.SafeGetPair(properties, "up_thread", null)).append(")");
        return b.toString();
    }

    private static String BuildFRAG(Map properties) {
        StringBuilder b = new StringBuilder(32);
        b.append("FRAG(").append(ConfigHelper.SafeGetPair(properties, "frag_size", null)).append(ConfigHelper.SafeGetPair(properties, "down_thread", null)).append(ConfigHelper.SafeGetPair(properties, "up_thread", null)).append(")");
        return b.toString();
    }

    private static String Buildpbcast_GMS(Map properties, boolean isPor) {
        StringBuilder b = new StringBuilder(256);
        if (isPor) {
            if (properties == null) {
                properties = new HashMap<String, String>();
            }
            properties.put("is_part_replica", "true");
        }
        b.append("pbcast.GMS(").append(ConfigHelper.SafeGetPair(properties, "shun", null)).append(ConfigHelper.SafeGetPair(properties, "join_timeout", null)).append(ConfigHelper.SafeGetPair(properties, "join_retry_timeout", null)).append(ConfigHelper.SafeGetPair(properties, "join_retry_count", null)).append(ConfigHelper.SafeGetPair(properties, "leave_timeout", null)).append(ConfigHelper.SafeGetPair(properties, "merge_timeout", null)).append(ConfigHelper.SafeGetPair(properties, "digest_timeout", null)).append(ConfigHelper.SafeGetPair(properties, "disable_initial_coord", null)).append(ConfigHelper.SafeGetPair(properties, "num_prev_mbrs", null)).append(ConfigHelper.SafeGetPair(properties, "print_local_addr", null)).append(ConfigHelper.SafeGetPair(properties, "down_thread", null)).append(ConfigHelper.SafeGetPair(properties, "up_thread", null)).append(ConfigHelper.SafeGetPair(properties, "is_part_replica", null)).append(")");
        return b.toString();
    }

    private static String BuildTOTAL(Map properties, long opTimeout) {
        StringBuilder b = new StringBuilder(8);
        b.append("TOTAL(").append(ConfigHelper.SafeGetPair(properties, "timeout", null)).append(ConfigHelper.SafeGetPair(properties, "down_thread", null)).append(ConfigHelper.SafeGetPair(properties, "up_thread", null)).append(ConfigHelper.SafeGetPair(properties, "op_timeout", opTimeout)).append(")");
        return b.toString();
    }

    private static String BuildVIEW_ENFORCER(Map properties) {
        StringBuilder b = new StringBuilder(16);
        b.append("VIEW_ENFORCER(").append(ConfigHelper.SafeGetPair(properties, "down_thread", null)).append(ConfigHelper.SafeGetPair(properties, "up_thread", null)).append(")");
        return b.toString();
    }

    private static String BuildTCPPING(Map properties) {
        StringBuilder b = new StringBuilder(256);
        b.append("TCPPING(").append(")").append(ConfigHelper.SafeGetPair(properties, "timeout", null)).append(ConfigHelper.SafeGetPair(properties, "port_range", null)).append(ConfigHelper.SafeGetPair(properties, "static", null)).append(ConfigHelper.SafeGetPair(properties, "num_initial_members", null)).append(ConfigHelper.SafeGetPair(properties, "initial_hosts", null)).append(ConfigHelper.SafeGetPair(properties, "discovery_addr", "228.8.8.8")).append(ConfigHelper.SafeGetPair(properties, "discovery_port", 7700)).append(ConfigHelper.SafeGetPair(properties, "down_thread", null)).append(ConfigHelper.SafeGetPair(properties, "up_thread", null)).append(")");
        return b.toString();
    }

    private static String BuildTCPPING(Map properties, String userId, String password) {
        StringBuilder b = new StringBuilder(256);
        b.append("TCPPING(").append(ConfigHelper.SafeGetPair(properties, "timeout", null)).append(ConfigHelper.SafeGetPair(properties, "port_range", null)).append(ConfigHelper.SafeGetPair(properties, "static", null)).append(ConfigHelper.SafeGetPair(properties, "num_initial_members", null)).append(ConfigHelper.SafeGetPair(properties, "initial_hosts", null)).append(ConfigHelper.SafeGetPair(properties, "discovery_addr", "228.8.8.8")).append(ConfigHelper.SafeGetPair(properties, "discovery_port", 7700)).append(ConfigHelper.SafeGetPair(properties, "down_thread", null)).append(ConfigHelper.SafeGetPair(properties, "up_thread", null)).append(ConfigHelper.SafeGetPair(properties, "user-id", userId)).append(ConfigHelper.SafeGetPair(properties, "password", password)).append(")");
        return b.toString();
    }

    private static String BuildTCP(Map properties) {
        String bindIP = ServicePropValues.CacheServer_BindToIP;
        StringBuilder b = new StringBuilder(256);
        b.append("TCP(").append(ConfigHelper.SafeGetPair(properties, "connection_retries", 0)).append(ConfigHelper.SafeGetPair(properties, "connection_retry_interval", 0)).append(ConfigHelper.SafeGetPair(properties, "bind_addr", bindIP)).append(ConfigHelper.SafeGetPair(properties, "start_port", null)).append(ConfigHelper.SafeGetPair(properties, "port_range", null)).append(ConfigHelper.SafeGetPair(properties, "send_buf_size", null)).append(ConfigHelper.SafeGetPair(properties, "recv_buf_size", null)).append(ConfigHelper.SafeGetPair(properties, "reaper_interval", null)).append(ConfigHelper.SafeGetPair(properties, "conn_expire_time", null)).append(ConfigHelper.SafeGetPair(properties, "skip_suspected_members", null)).append(ConfigHelper.SafeGetPair(properties, "down_thread", true)).append(ConfigHelper.SafeGetPair(properties, "up_thread", true)).append(ConfigHelper.SafeGetPair(properties, "use_heart_beat", true)).append(ConfigHelper.SafeGetPair(properties, "heart_beat_interval", null)).append(")");
        return b.toString();
    }
}

