/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Config;

import Alachisoft.NCache.Caching.Util.CacheInfo;
import Alachisoft.NCache.Config.ChannelConfigBuilder;
import Alachisoft.NCache.Config.OnClusterConfigUpdate;
import Alachisoft.NCache.Config.PropsConfigReader;
import com.alachisoft.ncache.runtime.exceptions.ConfigurationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ConfigHelper {
    public static OnClusterConfigUpdate OnConfigUpdated;

    public static CacheInfo GetCacheInfo(String propstring) throws ConfigurationException {
        PropsConfigReader pr = new PropsConfigReader(propstring);
        CacheInfo inf = ConfigHelper.GetCacheInfo(pr.getProperties());
        inf.setConfigString(propstring);
        return inf;
    }

    private static CacheInfo GetCacheInfo(Map properties) throws ConfigurationException {
        if (!properties.containsKey("cache")) {
            throw new ConfigurationException("Missing configuration attribute 'cache'");
        }
        CacheInfo inf = new CacheInfo();
        Map cacheConfig = (Map)properties.get("cache");
        String schemeName = "";
        if (cacheConfig.containsKey("name")) {
            inf.setName(String.valueOf(cacheConfig.get("name")).trim());
        }
        if (!cacheConfig.containsKey("class")) {
            throw new ConfigurationException("Missing configuration attribute 'class'");
        }
        schemeName = String.valueOf(cacheConfig.get("class"));
        if (inf.getName().length() < 1) {
            inf.setName(schemeName);
        }
        if (!cacheConfig.containsKey("cache-classes")) {
            throw new ConfigurationException("Missing configuration section 'cache-classes'");
        }
        Map cacheClasses = (Map)cacheConfig.get("cache-classes");
        if (!cacheClasses.containsKey(schemeName.toLowerCase())) {
            throw new ConfigurationException("Cannot find cache class '" + schemeName + "'");
        }
        Map schemeProps = (Map)cacheClasses.get(schemeName.toLowerCase());
        if (!schemeProps.containsKey("type")) {
            throw new ConfigurationException("Cannot find the type of cache, invalid configuration for cache class '" + schemeName + "'");
        }
        inf.setClassName(String.valueOf(schemeProps.get("type")));
        return inf;
    }

    public static String CreatePropertiesXml(Map properties, int indent, boolean format) {
        String endStr;
        Iterator it = properties.entrySet().iterator();
        StringBuilder returnStr = new StringBuilder(8096);
        StringBuilder nestedStr = new StringBuilder(8096);
        String preStr = format ? ConfigHelper.padRight("", indent * 2) : "";
        String string = endStr = format ? "\n" : "";
        while (it.hasNext()) {
            Map.Entry pair = it.next();
            String keyName = pair.getKey() instanceof String ? pair.getKey() : null;
            Object attributes = "";
            if (pair.getValue() instanceof HashMap) {
                HashMap subproperties = (HashMap)pair.getValue();
                if (keyName.equals("cluster") && OnConfigUpdated != null) {
                    OnConfigUpdated.invoke(subproperties.get("group-id").toString(), pair);
                }
                if (subproperties.containsKey("type") && subproperties.containsKey("id")) {
                    keyName = (String)subproperties.get("type");
                    attributes = subproperties.containsKey("partitionId") ? " id='" + subproperties.get("id") + "' partitionId='" + subproperties.get("partitionId") + "'" : " id='" + subproperties.get("id") + "'";
                    subproperties = (HashMap)subproperties.clone();
                    subproperties.remove("id");
                    subproperties.remove("type");
                }
                nestedStr.append(preStr).append("<" + keyName + (String)attributes + ">").append(endStr);
                nestedStr.append(ConfigHelper.CreatePropertiesXml(subproperties, indent + 1, format)).append(preStr).append("</" + keyName + ">").append(endStr);
                continue;
            }
            returnStr.append(preStr).append("<" + keyName + ">").append(pair.getValue()).append("</" + keyName + ">").append(endStr);
        }
        returnStr.append(nestedStr.toString());
        return returnStr.toString();
    }

    public static String CreatePropertiesXml2(Map properties, int indent, boolean format) {
        String endStr;
        Iterator it = properties.entrySet().iterator();
        StringBuilder returnStr = new StringBuilder(8096);
        StringBuilder nestedStr = new StringBuilder(8096);
        String preStr = format ? ConfigHelper.padRight("", indent * 2) : "";
        String string = endStr = format ? "\n" : "";
        while (it.hasNext()) {
            Map.Entry pair = it.next();
            String keyName = pair.getKey() instanceof String ? pair.getKey() : null;
            String attributes = "";
            String cacheName = "";
            if (!(pair.getValue() instanceof HashMap)) continue;
            HashMap subproperties = (HashMap)pair.getValue();
            if (subproperties.containsKey("type") && subproperties.containsKey("name")) {
                cacheName = subproperties.get("name") instanceof String ? subproperties.get("name") : null;
                keyName = (String)subproperties.get("type");
                subproperties = (HashMap)subproperties.clone();
                subproperties.remove("type");
            }
            nestedStr.append(preStr).append("<" + keyName + ConfigHelper.BuildAttributes(subproperties));
            if (subproperties.isEmpty()) {
                nestedStr.append("/>").append(endStr);
                continue;
            }
            if (subproperties.size() == 1) {
                for (Map.Entry pair1 : subproperties.entrySet()) {
                    if (((String)pair1.getKey()).toLowerCase().compareTo(cacheName) != 0 || !(pair1.getValue() instanceof Map)) continue;
                    subproperties = pair1.getValue() instanceof HashMap ? pair.getValue() : null;
                }
            }
            nestedStr.append(">").append(endStr);
            nestedStr.append(ConfigHelper.CreatePropertiesXml2(subproperties, indent + 1, format)).append(preStr).append("</" + keyName + ">").append(endStr);
        }
        returnStr.append(nestedStr.toString());
        return returnStr.toString();
    }

    private static String BuildAttributes(HashMap subProps) {
        StringBuilder attributes = new StringBuilder();
        String preString = " ";
        Object tempVar = subProps.clone();
        HashMap tmp = (HashMap)(tempVar instanceof HashMap ? tempVar : null);
        for (Map.Entry pair : tmp.entrySet()) {
            String key = pair.getKey() instanceof String ? pair.getKey() : null;
            if (pair.getValue() instanceof HashMap) continue;
            attributes.append(preString).append(key).append("=").append("\"").append(pair.getValue()).append("\"");
            subProps.remove(key);
        }
        return attributes.toString();
    }

    public static String CreatePropertiesXml(Map properties) {
        return ConfigHelper.CreatePropertiesXml(properties, 0, false);
    }

    public static String CreatePropertiesXml(Map properties, String configid) {
        StringBuilder returnStr = new StringBuilder("<cache-configuration id='");
        returnStr.append(configid).append("'>");
        returnStr.append(ConfigHelper.CreatePropertiesXml(properties, 0, false)).append("</cache-configuration>");
        return returnStr.toString();
    }

    public static String CreatePropertyString(Map properties) {
        return ConfigHelper.CreatePropertyString(properties, 0, false);
    }

    public static String CreatePropertyString(Map properties, int indent, boolean format) {
        String endStr;
        Iterator it = properties.entrySet().iterator();
        StringBuilder returnStr = new StringBuilder(8096);
        StringBuilder nestedStr = new StringBuilder(8096);
        String preStr = format ? ConfigHelper.padRight("", indent * 2) : "";
        String string = endStr = format ? "\n" : "";
        while (it.hasNext()) {
            Map.Entry pair = it.next();
            if (pair.getValue() instanceof HashMap) {
                HashMap subproperties = (HashMap)pair.getValue();
                if (pair.getKey().equals("cluster") && OnConfigUpdated != null) {
                    OnConfigUpdated.invoke(subproperties.get("group-id").toString(), pair);
                }
                if (subproperties.containsKey("type") && subproperties.containsKey("id")) {
                    nestedStr.append(preStr).append(subproperties.get("id"));
                    nestedStr.append("=").append(subproperties.get("type")).append(endStr);
                    subproperties = (HashMap)subproperties.clone();
                    subproperties.remove("id");
                    subproperties.remove("type");
                } else {
                    nestedStr.append(preStr).append(pair.getKey().toString()).append(endStr);
                }
                nestedStr.append(preStr).append("(").append(endStr).append(ConfigHelper.CreatePropertyString(subproperties, indent + 1, format)).append(preStr).append(")").append(endStr);
                continue;
            }
            returnStr.append(preStr).append(pair.getKey().toString());
            if (pair.getValue() instanceof String) {
                returnStr.append("='").append(pair.getValue()).append("';").append(endStr);
                continue;
            }
            returnStr.append("=").append(pair.getValue()).append(";").append(endStr);
        }
        returnStr.append(nestedStr.toString());
        return returnStr.toString();
    }

    public static String CreatePropertyString2(Map properties, int indent, boolean format) {
        String endStr;
        Iterator it = properties.entrySet().iterator();
        StringBuilder returnStr = new StringBuilder(8096);
        StringBuilder nestedStr = new StringBuilder(8096);
        String preStr = format ? ConfigHelper.padRight("", indent * 2) : "";
        String string = endStr = format ? "\n" : "";
        while (it.hasNext()) {
            Map.Entry pair = it.next();
            if (pair.getValue() instanceof HashMap) {
                HashMap subproperties = (HashMap)pair.getValue();
                if (subproperties.containsKey("type") && subproperties.containsKey("id")) {
                    nestedStr.append(preStr).append(subproperties.get("id"));
                    nestedStr.append("=").append(subproperties.get("type")).append(endStr);
                    subproperties = (HashMap)subproperties.clone();
                    subproperties.remove("id");
                    subproperties.remove("type");
                } else {
                    nestedStr.append(preStr).append(pair.getKey().toString()).append(endStr);
                }
                nestedStr.append(preStr).append("(").append(endStr).append(ConfigHelper.CreatePropertyString(subproperties, indent + 1, format)).append(preStr).append(")").append(endStr);
                continue;
            }
            returnStr.append(preStr).append(pair.getKey().toString());
            if (pair.getValue() instanceof String) {
                returnStr.append("='").append(pair.getValue()).append("';").append(endStr);
                continue;
            }
            returnStr.append("=").append(pair.getValue()).append(";").append(endStr);
        }
        returnStr.append(nestedStr.toString());
        return returnStr.toString();
    }

    public static Map GetCacheScheme(Map cacheClasses, Map properties, String cacheName) throws ConfigurationException {
        Map cacheProps = null;
        if (properties.containsKey(cacheName + "-ref")) {
            String cacheScheme = String.valueOf(properties.get(cacheName + "-ref")).toLowerCase();
            if (!cacheClasses.containsKey(cacheScheme)) {
                throw new ConfigurationException("Cannot find cache class '" + cacheScheme + "'");
            }
            cacheProps = (Map)cacheClasses.get(cacheScheme);
        } else if (properties.containsKey(cacheName)) {
            cacheProps = (Map)properties.get(cacheName);
        }
        if (cacheProps == null || !cacheProps.containsKey("type")) {
            throw new ConfigurationException("Cannot find the type of cache, invalid configuration for cache class");
        }
        return cacheProps;
    }

    public static String SafeGet(Map h, String key) {
        return ConfigHelper.SafeGet(h, key, null);
    }

    public static String SafeGet(Map h, String key, Object def) {
        Object res = null;
        if (h != null) {
            res = h.get(key);
        }
        if (res == null) {
            res = def;
        }
        if (res == null) {
            return "";
        }
        return res.toString();
    }

    public static String SafeGetPair(Map h, String key, Object def) {
        String res = ConfigHelper.SafeGet(h, key, def);
        if (res.equals("")) {
            return res;
        }
        StringBuilder b = new StringBuilder(64);
        b.append(key).append("=").append(res.toString()).append(";");
        return b.toString();
    }

    public static String GetClusterPropertyString(Map properties, long opTimeout) throws ConfigurationException {
        boolean udpCluster = true;
        String cacheScheme = ConfigHelper.SafeGet(properties, "class").toLowerCase();
        if (cacheScheme.equals("tcp")) {
            udpCluster = false;
        }
        if (!properties.containsKey("channel")) {
            throw new ConfigurationException("Cannot find channel properties");
        }
        Map channelprops = properties.get("channel") instanceof Map ? properties.get("channel") : null;
        if (udpCluster) {
            return ChannelConfigBuilder.BuildUDPConfiguration(channelprops);
        }
        return ChannelConfigBuilder.BuildTCPConfiguration(channelprops, opTimeout);
    }

    public static String GetClusterPropertyString(Map properties, String userId, String password, long opTimeout, boolean isPor) throws ConfigurationException {
        boolean udpCluster = true;
        String cacheScheme = ConfigHelper.SafeGet(properties, "class").toLowerCase();
        if (cacheScheme.equals("tcp")) {
            udpCluster = false;
        }
        if (!properties.containsKey("channel")) {
            throw new ConfigurationException("Cannot find channel properties");
        }
        Map channelprops = properties.get("channel") instanceof Map ? properties.get("channel") : null;
        if (udpCluster) {
            return ChannelConfigBuilder.BuildUDPConfiguration(channelprops);
        }
        return ChannelConfigBuilder.BuildTCPConfiguration(channelprops, userId, password, opTimeout, isPor);
    }

    public static String padRight(String s, int n) {
        return String.format("%1$-" + n + "s", s);
    }
}

