/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Config.Dom;

import Alachisoft.NCache.Common.Common;
import Alachisoft.NCache.Common.Configuration.ConfigurationAttributeAnnotation;
import Alachisoft.NCache.Common.Configuration.ConfigurationRootAnnotation;
import Alachisoft.NCache.Common.Configuration.ConfigurationSectionAnnotation;
import Alachisoft.NCache.Common.Enum.CacheStatus;
import Alachisoft.NCache.Common.Enum.ClientNodeStatus;
import Alachisoft.NCache.Common.Enum.DataFormat;
import Alachisoft.NCache.Common.Enum.RtContextValue;
import Alachisoft.NCache.Common.StatusInfo;
import Alachisoft.NCache.Config.Dom.Cluster;
import Alachisoft.NCache.Config.NewDom.AlertsNotifications;
import Alachisoft.NCache.Config.NewDom.AutoLoadBalancing;
import Alachisoft.NCache.Config.NewDom.BackingSource;
import Alachisoft.NCache.Config.NewDom.BridgeConfig;
import Alachisoft.NCache.Config.NewDom.BridgeConflictResolver;
import Alachisoft.NCache.Config.NewDom.CacheLoader;
import Alachisoft.NCache.Config.NewDom.Cleanup;
import Alachisoft.NCache.Config.NewDom.ClientActivityNotification;
import Alachisoft.NCache.Config.NewDom.ClientCacheSettings;
import Alachisoft.NCache.Config.NewDom.ClientDeathDetection;
import Alachisoft.NCache.Config.NewDom.ClientNode;
import Alachisoft.NCache.Config.NewDom.ClientNodes;
import Alachisoft.NCache.Config.NewDom.CompactSerialization;
import Alachisoft.NCache.Config.NewDom.Compression;
import Alachisoft.NCache.Config.NewDom.DataSharing;
import Alachisoft.NCache.Config.NewDom.Encryption;
import Alachisoft.NCache.Config.NewDom.EvictionPolicy;
import Alachisoft.NCache.Config.NewDom.ExpirationPolicy;
import Alachisoft.NCache.Config.NewDom.Log;
import Alachisoft.NCache.Config.NewDom.Notifications;
import Alachisoft.NCache.Config.NewDom.PerfCounters;
import Alachisoft.NCache.Config.NewDom.QueryIndex;
import Alachisoft.NCache.Config.NewDom.ReplicationStrategy;
import Alachisoft.NCache.Config.NewDom.SQLDependencyConfig;
import Alachisoft.NCache.Config.NewDom.Security;
import Alachisoft.NCache.Config.NewDom.Storage;
import Alachisoft.NCache.Config.NewDom.SynchronizationStrategy;
import Alachisoft.NCache.Config.NewDom.TaskConfiguration;
import com.alachisoft.ncache.licensing.LicenseManager;
import com.alachisoft.ncache.serialization.core.io.InternalCompactSerializable;
import com.alachisoft.ncache.serialization.standard.io.CompactReader;
import com.alachisoft.ncache.serialization.standard.io.CompactWriter;
import java.io.IOException;
import tangible.DotNetToJavaStringHelper;

@ConfigurationAttributeAnnotation(value="cache-config", appendText="")
@ConfigurationRootAnnotation(value="cache-config")
public class CacheServerConfig
implements Cloneable,
InternalCompactSerializable {
    private boolean cacheIsRunning = false;
    private boolean cacheIsRegistered = false;
    private boolean licenseIsExpired = false;
    private boolean autoStartCacheOnServiceStartup = false;
    private String name;
    private boolean inproc;
    private String configID;
    private String lastModified;
    private String cacheType;
    private Log log = new Log();
    private PerfCounters perfCounters;
    private BridgeConflictResolver conflictResolver;
    private Compression compression = new Compression();
    private QueryIndex indexes;
    private DataSharing dataSharing;
    private CompactSerialization compactSerialization;
    private BackingSource backingSource;
    private CacheLoader cacheloader;
    private Notifications notifications = new Notifications();
    private BridgeConfig bridge;
    private Cleanup cleanup;
    private Storage storage;
    private EvictionPolicy evictionPolicy;
    private Cluster cluster;
    private ReplicationStrategy _replicationStrategy;
    private Security security;
    private AutoLoadBalancing autoBalancing;
    private ClientNodes clientNodes;
    private AlertsNotifications _alertsNotifications;
    private ClientCacheSettings clientCacheSettings;
    private SQLDependencyConfig _sqlDependencyConfig;
    private Encryption _encryption;
    private RtContextValue _runtimeContextValue = RtContextValue.JVCACHE;
    private ExpirationPolicy expirationPolicy;
    private TaskConfiguration taskConfiguration;
    private ClientDeathDetection deathDetection;
    private SynchronizationStrategy synchronizationStrategy = new SynchronizationStrategy();
    private DataFormat dataFormat = DataFormat.Binary;
    private ClientActivityNotification clientActivityNotification = new ClientActivityNotification();
    private double configVersion;

    public final RtContextValue getRuntimeContext() {
        return this._runtimeContextValue;
    }

    public final void setRuntimeContext(RtContextValue contextValue) {
        this._runtimeContextValue = contextValue;
    }

    public final boolean getIsRegistered() {
        return this.cacheIsRegistered;
    }

    public final void setIsRegistered(boolean value) {
        this.cacheIsRegistered = value;
    }

    public final boolean getIsClientCacheEnabled() {
        if (!this.getCacheType().equals("clustered-cache")) {
            return false;
        }
        if (this.clientNodes != null && !DotNetToJavaStringHelper.isNullOrEmpty((String)this.clientNodes.getClientCacheId()) && this.clientNodes.getNodesList() != null) {
            for (ClientNode node : this.clientNodes.getNodesList()) {
                if (node.getStatus() != ClientNodeStatus.ClientCacheEnabled) continue;
                return true;
            }
        }
        return false;
    }

    public final boolean getIsRunning() {
        boolean isRunning = this.cacheIsRunning;
        if (this.getCacheType().equals("clustered-cache")) {
            for (StatusInfo cacheStatus : this.cluster.getNodes().values()) {
                if (cacheStatus.Status != CacheStatus.Running) continue;
                isRunning = true;
                break;
            }
        }
        return isRunning;
    }

    public final void setIsRunning(boolean value) {
        if (this.getCacheType().equals("local-cache") || this.getCacheType().equals("client-cache")) {
            this.cacheIsRunning = value;
        }
    }

    public final boolean getIsExpired() {
        return this.licenseIsExpired;
    }

    public final void setIsExpired(boolean value) {
        this.licenseIsExpired = value;
    }

    @ConfigurationAttributeAnnotation(value="name", appendText="")
    public final String getName() {
        return this.name;
    }

    @ConfigurationAttributeAnnotation(value="name", appendText="")
    public final void setName(String value) {
        this.name = value;
    }

    @ConfigurationAttributeAnnotation(value="inproc", appendText="")
    public final boolean getInProc() {
        return this.inproc;
    }

    @ConfigurationAttributeAnnotation(value="inproc", appendText="")
    public final void setInProc(boolean value) {
        this.inproc = value;
    }

    @ConfigurationAttributeAnnotation(value="config-version", appendText="")
    public final double getConfigVersion() {
        return this.configVersion;
    }

    @ConfigurationAttributeAnnotation(value="config-version", appendText="")
    public final void setConfigVersion(double value) {
        this.configVersion = value;
    }

    @ConfigurationAttributeAnnotation(value="config-id", appendText="")
    public final String getConfigID() {
        return this.configID;
    }

    @ConfigurationAttributeAnnotation(value="config-id", appendText="")
    public final void setConfigID(String value) {
        this.configID = value;
    }

    @ConfigurationAttributeAnnotation(value="last-modified", appendText="")
    public final String getLastModified() {
        return this.lastModified;
    }

    @ConfigurationAttributeAnnotation(value="last-modified", appendText="")
    public final void setLastModified(String value) {
        this.lastModified = value;
    }

    @ConfigurationAttributeAnnotation(value="type", appendText="")
    public final String getCacheType() {
        String type = this.cacheType;
        if (type == null) {
            type = "local-cache";
            if (this.cluster != null) {
                type = "clustered-cache";
            }
        }
        return type;
    }

    @ConfigurationAttributeAnnotation(value="type", appendText="")
    public final void setCacheType(String value) {
        this.cacheType = value;
    }

    @ConfigurationSectionAnnotation(value="client-cache-settings")
    public final ClientCacheSettings getClientCacheSettings() {
        return this.clientCacheSettings;
    }

    @ConfigurationSectionAnnotation(value="client-cache-settings")
    public final void setClientCacheSettings(ClientCacheSettings value) {
        this.clientCacheSettings = value;
    }

    @ConfigurationAttributeAnnotation(value="auto-start", appendText="")
    public final boolean getAutoStartCacheOnServiceStartup() {
        return this.autoStartCacheOnServiceStartup;
    }

    @ConfigurationAttributeAnnotation(value="auto-start", appendText="")
    public final void setAutoStartCacheOnServiceStartup(boolean value) {
        this.autoStartCacheOnServiceStartup = value;
    }

    @ConfigurationSectionAnnotation(value="log")
    public final Log getLog() {
        return this.log;
    }

    @ConfigurationSectionAnnotation(value="log")
    public final void setLog(Log value) {
        this.log = value;
    }

    @ConfigurationSectionAnnotation(value="perf-counters")
    public final PerfCounters getPerfCounters() {
        return this.perfCounters;
    }

    @ConfigurationSectionAnnotation(value="perf-counters")
    public final void setPerfCounters(PerfCounters value) {
        this.perfCounters = value;
    }

    @ConfigurationSectionAnnotation(value="conflict-resolver")
    public final BridgeConflictResolver getConflictResolver() {
        return this.conflictResolver;
    }

    @ConfigurationSectionAnnotation(value="conflict-resolver")
    public final void setConflictResolver(BridgeConflictResolver value) {
        this.conflictResolver = value;
    }

    @ConfigurationSectionAnnotation(value="replication-strategy")
    public final ReplicationStrategy getReplicationStrategy() {
        return this._replicationStrategy;
    }

    @ConfigurationSectionAnnotation(value="replication-strategy")
    public final void setReplicationStrategy(ReplicationStrategy value) {
        this._replicationStrategy = value;
    }

    @ConfigurationSectionAnnotation(value="data-load-balancing")
    public final AutoLoadBalancing getAutoLoadBalancing() {
        return this.autoBalancing;
    }

    @ConfigurationSectionAnnotation(value="data-load-balancing")
    public final void setAutoLoadBalancing(AutoLoadBalancing value) {
        this.autoBalancing = value;
    }

    @ConfigurationSectionAnnotation(value="client-nodes")
    public final ClientNodes getClientNodes() {
        return this.clientNodes;
    }

    @ConfigurationSectionAnnotation(value="client-nodes")
    public final void setClientNodes(ClientNodes value) {
        this.clientNodes = value;
    }

    @ConfigurationSectionAnnotation(value="compression")
    public final Compression getCompression() {
        return this.compression;
    }

    @ConfigurationSectionAnnotation(value="compression")
    public final void setCompression(Compression value) {
        this.compression = value;
    }

    @ConfigurationSectionAnnotation(value="indexes")
    public final QueryIndex getQueryIndices() {
        return this.indexes;
    }

    @ConfigurationSectionAnnotation(value="indexes")
    public final void setQueryIndices(QueryIndex value) {
        this.indexes = value;
    }

    @ConfigurationSectionAnnotation(value="backing-source")
    public final BackingSource getBackingSource() {
        return this.backingSource;
    }

    @ConfigurationSectionAnnotation(value="backing-source")
    public final void setBackingSource(BackingSource value) {
        this.backingSource = value;
    }

    @ConfigurationSectionAnnotation(value="cache-loader")
    public final CacheLoader getCacheLoader() {
        return this.cacheloader;
    }

    @ConfigurationSectionAnnotation(value="cache-loader")
    public final void setCacheLoader(CacheLoader value) {
        this.cacheloader = value;
    }

    @ConfigurationSectionAnnotation(value="data-sharing")
    public final DataSharing getDataSharing() {
        return this.dataSharing;
    }

    @ConfigurationSectionAnnotation(value="data-sharing")
    public final void setDataSharing(DataSharing value) {
        this.dataSharing = value;
    }

    @ConfigurationSectionAnnotation(value="compact-serialization")
    public final CompactSerialization getCompactSerialization() {
        return this.compactSerialization;
    }

    @ConfigurationSectionAnnotation(value="compact-serialization")
    public final void setCompactSerialization(CompactSerialization value) {
        this.compactSerialization = value;
    }

    @ConfigurationSectionAnnotation(value="notifications")
    public final Notifications getNotifications() {
        return this.notifications;
    }

    @ConfigurationSectionAnnotation(value="notifications")
    public final void setNotifications(Notifications value) {
        this.notifications = value;
    }

    @ConfigurationSectionAnnotation(value="bridge")
    public final BridgeConfig getBridge() {
        return this.bridge;
    }

    @ConfigurationSectionAnnotation(value="bridge")
    public final void setBridge(BridgeConfig value) {
        this.bridge = value;
    }

    @ConfigurationSectionAnnotation(value="cleanup")
    public final Cleanup getCleanup() {
        return this.cleanup;
    }

    @ConfigurationSectionAnnotation(value="cleanup")
    public final void setCleanup(Cleanup value) {
        this.cleanup = value;
    }

    @ConfigurationSectionAnnotation(value="storage")
    public final Storage getStorage() {
        return this.storage;
    }

    @ConfigurationSectionAnnotation(value="storage")
    public final void setStorage(Storage value) {
        this.storage = value;
    }

    @ConfigurationSectionAnnotation(value="eviction-policy")
    public final EvictionPolicy getEvictionPolicy() {
        return this.evictionPolicy;
    }

    @ConfigurationSectionAnnotation(value="eviction-policy")
    public final void setEvictionPolicy(EvictionPolicy value) {
        this.evictionPolicy = value;
    }

    @ConfigurationSectionAnnotation(value="synchronization")
    public final SynchronizationStrategy getSynchronizationStrategy() {
        return this.synchronizationStrategy;
    }

    @ConfigurationSectionAnnotation(value="synchronization")
    public final void setSynchronizationStrategy(SynchronizationStrategy value) {
        this.synchronizationStrategy = value;
    }

    @ConfigurationSectionAnnotation(value="expiration-policy")
    public final ExpirationPolicy getExpirationPolicy() {
        return this.expirationPolicy;
    }

    @ConfigurationSectionAnnotation(value="expiration-policy")
    public final void setExpirationPolicy(ExpirationPolicy value) {
        this.expirationPolicy = value;
    }

    @ConfigurationSectionAnnotation(value="cluster")
    public final Cluster getCluster() {
        return this.cluster;
    }

    @ConfigurationSectionAnnotation(value="cluster")
    public final void setCluster(Cluster value) {
        this.cluster = value;
    }

    @ConfigurationSectionAnnotation(value="security")
    public final Security getSecurity() {
        return this.security;
    }

    @ConfigurationSectionAnnotation(value="security")
    public final void setSecurity(Security value) {
        this.security = value;
    }

    @ConfigurationSectionAnnotation(value="alerts")
    public final AlertsNotifications getAlertsNotifications() {
        return this._alertsNotifications;
    }

    @ConfigurationSectionAnnotation(value="alerts")
    public final void setAlertsNotifications(AlertsNotifications value) {
        this._alertsNotifications = value;
    }

    @ConfigurationSectionAnnotation(value="sql-dependency")
    public final SQLDependencyConfig getSQLDependencyConfig() {
        return null;
    }

    @ConfigurationSectionAnnotation(value="sql-dependency")
    public final void setSQLDependencyConfig(SQLDependencyConfig value) {
        this._sqlDependencyConfig = value;
    }

    @ConfigurationSectionAnnotation(value="encryption")
    public final Encryption getEncryption() {
        return this._encryption;
    }

    @ConfigurationSectionAnnotation(value="encryption")
    public final void setEncryption(Encryption value) {
        this._encryption = value;
    }

    @ConfigurationSectionAnnotation(value="tasks-config")
    public final TaskConfiguration getTaskConfiguration() {
        return this.taskConfiguration;
    }

    @ConfigurationSectionAnnotation(value="tasks-config")
    public final void setTasksConfiguration(TaskConfiguration value) {
        this.taskConfiguration = value;
    }

    @ConfigurationAttributeAnnotation(value="data-format", appendText="")
    public final String getDataFormat() {
        return this.dataFormat.toString();
    }

    @ConfigurationAttributeAnnotation(value="data-format", appendText="")
    public final void setDataFormat(String value) {
        this.dataFormat = value.equalsIgnoreCase("object") ? DataFormat.Object : DataFormat.Binary;
    }

    @ConfigurationSectionAnnotation(value="client-activity-notification")
    public final ClientActivityNotification getClientActivityNotification() {
        return this.clientActivityNotification;
    }

    @ConfigurationSectionAnnotation(value="client-activity-annotation")
    public final void setClientActivityNotification(ClientActivityNotification value) {
        this.clientActivityNotification = value;
    }

    public final Object clone() throws CloneNotSupportedException {
        CacheServerConfig config = new CacheServerConfig();
        config.setName(this.getName() != null ? new String(this.getName()) : null);
        config.cacheType = this.cacheType;
        config.setAutoStartCacheOnServiceStartup(this.getAutoStartCacheOnServiceStartup());
        config.setInProc(this.getInProc());
        config.setConfigID(this.getConfigID());
        config.setLastModified(this.getLastModified() != null ? new String(this.getLastModified()) : null);
        Object tempVar = this.clientNodes.clone();
        config.clientNodes = this.clientNodes != null ? (ClientNodes)(tempVar instanceof ClientNodes ? tempVar : null) : null;
        config.setLog(this.getLog() != null ? (Log)this.getLog().clone() : null);
        config.setPerfCounters(this.getPerfCounters() != null ? (PerfCounters)this.getPerfCounters().clone() : null);
        config.setConflictResolver(this.getConflictResolver() != null ? (BridgeConflictResolver)this.getConflictResolver().clone() : null);
        config.setReplicationStrategy(this.getReplicationStrategy() != null ? (ReplicationStrategy)this.getReplicationStrategy().clone() : null);
        config.autoBalancing = this.autoBalancing != null ? (AutoLoadBalancing)this.autoBalancing.clone() : null;
        config.setBridge(this.getBridge() != null ? (BridgeConfig)this.getBridge().clone() : null);
        config.setCleanup(this.getCleanup() != null ? (Cleanup)this.getCleanup().clone() : null);
        config.setStorage(this.getStorage() != null ? (Storage)this.getStorage().clone() : null);
        config.setEvictionPolicy(this.getEvictionPolicy() != null ? (EvictionPolicy)this.getEvictionPolicy().clone() : null);
        config.setCluster(this.getCluster() != null ? (Cluster)this.getCluster().clone() : null);
        config.backingSource = this.backingSource != null ? (BackingSource)this.backingSource.clone() : null;
        config.cacheloader = this.cacheloader != null ? (CacheLoader)this.cacheloader.clone() : null;
        config.setSecurity(this.getSecurity() != null ? (Security)this.getSecurity().clone() : null);
        config.setAlertsNotifications(this.getAlertsNotifications() != null ? (AlertsNotifications)this.getAlertsNotifications().clone() : null);
        config.setCompression(this.getCompression() != null ? (Compression)this.getCompression().clone() : null);
        config.setQueryIndices(this.getQueryIndices() != null ? (QueryIndex)this.getQueryIndices().clone() : null);
        config.setDataSharing(this.getDataSharing() != null ? (DataSharing)this.getDataSharing().clone() : null);
        config.setCompactSerialization(this.getCompactSerialization() != null ? (CompactSerialization)this.getCompactSerialization().clone() : null);
        config.setNotifications(this.getNotifications() != null ? (Notifications)this.getNotifications().clone() : null);
        config.setSQLDependencyConfig(this.getSQLDependencyConfig() != null ? (SQLDependencyConfig)this.getSQLDependencyConfig().clone() : null);
        config.setIsRegistered(this.getIsRegistered());
        config.setIsRunning(this.getIsRunning());
        config.licenseIsExpired = this.licenseIsExpired;
        config._runtimeContextValue = this._runtimeContextValue;
        config.configVersion = this.configVersion;
        return config;
    }

    public void Deserialize(CompactReader reader) throws IOException, ClassNotFoundException {
        this.cacheIsRunning = reader.ReadBoolean();
        this.cacheIsRegistered = reader.ReadBoolean();
        this.licenseIsExpired = reader.ReadBoolean();
        this.autoStartCacheOnServiceStartup = reader.ReadBoolean();
        this.name = (String)Common.as((Object)reader.ReadObject(), String.class);
        this.inproc = reader.ReadBoolean();
        this.configID = reader.ReadString();
        this.configVersion = reader.ReadDouble();
        this.lastModified = (String)Common.as((Object)reader.ReadObject(), String.class);
        this.cacheType = (String)Common.as((Object)reader.ReadObject(), String.class);
        this.log = (Log)Common.as((Object)reader.ReadObject(), Log.class);
        this.perfCounters = (PerfCounters)Common.as((Object)reader.ReadObject(), PerfCounters.class);
        if (LicenseManager.isEnterprise()) {
            this.conflictResolver = (BridgeConflictResolver)Common.as((Object)reader.ReadObject(), BridgeConflictResolver.class);
        }
        this.compression = (Compression)Common.as((Object)reader.ReadObject(), Compression.class);
        this.indexes = (QueryIndex)Common.as((Object)reader.ReadObject(), QueryIndex.class);
        this.dataSharing = (DataSharing)Common.as((Object)reader.ReadObject(), DataSharing.class);
        this.compactSerialization = (CompactSerialization)Common.as((Object)reader.ReadObject(), CompactSerialization.class);
        this.backingSource = (BackingSource)Common.as((Object)reader.ReadObject(), BackingSource.class);
        this.cacheloader = (CacheLoader)Common.as((Object)reader.ReadObject(), CacheLoader.class);
        this.notifications = (Notifications)Common.as((Object)reader.ReadObject(), Notifications.class);
        this.bridge = (BridgeConfig)Common.as((Object)reader.ReadObject(), BridgeConfig.class);
        this.cleanup = (Cleanup)Common.as((Object)reader.ReadObject(), Cleanup.class);
        this.storage = (Storage)Common.as((Object)reader.ReadObject(), Storage.class);
        this.evictionPolicy = (EvictionPolicy)Common.as((Object)reader.ReadObject(), EvictionPolicy.class);
        this.expirationPolicy = (ExpirationPolicy)Common.as((Object)reader.ReadObject(), ExpirationPolicy.class);
        this.cluster = (Cluster)Common.as((Object)reader.ReadObject(), Cluster.class);
        this._replicationStrategy = (ReplicationStrategy)Common.as((Object)reader.ReadObject(), ReplicationStrategy.class);
        this.security = (Security)Common.as((Object)reader.ReadObject(), Security.class);
        this.autoBalancing = (AutoLoadBalancing)Common.as((Object)reader.ReadObject(), AutoLoadBalancing.class);
        this.clientNodes = (ClientNodes)Common.as((Object)reader.ReadObject(), ClientNodes.class);
        this._alertsNotifications = (AlertsNotifications)Common.as((Object)reader.ReadObject(), AlertsNotifications.class);
        if (LicenseManager.isEnterprise()) {
            this._sqlDependencyConfig = (SQLDependencyConfig)Common.as((Object)reader.ReadObject(), SQLDependencyConfig.class);
            this._encryption = (Encryption)Common.as((Object)reader.ReadObject(), Encryption.class);
        }
        this.taskConfiguration = (TaskConfiguration)Common.as((Object)reader.ReadObject(), TaskConfiguration.class);
        this.deathDetection = (ClientDeathDetection)Common.as((Object)reader.ReadObject(), ClientDeathDetection.class);
        this._runtimeContextValue = "1".equals(Common.as((Object)reader.ReadObject(), String.class)) ? RtContextValue.JVCACHE : RtContextValue.NCACHE;
        String temp = (String)Common.as((Object)reader.ReadObject(), String.class);
        this.clientCacheSettings = (ClientCacheSettings)Common.as((Object)reader.ReadObject(), ClientCacheSettings.class);
        this.synchronizationStrategy = (SynchronizationStrategy)Common.as((Object)reader.ReadObject(), SynchronizationStrategy.class);
        this.dataFormat = (DataFormat)Common.as((Object)reader.ReadObject(), DataFormat.class);
        this.clientActivityNotification = (ClientActivityNotification)Common.as((Object)reader.ReadObject(), ClientActivityNotification.class);
    }

    public void Serialize(CompactWriter writer) throws IOException {
        writer.Write(this.cacheIsRunning);
        writer.Write(this.cacheIsRegistered);
        writer.Write(this.licenseIsExpired);
        writer.Write(this.autoStartCacheOnServiceStartup);
        writer.WriteObject((Object)this.name);
        writer.Write(this.inproc);
        writer.Write(this.configID);
        writer.Write(this.configVersion);
        writer.WriteObject((Object)this.lastModified);
        writer.WriteObject((Object)this.cacheType);
        writer.WriteObject((Object)this.log);
        writer.WriteObject((Object)this.perfCounters);
        if (LicenseManager.isEnterprise()) {
            writer.WriteObject((Object)this.conflictResolver);
        }
        writer.WriteObject((Object)this.compression);
        writer.WriteObject((Object)this.indexes);
        writer.WriteObject((Object)this.dataSharing);
        writer.WriteObject((Object)this.compactSerialization);
        writer.WriteObject((Object)this.backingSource);
        writer.WriteObject((Object)this.cacheloader);
        writer.WriteObject((Object)this.notifications);
        writer.WriteObject((Object)this.bridge);
        writer.WriteObject((Object)this.cleanup);
        writer.WriteObject((Object)this.storage);
        writer.WriteObject((Object)this.evictionPolicy);
        writer.WriteObject((Object)this.expirationPolicy);
        writer.WriteObject((Object)this.cluster);
        writer.WriteObject((Object)this._replicationStrategy);
        writer.WriteObject((Object)this.security);
        writer.WriteObject((Object)this.autoBalancing);
        writer.WriteObject((Object)this.clientNodes);
        writer.WriteObject((Object)this._alertsNotifications);
        if (LicenseManager.isEnterprise()) {
            writer.WriteObject((Object)this._sqlDependencyConfig);
            writer.WriteObject((Object)this._encryption);
        }
        writer.WriteObject((Object)this.taskConfiguration);
        writer.WriteObject((Object)this.deathDetection);
        writer.WriteObject((Object)(this._runtimeContextValue == RtContextValue.JVCACHE ? "1" : "0"));
        writer.WriteObject((Object)this.synchronizationStrategy);
        writer.WriteObject((Object)this.clientCacheSettings);
        writer.WriteObject((Object)this.dataFormat);
        writer.WriteObject((Object)this.clientActivityNotification);
    }
}

