/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Config.Dom;

import Alachisoft.NCache.Common.Common;
import Alachisoft.NCache.Common.Configuration.ConfigurationAttributeAnnotation;
import Alachisoft.NCache.Common.Configuration.ConfigurationSectionAnnotation;
import Alachisoft.NCache.Common.Net.Address;
import Alachisoft.NCache.Common.StatusInfo;
import Alachisoft.NCache.Config.Dom.Channel;
import Alachisoft.NCache.Config.NewDom.NodeIdentity;
import com.alachisoft.ncache.serialization.core.io.InternalCompactSerializable;
import com.alachisoft.ncache.serialization.standard.io.CompactReader;
import com.alachisoft.ncache.serialization.standard.io.CompactWriter;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class Cluster
implements Cloneable,
InternalCompactSerializable {
    private String topology;
    private String activeMirrorNode = null;
    private int opTimeout = 60;
    private int statsRepInterval;
    private boolean useHeartBeat;
    private Channel channel = new Channel();
    private HashMap<NodeIdentity, StatusInfo> nodes = new HashMap();

    @ConfigurationAttributeAnnotation(value="topology", appendText="")
    public final String getCacheType() {
        return this.topology;
    }

    @ConfigurationAttributeAnnotation(value="topology", appendText="")
    public final void setCacheType(String value) {
        this.topology = value;
    }

    public final String getTopology() {
        String value = this.topology;
        if (value != null) {
            if ((value = value.toLowerCase()).equals("replicated")) {
                return "replicated-server";
            }
            if (value.equals("partitioned")) {
                return "partitioned-server";
            }
            if (value.equals("partition-replica")) {
                return "partitioned-replicas-server";
            }
            if (value.equals("mirror")) {
                return "mirror-server";
            }
        }
        return value;
    }

    public final void setTopology(String value) {
        this.topology = value;
    }

    @ConfigurationAttributeAnnotation(value="op-timeout", appendText="sec")
    public final int getOpTimeout() {
        return this.opTimeout;
    }

    @ConfigurationAttributeAnnotation(value="op-timeout", appendText="sec")
    public final void setOpTimeout(int value) {
        this.opTimeout = value;
    }

    @ConfigurationAttributeAnnotation(value="stats-repl-interval", appendText="sec")
    public final int getStatsRepInterval() {
        return this.statsRepInterval;
    }

    @ConfigurationAttributeAnnotation(value="stats-repl-interval", appendText="sec")
    public final void setStatsRepInterval(int value) {
        this.statsRepInterval = value;
    }

    @ConfigurationAttributeAnnotation(value="use-heart-beat", appendText="")
    public final boolean getUseHeartbeat() {
        return this.useHeartBeat;
    }

    @ConfigurationAttributeAnnotation(value="use-heart-beat", appendText="")
    public final void setUseHeartbeat(boolean value) {
        this.useHeartBeat = value;
    }

    @ConfigurationSectionAnnotation(value="channel")
    public final Channel getChannel() {
        return this.channel;
    }

    @ConfigurationSectionAnnotation(value="channel")
    public final void setChannel(Channel value) {
        this.channel = value;
    }

    public final HashMap<NodeIdentity, StatusInfo> getNodes() {
        return this.nodes;
    }

    public final void setNodes(HashMap<NodeIdentity, StatusInfo> value) {
        this.nodes = value;
    }

    public final ArrayList<NodeIdentity> getNodeIdentities() {
        NodeIdentity[] nodeIdentities = new NodeIdentity[this.nodes.size()];
        this.nodes.keySet().toArray(nodeIdentities);
        return new ArrayList<NodeIdentity>(Arrays.asList(nodeIdentities));
    }

    @ConfigurationAttributeAnnotation(value="active-mirror-node", appendText="")
    public final String getActiveMirrorNode() {
        return this.activeMirrorNode;
    }

    @ConfigurationAttributeAnnotation(value="active-mirror-node", appendText="")
    public final void setActiveMirrorNode(String value) {
        this.activeMirrorNode = value;
    }

    public final int getNewNodePriority() {
        int priority = 0;
        if (this.getNodes() == null) {
            return 1;
        }
        for (NodeIdentity node : this.getNodeIdentities()) {
            if (node.getNodePriority() <= priority) continue;
            priority = node.getNodePriority();
        }
        return priority + 1;
    }

    public final void ReAssignPriority(NodeIdentity leavingNode) {
        for (NodeIdentity node : this.getNodeIdentities()) {
            if (!leavingNode.getNodeName().equals(node.getNodeName())) continue;
            leavingNode.setNodePriority(node.getNodePriority());
        }
        for (NodeIdentity oldNode : this.getNodeIdentities()) {
            if (oldNode.getNodePriority() <= leavingNode.getNodePriority()) continue;
            oldNode.setNodePriority(oldNode.getNodePriority() - 1);
        }
    }

    public final ArrayList<Address> GetAllConfiguredNodes() throws UnknownHostException {
        ArrayList<Address> nodes = new ArrayList<Address>();
        if (this.getChannel() != null) {
            String[] splitted = this.getChannel().getInitialHosts().split("[,]", -1);
            String nameOrIP = null;
            for (String hostString : splitted) {
                int firstBrace = hostString.indexOf("[");
                int lastBrace = hostString.indexOf("]");
                if (firstBrace <= 0 || lastBrace <= firstBrace) continue;
                nameOrIP = hostString.substring(0, firstBrace);
                int port = Integer.parseInt(hostString.substring(firstBrace + 1, firstBrace + 1 + lastBrace - firstBrace - 1));
                nodes.add(new Address(nameOrIP, port));
            }
        }
        return nodes;
    }

    public final Object clone() throws CloneNotSupportedException {
        Cluster cluster = new Cluster();
        cluster.topology = this.topology != null ? new String(this.topology) : null;
        cluster.setOpTimeout(this.getOpTimeout());
        cluster.setStatsRepInterval(this.getStatsRepInterval());
        cluster.setUseHeartbeat(this.getUseHeartbeat());
        cluster.activeMirrorNode = this.activeMirrorNode;
        if (this.nodes != null) {
            cluster.nodes = new HashMap();
            for (Map.Entry<NodeIdentity, StatusInfo> pair : this.nodes.entrySet()) {
                cluster.nodes.put(pair.getKey(), pair.getValue());
            }
        }
        cluster.setChannel(this.getChannel() != null ? (Channel)this.getChannel().clone() : null);
        return cluster;
    }

    public void Deserialize(CompactReader reader) throws IOException, ClassNotFoundException {
        this.topology = (String)Common.readAs((Object)reader.ReadObject(), String.class);
        this.activeMirrorNode = (String)Common.readAs((Object)reader.ReadObject(), String.class);
        this.opTimeout = reader.ReadInt32();
        this.statsRepInterval = reader.ReadInt32();
        this.useHeartBeat = reader.ReadBoolean();
        this.channel = (Channel)Common.readAs((Object)reader.ReadObject(), Channel.class);
        boolean nodeExists = reader.ReadBoolean();
        if (nodeExists) {
            this.nodes = new HashMap();
            int count = reader.ReadInt32();
            for (int i = 0; i < count; ++i) {
                this.nodes.put((NodeIdentity)Common.readAs((Object)reader.ReadObject(), NodeIdentity.class), (StatusInfo)Common.readAs((Object)reader.ReadObject(), StatusInfo.class));
            }
        }
    }

    public void Serialize(CompactWriter writer) throws IOException {
        writer.WriteObject((Object)this.topology);
        writer.WriteObject((Object)this.activeMirrorNode);
        writer.Write(this.opTimeout);
        writer.Write(this.statsRepInterval);
        writer.Write(this.useHeartBeat);
        writer.WriteObject((Object)this.channel);
        if (this.nodes != null) {
            writer.Write(true);
            writer.Write(this.nodes.size());
            for (Map.Entry<NodeIdentity, StatusInfo> current : this.nodes.entrySet()) {
                writer.WriteObject((Object)current.getKey());
                writer.WriteObject((Object)current.getValue());
            }
        } else {
            writer.Write(false);
        }
    }
}

