/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Config.NewDom;

import Alachisoft.NCache.Common.Common;
import Alachisoft.NCache.Common.Configuration.ConfigurationAttributeAnnotation;
import com.alachisoft.ncache.serialization.core.io.InternalCompactSerializable;
import com.alachisoft.ncache.serialization.standard.io.CompactReader;
import com.alachisoft.ncache.serialization.standard.io.CompactWriter;
import java.io.IOException;

public class Channel
implements Cloneable,
InternalCompactSerializable {
    private int tcpPort;
    private int numInitHosts;
    private int connectionRetries = 2;
    private int connectionRetryInterval = 2;
    private int portRange = 1;
    private String initialHosts;
    private int joinRetryInterval = 5;
    private int joinRetries = 24;

    public Channel() {
    }

    public Channel(int defaultPortRange) {
        this.portRange = defaultPortRange;
    }

    @ConfigurationAttributeAnnotation(value="cluster-port", appendText="")
    public final int getTcpPort() {
        return this.tcpPort;
    }

    @ConfigurationAttributeAnnotation(value="cluster-port", appendText="")
    public final void setTcpPort(int value) {
        this.tcpPort = value;
    }

    @ConfigurationAttributeAnnotation(value="port-range", appendText="")
    public final int getPortRange() {
        return this.portRange;
    }

    @ConfigurationAttributeAnnotation(value="port-range", appendText="")
    public final void setPortRange(int value) {
        this.portRange = value;
    }

    @ConfigurationAttributeAnnotation(value="connection-retries", appendText="")
    public final int getConnectionRetries() {
        return this.connectionRetries;
    }

    @ConfigurationAttributeAnnotation(value="connection-retries", appendText="")
    public final void setConnectionRetries(int value) {
        this.connectionRetries = value;
    }

    @ConfigurationAttributeAnnotation(value="connection-retry-interval", appendText="secs")
    public final int getConnectionRetryInterval() {
        return this.connectionRetryInterval;
    }

    @ConfigurationAttributeAnnotation(value="connection-retry-interval", appendText="secs")
    public final void setConnectionRetryInterval(int value) {
        this.connectionRetryInterval = value;
    }

    public final String getInitialHosts() {
        return this.initialHosts;
    }

    public final void setInitialHosts(String value) {
        this.initialHosts = value;
    }

    public final int getNumInitHosts() {
        return this.numInitHosts;
    }

    public final void setNumInitHosts(int value) {
        this.numInitHosts = value;
    }

    @ConfigurationAttributeAnnotation(value="join_retry_count", appendText="")
    public final int getJoinRetries() {
        return this.joinRetries;
    }

    @ConfigurationAttributeAnnotation(value="join_retry_count", appendText="")
    public final void setJoinRetries(int value) {
        this.joinRetries = value;
    }

    @ConfigurationAttributeAnnotation(value="join_retry_timeout", appendText="")
    public final int getJoinRetryInterval() {
        return this.joinRetryInterval;
    }

    @ConfigurationAttributeAnnotation(value="join_retry_timeout", appendText="")
    public final void setJoinRetryInterval(int value) {
        this.joinRetryInterval = value;
    }

    public final Object clone() throws CloneNotSupportedException {
        Channel channel = new Channel();
        channel.setTcpPort(this.getTcpPort());
        channel.setPortRange(this.getPortRange());
        channel.setConnectionRetries(this.getConnectionRetries());
        channel.setConnectionRetryInterval(this.getConnectionRetryInterval());
        channel.setInitialHosts(this.getInitialHosts() != null ? new String(this.getInitialHosts()) : null);
        channel.setNumInitHosts(this.getNumInitHosts());
        return channel;
    }

    public void Deserialize(CompactReader reader) throws IOException, ClassNotFoundException {
        this.tcpPort = reader.ReadInt32();
        this.numInitHosts = reader.ReadInt32();
        this.connectionRetries = reader.ReadInt32();
        this.connectionRetryInterval = reader.ReadInt32();
        this.portRange = reader.ReadInt32();
        this.initialHosts = (String)Common.readAs((Object)reader.ReadObject(), String.class);
        this.joinRetryInterval = reader.ReadInt32();
        this.joinRetries = reader.ReadInt32();
    }

    public void Serialize(CompactWriter writer) throws IOException {
        writer.Write(this.tcpPort);
        writer.Write(this.numInitHosts);
        writer.Write(this.connectionRetries);
        writer.Write(this.connectionRetryInterval);
        writer.Write(this.portRange);
        writer.WriteObject((Object)this.initialHosts);
        writer.Write(this.joinRetryInterval);
        writer.Write(this.joinRetries);
    }
}

