/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Config.NewDom;

import Alachisoft.NCache.Common.Common;
import Alachisoft.NCache.Common.Configuration.ConfigurationAttributeAnnotation;
import Alachisoft.NCache.Common.Enum.ClientNodeStatus;
import Alachisoft.NCache.Common.Enum.RtContextValue;
import com.alachisoft.ncache.serialization.core.io.InternalCompactSerializable;
import com.alachisoft.ncache.serialization.standard.io.CompactReader;
import com.alachisoft.ncache.serialization.standard.io.CompactWriter;
import java.io.IOException;

public class ClientNode
implements Cloneable,
InternalCompactSerializable {
    private String name;
    private ClientNodeStatus status = ClientNodeStatus.values()[0];
    private RtContextValue clientRuntimeContext = RtContextValue.JVCACHE;

    @ConfigurationAttributeAnnotation(value="client-cache-status", appendText="")
    public final String getStatusString() {
        String statusString = "";
        switch (this.status) {
            case ClientCacheDisabled: {
                statusString = "disabled";
                break;
            }
            case ClientCacheEnabled: {
                statusString = "enabled";
                break;
            }
            case ClientCacheUnavailable: {
                statusString = "unavailable";
            }
        }
        return statusString;
    }

    @ConfigurationAttributeAnnotation(value="client-cache-status", appendText="")
    public final void setStatusString(String value) {
        if (value.equals("disabled")) {
            this.status = ClientNodeStatus.ClientCacheDisabled;
        } else if (value.equals("enabled")) {
            this.status = ClientNodeStatus.ClientCacheEnabled;
        } else if (value.equals("unavailable")) {
            this.status = ClientNodeStatus.ClientCacheUnavailable;
        }
    }

    public final ClientNodeStatus getStatus() {
        return this.status;
    }

    public final void setStatus(ClientNodeStatus value) {
        this.status = value;
    }

    @ConfigurationAttributeAnnotation(value="ip", appendText="")
    public final String getName() {
        return this.name;
    }

    @ConfigurationAttributeAnnotation(value="ip", appendText="")
    public final void setName(String value) {
        this.name = value;
    }

    public final RtContextValue getClientRuntimeContext() {
        return this.clientRuntimeContext;
    }

    public final void setClientRuntimeContext(RtContextValue clientRtContext) {
        this.clientRuntimeContext = clientRtContext;
    }

    public final String getClientRuntimeContextString() {
        if (this.clientRuntimeContext == RtContextValue.JVCACHE) {
            return "JVCACHE";
        }
        return "NCACHE";
    }

    public final void setClientRuntimeContextString(String value) {
        if (value.equals("JVCACHE")) {
            this.clientRuntimeContext = RtContextValue.JVCACHE;
        } else if (value.equals("NCACHE")) {
            this.clientRuntimeContext = RtContextValue.NCACHE;
        }
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ClientNode) {
            ClientNode clientNode = (ClientNode)(obj instanceof ClientNode ? obj : null);
            return clientNode.name.toLowerCase().compareTo(this.name.toLowerCase()) == 0;
        }
        return false;
    }

    public final Object clone() {
        ClientNode node = new ClientNode();
        node.name = this.name;
        node.status = this.status;
        node.clientRuntimeContext = this.clientRuntimeContext;
        return node;
    }

    public void Deserialize(CompactReader reader) throws IOException, ClassNotFoundException {
        this.name = (String)Common.readAs((Object)reader.ReadObject(), String.class);
        this.status = ClientNodeStatus.forValue((int)reader.ReadInt32());
        this.clientRuntimeContext = "1".equals(Common.as((Object)reader.ReadObject(), String.class)) ? RtContextValue.JVCACHE : RtContextValue.NCACHE;
    }

    public void Serialize(CompactWriter writer) throws IOException {
        writer.WriteObject((Object)this.name);
        writer.Write(this.status.getValue());
        writer.WriteObject((Object)(this.clientRuntimeContext == RtContextValue.JVCACHE ? "1" : "0"));
    }
}

