/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Config.NewDom;

import Alachisoft.NCache.Config.NewDom.CacheDeployment;
import Alachisoft.NCache.Config.NewDom.CacheServerConfig;
import Alachisoft.NCache.Config.NewDom.CacheServerConfigSetting;
import Alachisoft.NCache.Config.NewDom.CacheTopology;
import Alachisoft.NCache.Config.NewDom.Channel;
import Alachisoft.NCache.Config.NewDom.Cleanup;
import Alachisoft.NCache.Config.NewDom.ClientNodes;
import Alachisoft.NCache.Config.NewDom.Cluster;
import Alachisoft.NCache.Config.NewDom.Compression;
import Alachisoft.NCache.Config.NewDom.EvictionPolicy;
import Alachisoft.NCache.Config.NewDom.Log;
import Alachisoft.NCache.Config.NewDom.Notifications;
import Alachisoft.NCache.Config.NewDom.PerfCounters;
import Alachisoft.NCache.Config.NewDom.ReplicationStrategy;
import Alachisoft.NCache.Config.NewDom.ServerNode;
import Alachisoft.NCache.Config.NewDom.ServersNodes;
import Alachisoft.NCache.Config.NewDom.Storage;
import com.alachisoft.ncache.common.Tokenizer;
import java.util.ArrayList;

public class DomHelper {
    public static Alachisoft.NCache.Config.Dom.CacheServerConfig convertToOldDom(CacheServerConfig newDom) throws Exception {
        Alachisoft.NCache.Config.Dom.CacheServerConfig oldDom = null;
        try {
            if (newDom != null) {
                oldDom = new Alachisoft.NCache.Config.Dom.CacheServerConfig();
                if (newDom.getCacheSettings() != null) {
                    oldDom.setAutoStartCacheOnServiceStartup(newDom.getCacheSettings().getAutoStartCacheOnServiceStartup());
                    oldDom.setName(newDom.getName());
                    oldDom.setInProc(newDom.getCacheSettings().getInProc());
                    oldDom.setConfigID(newDom.getConfigID());
                    oldDom.setLastModified(newDom.getCacheSettings().getLastModified());
                    if (newDom.getCacheSettings().getLog() != null) {
                        oldDom.setLog(newDom.getCacheSettings().getLog());
                    } else {
                        oldDom.setLog(new Log());
                    }
                    if (newDom.getCacheSettings().getPerfCounters() != null) {
                        oldDom.setPerfCounters(newDom.getCacheSettings().getPerfCounters());
                    } else {
                        oldDom.setPerfCounters(new PerfCounters());
                    }
                    if (newDom.getCacheSettings().getConflictResolver() != null) {
                        oldDom.setConflictResolver(newDom.getCacheSettings().getConflictResolver());
                    }
                    if (newDom.getCacheSettings().getCompression() != null) {
                        oldDom.setCompression(newDom.getCacheSettings().getCompression());
                    } else {
                        oldDom.setCompression(new Compression());
                    }
                    if (newDom.getCacheSettings().getQueryIndices() != null) {
                        oldDom.setQueryIndices(newDom.getCacheSettings().getQueryIndices());
                    }
                    if (newDom.getCacheSettings().getDataSharing() != null) {
                        oldDom.setDataSharing(newDom.getCacheSettings().getDataSharing());
                    }
                    if (newDom.getCacheSettings().getCompactSerialization() != null) {
                        oldDom.setCompactSerialization(newDom.getCacheSettings().getCompactSerialization());
                    }
                    if (newDom.getCacheSettings().getBackingSource() != null) {
                        oldDom.setBackingSource(newDom.getCacheSettings().getBackingSource());
                    }
                    if (newDom.getCacheSettings().getCacheLoader() != null) {
                        oldDom.setCacheLoader(newDom.getCacheSettings().getCacheLoader());
                    }
                    if (newDom.getCacheSettings().getNotifications() != null) {
                        oldDom.setNotifications(newDom.getCacheSettings().getNotifications());
                    } else {
                        oldDom.setNotifications(new Notifications());
                    }
                    if (newDom.getCacheSettings().getBridge() != null) {
                        oldDom.setBridge(newDom.getCacheSettings().getBridge());
                    }
                    if (newDom.getCacheSettings().getCleanup() != null) {
                        oldDom.setCleanup(newDom.getCacheSettings().getCleanup());
                    } else {
                        oldDom.setCleanup(new Cleanup());
                    }
                    if (newDom.getCacheSettings().getStorage() != null) {
                        oldDom.setStorage(newDom.getCacheSettings().getStorage());
                    } else {
                        oldDom.setStorage(new Storage());
                    }
                    if (newDom.getCacheSettings().getEvictionPolicy() != null) {
                        oldDom.setEvictionPolicy(newDom.getCacheSettings().getEvictionPolicy());
                    } else {
                        oldDom.setEvictionPolicy(new EvictionPolicy());
                    }
                    if (newDom.getCacheSettings().getCacheTopology() != null) {
                        oldDom.setCacheType(newDom.getCacheSettings().getCacheType());
                    }
                    if (oldDom.getCacheType().equals("clustered-cache") && newDom.getCacheDeployment() != null) {
                        String topology;
                        if (oldDom.getCluster() == null) {
                            oldDom.setCluster(new Alachisoft.NCache.Config.Dom.Cluster());
                        }
                        if ((topology = newDom.getCacheSettings().getCacheTopology().getTopology()) != null) {
                            if ((topology = topology.toLowerCase()).equals("replicated")) {
                                topology = "replicated-server";
                            } else if (topology.equals("partitioned")) {
                                topology = "partitioned-server";
                            } else if (topology.equals("partitioned-replica")) {
                                topology = "partitioned-replicas-server";
                            } else if (topology.equals("mirrored")) {
                                topology = "mirror-server";
                            } else if (topology.equals("local")) {
                                topology = "local-cache";
                            } else if (topology.equals("client-cache")) {
                                topology = "client-cache";
                            }
                        }
                        oldDom.getCluster().setTopology(topology);
                        oldDom.getCluster().setOpTimeout(newDom.getCacheSettings().getCacheTopology().getClusterSettings().getOpTimeout());
                        oldDom.getCluster().setStatsRepInterval(newDom.getCacheSettings().getCacheTopology().getClusterSettings().getStatsRepInterval());
                        oldDom.getCluster().setUseHeartbeat(newDom.getCacheSettings().getCacheTopology().getClusterSettings().getUseHeartbeat());
                        if (oldDom.getCluster().getChannel() == null) {
                            oldDom.getCluster().setChannel(new Alachisoft.NCache.Config.Dom.Channel());
                        }
                        oldDom.getCluster().getChannel().setTcpPort(newDom.getCacheSettings().getCacheTopology().getClusterSettings().getChannel().getTcpPort());
                        oldDom.getCluster().getChannel().setPortRange(newDom.getCacheSettings().getCacheTopology().getClusterSettings().getChannel().getPortRange());
                        oldDom.getCluster().getChannel().setConnectionRetries(newDom.getCacheSettings().getCacheTopology().getClusterSettings().getChannel().getConnectionRetries());
                        oldDom.getCluster().getChannel().setConnectionRetryInterval(newDom.getCacheSettings().getCacheTopology().getClusterSettings().getChannel().getConnectionRetryInterval());
                        if (newDom.getCacheSettings().getCacheTopology().getClusterSettings().getReplicationStrategy() != null) {
                            oldDom.setReplicationStrategy(newDom.getCacheSettings().getCacheTopology().getClusterSettings().getReplicationStrategy());
                        } else {
                            oldDom.setReplicationStrategy(new ReplicationStrategy());
                        }
                        oldDom.getCluster().getChannel().setInitialHosts(DomHelper.createInitialHosts(newDom.getCacheDeployment().getServers().getNodesList(), newDom.getCacheSettings().getCacheTopology().getClusterSettings().getChannel().getTcpPort()));
                        oldDom.getCluster().getChannel().setNumInitHosts(newDom.getCacheDeployment().getServers().getNodesList().size());
                        oldDom.getCluster().setActiveMirrorNode(newDom.getCacheDeployment().getServers().getActiveMirrorNode());
                        if (newDom.getCacheDeployment().getClientNodes() != null) {
                            if (oldDom.getClientNodes() == null) {
                                oldDom.setClientNodes(new ClientNodes());
                            }
                            oldDom.setClientNodes(newDom.getCacheDeployment().getClientNodes());
                        }
                    }
                    if (newDom.getCacheSettings().getSecurity() != null) {
                        oldDom.setSecurity(newDom.getCacheSettings().getSecurity());
                    }
                    if (newDom.getCacheSettings().getAutoLoadBalancing() != null) {
                        oldDom.setAutoLoadBalancing(newDom.getCacheSettings().getAutoLoadBalancing());
                    }
                    if (newDom.getCacheSettings().getAlertsNotifications() != null) {
                        oldDom.setAlertsNotifications(newDom.getCacheSettings().getAlertsNotifications());
                    }
                    if (newDom.getCacheSettings().getSQLDependencyConfig() != null) {
                        oldDom.setSQLDependencyConfig(newDom.getCacheSettings().getSQLDependencyConfig());
                    }
                    if (newDom.getCacheSettings().getEncryption() != null) {
                        oldDom.setEncryption(newDom.getCacheSettings().getEncryption());
                    }
                    oldDom.setIsRunning(newDom.getIsRunning());
                    oldDom.setIsRegistered(newDom.getIsRegistered());
                    oldDom.setIsExpired(newDom.getIsExpired());
                }
            }
        }
        catch (Exception ex) {
            throw new Exception("DomHelper.convertToOldDom" + ex.getMessage());
        }
        return oldDom;
    }

    public static CacheServerConfig convertToNewDom(Alachisoft.NCache.Config.Dom.CacheServerConfig oldDom) throws Exception {
        CacheServerConfig newDom = null;
        try {
            if (oldDom != null) {
                newDom = new CacheServerConfig();
                if (newDom.getCacheSettings() == null) {
                    newDom.setCacheSettings(new CacheServerConfigSetting());
                }
                newDom.getCacheSettings().setAutoStartCacheOnServiceStartup(oldDom.getAutoStartCacheOnServiceStartup());
                newDom.setName(oldDom.getName());
                newDom.getCacheSettings().setInProc(oldDom.getInProc());
                newDom.setConfigID(oldDom.getConfigID());
                newDom.getCacheSettings().setLastModified(oldDom.getLastModified());
                if (oldDom.getLog() != null) {
                    newDom.getCacheSettings().setLog(oldDom.getLog());
                } else {
                    newDom.getCacheSettings().setLog(new Log());
                }
                if (oldDom.getPerfCounters() != null) {
                    newDom.getCacheSettings().setPerfCounters(oldDom.getPerfCounters());
                } else {
                    newDom.getCacheSettings().setPerfCounters(new PerfCounters());
                }
                if (oldDom.getConflictResolver() != null) {
                    newDom.getCacheSettings().setConflictResolver(oldDom.getConflictResolver());
                }
                if (oldDom.getCompression() != null) {
                    newDom.getCacheSettings().setCompression(oldDom.getCompression());
                } else {
                    newDom.getCacheSettings().setCompression(new Compression());
                }
                if (oldDom.getQueryIndices() != null) {
                    newDom.getCacheSettings().setQueryIndices(oldDom.getQueryIndices());
                }
                if (oldDom.getDataSharing() != null) {
                    newDom.getCacheSettings().setDataSharing(oldDom.getDataSharing());
                }
                if (oldDom.getCompactSerialization() != null) {
                    newDom.getCacheSettings().setCompactSerialization(oldDom.getCompactSerialization());
                }
                if (oldDom.getBackingSource() != null) {
                    newDom.getCacheSettings().setBackingSource(oldDom.getBackingSource());
                }
                if (oldDom.getCacheLoader() != null) {
                    newDom.getCacheSettings().setCacheLoader(oldDom.getCacheLoader());
                }
                if (oldDom.getNotifications() != null) {
                    newDom.getCacheSettings().setNotifications(oldDom.getNotifications());
                } else {
                    newDom.getCacheSettings().setNotifications(new Notifications());
                }
                if (oldDom.getBridge() != null) {
                    newDom.getCacheSettings().setBridge(oldDom.getBridge());
                }
                if (oldDom.getCleanup() != null) {
                    newDom.getCacheSettings().setCleanup(oldDom.getCleanup());
                } else {
                    newDom.getCacheSettings().setCleanup(new Cleanup());
                }
                if (oldDom.getStorage() != null) {
                    newDom.getCacheSettings().setStorage(oldDom.getStorage());
                } else {
                    newDom.getCacheSettings().setStorage(new Storage());
                }
                if (oldDom.getEvictionPolicy() != null) {
                    newDom.getCacheSettings().setEvictionPolicy(oldDom.getEvictionPolicy());
                } else {
                    newDom.getCacheSettings().setEvictionPolicy(oldDom.getEvictionPolicy());
                }
                if (newDom.getCacheSettings().getCacheTopology() == null) {
                    newDom.getCacheSettings().setCacheTopology(new CacheTopology());
                }
                newDom.getCacheSettings().setCacheType(oldDom.getCacheType());
                if (oldDom.getCluster() != null) {
                    String topology = oldDom.getCluster().getTopology();
                    if (topology != null) {
                        if ((topology = topology.toLowerCase()).equals("replicated-server")) {
                            topology = "replicated";
                        } else if (topology.equals("partitioned-server")) {
                            topology = "partitioned";
                        } else if (topology.equals("partitioned-replicas-server")) {
                            topology = "partitioned-replica";
                        } else if (topology.equals("mirror-server")) {
                            topology = "mirrored";
                        } else if (topology.equals("local-cache")) {
                            topology = "local-cache";
                        } else if (topology.equals("client-cache")) {
                            topology = "client-cache";
                        }
                    }
                    newDom.getCacheSettings().getCacheTopology().setTopology(topology);
                    if (oldDom.getCacheType().equals("clustered-cache")) {
                        if (newDom.getCacheDeployment() == null) {
                            newDom.setCacheDeployment(new CacheDeployment());
                        }
                        if (newDom.getCacheSettings().getCacheTopology().getClusterSettings() == null) {
                            newDom.getCacheSettings().getCacheTopology().setClusterSettings(new Cluster());
                        }
                        newDom.getCacheSettings().getCacheTopology().getClusterSettings().setOpTimeout(oldDom.getCluster().getOpTimeout());
                        newDom.getCacheSettings().getCacheTopology().getClusterSettings().setStatsRepInterval(oldDom.getCluster().getStatsRepInterval());
                        newDom.getCacheSettings().getCacheTopology().getClusterSettings().setUseHeartbeat(oldDom.getCluster().getUseHeartbeat());
                        if (newDom.getCacheSettings().getCacheTopology().getClusterSettings().getChannel() == null) {
                            newDom.getCacheSettings().getCacheTopology().getClusterSettings().setChannel(new Channel());
                        }
                        if (oldDom.getCluster().getChannel() != null) {
                            newDom.getCacheSettings().getCacheTopology().getClusterSettings().getChannel().setTcpPort(oldDom.getCluster().getChannel().getTcpPort());
                            newDom.getCacheSettings().getCacheTopology().getClusterSettings().getChannel().setPortRange(oldDom.getCluster().getChannel().getPortRange());
                            newDom.getCacheSettings().getCacheTopology().getClusterSettings().getChannel().setConnectionRetries(oldDom.getCluster().getChannel().getConnectionRetries());
                            newDom.getCacheSettings().getCacheTopology().getClusterSettings().getChannel().setConnectionRetryInterval(oldDom.getCluster().getChannel().getConnectionRetryInterval());
                        }
                        if (oldDom.getReplicationStrategy() != null) {
                            newDom.getCacheSettings().getCacheTopology().getClusterSettings().setReplicationStrategy(oldDom.getReplicationStrategy());
                        } else {
                            newDom.getCacheSettings().getCacheTopology().getClusterSettings().setReplicationStrategy(new ReplicationStrategy());
                        }
                        if (newDom.getCacheDeployment().getServers() == null) {
                            newDom.getCacheDeployment().setServers(new ServersNodes());
                        }
                        newDom.getCacheDeployment().getServers().setNodesList(DomHelper.createServers(oldDom.getCluster().getChannel().getInitialHosts(), oldDom.getCluster().getActiveMirrorNode()));
                        if (oldDom.getClientNodes() != null) {
                            if (newDom.getCacheDeployment().getClientNodes() == null) {
                                newDom.getCacheDeployment().setClientNodes(new ClientNodes());
                            }
                            newDom.getCacheDeployment().setClientNodes(oldDom.getClientNodes());
                        }
                    }
                } else if (oldDom.getCacheType() != null) {
                    if (oldDom.getCacheType().equals("client-cache")) {
                        newDom.getCacheSettings().getCacheTopology().setTopology(oldDom.getCacheType());
                    } else if (oldDom.getCacheType().equals("local-cache")) {
                        newDom.getCacheSettings().getCacheTopology().setTopology(oldDom.getCacheType());
                    }
                    newDom.getCacheSettings().getCacheTopology().setClusterSettings(null);
                }
                if (oldDom.getSecurity() != null) {
                    newDom.getCacheSettings().setSecurity(oldDom.getSecurity());
                }
                if (oldDom.getAutoLoadBalancing() != null) {
                    newDom.getCacheSettings().setAutoLoadBalancing(oldDom.getAutoLoadBalancing());
                }
                if (oldDom.getAlertsNotifications() != null) {
                    newDom.getCacheSettings().setAlertsNotifications(oldDom.getAlertsNotifications());
                }
                if (oldDom.getSQLDependencyConfig() != null) {
                    newDom.getCacheSettings().setSQLDependencyConfig(oldDom.getSQLDependencyConfig());
                }
                if (oldDom.getEncryption() != null) {
                    newDom.getCacheSettings().setEncryption(oldDom.getEncryption());
                }
                newDom.setIsRunning(oldDom.getIsRunning());
                newDom.setIsRegistered(oldDom.getIsRegistered());
                newDom.setIsExpired(oldDom.getIsExpired());
            }
        }
        catch (Exception ex) {
            throw new Exception("DomHelper.convertToNewDom" + ex.getMessage());
        }
        return newDom;
    }

    private static ArrayList createServers(String l, String an) {
        Tokenizer tok = new Tokenizer(l, ",");
        ArrayList<ServerNode> retval = new ArrayList<ServerNode>();
        while (tok.hasNext()) {
            try {
                String t = tok.next();
                String host = t.substring(0, t.indexOf(91) - 0);
                host = host.trim();
                ServerNode node = an != null && !an.isEmpty() ? (an.equals(host) ? new ServerNode(host, true) : new ServerNode(host, false)) : new ServerNode(host, false);
                retval.add(node);
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (Exception exception) {}
        }
        return retval;
    }

    private static String createInitialHosts(ArrayList nodes, int port) {
        Object initialhost = "";
        try {
            for (int index = 0; index < nodes.size(); ++index) {
                ServerNode node = (ServerNode)nodes.get(index);
                initialhost = (String)initialhost + node.getIP() + "[" + port + "]";
                if (nodes.size() <= 1 || index == nodes.size() - 1) continue;
                initialhost = (String)initialhost + ",";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return initialhost;
    }
}

