/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Config.NewDom;

import Alachisoft.NCache.Common.Common;
import Alachisoft.NCache.Common.Net.DnsCache;
import com.alachisoft.ncache.serialization.core.io.InternalCompactSerializable;
import com.alachisoft.ncache.serialization.standard.io.CompactReader;
import com.alachisoft.ncache.serialization.standard.io.CompactWriter;
import java.io.IOException;
import java.net.UnknownHostException;

public class NodeIdentity
implements InternalCompactSerializable {
    private String _nodeName;
    private String _partitionId;
    private int _nodePriority = 1;

    public NodeIdentity() {
    }

    public NodeIdentity(String nodeName, String partitionId) {
        this._nodeName = nodeName;
        this._partitionId = partitionId;
    }

    public NodeIdentity(String nodeName, String partitionId, int nodePriority) {
        this(nodeName, partitionId);
        this._nodePriority = nodePriority;
    }

    public final String getNodeName() {
        return this._nodeName;
    }

    public final void setNodeName(String value) {
        this._nodeName = value;
    }

    public final String getPartitionId() {
        return this._partitionId;
    }

    public final void setPartitionId(String value) {
        this._partitionId = value;
    }

    public final int getNodePriority() {
        return this._nodePriority;
    }

    public final void setNodePriority(int value) {
        this._nodePriority = value;
    }

    public final NodeIdentity Resolve() throws UnknownHostException {
        if (DnsCache.ResolveAddress((String)this.getNodeName()) != null) {
            String nodeName = DnsCache.ResolveAddress((String)this.getNodeName());
            return new NodeIdentity(nodeName, this.getPartitionId());
        }
        return this;
    }

    public boolean equals(Object obj) {
        if (obj instanceof NodeIdentity) {
            NodeIdentity other = (NodeIdentity)(obj instanceof NodeIdentity ? obj : null);
            if (this.getPartitionId() == null) {
                this.setPartitionId("");
            }
            if (other.getPartitionId() == null) {
                other.setPartitionId("");
            }
            if (other.getNodeName().equals(this.getNodeName())) {
                if (other.getPartitionId() != null && this.getPartitionId() != null) {
                    return other.getPartitionId().equals(this.getPartitionId());
                }
                return false;
            }
        } else if (obj instanceof String) {
            return this.getNodeName().equals((String)obj);
        }
        return false;
    }

    public int hashCode() {
        return this._nodeName.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Node Name : " + this.getNodeName());
        sb.append(", Partition Id : ");
        sb.append(this.getPartitionId() == null ? "null" : this.getPartitionId());
        return sb.toString();
    }

    public void Deserialize(CompactReader reader) throws IOException, ClassNotFoundException {
        this._nodeName = (String)Common.readAs((Object)reader.ReadObject(), String.class);
        this._partitionId = (String)Common.readAs((Object)reader.ReadObject(), String.class);
        this._nodePriority = reader.ReadInt32();
    }

    public void Serialize(CompactWriter writer) throws IOException {
        writer.WriteObject((Object)this._nodeName);
        writer.WriteObject((Object)this._partitionId);
        writer.Write(this._nodePriority);
    }
}

