/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.caching.statistics;

import Alachisoft.NCache.Common.Enum.Time;
import Alachisoft.NCache.Common.IDisposable;
import Alachisoft.NCache.Common.Logger.ILogger;
import Alachisoft.NCache.Common.Stats.HPTime;
import Alachisoft.NCache.Common.Stats.UsageStats;
import com.alachisoft.ncache.caching.statistics.StatisticCounter;
import com.alachisoft.ncache.common.caching.statistics.customcounters.AverageCounter;
import com.alachisoft.ncache.common.caching.statistics.customcounters.NumberOfItemCounter;
import com.alachisoft.ncache.common.caching.statistics.customcounters.PerformanceCounter;
import com.alachisoft.ncache.common.caching.statistics.customcounters.RateOfCounter;
import com.alachisoft.ncache.common.caching.statistics.monitoring.CacheMonitor;
import com.alachisoft.ncache.common.caching.statistics.monitoring.ClusteredCacheMonitor;
import com.alachisoft.ncache.common.caching.statistics.monitoring.Monitor;
import com.alachisoft.ncache.common.caching.statistics.operations.CacheOperations;
import com.alachisoft.ncache.common.caching.statistics.operations.Operations;
import com.google.common.util.concurrent.AtomicDouble;
import java.lang.management.ManagementFactory;

public class PerfStatsCollector
implements StatisticCounter,
IDisposable {
    Monitor monitor;
    private HPTime initTime;
    private String instanceName;
    private int snmpPort;
    private boolean isClustered;
    private PerformanceCounter pcCount = null;
    private PerformanceCounter pcCacheSize = null;
    private PerformanceCounter pcCachelastAccessCount = null;
    private PerformanceCounter pcHitsPerSec = null;
    private PerformanceCounter pcMissPerSec = null;
    private AverageCounter pcHitsRatioSec = null;
    private PerformanceCounter pcGetPerSec = null;
    private PerformanceCounter pcAddPerSec = null;
    private PerformanceCounter pcUpdPerSec = null;
    private PerformanceCounter pcDelPerSec = null;
    private PerformanceCounter pcEvictPerSec = null;
    private PerformanceCounter pcExpiryPerSec = null;
    private PerformanceCounter pcStateTxfrPerSec = null;
    private PerformanceCounter pcDataBalPerSec = null;
    private PerformanceCounter pcMirrorQueueSize = null;
    private PerformanceCounter pcSlidingIndexQueueSize = null;
    private PerformanceCounter pcMSecPerGetAvg = null;
    private PerformanceCounter pcMSecPerAddAvg = null;
    private PerformanceCounter pcMSecPerUpdAvg = null;
    private PerformanceCounter pcMSecPerDelAvg = null;
    private PerformanceCounter pcReadThruPerSec = null;
    private PerformanceCounter pcWriteThruPerSec = null;
    private UsageStats usMSecPerGet = null;
    private UsageStats usMSecPerAdd = null;
    private UsageStats usMSecPerUpd = null;
    private UsageStats usMSecPerDel = null;
    private PerformanceCounter pcWBQueueCount = null;
    private PerformanceCounter pcWriteBehindPerSec = null;
    private UsageStats usMsecPerDSWrite = null;
    private AverageCounter pcMsecPerDSWriteAvg = null;
    private PerformanceCounter pcWBFailureRertyCount = null;
    private PerformanceCounter pcWBEvicPerSec = null;
    private PerformanceCounter pcDSUpdatesPerSec = null;
    private AverageCounter pcMsecPerDSUpdateAvg = null;
    private UsageStats usMsecPerDSUp = null;
    private PerformanceCounter pcDSFailedOpsPerSec = null;
    private PerformanceCounter pcWBCurrenBatchOpCount = null;
    private ILogger logger;
    private AtomicDouble expirations = new AtomicDouble(0.0);
    private AtomicDouble evictions = new AtomicDouble(0.0);
    private AtomicDouble stateXfer = new AtomicDouble(0.0);
    private AtomicDouble dataBalance = new AtomicDouble(0.0);

    public PerfStatsCollector(String instanceName, boolean inProc) {
        this.instanceName = this.GetInstanceName(instanceName, 0, inProc);
    }

    public PerfStatsCollector(String instanceName, int port, boolean inProc) {
        this.instanceName = this.GetInstanceName(instanceName, port, inProc);
    }

    @Override
    public Monitor getMonitor() {
        return this.monitor;
    }

    public final String GetInstanceName(String instanceName, int port, boolean inProc) {
        return !inProc ? instanceName : instanceName + " - " + ManagementFactory.getRuntimeMXBean().getName() + "-" + port;
    }

    @Override
    public final String getInstanceName() {
        return this.instanceName;
    }

    @Override
    public final void setInstanceName(String value) {
        this.instanceName = value;
    }

    @Override
    public final boolean getUserHasAccessRights() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void dispose() {
        PerfStatsCollector perfStatsCollector = this;
        synchronized (perfStatsCollector) {
            if (this.pcCount != null) {
                if (this.monitor != null) {
                    this.monitor.unRegisterCounter((Operations)CacheOperations.Count);
                }
                this.pcCount = null;
            }
            if (this.pcCachelastAccessCount != null) {
                if (this.monitor != null) {
                    this.monitor.unRegisterCounter((Operations)CacheOperations.CacheLastAccessCount);
                }
                this.pcCachelastAccessCount = null;
            }
            if (this.pcHitsPerSec != null) {
                if (this.monitor != null) {
                    this.monitor.unRegisterCounter((Operations)CacheOperations.HitsPerSec);
                }
                this.pcHitsPerSec = null;
            }
            if (this.pcMissPerSec != null) {
                this.monitor.unRegisterCounter((Operations)CacheOperations.MissPerSec);
                this.pcMissPerSec = null;
            }
            if (this.pcHitsRatioSec != null) {
                if (this.monitor != null) {
                    this.monitor.unRegisterCounter((Operations)CacheOperations.HitsRatioSec);
                }
                this.pcHitsRatioSec = null;
            }
            if (this.pcAddPerSec != null) {
                this.monitor.unRegisterCounter((Operations)CacheOperations.AddsPerSec);
                this.pcAddPerSec = null;
            }
            if (this.pcGetPerSec != null) {
                if (this.monitor != null) {
                    this.monitor.unRegisterCounter((Operations)CacheOperations.GetsPerSec);
                }
                this.pcGetPerSec = null;
            }
            if (this.pcUpdPerSec != null) {
                if (this.monitor != null) {
                    this.monitor.unRegisterCounter((Operations)CacheOperations.InsertsPerSec);
                }
                this.pcUpdPerSec = null;
            }
            if (this.pcDelPerSec != null) {
                if (this.monitor != null) {
                    this.monitor.unRegisterCounter((Operations)CacheOperations.DelsPerSec);
                }
                this.pcDelPerSec = null;
            }
            if (this.pcMSecPerAddAvg != null) {
                if (this.monitor != null) {
                    this.monitor.unRegisterCounter((Operations)CacheOperations.MSecPerAddAverage);
                }
                this.pcMSecPerAddAvg = null;
            }
            if (this.pcMSecPerDelAvg != null) {
                if (this.monitor != null) {
                    this.monitor.unRegisterCounter((Operations)CacheOperations.MSecPerDelAverage);
                }
                this.pcMSecPerDelAvg = null;
            }
            if (this.pcMSecPerGetAvg != null) {
                if (this.monitor != null) {
                    this.monitor.unRegisterCounter((Operations)CacheOperations.MSecPerGetAverage);
                }
                this.pcMSecPerGetAvg = null;
            }
            if (this.pcMSecPerUpdAvg != null) {
                if (this.monitor != null) {
                    this.monitor.unRegisterCounter((Operations)CacheOperations.MSecPerInsertAverage);
                }
                this.pcMSecPerUpdAvg = null;
            }
            if (this.pcEvictPerSec != null) {
                this.monitor.unRegisterCounter((Operations)CacheOperations.EvictPerSec);
                this.pcEvictPerSec = null;
            }
            if (this.pcExpiryPerSec != null) {
                this.monitor.unRegisterCounter((Operations)CacheOperations.ExpiryPerSec);
                this.pcExpiryPerSec = null;
            }
            if (this.pcStateTxfrPerSec != null) {
                this.monitor.unRegisterCounter((Operations)CacheOperations.StateTransferPerSec);
                this.pcStateTxfrPerSec = null;
            }
            if (this.pcDataBalPerSec != null) {
                this.monitor.unRegisterCounter((Operations)CacheOperations.DataBalPerSec);
                this.pcDataBalPerSec = null;
            }
            if (this.pcMirrorQueueSize != null) {
                this.monitor.unRegisterCounter((Operations)CacheOperations.MirrorQueueSize);
                this.pcMirrorQueueSize = null;
            }
            if (this.pcSlidingIndexQueueSize != null) {
                this.monitor.unRegisterCounter((Operations)CacheOperations.SlidingIndexQueueSize);
                this.pcSlidingIndexQueueSize = null;
            }
            if (this.pcReadThruPerSec != null) {
                this.monitor.unRegisterCounter((Operations)CacheOperations.ReadThruPerSec);
                this.pcReadThruPerSec = null;
            }
            if (this.pcWriteThruPerSec != null) {
                this.monitor.unRegisterCounter((Operations)CacheOperations.WriterThruPerSec);
                this.pcWriteThruPerSec = null;
            }
            if (this.pcWBQueueCount != null) {
                this.monitor.unRegisterCounter((Operations)CacheOperations.WBQueueCount);
                this.pcWBQueueCount = null;
            }
            if (this.pcWBCurrenBatchOpCount != null) {
                this.monitor.unRegisterCounter((Operations)CacheOperations.WBCurrenBatchOpCount);
                this.pcWBCurrenBatchOpCount = null;
            }
            if (this.monitor != null) {
                this.monitor.unRegisterNode();
                this.monitor = null;
            }
        }
    }

    @Override
    public void initializePerfCounters(boolean inproc) {
        this.initializePerfCounters(inproc, false);
    }

    @Override
    public final void initializePerfCounters(boolean inProc, boolean clusteredCache) {
        this.monitor = clusteredCache ? new ClusteredCacheMonitor(this.instanceName, this.logger) : new CacheMonitor(this.instanceName, this.logger);
        this.monitor.registerNode();
        try {
            this.pcAddPerSec = new RateOfCounter("Additions/sec", this.instanceName);
            this.monitor.registerCounter((Operations)CacheOperations.AddsPerSec, this.pcAddPerSec);
            this.pcMSecPerAddAvg = new AverageCounter("Average \u00c2\u00b5s/add", this.instanceName);
            this.monitor.registerCounter((Operations)CacheOperations.MSecPerAddAverage, this.pcMSecPerAddAvg);
            this.usMSecPerAdd = new UsageStats();
            this.pcUpdPerSec = new RateOfCounter("Updates/sec", this.instanceName);
            this.monitor.registerCounter((Operations)CacheOperations.InsertsPerSec, this.pcUpdPerSec);
            this.pcMSecPerUpdAvg = new AverageCounter("Average \u00c2\u00b5s/insert", this.instanceName);
            this.monitor.registerCounter((Operations)CacheOperations.MSecPerInsertAverage, this.pcMSecPerUpdAvg);
            this.usMSecPerUpd = new UsageStats();
            this.pcGetPerSec = new RateOfCounter("Average get/sec", this.instanceName);
            this.monitor.registerCounter((Operations)CacheOperations.GetsPerSec, this.pcGetPerSec);
            this.pcMSecPerGetAvg = new AverageCounter("Avearge \u00c2\u00b5s/fetch", this.instanceName);
            this.monitor.registerCounter((Operations)CacheOperations.MSecPerGetAverage, this.pcMSecPerGetAvg);
            this.usMSecPerGet = new UsageStats();
            this.pcDelPerSec = new RateOfCounter("Deletes/sec", this.instanceName);
            this.monitor.registerCounter((Operations)CacheOperations.DelsPerSec, this.pcDelPerSec);
            this.pcMSecPerDelAvg = new AverageCounter("Average \u00c2\u00b5s/remove", this.instanceName);
            this.monitor.registerCounter((Operations)CacheOperations.MSecPerDelAverage, this.pcMSecPerDelAvg);
            this.usMSecPerDel = new UsageStats();
            this.pcHitsPerSec = new RateOfCounter("Hits/sec", this.instanceName);
            this.monitor.registerCounter((Operations)CacheOperations.HitsPerSec, this.pcHitsPerSec);
            this.pcHitsRatioSec = new AverageCounter("Hits ratio/sec (%)", this.instanceName);
            this.monitor.registerCounter((Operations)CacheOperations.HitsRatioSec, (PerformanceCounter)this.pcHitsRatioSec);
            this.pcMissPerSec = new RateOfCounter("Misses/sec", this.instanceName);
            this.monitor.registerCounter((Operations)CacheOperations.MissPerSec, this.pcMissPerSec);
            this.pcCount = new NumberOfItemCounter("Count", this.instanceName);
            this.monitor.registerCounter((Operations)CacheOperations.Count, this.pcCount);
            this.pcCacheSize = new NumberOfItemCounter("Cache Size", this.instanceName);
            this.monitor.registerCounter((Operations)CacheOperations.CacheSize, this.pcCacheSize);
            this.pcCachelastAccessCount = new NumberOfItemCounter("CacheLastAccessCount", this.instanceName);
            this.monitor.registerCounter((Operations)CacheOperations.CacheLastAccessCount, this.pcCount);
            this.pcReadThruPerSec = new RateOfCounter("Readthru/sec", this.instanceName);
            this.monitor.registerCounter((Operations)CacheOperations.ReadThruPerSec, this.pcReadThruPerSec);
            this.pcWriteThruPerSec = new RateOfCounter("Writethru/sec", this.instanceName);
            this.monitor.registerCounter((Operations)CacheOperations.WriterThruPerSec, this.pcWriteThruPerSec);
            this.pcExpiryPerSec = new RateOfCounter("Expirations/sec", this.instanceName);
            this.monitor.registerCounter((Operations)CacheOperations.ExpiryPerSec, this.pcExpiryPerSec);
            this.pcEvictPerSec = new RateOfCounter("Evictions/sec", this.instanceName);
            this.monitor.registerCounter((Operations)CacheOperations.EvictPerSec, this.pcEvictPerSec);
            if (clusteredCache) {
                this.pcStateTxfrPerSec = new RateOfCounter("State transfer/sec", this.instanceName);
                this.monitor.registerCounter((Operations)CacheOperations.StateTransferPerSec, this.pcStateTxfrPerSec);
                this.pcDataBalPerSec = new RateOfCounter("Data balance/sec", this.instanceName);
                this.monitor.registerCounter((Operations)CacheOperations.DataBalPerSec, this.pcDataBalPerSec);
                this.pcSlidingIndexQueueSize = new NumberOfItemCounter("Sliding Index queue size", this.instanceName);
                this.monitor.registerCounter((Operations)CacheOperations.SlidingIndexQueueSize, this.pcSlidingIndexQueueSize);
                this.pcMirrorQueueSize = new NumberOfItemCounter("Mirror Queue Size", this.instanceName);
                this.monitor.registerCounter((Operations)CacheOperations.MirrorQueueSize, this.pcMirrorQueueSize);
            }
            this.pcWBQueueCount = new NumberOfItemCounter("Write-behind queue count", this.instanceName);
            this.monitor.registerCounter((Operations)CacheOperations.WBQueueCount, this.pcWBQueueCount);
            this.pcWriteBehindPerSec = new RateOfCounter("Write-behind/sec", this.instanceName);
            this.monitor.registerCounter((Operations)CacheOperations.WriteBehindPerSec, this.pcWriteBehindPerSec);
            this.pcMsecPerDSWriteAvg = new AverageCounter("Average \u00c2\u00b5s/datasource write", this.instanceName);
            this.monitor.registerCounter((Operations)CacheOperations.MsecPerDSWriteAvg, (PerformanceCounter)this.pcMsecPerDSWriteAvg);
            this.pcWBFailureRertyCount = new NumberOfItemCounter("Write-behind failure retry count", this.instanceName);
            this.monitor.registerCounter((Operations)CacheOperations.WBFailureRertyCount, this.pcWBFailureRertyCount);
            this.pcWBEvicPerSec = new RateOfCounter("Write-behind evictions/sec", this.instanceName);
            this.monitor.registerCounter((Operations)CacheOperations.WBEvicPerSec, this.pcWBEvicPerSec);
            this.pcDSUpdatesPerSec = new RateOfCounter("Datasource updates/sec", this.instanceName);
            this.monitor.registerCounter((Operations)CacheOperations.DSUpdatesPerSec, this.pcDSUpdatesPerSec);
            this.pcMsecPerDSUpdateAvg = new AverageCounter("Average \u00c2\u00b5s/datasource update", this.instanceName);
            this.monitor.registerCounter((Operations)CacheOperations.MsecPerDSUpdateAvg, (PerformanceCounter)this.pcMsecPerDSUpdateAvg);
            this.pcDSFailedOpsPerSec = new RateOfCounter("Datasource failed operations/sec", this.instanceName);
            this.monitor.registerCounter((Operations)CacheOperations.DSFailedOpsPerSec, this.pcDSFailedOpsPerSec);
            this.pcWBCurrenBatchOpCount = new NumberOfItemCounter("Current batch operations count", this.instanceName);
            this.monitor.registerCounter((Operations)CacheOperations.WBCurrenBatchOpCount, this.pcWBCurrenBatchOpCount);
            this.usMsecPerDSWrite = new UsageStats();
            this.usMsecPerDSUp = new UsageStats();
        }
        catch (Exception exception) {
            this.getNCacheLog().Error(PerfStatsCollector.class.getCanonicalName().toString(), exception.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void incrementCountStats() {
        if (this.pcCount != null) {
            PerformanceCounter performanceCounter = this.pcCount;
            synchronized (performanceCounter) {
                this.pcCount.increment();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setCountStats(long count) {
        if (this.pcCount != null) {
            PerformanceCounter performanceCounter = this.pcCount;
            synchronized (performanceCounter) {
                this.pcCount.setValue((double)count);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void incrementCountStatsBy(long count) {
        if (this.pcCount != null) {
            PerformanceCounter performanceCounter = this.pcCount;
            synchronized (performanceCounter) {
                this.pcCount.incrementBy((double)count);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void incrementCacheSizeStats() {
        if (this.pcCacheSize != null) {
            PerformanceCounter performanceCounter = this.pcCacheSize;
            synchronized (performanceCounter) {
                this.pcCacheSize.increment();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void incrementCacheSizeStatsBy(long size) {
        if (this.pcCacheSize != null) {
            PerformanceCounter performanceCounter = this.pcCacheSize;
            synchronized (performanceCounter) {
                this.pcCacheSize.incrementBy((double)size);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setCacheSizeStats(long size) {
        if (this.pcCacheSize != null) {
            PerformanceCounter performanceCounter = this.pcCacheSize;
            synchronized (performanceCounter) {
                this.pcCacheSize.setValue((double)size);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void incrementCacheLastAccessCountStats(long count) {
        if (this.pcCachelastAccessCount != null) {
            PerformanceCounter performanceCounter = this.pcCachelastAccessCount;
            synchronized (performanceCounter) {
                this.pcCachelastAccessCount.setValue((double)count);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void incrementHitsPerSecStats() {
        if (this.pcHitsPerSec != null) {
            PerformanceCounter performanceCounter = this.pcHitsPerSec;
            synchronized (performanceCounter) {
                this.pcHitsPerSec.increment();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void incrementMissPerSecStats() {
        if (this.pcMissPerSec != null) {
            PerformanceCounter performanceCounter = this.pcMissPerSec;
            synchronized (performanceCounter) {
                this.pcMissPerSec.increment();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void incrementHitsRatioPerSecStats() {
        if (this.pcHitsRatioSec != null) {
            AverageCounter averageCounter = this.pcHitsRatioSec;
            synchronized (averageCounter) {
                this.pcHitsRatioSec.incrementBy(1.0, 0.0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void incrementHitsRatioPerSecBaseStats() {
        if (this.pcHitsRatioSec != null) {
            AverageCounter averageCounter = this.pcHitsRatioSec;
            synchronized (averageCounter) {
                this.pcHitsRatioSec.incrementBy(0.0, 1.0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void incrementGetPerSecStats() {
        if (this.pcGetPerSec != null) {
            PerformanceCounter performanceCounter = this.pcGetPerSec;
            synchronized (performanceCounter) {
                this.pcGetPerSec.increment();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void incrementGetPerSecStatsBy(double value) {
        if (this.pcGetPerSec != null) {
            PerformanceCounter performanceCounter = this.pcGetPerSec;
            synchronized (performanceCounter) {
                this.pcGetPerSec.incrementBy(value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void incrementAddPerSecStats() {
        if (this.pcAddPerSec != null) {
            PerformanceCounter performanceCounter = this.pcAddPerSec;
            synchronized (performanceCounter) {
                this.pcAddPerSec.increment();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void incrementUpdPerSecStats() {
        if (this.pcUpdPerSec != null) {
            PerformanceCounter performanceCounter = this.pcUpdPerSec;
            synchronized (performanceCounter) {
                this.pcUpdPerSec.increment();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void incrementDelPerSecStats() {
        if (this.pcDelPerSec != null) {
            PerformanceCounter performanceCounter = this.pcDelPerSec;
            synchronized (performanceCounter) {
                this.pcDelPerSec.increment();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void incrementEvictPerSecStats() {
        this.evictions.addAndGet(1.0);
        if (this.pcEvictPerSec != null) {
            PerformanceCounter performanceCounter = this.pcEvictPerSec;
            synchronized (performanceCounter) {
                this.pcEvictPerSec.increment();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void incrementExpiryPerSecStats() {
        this.expirations.addAndGet(1.0);
        if (this.pcExpiryPerSec != null) {
            PerformanceCounter performanceCounter = this.pcExpiryPerSec;
            synchronized (performanceCounter) {
                this.pcExpiryPerSec.increment();
            }
        }
    }

    @Override
    public final void incrementReadThruPerSec() {
        this.incrementReadThruPerSecBy(1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void incrementReadThruPerSecBy(long value) {
        if (this.pcReadThruPerSec != null) {
            PerformanceCounter performanceCounter = this.pcReadThruPerSec;
            synchronized (performanceCounter) {
                this.pcReadThruPerSec.incrementBy((double)value);
            }
        }
    }

    @Override
    public final void incrementWriteThruPerSec() {
        this.incrementWriteThruPerSecBy(1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void incrementWriteThruPerSecBy(long value) {
        if (this.pcWriteThruPerSec != null) {
            PerformanceCounter performanceCounter = this.pcWriteThruPerSec;
            synchronized (performanceCounter) {
                this.pcWriteThruPerSec.incrementBy((double)value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void incrementEvictPerSecStatsBy(long value) {
        this.evictions.addAndGet((double)value);
        if (this.pcEvictPerSec != null) {
            PerformanceCounter performanceCounter = this.pcEvictPerSec;
            synchronized (performanceCounter) {
                this.pcEvictPerSec.incrementBy((double)value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void incrementExpiryPerSecStatsBy(long value) {
        this.expirations.addAndGet((double)value);
        if (this.pcExpiryPerSec != null) {
            PerformanceCounter performanceCounter = this.pcExpiryPerSec;
            synchronized (performanceCounter) {
                this.pcExpiryPerSec.incrementBy((double)value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void mSecPerGetBeginSample() {
        if (this.pcMSecPerGetAvg != null) {
            UsageStats usageStats = this.usMSecPerGet;
            synchronized (usageStats) {
                this.usMSecPerGet.BeginSample();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void mSecPerGetEndSample() {
        if (this.pcMSecPerGetAvg != null) {
            PerformanceCounter performanceCounter = this.pcMSecPerGetAvg;
            synchronized (performanceCounter) {
                this.usMSecPerGet.EndSample();
                this.pcMSecPerGetAvg.incrementBy(Time.toMicroSeconds((long)this.usMSecPerGet.getCurrent(), (Time)Time.nSEC));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void mSecPerAddBeginSample() {
        if (this.pcMSecPerAddAvg != null) {
            PerformanceCounter performanceCounter = this.pcMSecPerAddAvg;
            synchronized (performanceCounter) {
                this.usMSecPerAdd.BeginSample();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void mSecPerAddEndSample() {
        if (this.pcMSecPerAddAvg != null) {
            PerformanceCounter performanceCounter = this.pcMSecPerAddAvg;
            synchronized (performanceCounter) {
                this.usMSecPerAdd.EndSample();
                this.pcMSecPerAddAvg.incrementBy(Time.toMicroSeconds((long)this.usMSecPerAdd.getCurrent(), (Time)Time.nSEC));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void mSecPerUpdBeginSample() {
        if (this.pcMSecPerUpdAvg != null) {
            PerformanceCounter performanceCounter = this.pcMSecPerUpdAvg;
            synchronized (performanceCounter) {
                this.usMSecPerUpd.BeginSample();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void mSecPerUpdEndSample() {
        if (this.pcMSecPerUpdAvg != null) {
            PerformanceCounter performanceCounter = this.pcMSecPerUpdAvg;
            synchronized (performanceCounter) {
                this.usMSecPerUpd.EndSample();
                this.pcMSecPerUpdAvg.incrementBy(Time.toMicroSeconds((long)this.usMSecPerUpd.getCurrent(), (Time)Time.nSEC));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void mSecPerDelBeginSample() {
        if (this.pcMSecPerDelAvg != null) {
            PerformanceCounter performanceCounter = this.pcMSecPerDelAvg;
            synchronized (performanceCounter) {
                this.usMSecPerDel.BeginSample();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void mSecPerDelEndSample() {
        if (this.pcMSecPerDelAvg != null) {
            PerformanceCounter performanceCounter = this.pcMSecPerDelAvg;
            synchronized (performanceCounter) {
                this.usMSecPerDel.EndSample();
                this.pcMSecPerDelAvg.incrementBy(Time.toMicroSeconds((long)this.usMSecPerDel.getCurrent(), (Time)Time.nSEC));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void incrementStateTxfrPerSecStats() {
        this.stateXfer.addAndGet(1.0);
        if (this.pcStateTxfrPerSec != null) {
            PerformanceCounter performanceCounter = this.pcStateTxfrPerSec;
            synchronized (performanceCounter) {
                this.pcStateTxfrPerSec.increment();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void incrementStateTxfrPerSecStatsBy(long value) {
        this.stateXfer.addAndGet((double)value);
        if (this.pcStateTxfrPerSec != null) {
            PerformanceCounter performanceCounter = this.pcStateTxfrPerSec;
            synchronized (performanceCounter) {
                this.pcStateTxfrPerSec.incrementBy((double)value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void incrementDataBalPerSecStats() {
        this.dataBalance.addAndGet(1.0);
        if (this.pcDataBalPerSec != null) {
            PerformanceCounter performanceCounter = this.pcDataBalPerSec;
            synchronized (performanceCounter) {
                this.pcDataBalPerSec.increment();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void incrementDataBalPerSecStatsBy(long value) {
        this.dataBalance.addAndGet((double)value);
        if (this.pcDataBalPerSec != null) {
            PerformanceCounter performanceCounter = this.pcDataBalPerSec;
            synchronized (performanceCounter) {
                this.pcDataBalPerSec.incrementBy((double)value);
            }
        }
    }

    @Override
    public final float getExpirations() {
        return (float)this.expirations.getAndSet(0.0);
    }

    @Override
    public final float getEviction() {
        return (float)this.expirations.getAndSet(0.0);
    }

    @Override
    public final float getStateXfer() {
        return (float)this.expirations.getAndSet(0.0);
    }

    @Override
    public final float getDataBalance() {
        return (float)this.expirations.getAndSet(0.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void incrementMirrorQueueSizeStats(long count) {
        if (this.pcMirrorQueueSize != null) {
            PerformanceCounter performanceCounter = this.pcMirrorQueueSize;
            synchronized (performanceCounter) {
                this.pcMirrorQueueSize.setValue((double)count);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void incrementSlidingIndexQueueSizeStats(long count) {
        if (this.pcSlidingIndexQueueSize != null) {
            PerformanceCounter performanceCounter = this.pcSlidingIndexQueueSize;
            synchronized (performanceCounter) {
                this.pcSlidingIndexQueueSize.setValue((double)count);
            }
        }
    }

    @Override
    public final ILogger getNCacheLog() {
        return this.logger;
    }

    @Override
    public final void setNCacheLog(ILogger value) {
        this.logger = value;
    }

    @Override
    public String getInstanceName(String instanceName, int port, boolean inProc) {
        return !inProc ? instanceName : instanceName + " - " + ManagementFactory.getRuntimeMXBean().getName() + "-" + port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void incrementDelPerSecStatsBy(int value) {
        if (this.pcDelPerSec != null) {
            PerformanceCounter performanceCounter = this.pcDelPerSec;
            synchronized (performanceCounter) {
                this.pcDelPerSec.incrementBy((double)value);
            }
        }
    }

    @Override
    public void incrementDSFailedOpsPerSec() {
        this.incrementDSFailedOpsPerSecBy(1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void incrementDSFailedOpsPerSecBy(long value) {
        if (this.pcDSFailedOpsPerSec != null) {
            PerformanceCounter performanceCounter = this.pcDSFailedOpsPerSec;
            synchronized (performanceCounter) {
                this.pcDSFailedOpsPerSec.incrementBy((double)value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void incrementWBEvictionRate() {
        if (this.pcWBEvicPerSec != null) {
            PerformanceCounter performanceCounter = this.pcWBEvicPerSec;
            synchronized (performanceCounter) {
                this.pcWBEvicPerSec.increment();
            }
        }
    }

    @Override
    public void incrementWriteBehindPerSec() {
        this.incrementWriteBehindPerSecBy(1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void incrementWriteBehindPerSecBy(long value) {
        if (this.pcWriteBehindPerSec != null) {
            PerformanceCounter performanceCounter = this.pcWriteBehindPerSec;
            synchronized (performanceCounter) {
                this.pcWriteBehindPerSec.incrementBy((double)value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setWBQueueCounter(long value) {
        if (this.pcWBQueueCount != null) {
            PerformanceCounter performanceCounter = this.pcWBQueueCount;
            synchronized (performanceCounter) {
                this.pcWBQueueCount.setValue((double)value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setWBFailureRetryCounter(long value) {
        if (this.pcWBFailureRertyCount != null) {
            PerformanceCounter performanceCounter = this.pcWBFailureRertyCount;
            synchronized (performanceCounter) {
                this.pcWBFailureRertyCount.setValue((double)value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void decrementWBFailureRetryCounter() {
        if (this.pcWBFailureRertyCount != null) {
            PerformanceCounter performanceCounter = this.pcWBFailureRertyCount;
            synchronized (performanceCounter) {
                this.pcWBFailureRertyCount.decrement();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setWBCurrentBatchOpsCounter(long value) {
        if (this.pcWBCurrenBatchOpCount != null) {
            PerformanceCounter performanceCounter = this.pcWBCurrenBatchOpCount;
            synchronized (performanceCounter) {
                this.pcWBCurrenBatchOpCount.setValue((double)value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mSecPerDSWriteBeginSample() {
        if (this.pcMsecPerDSWriteAvg != null) {
            AverageCounter averageCounter = this.pcMsecPerDSWriteAvg;
            synchronized (averageCounter) {
                this.usMsecPerDSWrite.BeginSample();
            }
        }
    }

    @Override
    public void mSecPerDSWriteEndSample() {
        this.mSecPerDSWriteEndSample(1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mSecPerDSWriteEndSample(long bulkCount) {
        if (this.pcMsecPerDSWriteAvg != null) {
            AverageCounter averageCounter = this.pcMsecPerDSWriteAvg;
            synchronized (averageCounter) {
                this.usMsecPerDSWrite.EndSample();
                this.pcMsecPerDSWriteAvg.incrementBy(Time.toMicroSeconds((long)this.usMsecPerDSWrite.getCurrent(), (Time)Time.nSEC), (double)bulkCount);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mSecPerDSUpdBeginSample() {
        if (this.pcMsecPerDSUpdateAvg != null) {
            AverageCounter averageCounter = this.pcMsecPerDSUpdateAvg;
            synchronized (averageCounter) {
                this.usMsecPerDSUp.BeginSample();
            }
        }
    }

    @Override
    public void mSecPerDSUpdEndSample() {
        this.mSecPerDSUpdEndSample(1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mSecPerDSUpdEndSample(long bulkCount) {
        if (this.pcMsecPerDSUpdateAvg != null) {
            AverageCounter averageCounter = this.pcMsecPerDSUpdateAvg;
            synchronized (averageCounter) {
                this.usMsecPerDSUp.EndSample();
                this.pcMsecPerDSUpdateAvg.incrementBy(Time.toMicroSeconds((long)this.usMsecPerDSUp.getCurrent(), (Time)Time.nSEC), (double)bulkCount);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void incrementDSUpdatePerSec() {
        if (this.pcDSUpdatesPerSec != null) {
            PerformanceCounter performanceCounter = this.pcDSUpdatesPerSec;
            synchronized (performanceCounter) {
                this.pcDSUpdatesPerSec.increment();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void incrementDSUpdatePerSecBy(long value) {
        if (this.pcDSUpdatesPerSec != null) {
            PerformanceCounter performanceCounter = this.pcDSUpdatesPerSec;
            synchronized (performanceCounter) {
                this.pcDSUpdatesPerSec.incrementBy((double)value);
            }
        }
    }
}

