/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.serialization.core.io;

import com.alachisoft.ncache.serialization.core.io.TypeSurrogateSelector;
import com.alachisoft.ncache.serialization.util.CookieList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SerializationContext {
    public static final int InvalidCookie = -1;
    private TypeSurrogateSelector mSurrogateSelector;
    private CookieList mCookieList;
    private Map<Object, Object> mUserItems;
    private List<Object> mGraphList;

    public SerializationContext() {
        this.mSurrogateSelector = null;
        this.mCookieList = new CookieList();
        this.mUserItems = new HashMap<Object, Object>();
        this.mGraphList = new ArrayList<Object>();
    }

    public SerializationContext(TypeSurrogateSelector surrogateSelector) {
        this.mSurrogateSelector = surrogateSelector;
        this.mCookieList = new CookieList();
        this.mUserItems = new HashMap<Object, Object>();
        this.mGraphList = new ArrayList<Object>();
    }

    public TypeSurrogateSelector getSurrogateSelector() {
        return this.mSurrogateSelector;
    }

    public Object getUserItem(Object key) {
        if (key == null) {
            throw new NullPointerException();
        }
        return this.mUserItems.get(key);
    }

    public void putUserItem(Object key, Object value) {
        if (key == null) {
            throw new NullPointerException();
        }
        this.mUserItems.put(key, value);
    }

    public void clear() {
        this.mGraphList.clear();
        this.mCookieList.clear();
        this.mUserItems.clear();
    }

    public Integer getCookie(Object graph) {
        if (this.mCookieList.contains(graph)) {
            return this.mCookieList.indexOf(graph);
        }
        return -1;
    }

    public Object getObject(Integer key) {
        if (key > -1 && key < this.mGraphList.size()) {
            return this.mGraphList.get(key);
        }
        return null;
    }

    public Integer rememberForRead(Object graph) {
        Integer cookie = this.mGraphList.size();
        this.mGraphList.add(graph);
        return cookie;
    }

    public Integer rememberForWrite(Object graph) {
        Integer cookie = this.mCookieList.size();
        this.mCookieList.add(graph);
        return this.mCookieList.indexOf(graph);
    }
}

