/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.serialization.standard.io;

import com.alachisoft.ncache.serialization.standard.io.ObjectInputStream;
import java.io.IOException;

public class CompactReader {
    private ObjectInputStream reader;

    public CompactReader(ObjectInputStream input) {
        this.reader = input;
    }

    public Object ReadObject() throws IOException, ClassNotFoundException {
        return this.reader.readObject();
    }

    public void SkipObject() throws IOException {
        this.reader.skipObject();
    }

    public boolean ReadBoolean() throws IOException {
        return this.reader.readBoolean();
    }

    public byte ReadByte() throws IOException {
        return this.reader.readByte();
    }

    public byte[] ReadBytes(int count) throws IOException {
        byte[] buffer = new byte[count];
        this.reader.read(buffer, 0, count);
        return buffer;
    }

    public char ReadChar() throws IOException {
        return this.reader.readChar();
    }

    public char[] ReadChars(int count) throws IOException {
        char[] characters = new char[count];
        for (int i = 0; i < count; ++i) {
            characters[i] = this.reader.readChar();
        }
        return characters;
    }

    public float ReadSingle() throws IOException {
        return this.reader.readFloat();
    }

    public double ReadDouble() throws IOException {
        return this.reader.readDouble();
    }

    public short ReadInt16() throws IOException {
        return this.reader.readShort();
    }

    public int ReadInt32() throws IOException {
        return this.reader.readInt();
    }

    public long ReadInt64() throws IOException {
        return this.reader.readLong();
    }

    public String ReadString() throws IOException {
        return this.reader.readUTF();
    }

    public int Read(byte[] buffer, int index, int count) throws IOException {
        return this.reader.read(buffer, index, count);
    }

    public int Read(char[] buffer, int index, int count) throws IOException {
        for (int i = index; i < count; ++i) {
            buffer[index] = this.reader.readChar();
        }
        return count;
    }

    public int ReadUInt16() throws IOException {
        return this.reader.readUInt16();
    }

    public long ReadUInt32() throws IOException {
        return this.reader.readUInt32();
    }

    public void SkipBoolean() throws IOException {
        this.reader.skipBoolean();
    }

    public void SkipByte() throws IOException {
        this.reader.skipByte();
    }

    public void SkipBytes(int count) throws IOException {
        this.reader.skipBytes(count);
    }

    public void SkipChar() throws IOException {
        this.reader.skipChar();
    }

    public void SkipChars(int count) throws IOException {
        for (int i = 0; i < count; ++i) {
            this.reader.skipChar();
        }
    }

    public void SkipSingle() throws IOException {
        this.reader.skipFloat();
    }

    public void SkipDouble() throws IOException {
        this.reader.skipDouble();
    }

    public void SkipInt16() throws IOException {
        this.reader.skipShort();
    }

    public void SkipInt32() throws IOException {
        this.reader.skipInt();
    }

    public void SkipInt64() throws IOException {
        this.reader.skipLong();
    }

    public void SkipSByte() throws IOException {
        this.reader.skipByte();
    }

    public void SkipUInt16() throws IOException {
        this.reader.skipUInt16();
    }

    public void SkipUInt32() throws IOException {
        this.reader.skipUInt32();
    }

    public void SkipUInt64() throws IOException {
        this.reader.skipLong();
    }
}

