/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.serialization.standard.io;

import com.alachisoft.ncache.serialization.standard.io.ObjectOutputStream;
import java.io.IOException;
import java.math.BigInteger;

public class CompactWriter {
    private ObjectOutputStream writer;

    public CompactWriter(ObjectOutputStream output) {
        this.writer = output;
    }

    public void WriteObject(Object graph) throws IOException {
        this.writer.writeObject(graph);
    }

    public void Write(boolean value) throws IOException {
        this.writer.writeBoolean(value);
    }

    public void Write(byte value) throws IOException {
        this.writer.writeByte(value);
    }

    public void Write(char ch) throws IOException {
        this.writer.writeChar(ch);
    }

    public void Write(short value) throws IOException {
        this.writer.writeShort(value);
    }

    public void Write(int value) throws IOException, IOException, IOException, IOException {
        this.writer.writeInt(value);
    }

    public void Write(long value) throws IOException {
        this.writer.writeLong(value);
    }

    public void Write(float value) throws IOException {
        this.writer.writeFloat(value);
    }

    public void Write(double value) throws IOException {
        this.writer.writeDouble(value);
    }

    public void Write(byte[] buffer) throws IOException {
        if (buffer != null) {
            this.writer.write(buffer, 0, buffer.length);
        } else {
            this.WriteObject(null);
        }
    }

    public void Write(char[] chars) throws IOException {
        if (chars != null) {
            for (int i = 0; i < chars.length; ++i) {
                this.writer.writeChar(chars[i]);
            }
        } else {
            this.WriteObject(null);
        }
    }

    public void Write(String value) throws IOException {
        if (value != null) {
            this.writer.writeUTF(value);
        } else {
            this.WriteObject(null);
        }
    }

    public void Write(byte[] buffer, int index, int count) throws IOException {
        if (buffer != null) {
            this.writer.write(buffer, index, count);
        } else {
            this.WriteObject(null);
        }
    }

    public void Write(char[] chars, int index, int count) throws IOException {
        if (chars != null) {
            for (int i = index; i < count; ++i) {
                this.writer.writeChar(chars[i]);
            }
        } else {
            this.WriteObject(null);
        }
    }

    public void WriteUint16(int value) throws IOException {
        this.writer.writeUInt16(value);
    }

    public void WriteUint32(long value) throws IOException {
        this.writer.writeUInt32(value);
    }

    public void Write(BigInteger value) throws IOException {
        this.writer.writeUInt64(value);
    }
}

